/*
 * Decompiled with CFR 0.152.
 */
package com.fr.zip4j.core;

import com.fr.zip4j.exception.ZipException;
import com.fr.zip4j.model.AESExtraDataRecord;
import com.fr.zip4j.model.CentralDirectory;
import com.fr.zip4j.model.DigitalSignature;
import com.fr.zip4j.model.EndCentralDirRecord;
import com.fr.zip4j.model.ExtraDataRecord;
import com.fr.zip4j.model.FileHeader;
import com.fr.zip4j.model.LocalFileHeader;
import com.fr.zip4j.model.Zip64EndCentralDirLocator;
import com.fr.zip4j.model.Zip64EndCentralDirRecord;
import com.fr.zip4j.model.Zip64ExtendedInfo;
import com.fr.zip4j.model.ZipModel;
import com.fr.zip4j.util.Raw;
import com.fr.zip4j.util.Zip4jUtil;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class HeaderReader {
    private RandomAccessFile zip4jRaf = null;
    private ZipModel zipModel;

    public HeaderReader(RandomAccessFile randomAccessFile) {
        this.zip4jRaf = randomAccessFile;
    }

    public ZipModel readAllHeaders() throws ZipException {
        return this.readAllHeaders(null);
    }

    public ZipModel readAllHeaders(String string) throws ZipException {
        this.zipModel = new ZipModel();
        this.zipModel.setFileNameCharset(string);
        this.zipModel.setEndCentralDirRecord(this.readEndOfCentralDirectoryRecord());
        this.zipModel.setZip64EndCentralDirLocator(this.readZip64EndCentralDirLocator());
        if (this.zipModel.isZip64Format()) {
            this.zipModel.setZip64EndCentralDirRecord(this.readZip64EndCentralDirRec());
            if (this.zipModel.getZip64EndCentralDirRecord() != null && this.zipModel.getZip64EndCentralDirRecord().getNoOfThisDisk() > 0) {
                this.zipModel.setSplitArchive(true);
            } else {
                this.zipModel.setSplitArchive(false);
            }
        }
        this.zipModel.setCentralDirectory(this.readCentralDirectory());
        return this.zipModel;
    }

    private EndCentralDirRecord readEndOfCentralDirectoryRecord() throws ZipException {
        if (this.zip4jRaf == null) {
            throw new ZipException("random access file was null", 3);
        }
        try {
            byte[] byArray = new byte[4];
            long l2 = this.zip4jRaf.length() - 22L;
            EndCentralDirRecord endCentralDirRecord = new EndCentralDirRecord();
            int n2 = 0;
            do {
                this.zip4jRaf.seek(l2--);
            } while ((long)Raw.readLeInt(this.zip4jRaf, byArray) != 101010256L && ++n2 <= 3000);
            if ((long)Raw.readIntLittleEndian(byArray, 0) != 101010256L) {
                throw new ZipException("zip headers not found. probably not a zip file");
            }
            byte[] byArray2 = new byte[4];
            byte[] byArray3 = new byte[2];
            endCentralDirRecord.setSignature(101010256L);
            this.readIntoBuff(this.zip4jRaf, byArray3);
            endCentralDirRecord.setNoOfThisDisk(Raw.readShortLittleEndian(byArray3, 0));
            this.readIntoBuff(this.zip4jRaf, byArray3);
            endCentralDirRecord.setNoOfThisDiskStartOfCentralDir(Raw.readShortLittleEndian(byArray3, 0));
            this.readIntoBuff(this.zip4jRaf, byArray3);
            endCentralDirRecord.setTotNoOfEntriesInCentralDirOnThisDisk(Raw.readShortLittleEndian(byArray3, 0));
            this.readIntoBuff(this.zip4jRaf, byArray3);
            endCentralDirRecord.setTotNoOfEntriesInCentralDir(Raw.readShortLittleEndian(byArray3, 0));
            this.readIntoBuff(this.zip4jRaf, byArray2);
            endCentralDirRecord.setSizeOfCentralDir(Raw.readIntLittleEndian(byArray2, 0));
            this.readIntoBuff(this.zip4jRaf, byArray2);
            byte[] byArray4 = this.getLongByteFromIntByte(byArray2);
            endCentralDirRecord.setOffsetOfStartOfCentralDir(Raw.readLongLittleEndian(byArray4, 0));
            this.readIntoBuff(this.zip4jRaf, byArray3);
            int n3 = Raw.readShortLittleEndian(byArray3, 0);
            endCentralDirRecord.setCommentLength(n3);
            if (n3 > 0) {
                byte[] byArray5 = new byte[n3];
                this.readIntoBuff(this.zip4jRaf, byArray5);
                endCentralDirRecord.setComment(new String(byArray5));
                endCentralDirRecord.setCommentBytes(byArray5);
            } else {
                endCentralDirRecord.setComment(null);
            }
            int n4 = endCentralDirRecord.getNoOfThisDisk();
            if (n4 > 0) {
                this.zipModel.setSplitArchive(true);
            } else {
                this.zipModel.setSplitArchive(false);
            }
            return endCentralDirRecord;
        }
        catch (IOException iOException) {
            throw new ZipException("Probably not a zip file or a corrupted zip file", iOException, 4);
        }
    }

    private CentralDirectory readCentralDirectory() throws ZipException {
        if (this.zip4jRaf == null) {
            throw new ZipException("random access file was null", 3);
        }
        if (this.zipModel.getEndCentralDirRecord() == null) {
            throw new ZipException("EndCentralRecord was null, maybe a corrupt zip file");
        }
        try {
            int n2;
            CentralDirectory centralDirectory = new CentralDirectory();
            ArrayList<FileHeader> arrayList = new ArrayList<FileHeader>();
            EndCentralDirRecord endCentralDirRecord = this.zipModel.getEndCentralDirRecord();
            long l2 = endCentralDirRecord.getOffsetOfStartOfCentralDir();
            int n3 = endCentralDirRecord.getTotNoOfEntriesInCentralDir();
            if (this.zipModel.isZip64Format()) {
                l2 = this.zipModel.getZip64EndCentralDirRecord().getOffsetStartCenDirWRTStartDiskNo();
                n3 = (int)this.zipModel.getZip64EndCentralDirRecord().getTotNoOfEntriesInCentralDir();
            }
            this.zip4jRaf.seek(l2);
            byte[] byArray = new byte[4];
            byte[] byArray2 = new byte[2];
            byte[] byArray3 = new byte[8];
            for (int i2 = 0; i2 < n3; ++i2) {
                byte[] byArray4;
                FileHeader fileHeader = new FileHeader();
                this.readIntoBuff(this.zip4jRaf, byArray);
                n2 = Raw.readIntLittleEndian(byArray, 0);
                if ((long)n2 != 33639248L) {
                    throw new ZipException("Expected central directory entry not found (#" + (i2 + 1) + ")");
                }
                fileHeader.setSignature(n2);
                this.readIntoBuff(this.zip4jRaf, byArray2);
                fileHeader.setVersionMadeBy(Raw.readShortLittleEndian(byArray2, 0));
                this.readIntoBuff(this.zip4jRaf, byArray2);
                fileHeader.setVersionNeededToExtract(Raw.readShortLittleEndian(byArray2, 0));
                this.readIntoBuff(this.zip4jRaf, byArray2);
                fileHeader.setFileNameUTF8Encoded((Raw.readShortLittleEndian(byArray2, 0) & 0x800) != 0);
                byte by = byArray2[0];
                int n4 = by & 1;
                if (n4 != 0) {
                    fileHeader.setEncrypted(true);
                }
                fileHeader.setGeneralPurposeFlag((byte[])byArray2.clone());
                fileHeader.setDataDescriptorExists(by >> 3 == 1);
                this.readIntoBuff(this.zip4jRaf, byArray2);
                fileHeader.setCompressionMethod(Raw.readShortLittleEndian(byArray2, 0));
                this.readIntoBuff(this.zip4jRaf, byArray);
                fileHeader.setLastModFileTime(Raw.readIntLittleEndian(byArray, 0));
                this.readIntoBuff(this.zip4jRaf, byArray);
                fileHeader.setCrc32(Raw.readIntLittleEndian(byArray, 0));
                fileHeader.setCrcBuff((byte[])byArray.clone());
                this.readIntoBuff(this.zip4jRaf, byArray);
                byArray3 = this.getLongByteFromIntByte(byArray);
                fileHeader.setCompressedSize(Raw.readLongLittleEndian(byArray3, 0));
                this.readIntoBuff(this.zip4jRaf, byArray);
                byArray3 = this.getLongByteFromIntByte(byArray);
                fileHeader.setUncompressedSize(Raw.readLongLittleEndian(byArray3, 0));
                this.readIntoBuff(this.zip4jRaf, byArray2);
                int n5 = Raw.readShortLittleEndian(byArray2, 0);
                fileHeader.setFileNameLength(n5);
                this.readIntoBuff(this.zip4jRaf, byArray2);
                int n6 = Raw.readShortLittleEndian(byArray2, 0);
                fileHeader.setExtraFieldLength(n6);
                this.readIntoBuff(this.zip4jRaf, byArray2);
                int n7 = Raw.readShortLittleEndian(byArray2, 0);
                fileHeader.setFileComment(new String(byArray2));
                this.readIntoBuff(this.zip4jRaf, byArray2);
                fileHeader.setDiskNumberStart(Raw.readShortLittleEndian(byArray2, 0));
                this.readIntoBuff(this.zip4jRaf, byArray2);
                fileHeader.setInternalFileAttr((byte[])byArray2.clone());
                this.readIntoBuff(this.zip4jRaf, byArray);
                fileHeader.setExternalFileAttr((byte[])byArray.clone());
                this.readIntoBuff(this.zip4jRaf, byArray);
                byArray3 = this.getLongByteFromIntByte(byArray);
                fileHeader.setOffsetLocalHeader(Raw.readLongLittleEndian(byArray3, 0) & 0xFFFFFFFFL);
                if (n5 > 0) {
                    byArray4 = new byte[n5];
                    this.readIntoBuff(this.zip4jRaf, byArray4);
                    String string = null;
                    string = Zip4jUtil.isStringNotNullAndNotEmpty(this.zipModel.getFileNameCharset()) ? new String(byArray4, this.zipModel.getFileNameCharset()) : Zip4jUtil.decodeFileName(byArray4, fileHeader.isFileNameUTF8Encoded());
                    if (string == null) {
                        throw new ZipException("fileName is null when reading central directory");
                    }
                    if (string.indexOf(":" + System.getProperty("file.separator")) >= 0) {
                        string = string.substring(string.indexOf(":" + System.getProperty("file.separator")) + 2);
                    }
                    fileHeader.setFileName(string);
                    fileHeader.setDirectory(string.endsWith("/") || string.endsWith("\\"));
                } else {
                    fileHeader.setFileName(null);
                }
                this.readAndSaveExtraDataRecord(fileHeader);
                this.readAndSaveZip64ExtendedInfo(fileHeader);
                this.readAndSaveAESExtraDataRecord(fileHeader);
                if (n7 > 0) {
                    byArray4 = new byte[n7];
                    this.readIntoBuff(this.zip4jRaf, byArray4);
                    fileHeader.setFileComment(new String(byArray4));
                }
                arrayList.add(fileHeader);
            }
            centralDirectory.setFileHeaders(arrayList);
            DigitalSignature digitalSignature = new DigitalSignature();
            this.readIntoBuff(this.zip4jRaf, byArray);
            int n8 = Raw.readIntLittleEndian(byArray, 0);
            if ((long)n8 != 84233040L) {
                return centralDirectory;
            }
            digitalSignature.setHeaderSignature(n8);
            this.readIntoBuff(this.zip4jRaf, byArray2);
            n2 = Raw.readShortLittleEndian(byArray2, 0);
            digitalSignature.setSizeOfData(n2);
            if (n2 > 0) {
                byte[] byArray5 = new byte[n2];
                this.readIntoBuff(this.zip4jRaf, byArray5);
                digitalSignature.setSignatureData(new String(byArray5));
            }
            return centralDirectory;
        }
        catch (IOException iOException) {
            throw new ZipException(iOException);
        }
    }

    private void readAndSaveExtraDataRecord(FileHeader fileHeader) throws ZipException {
        if (this.zip4jRaf == null) {
            throw new ZipException("invalid file handler when trying to read extra data record");
        }
        if (fileHeader == null) {
            throw new ZipException("file header is null");
        }
        int n2 = fileHeader.getExtraFieldLength();
        if (n2 <= 0) {
            return;
        }
        fileHeader.setExtraDataRecords(this.readExtraDataRecords(n2));
    }

    private void readAndSaveExtraDataRecord(LocalFileHeader localFileHeader) throws ZipException {
        if (this.zip4jRaf == null) {
            throw new ZipException("invalid file handler when trying to read extra data record");
        }
        if (localFileHeader == null) {
            throw new ZipException("file header is null");
        }
        int n2 = localFileHeader.getExtraFieldLength();
        if (n2 <= 0) {
            return;
        }
        localFileHeader.setExtraDataRecords(this.readExtraDataRecords(n2));
    }

    private ArrayList readExtraDataRecords(int n2) throws ZipException {
        if (n2 <= 0) {
            return null;
        }
        try {
            int n3;
            byte[] byArray = new byte[n2];
            this.zip4jRaf.read(byArray);
            ArrayList<ExtraDataRecord> arrayList = new ArrayList<ExtraDataRecord>();
            for (int i2 = 0; i2 < n2; i2 += n3) {
                ExtraDataRecord extraDataRecord = new ExtraDataRecord();
                int n4 = Raw.readShortLittleEndian(byArray, i2);
                extraDataRecord.setHeader(n4);
                n3 = Raw.readShortLittleEndian(byArray, i2 += 2);
                if (2 + n3 > n2 && 2 + (n3 = (int)Raw.readShortBigEndian(byArray, i2)) > n2) break;
                extraDataRecord.setSizeOfData(n3);
                i2 += 2;
                if (n3 > 0) {
                    byte[] byArray2 = new byte[n3];
                    System.arraycopy(byArray, i2, byArray2, 0, n3);
                    extraDataRecord.setData(byArray2);
                }
                arrayList.add(extraDataRecord);
            }
            if (arrayList.size() > 0) {
                return arrayList;
            }
            return null;
        }
        catch (IOException iOException) {
            throw new ZipException(iOException);
        }
    }

    private Zip64EndCentralDirLocator readZip64EndCentralDirLocator() throws ZipException {
        if (this.zip4jRaf == null) {
            throw new ZipException("invalid file handler when trying to read Zip64EndCentralDirLocator");
        }
        try {
            Zip64EndCentralDirLocator zip64EndCentralDirLocator = new Zip64EndCentralDirLocator();
            this.setFilePointerToReadZip64EndCentralDirLoc();
            byte[] byArray = new byte[4];
            byte[] byArray2 = new byte[8];
            this.readIntoBuff(this.zip4jRaf, byArray);
            int n2 = Raw.readIntLittleEndian(byArray, 0);
            if ((long)n2 != 117853008L) {
                this.zipModel.setZip64Format(false);
                return null;
            }
            this.zipModel.setZip64Format(true);
            zip64EndCentralDirLocator.setSignature(n2);
            this.readIntoBuff(this.zip4jRaf, byArray);
            zip64EndCentralDirLocator.setNoOfDiskStartOfZip64EndOfCentralDirRec(Raw.readIntLittleEndian(byArray, 0));
            this.readIntoBuff(this.zip4jRaf, byArray2);
            zip64EndCentralDirLocator.setOffsetZip64EndOfCentralDirRec(Raw.readLongLittleEndian(byArray2, 0));
            this.readIntoBuff(this.zip4jRaf, byArray);
            zip64EndCentralDirLocator.setTotNumberOfDiscs(Raw.readIntLittleEndian(byArray, 0));
            return zip64EndCentralDirLocator;
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
    }

    private Zip64EndCentralDirRecord readZip64EndCentralDirRec() throws ZipException {
        if (this.zipModel.getZip64EndCentralDirLocator() == null) {
            throw new ZipException("invalid zip64 end of central directory locator");
        }
        long l2 = this.zipModel.getZip64EndCentralDirLocator().getOffsetZip64EndOfCentralDirRec();
        if (l2 < 0L) {
            throw new ZipException("invalid offset for start of end of central directory record");
        }
        try {
            this.zip4jRaf.seek(l2);
            Zip64EndCentralDirRecord zip64EndCentralDirRecord = new Zip64EndCentralDirRecord();
            byte[] byArray = new byte[2];
            byte[] byArray2 = new byte[4];
            byte[] byArray3 = new byte[8];
            this.readIntoBuff(this.zip4jRaf, byArray2);
            int n2 = Raw.readIntLittleEndian(byArray2, 0);
            if ((long)n2 != 101075792L) {
                throw new ZipException("invalid signature for zip64 end of central directory record");
            }
            zip64EndCentralDirRecord.setSignature(n2);
            this.readIntoBuff(this.zip4jRaf, byArray3);
            zip64EndCentralDirRecord.setSizeOfZip64EndCentralDirRec(Raw.readLongLittleEndian(byArray3, 0));
            this.readIntoBuff(this.zip4jRaf, byArray);
            zip64EndCentralDirRecord.setVersionMadeBy(Raw.readShortLittleEndian(byArray, 0));
            this.readIntoBuff(this.zip4jRaf, byArray);
            zip64EndCentralDirRecord.setVersionNeededToExtract(Raw.readShortLittleEndian(byArray, 0));
            this.readIntoBuff(this.zip4jRaf, byArray2);
            zip64EndCentralDirRecord.setNoOfThisDisk(Raw.readIntLittleEndian(byArray2, 0));
            this.readIntoBuff(this.zip4jRaf, byArray2);
            zip64EndCentralDirRecord.setNoOfThisDiskStartOfCentralDir(Raw.readIntLittleEndian(byArray2, 0));
            this.readIntoBuff(this.zip4jRaf, byArray3);
            zip64EndCentralDirRecord.setTotNoOfEntriesInCentralDirOnThisDisk(Raw.readLongLittleEndian(byArray3, 0));
            this.readIntoBuff(this.zip4jRaf, byArray3);
            zip64EndCentralDirRecord.setTotNoOfEntriesInCentralDir(Raw.readLongLittleEndian(byArray3, 0));
            this.readIntoBuff(this.zip4jRaf, byArray3);
            zip64EndCentralDirRecord.setSizeOfCentralDir(Raw.readLongLittleEndian(byArray3, 0));
            this.readIntoBuff(this.zip4jRaf, byArray3);
            zip64EndCentralDirRecord.setOffsetStartCenDirWRTStartDiskNo(Raw.readLongLittleEndian(byArray3, 0));
            long l3 = zip64EndCentralDirRecord.getSizeOfZip64EndCentralDirRec() - 44L;
            if (l3 > 0L) {
                byte[] byArray4 = new byte[(int)l3];
                this.readIntoBuff(this.zip4jRaf, byArray4);
                zip64EndCentralDirRecord.setExtensibleDataSector(byArray4);
            }
            return zip64EndCentralDirRecord;
        }
        catch (IOException iOException) {
            throw new ZipException(iOException);
        }
    }

    private void readAndSaveZip64ExtendedInfo(FileHeader fileHeader) throws ZipException {
        if (fileHeader == null) {
            throw new ZipException("file header is null in reading Zip64 Extended Info");
        }
        if (fileHeader.getExtraDataRecords() == null || fileHeader.getExtraDataRecords().size() <= 0) {
            return;
        }
        Zip64ExtendedInfo zip64ExtendedInfo = this.readZip64ExtendedInfo(fileHeader.getExtraDataRecords(), fileHeader.getUncompressedSize(), fileHeader.getCompressedSize(), fileHeader.getOffsetLocalHeader(), fileHeader.getDiskNumberStart());
        if (zip64ExtendedInfo != null) {
            fileHeader.setZip64ExtendedInfo(zip64ExtendedInfo);
            if (zip64ExtendedInfo.getUnCompressedSize() != -1L) {
                fileHeader.setUncompressedSize(zip64ExtendedInfo.getUnCompressedSize());
            }
            if (zip64ExtendedInfo.getCompressedSize() != -1L) {
                fileHeader.setCompressedSize(zip64ExtendedInfo.getCompressedSize());
            }
            if (zip64ExtendedInfo.getOffsetLocalHeader() != -1L) {
                fileHeader.setOffsetLocalHeader(zip64ExtendedInfo.getOffsetLocalHeader());
            }
            if (zip64ExtendedInfo.getDiskNumberStart() != -1) {
                fileHeader.setDiskNumberStart(zip64ExtendedInfo.getDiskNumberStart());
            }
        }
    }

    private void readAndSaveZip64ExtendedInfo(LocalFileHeader localFileHeader) throws ZipException {
        if (localFileHeader == null) {
            throw new ZipException("file header is null in reading Zip64 Extended Info");
        }
        if (localFileHeader.getExtraDataRecords() == null || localFileHeader.getExtraDataRecords().size() <= 0) {
            return;
        }
        Zip64ExtendedInfo zip64ExtendedInfo = this.readZip64ExtendedInfo(localFileHeader.getExtraDataRecords(), localFileHeader.getUncompressedSize(), localFileHeader.getCompressedSize(), -1L, -1);
        if (zip64ExtendedInfo != null) {
            localFileHeader.setZip64ExtendedInfo(zip64ExtendedInfo);
            if (zip64ExtendedInfo.getUnCompressedSize() != -1L) {
                localFileHeader.setUncompressedSize(zip64ExtendedInfo.getUnCompressedSize());
            }
            if (zip64ExtendedInfo.getCompressedSize() != -1L) {
                localFileHeader.setCompressedSize(zip64ExtendedInfo.getCompressedSize());
            }
        }
    }

    private Zip64ExtendedInfo readZip64ExtendedInfo(ArrayList arrayList, long l2, long l3, long l4, int n2) throws ZipException {
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            long l5;
            ExtraDataRecord extraDataRecord = (ExtraDataRecord)arrayList.get(i2);
            if (extraDataRecord == null || extraDataRecord.getHeader() != 1L) continue;
            Zip64ExtendedInfo zip64ExtendedInfo = new Zip64ExtendedInfo();
            byte[] byArray = extraDataRecord.getData();
            if (extraDataRecord.getSizeOfData() <= 0) break;
            byte[] byArray2 = new byte[8];
            byte[] byArray3 = new byte[4];
            int n3 = 0;
            boolean bl = false;
            if ((l2 & 0xFFFFL) == 65535L && n3 < extraDataRecord.getSizeOfData()) {
                System.arraycopy(byArray, n3, byArray2, 0, 8);
                l5 = Raw.readLongLittleEndian(byArray2, 0);
                zip64ExtendedInfo.setUnCompressedSize(l5);
                n3 += 8;
                bl = true;
            }
            if ((l3 & 0xFFFFL) == 65535L && n3 < extraDataRecord.getSizeOfData()) {
                System.arraycopy(byArray, n3, byArray2, 0, 8);
                l5 = Raw.readLongLittleEndian(byArray2, 0);
                zip64ExtendedInfo.setCompressedSize(l5);
                n3 += 8;
                bl = true;
            }
            if ((l4 & 0xFFFFL) == 65535L && n3 < extraDataRecord.getSizeOfData()) {
                System.arraycopy(byArray, n3, byArray2, 0, 8);
                l5 = Raw.readLongLittleEndian(byArray2, 0);
                zip64ExtendedInfo.setOffsetLocalHeader(l5);
                n3 += 8;
                bl = true;
            }
            if ((n2 & 0xFFFF) == 65535 && n3 < extraDataRecord.getSizeOfData()) {
                System.arraycopy(byArray, n3, byArray3, 0, 4);
                int n4 = Raw.readIntLittleEndian(byArray3, 0);
                zip64ExtendedInfo.setDiskNumberStart(n4);
                n3 += 8;
                bl = true;
            }
            if (!bl) break;
            return zip64ExtendedInfo;
        }
        return null;
    }

    private void setFilePointerToReadZip64EndCentralDirLoc() throws ZipException {
        try {
            byte[] byArray = new byte[4];
            long l2 = this.zip4jRaf.length() - 22L;
            do {
                this.zip4jRaf.seek(l2--);
            } while ((long)Raw.readLeInt(this.zip4jRaf, byArray) != 101010256L);
            this.zip4jRaf.seek(this.zip4jRaf.getFilePointer() - 4L - 4L - 8L - 4L - 4L);
        }
        catch (IOException iOException) {
            throw new ZipException(iOException);
        }
    }

    public LocalFileHeader readLocalFileHeader(FileHeader fileHeader) throws ZipException {
        Zip64ExtendedInfo zip64ExtendedInfo;
        if (fileHeader == null || this.zip4jRaf == null) {
            throw new ZipException("invalid read parameters for local header");
        }
        long l2 = fileHeader.getOffsetLocalHeader();
        if (fileHeader.getZip64ExtendedInfo() != null && (zip64ExtendedInfo = fileHeader.getZip64ExtendedInfo()).getOffsetLocalHeader() > 0L) {
            l2 = fileHeader.getOffsetLocalHeader();
        }
        if (l2 < 0L) {
            throw new ZipException("invalid local header offset");
        }
        try {
            this.zip4jRaf.seek(l2);
            int n2 = 0;
            LocalFileHeader localFileHeader = new LocalFileHeader();
            byte[] byArray = new byte[2];
            byte[] byArray2 = new byte[4];
            byte[] byArray3 = new byte[8];
            this.readIntoBuff(this.zip4jRaf, byArray2);
            int n3 = Raw.readIntLittleEndian(byArray2, 0);
            if ((long)n3 != 67324752L) {
                throw new ZipException("invalid local header signature for file: " + fileHeader.getFileName());
            }
            localFileHeader.setSignature(n3);
            n2 += 4;
            this.readIntoBuff(this.zip4jRaf, byArray);
            localFileHeader.setVersionNeededToExtract(Raw.readShortLittleEndian(byArray, 0));
            n2 += 2;
            this.readIntoBuff(this.zip4jRaf, byArray);
            localFileHeader.setFileNameUTF8Encoded((Raw.readShortLittleEndian(byArray, 0) & 0x800) != 0);
            byte by = byArray[0];
            int n4 = by & 1;
            if (n4 != 0) {
                localFileHeader.setEncrypted(true);
            }
            localFileHeader.setGeneralPurposeFlag(byArray);
            n2 += 2;
            String string = Integer.toBinaryString(by);
            if (string.length() >= 4) {
                localFileHeader.setDataDescriptorExists(string.charAt(3) == '1');
            }
            this.readIntoBuff(this.zip4jRaf, byArray);
            localFileHeader.setCompressionMethod(Raw.readShortLittleEndian(byArray, 0));
            n2 += 2;
            this.readIntoBuff(this.zip4jRaf, byArray2);
            localFileHeader.setLastModFileTime(Raw.readIntLittleEndian(byArray2, 0));
            n2 += 4;
            this.readIntoBuff(this.zip4jRaf, byArray2);
            localFileHeader.setCrc32(Raw.readIntLittleEndian(byArray2, 0));
            localFileHeader.setCrcBuff((byte[])byArray2.clone());
            n2 += 4;
            this.readIntoBuff(this.zip4jRaf, byArray2);
            byArray3 = this.getLongByteFromIntByte(byArray2);
            localFileHeader.setCompressedSize(Raw.readLongLittleEndian(byArray3, 0));
            n2 += 4;
            this.readIntoBuff(this.zip4jRaf, byArray2);
            byArray3 = this.getLongByteFromIntByte(byArray2);
            localFileHeader.setUncompressedSize(Raw.readLongLittleEndian(byArray3, 0));
            n2 += 4;
            this.readIntoBuff(this.zip4jRaf, byArray);
            int n5 = Raw.readShortLittleEndian(byArray, 0);
            localFileHeader.setFileNameLength(n5);
            n2 += 2;
            this.readIntoBuff(this.zip4jRaf, byArray);
            int n6 = Raw.readShortLittleEndian(byArray, 0);
            localFileHeader.setExtraFieldLength(n6);
            n2 += 2;
            if (n5 > 0) {
                byte[] byArray4 = new byte[n5];
                this.readIntoBuff(this.zip4jRaf, byArray4);
                String string2 = Zip4jUtil.decodeFileName(byArray4, localFileHeader.isFileNameUTF8Encoded());
                if (string2 == null) {
                    throw new ZipException("file name is null, cannot assign file name to local file header");
                }
                if (string2.indexOf(":" + System.getProperty("file.separator")) >= 0) {
                    string2 = string2.substring(string2.indexOf(":" + System.getProperty("file.separator")) + 2);
                }
                localFileHeader.setFileName(string2);
                n2 += n5;
            } else {
                localFileHeader.setFileName(null);
            }
            this.readAndSaveExtraDataRecord(localFileHeader);
            localFileHeader.setOffsetStartOfData(l2 + (long)(n2 += n6));
            localFileHeader.setPassword(fileHeader.getPassword());
            this.readAndSaveZip64ExtendedInfo(localFileHeader);
            this.readAndSaveAESExtraDataRecord(localFileHeader);
            if (localFileHeader.isEncrypted() && localFileHeader.getEncryptionMethod() != 99) {
                if ((by & 0x40) == 64) {
                    localFileHeader.setEncryptionMethod(1);
                } else {
                    localFileHeader.setEncryptionMethod(0);
                }
            }
            if (localFileHeader.getCrc32() <= 0L) {
                localFileHeader.setCrc32(fileHeader.getCrc32());
                localFileHeader.setCrcBuff(fileHeader.getCrcBuff());
            }
            if (localFileHeader.getCompressedSize() <= 0L) {
                localFileHeader.setCompressedSize(fileHeader.getCompressedSize());
            }
            if (localFileHeader.getUncompressedSize() <= 0L) {
                localFileHeader.setUncompressedSize(fileHeader.getUncompressedSize());
            }
            return localFileHeader;
        }
        catch (IOException iOException) {
            throw new ZipException(iOException);
        }
    }

    private void readAndSaveAESExtraDataRecord(FileHeader fileHeader) throws ZipException {
        if (fileHeader == null) {
            throw new ZipException("file header is null in reading Zip64 Extended Info");
        }
        if (fileHeader.getExtraDataRecords() == null || fileHeader.getExtraDataRecords().size() <= 0) {
            return;
        }
        AESExtraDataRecord aESExtraDataRecord = this.readAESExtraDataRecord(fileHeader.getExtraDataRecords());
        if (aESExtraDataRecord != null) {
            fileHeader.setAesExtraDataRecord(aESExtraDataRecord);
            fileHeader.setEncryptionMethod(99);
        }
    }

    private void readAndSaveAESExtraDataRecord(LocalFileHeader localFileHeader) throws ZipException {
        if (localFileHeader == null) {
            throw new ZipException("file header is null in reading Zip64 Extended Info");
        }
        if (localFileHeader.getExtraDataRecords() == null || localFileHeader.getExtraDataRecords().size() <= 0) {
            return;
        }
        AESExtraDataRecord aESExtraDataRecord = this.readAESExtraDataRecord(localFileHeader.getExtraDataRecords());
        if (aESExtraDataRecord != null) {
            localFileHeader.setAesExtraDataRecord(aESExtraDataRecord);
            localFileHeader.setEncryptionMethod(99);
        }
    }

    private AESExtraDataRecord readAESExtraDataRecord(ArrayList arrayList) throws ZipException {
        if (arrayList == null) {
            return null;
        }
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            ExtraDataRecord extraDataRecord = (ExtraDataRecord)arrayList.get(i2);
            if (extraDataRecord == null || extraDataRecord.getHeader() != 39169L) continue;
            if (extraDataRecord.getData() == null) {
                throw new ZipException("corrput AES extra data records");
            }
            AESExtraDataRecord aESExtraDataRecord = new AESExtraDataRecord();
            aESExtraDataRecord.setSignature(39169L);
            aESExtraDataRecord.setDataSize(extraDataRecord.getSizeOfData());
            byte[] byArray = extraDataRecord.getData();
            aESExtraDataRecord.setVersionNumber(Raw.readShortLittleEndian(byArray, 0));
            byte[] byArray2 = new byte[2];
            System.arraycopy(byArray, 2, byArray2, 0, 2);
            aESExtraDataRecord.setVendorID(new String(byArray2));
            aESExtraDataRecord.setAesStrength(byArray[4] & 0xFF);
            aESExtraDataRecord.setCompressionMethod(Raw.readShortLittleEndian(byArray, 5));
            return aESExtraDataRecord;
        }
        return null;
    }

    private byte[] readIntoBuff(RandomAccessFile randomAccessFile, byte[] byArray) throws ZipException {
        try {
            if (randomAccessFile.read(byArray, 0, byArray.length) != -1) {
                return byArray;
            }
            throw new ZipException("unexpected end of file when reading short buff");
        }
        catch (IOException iOException) {
            throw new ZipException("IOException when reading short buff", iOException);
        }
    }

    private byte[] getLongByteFromIntByte(byte[] byArray) throws ZipException {
        if (byArray == null) {
            throw new ZipException("input parameter is null, cannot expand to 8 bytes");
        }
        if (byArray.length != 4) {
            throw new ZipException("invalid byte length, cannot expand to 8 bytes");
        }
        byte[] byArray2 = new byte[]{byArray[0], byArray[1], byArray[2], byArray[3], 0, 0, 0, 0};
        return byArray2;
    }
}

