/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.javax.xml.stream.dtd.nonvalidating;

import com.fr.third.javax.xml.stream.dtd.nonvalidating.XMLAttributeDecl;
import com.fr.third.javax.xml.stream.dtd.nonvalidating.XMLElementDecl;
import com.fr.third.javax.xml.stream.dtd.nonvalidating.XMLNotationDecl;
import com.fr.third.javax.xml.stream.dtd.nonvalidating.XMLSimpleType;
import com.fr.third.javax.xml.stream.xerces.util.SymbolTable;
import com.fr.third.javax.xml.stream.xerces.util.XMLSymbols;
import com.fr.third.javax.xml.stream.xerces.xni.Augmentations;
import com.fr.third.javax.xml.stream.xerces.xni.QName;
import com.fr.third.javax.xml.stream.xerces.xni.XMLLocator;
import com.fr.third.javax.xml.stream.xerces.xni.XMLResourceIdentifier;
import com.fr.third.javax.xml.stream.xerces.xni.XMLString;
import com.fr.third.javax.xml.stream.xerces.xni.XNIException;
import com.fr.third.javax.xml.stream.xerces.xni.parser.XMLDTDContentModelSource;
import com.fr.third.javax.xml.stream.xerces.xni.parser.XMLDTDSource;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class DTDGrammar {
    public static final int TOP_LEVEL_SCOPE = -1;
    private static final int CHUNK_SHIFT = 8;
    private static final int CHUNK_SIZE = 256;
    private static final int CHUNK_MASK = 255;
    private static final int INITIAL_CHUNK_COUNT = 4;
    private static final short LIST_FLAG = 128;
    private static final short LIST_MASK = -129;
    private static final boolean DEBUG = false;
    protected XMLDTDSource fDTDSource = null;
    protected XMLDTDContentModelSource fDTDContentModelSource = null;
    protected int fCurrentElementIndex;
    protected int fCurrentAttributeIndex;
    protected boolean fReadingExternalDTD = false;
    private SymbolTable fSymbolTable;
    private ArrayList notationDecls = new ArrayList();
    private int fElementDeclCount = 0;
    private QName[][] fElementDeclName = new QName[4][];
    private short[][] fElementDeclType = new short[4][];
    private int[][] fElementDeclFirstAttributeDeclIndex = new int[4][];
    private int[][] fElementDeclLastAttributeDeclIndex = new int[4][];
    private int fAttributeDeclCount = 0;
    private QName[][] fAttributeDeclName = new QName[4][];
    private boolean fIsImmutable = false;
    private short[][] fAttributeDeclType = new short[4][];
    private String[][][] fAttributeDeclEnumeration = new String[4][][];
    private short[][] fAttributeDeclDefaultType = new short[4][];
    private String[][] fAttributeDeclDefaultValue = new String[4][];
    private String[][] fAttributeDeclNonNormalizedDefaultValue = new String[4][];
    private int[][] fAttributeDeclNextAttributeDeclIndex = new int[4][];
    private QNameHashtable fElementIndexMap = new QNameHashtable();
    private QName fQName = new QName();
    private QName fQName2 = new QName();
    protected XMLAttributeDecl fAttributeDecl = new XMLAttributeDecl();
    private int fLeafCount = 0;
    private int fEpsilonIndex = -1;
    private XMLElementDecl fElementDecl = new XMLElementDecl();
    private XMLSimpleType fSimpleType = new XMLSimpleType();
    Hashtable fElementDeclTab = new Hashtable();
    private short[] fOpStack = null;
    private int[] fNodeIndexStack = null;
    private int[] fPrevNodeIndexStack = null;
    private int fDepth = 0;
    int valueIndex = -1;
    int prevNodeIndex = -1;
    int nodeIndex = -1;

    public DTDGrammar(SymbolTable symbolTable) {
        this.fSymbolTable = symbolTable;
    }

    public int getAttributeDeclIndex(int n2, String string) {
        if (n2 == -1) {
            return -1;
        }
        int n3 = this.getFirstAttributeDeclIndex(n2);
        while (n3 != -1) {
            this.getAttributeDecl(n3, this.fAttributeDecl);
            if (this.fAttributeDecl.name.rawname == string || string.equals(this.fAttributeDecl.name.rawname)) {
                return n3;
            }
            n3 = this.getNextAttributeDeclIndex(n3);
        }
        return -1;
    }

    public void startDTD(XMLLocator xMLLocator, Augmentations augmentations) throws XNIException {
        this.fOpStack = null;
        this.fNodeIndexStack = null;
        this.fPrevNodeIndexStack = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void elementDecl(String string, String string2, Augmentations augmentations) throws XNIException {
        XMLElementDecl xMLElementDecl = (XMLElementDecl)this.fElementDeclTab.get(string);
        if (xMLElementDecl != null) {
            if (xMLElementDecl.type != -1) return;
            this.fCurrentElementIndex = this.getElementDeclIndex(string);
        } else {
            this.fCurrentElementIndex = this.createElementDecl();
        }
        XMLElementDecl xMLElementDecl2 = new XMLElementDecl();
        QName qName = new QName(null, string, string, null);
        xMLElementDecl2.name.setValues(qName);
        xMLElementDecl2.scope = -1;
        if (string2.equals("EMPTY")) {
            xMLElementDecl2.type = 1;
        } else if (string2.equals("ANY")) {
            xMLElementDecl2.type = 0;
        } else if (string2.startsWith("(")) {
            xMLElementDecl2.type = string2.indexOf("#PCDATA") > 0 ? (short)2 : (short)3;
        }
        this.fElementDeclTab.put(string, xMLElementDecl2);
        this.fElementDecl = xMLElementDecl2;
        this.setElementDecl(this.fCurrentElementIndex, this.fElementDecl);
        int n2 = this.fCurrentElementIndex >> 8;
        int n3 = this.fCurrentElementIndex & 0xFF;
        this.ensureElementDeclCapacity(n2);
    }

    public void attributeDecl(String string, String string2, String string3, String[] stringArray, String string4, XMLString xMLString, XMLString xMLString2, Augmentations augmentations) throws XNIException {
        int n2;
        if (string3 != XMLSymbols.fCDATASymbol && xMLString != null) {
            this.normalizeDefaultAttrValue(xMLString);
        }
        if (!this.fElementDeclTab.containsKey(string)) {
            this.fCurrentElementIndex = this.createElementDecl();
            XMLElementDecl xMLElementDecl = new XMLElementDecl();
            xMLElementDecl.name.setValues(null, string, string, null);
            xMLElementDecl.scope = -1;
            this.fElementDeclTab.put(string, xMLElementDecl);
            this.setElementDecl(this.fCurrentElementIndex, xMLElementDecl);
        }
        if (this.getAttributeDeclIndex(n2 = this.getElementDeclIndex(string), string2) != -1) {
            return;
        }
        this.fCurrentAttributeIndex = this.createAttributeDecl();
        this.fSimpleType.clear();
        if (string4 != null) {
            if (string4.equals("#FIXED")) {
                this.fSimpleType.defaultType = 1;
            } else if (string4.equals("#IMPLIED")) {
                this.fSimpleType.defaultType = 0;
            } else if (string4.equals("#REQUIRED")) {
                this.fSimpleType.defaultType = (short)2;
            }
        }
        this.fSimpleType.defaultValue = xMLString != null ? xMLString.toString() : null;
        this.fSimpleType.nonNormalizedDefaultValue = xMLString2 != null ? xMLString2.toString() : null;
        this.fSimpleType.enumeration = stringArray;
        if (string3.equals("CDATA")) {
            this.fSimpleType.type = 0;
        } else if (string3.equals("ID")) {
            this.fSimpleType.type = (short)3;
        } else if (string3.startsWith("IDREF")) {
            this.fSimpleType.type = (short)4;
            if (string3.indexOf("S") > 0) {
                this.fSimpleType.list = true;
            }
        } else if (string3.equals("ENTITIES")) {
            this.fSimpleType.type = 1;
            this.fSimpleType.list = true;
        } else if (string3.equals("ENTITY")) {
            this.fSimpleType.type = 1;
        } else if (string3.equals("NMTOKENS")) {
            this.fSimpleType.type = (short)5;
            this.fSimpleType.list = true;
        } else if (string3.equals("NMTOKEN")) {
            this.fSimpleType.type = (short)5;
        } else if (string3.startsWith("NOTATION")) {
            this.fSimpleType.type = (short)6;
        } else if (string3.startsWith("ENUMERATION")) {
            this.fSimpleType.type = (short)2;
        } else {
            System.err.println("!!! unknown attribute type " + string3);
        }
        this.fQName.setValues(null, string2, string2, null);
        this.fAttributeDecl.setValues(this.fQName, this.fSimpleType, false);
        this.setAttributeDecl(n2, this.fCurrentAttributeIndex, this.fAttributeDecl);
        int n3 = this.fCurrentAttributeIndex >> 8;
        int n4 = this.fCurrentAttributeIndex & 0xFF;
        this.ensureAttributeDeclCapacity(n3);
    }

    public SymbolTable getSymbolTable() {
        return this.fSymbolTable;
    }

    public int getFirstElementDeclIndex() {
        return this.fElementDeclCount >= 0 ? 0 : -1;
    }

    public int getNextElementDeclIndex(int n2) {
        return n2 < this.fElementDeclCount - 1 ? n2 + 1 : -1;
    }

    public int getElementDeclIndex(String string) {
        int n2 = this.fElementIndexMap.get(string);
        return n2;
    }

    public int getElementDeclIndex(QName qName) {
        return this.getElementDeclIndex(qName.rawname);
    }

    public short getContentSpecType(int n2) {
        if (n2 < 0 || n2 >= this.fElementDeclCount) {
            return -1;
        }
        int n3 = n2 >> 8;
        int n4 = n2 & 0xFF;
        if (this.fElementDeclType[n3][n4] == -1) {
            return -1;
        }
        return (short)(this.fElementDeclType[n3][n4] & 0xFFFFFF7F);
    }

    public boolean getElementDecl(int n2, XMLElementDecl xMLElementDecl) {
        if (n2 < 0 || n2 >= this.fElementDeclCount) {
            return false;
        }
        int n3 = n2 >> 8;
        int n4 = n2 & 0xFF;
        xMLElementDecl.name.setValues(this.fElementDeclName[n3][n4]);
        if (this.fElementDeclType[n3][n4] == -1) {
            xMLElementDecl.type = (short)-1;
            xMLElementDecl.simpleType.list = false;
        } else {
            xMLElementDecl.type = (short)(this.fElementDeclType[n3][n4] & 0xFFFFFF7F);
            xMLElementDecl.simpleType.list = (this.fElementDeclType[n3][n4] & 0x80) != 0;
        }
        xMLElementDecl.simpleType.defaultType = (short)-1;
        xMLElementDecl.simpleType.defaultValue = null;
        return true;
    }

    public int getFirstAttributeDeclIndex(int n2) {
        int n3 = n2 >> 8;
        int n4 = n2 & 0xFF;
        return this.fElementDeclFirstAttributeDeclIndex[n3][n4];
    }

    public int getNextAttributeDeclIndex(int n2) {
        int n3 = n2 >> 8;
        int n4 = n2 & 0xFF;
        return this.fAttributeDeclNextAttributeDeclIndex[n3][n4];
    }

    public boolean getAttributeDecl(int n2, XMLAttributeDecl xMLAttributeDecl) {
        boolean bl;
        short s2;
        if (n2 < 0 || n2 >= this.fAttributeDeclCount) {
            return false;
        }
        int n3 = n2 >> 8;
        int n4 = n2 & 0xFF;
        xMLAttributeDecl.name.setValues(this.fAttributeDeclName[n3][n4]);
        if (this.fAttributeDeclType[n3][n4] == -1) {
            s2 = -1;
            bl = false;
        } else {
            s2 = (short)(this.fAttributeDeclType[n3][n4] & 0xFFFFFF7F);
            bl = (this.fAttributeDeclType[n3][n4] & 0x80) != 0;
        }
        xMLAttributeDecl.simpleType.setValues(s2, this.fAttributeDeclName[n3][n4].localpart, this.fAttributeDeclEnumeration[n3][n4], bl, this.fAttributeDeclDefaultType[n3][n4], this.fAttributeDeclDefaultValue[n3][n4], this.fAttributeDeclNonNormalizedDefaultValue[n3][n4]);
        return true;
    }

    public boolean isCDATAAttribute(QName qName, QName qName2) {
        int n2 = this.getElementDeclIndex(qName);
        int n3 = this.getAttributeDeclIndex(n2, qName2.rawname);
        return !this.getAttributeDecl(n2, this.fAttributeDecl) || this.fAttributeDecl.simpleType.type == 0;
    }

    public void printElements() {
        int n2 = 0;
        XMLElementDecl xMLElementDecl = new XMLElementDecl();
        while (this.getElementDecl(n2++, xMLElementDecl)) {
            System.out.println("element decl: " + xMLElementDecl.name + ", " + xMLElementDecl.name.rawname);
        }
    }

    public void printAttributes(int n2) {
        int n3 = this.getFirstAttributeDeclIndex(n2);
        System.out.print(n2);
        System.out.print(" [");
        while (n3 != -1) {
            System.out.print(' ');
            System.out.print(n3);
            this.printAttribute(n3);
            n3 = this.getNextAttributeDeclIndex(n3);
            if (n3 == -1) continue;
            System.out.print(",");
        }
        System.out.println(" ]");
    }

    protected int createElementDecl() {
        int n2 = this.fElementDeclCount >> 8;
        int n3 = this.fElementDeclCount & 0xFF;
        this.ensureElementDeclCapacity(n2);
        this.fElementDeclName[n2][n3] = new QName();
        this.fElementDeclType[n2][n3] = -1;
        this.fElementDeclFirstAttributeDeclIndex[n2][n3] = -1;
        this.fElementDeclLastAttributeDeclIndex[n2][n3] = -1;
        return this.fElementDeclCount++;
    }

    protected void setElementDecl(int n2, XMLElementDecl xMLElementDecl) {
        if (n2 < 0 || n2 >= this.fElementDeclCount) {
            return;
        }
        int n3 = n2 >> 8;
        int n4 = n2 & 0xFF;
        int n5 = xMLElementDecl.scope;
        this.fElementDeclName[n3][n4].setValues(xMLElementDecl.name);
        this.fElementDeclType[n3][n4] = xMLElementDecl.type;
        if (xMLElementDecl.simpleType.list) {
            int n6 = n4;
            short[] sArray = this.fElementDeclType[n3];
            sArray[n6] = (short)(sArray[n6] | 0x80);
        }
        this.fElementIndexMap.put(xMLElementDecl.name.rawname, n2);
    }

    protected void setFirstAttributeDeclIndex(int n2, int n3) {
        if (n2 < 0 || n2 >= this.fElementDeclCount) {
            return;
        }
        int n4 = n2 >> 8;
        int n5 = n2 & 0xFF;
        this.fElementDeclFirstAttributeDeclIndex[n4][n5] = n3;
    }

    protected int createAttributeDecl() {
        int n2 = this.fAttributeDeclCount >> 8;
        int n3 = this.fAttributeDeclCount & 0xFF;
        this.ensureAttributeDeclCapacity(n2);
        this.fAttributeDeclName[n2][n3] = new QName();
        this.fAttributeDeclType[n2][n3] = -1;
        this.fAttributeDeclEnumeration[n2][n3] = null;
        this.fAttributeDeclDefaultType[n2][n3] = 0;
        this.fAttributeDeclDefaultValue[n2][n3] = null;
        this.fAttributeDeclNonNormalizedDefaultValue[n2][n3] = null;
        this.fAttributeDeclNextAttributeDeclIndex[n2][n3] = -1;
        return this.fAttributeDeclCount++;
    }

    protected void setAttributeDecl(int n2, int n3, XMLAttributeDecl xMLAttributeDecl) {
        int n4;
        int n5 = n3 >> 8;
        int n6 = n3 & 0xFF;
        this.fAttributeDeclName[n5][n6].setValues(xMLAttributeDecl.name);
        this.fAttributeDeclType[n5][n6] = xMLAttributeDecl.simpleType.type;
        if (xMLAttributeDecl.simpleType.list) {
            n4 = n6;
            short[] sArray = this.fAttributeDeclType[n5];
            sArray[n4] = (short)(sArray[n4] | 0x80);
        }
        this.fAttributeDeclEnumeration[n5][n6] = xMLAttributeDecl.simpleType.enumeration;
        this.fAttributeDeclDefaultType[n5][n6] = xMLAttributeDecl.simpleType.defaultType;
        this.fAttributeDeclDefaultValue[n5][n6] = xMLAttributeDecl.simpleType.defaultValue;
        this.fAttributeDeclNonNormalizedDefaultValue[n5][n6] = xMLAttributeDecl.simpleType.nonNormalizedDefaultValue;
        n4 = n2 >> 8;
        int n7 = n2 & 0xFF;
        int n8 = this.fElementDeclFirstAttributeDeclIndex[n4][n7];
        while (n8 != -1 && n8 != n3) {
            n5 = n8 >> 8;
            n6 = n8 & 0xFF;
            n8 = this.fAttributeDeclNextAttributeDeclIndex[n5][n6];
        }
        if (n8 == -1) {
            if (this.fElementDeclFirstAttributeDeclIndex[n4][n7] == -1) {
                this.fElementDeclFirstAttributeDeclIndex[n4][n7] = n3;
            } else {
                n8 = this.fElementDeclLastAttributeDeclIndex[n4][n7];
                n5 = n8 >> 8;
                n6 = n8 & 0xFF;
                this.fAttributeDeclNextAttributeDeclIndex[n5][n6] = n3;
            }
            this.fElementDeclLastAttributeDeclIndex[n4][n7] = n3;
        }
    }

    public void notationDecl(String string, XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) throws XNIException {
        XMLNotationDecl xMLNotationDecl = new XMLNotationDecl();
        xMLNotationDecl.setValues(string, xMLResourceIdentifier.getPublicId(), xMLResourceIdentifier.getLiteralSystemId(), xMLResourceIdentifier.getBaseSystemId());
        this.notationDecls.add(xMLNotationDecl);
    }

    public List getNotationDecls() {
        return this.notationDecls;
    }

    private void printAttribute(int n2) {
        XMLAttributeDecl xMLAttributeDecl = new XMLAttributeDecl();
        if (this.getAttributeDecl(n2, xMLAttributeDecl)) {
            System.out.print(" { ");
            System.out.print(xMLAttributeDecl.name.localpart);
            System.out.print(" }");
        }
    }

    private void ensureElementDeclCapacity(int n2) {
        if (n2 >= this.fElementDeclName.length) {
            this.fElementDeclName = DTDGrammar.resize(this.fElementDeclName, this.fElementDeclName.length * 2);
            this.fElementDeclType = DTDGrammar.resize(this.fElementDeclType, this.fElementDeclType.length * 2);
            this.fElementDeclFirstAttributeDeclIndex = DTDGrammar.resize(this.fElementDeclFirstAttributeDeclIndex, this.fElementDeclFirstAttributeDeclIndex.length * 2);
            this.fElementDeclLastAttributeDeclIndex = DTDGrammar.resize(this.fElementDeclLastAttributeDeclIndex, this.fElementDeclLastAttributeDeclIndex.length * 2);
        } else if (this.fElementDeclName[n2] != null) {
            return;
        }
        this.fElementDeclName[n2] = new QName[256];
        this.fElementDeclType[n2] = new short[256];
        this.fElementDeclFirstAttributeDeclIndex[n2] = new int[256];
        this.fElementDeclLastAttributeDeclIndex[n2] = new int[256];
    }

    private void ensureAttributeDeclCapacity(int n2) {
        if (n2 >= this.fAttributeDeclName.length) {
            this.fAttributeDeclName = DTDGrammar.resize(this.fAttributeDeclName, this.fAttributeDeclName.length * 2);
            this.fAttributeDeclType = DTDGrammar.resize(this.fAttributeDeclType, this.fAttributeDeclType.length * 2);
            this.fAttributeDeclEnumeration = DTDGrammar.resize(this.fAttributeDeclEnumeration, this.fAttributeDeclEnumeration.length * 2);
            this.fAttributeDeclDefaultType = DTDGrammar.resize(this.fAttributeDeclDefaultType, this.fAttributeDeclDefaultType.length * 2);
            this.fAttributeDeclDefaultValue = DTDGrammar.resize(this.fAttributeDeclDefaultValue, this.fAttributeDeclDefaultValue.length * 2);
            this.fAttributeDeclNonNormalizedDefaultValue = DTDGrammar.resize(this.fAttributeDeclNonNormalizedDefaultValue, this.fAttributeDeclNonNormalizedDefaultValue.length * 2);
            this.fAttributeDeclNextAttributeDeclIndex = DTDGrammar.resize(this.fAttributeDeclNextAttributeDeclIndex, this.fAttributeDeclNextAttributeDeclIndex.length * 2);
        } else if (this.fAttributeDeclName[n2] != null) {
            return;
        }
        this.fAttributeDeclName[n2] = new QName[256];
        this.fAttributeDeclType[n2] = new short[256];
        this.fAttributeDeclEnumeration[n2] = new String[256][];
        this.fAttributeDeclDefaultType[n2] = new short[256];
        this.fAttributeDeclDefaultValue[n2] = new String[256];
        this.fAttributeDeclNonNormalizedDefaultValue[n2] = new String[256];
        this.fAttributeDeclNextAttributeDeclIndex[n2] = new int[256];
    }

    private static byte[][] resize(byte[][] byArray, int n2) {
        byte[][] byArrayArray = new byte[n2][];
        System.arraycopy(byArray, 0, byArrayArray, 0, byArray.length);
        return byArrayArray;
    }

    private static short[][] resize(short[][] sArray, int n2) {
        short[][] sArrayArray = new short[n2][];
        System.arraycopy(sArray, 0, sArrayArray, 0, sArray.length);
        return sArrayArray;
    }

    private static int[][] resize(int[][] nArray, int n2) {
        int[][] nArrayArray = new int[n2][];
        System.arraycopy(nArray, 0, nArrayArray, 0, nArray.length);
        return nArrayArray;
    }

    private static Object[][] resize(Object[][] objectArray, int n2) {
        Object[][] objectArray2 = new Object[n2][];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        return objectArray2;
    }

    private static QName[][] resize(QName[][] qNameArray, int n2) {
        QName[][] qNameArray2 = new QName[n2][];
        System.arraycopy(qNameArray, 0, qNameArray2, 0, qNameArray.length);
        return qNameArray2;
    }

    private static String[][] resize(String[][] stringArray, int n2) {
        String[][] stringArray2 = new String[n2][];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    private static String[][][] resize(String[][][] stringArray, int n2) {
        String[][][] stringArray2 = new String[n2][][];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    private boolean normalizeDefaultAttrValue(XMLString xMLString) {
        int n2 = xMLString.length;
        boolean bl = true;
        int n3 = xMLString.offset;
        int n4 = xMLString.offset + xMLString.length;
        int n5 = xMLString.offset;
        while (n5 < n4) {
            if (xMLString.ch[n5] == ' ') {
                if (!bl) {
                    xMLString.ch[n3++] = 32;
                    bl = true;
                }
            } else {
                if (n3 != n5) {
                    xMLString.ch[n3] = xMLString.ch[n5];
                }
                ++n3;
                bl = false;
            }
            ++n5;
        }
        if (n3 != n4) {
            if (bl) {
                --n3;
            }
            xMLString.length = n3 - xMLString.offset;
            return true;
        }
        return false;
    }

    public void endDTD(Augmentations augmentations) throws XNIException {
    }

    protected static final class QNameHashtable {
        public static final boolean UNIQUE_STRINGS = true;
        private static final int INITIAL_BUCKET_SIZE = 4;
        private static final int HASHTABLE_SIZE = 101;
        private Object[][] fHashTable = new Object[101][];

        protected QNameHashtable() {
        }

        public void put(String string, int n2) {
            int n3 = (this.hash(string) + 2) % 101;
            Object[] objectArray = this.fHashTable[n3];
            if (objectArray == null) {
                objectArray = new Object[9];
                objectArray[0] = new int[]{1};
                objectArray[1] = string;
                objectArray[2] = new int[]{n2};
                this.fHashTable[n3] = objectArray;
            } else {
                int n4;
                int n5 = ((int[])objectArray[0])[0];
                int n6 = 1 + 2 * n5;
                if (n6 == objectArray.length) {
                    n4 = n5 + 4;
                    Object[] objectArray2 = new Object[1 + 2 * n4];
                    System.arraycopy(objectArray, 0, objectArray2, 0, n6);
                    objectArray = objectArray2;
                    this.fHashTable[n3] = objectArray;
                }
                n4 = 0;
                int n7 = 1;
                int n8 = 0;
                while (n8 < n5) {
                    if ((String)objectArray[n7] == string) {
                        ((int[])objectArray[n7 + 1])[0] = n2;
                        n4 = 1;
                        break;
                    }
                    n7 += 2;
                    ++n8;
                }
                if (n4 == 0) {
                    objectArray[n6++] = string;
                    objectArray[n6] = new int[]{n2};
                    ((int[])objectArray[0])[0] = ++n5;
                }
            }
        }

        public int get(String string) {
            int n2 = (this.hash(string) + 2) % 101;
            Object[] objectArray = this.fHashTable[n2];
            if (objectArray == null) {
                return -1;
            }
            int n3 = ((int[])objectArray[0])[0];
            int n4 = 1;
            int n5 = 0;
            while (n5 < n3) {
                if ((String)objectArray[n4] == string) {
                    return ((int[])objectArray[n4 + 1])[0];
                }
                n4 += 2;
                ++n5;
            }
            return -1;
        }

        protected int hash(String string) {
            if (string == null) {
                return 0;
            }
            int n2 = 0;
            int n3 = string.length();
            int n4 = 0;
            while (n4 < n3) {
                n2 = n2 * 37 + string.charAt(n4);
                ++n4;
            }
            return n2 & 0x7FFFFFF;
        }
    }
}

