/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.javax.xml.stream.dtd;

import com.fr.third.javax.xml.stream.dtd.nonvalidating.DTDGrammar;
import com.fr.third.javax.xml.stream.dtd.nonvalidating.XMLAttributeDecl;
import com.fr.third.javax.xml.stream.xerces.util.NamespaceSupport;
import com.fr.third.javax.xml.stream.xerces.util.SymbolTable;
import com.fr.third.javax.xml.stream.xerces.util.XMLChar;
import com.fr.third.javax.xml.stream.xerces.util.XMLSymbols;
import com.fr.third.javax.xml.stream.xerces.xni.Augmentations;
import com.fr.third.javax.xml.stream.xerces.xni.NamespaceContext;
import com.fr.third.javax.xml.stream.xerces.xni.QName;
import com.fr.third.javax.xml.stream.xerces.xni.XMLAttributes;
import com.fr.third.javax.xml.stream.xerces.xni.XMLString;
import com.fr.third.javax.xml.stream.xerces.xni.XNIException;
import com.fr.third.javax.xml.stream.xerces.xni.parser.XMLComponentManager;
import com.fr.third.javax.xml.stream.xerces.xni.parser.XMLConfigurationException;

public class DTDGrammarUtil {
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    private static final boolean DEBUG_ATTRIBUTES = false;
    private static final boolean DEBUG_ELEMENT_CHILDREN = false;
    protected DTDGrammar fDTDGrammar = null;
    protected boolean fNamespaces;
    protected SymbolTable fSymbolTable = null;
    private int fCurrentElementIndex = -1;
    private int fCurrentContentSpecType = -1;
    private boolean fInCDATASection = false;
    private boolean[] fElementContentState = new boolean[8];
    private int fElementDepth = -1;
    private boolean fInElementContent = false;
    private XMLAttributeDecl fTempAttDecl = new XMLAttributeDecl();
    private QName fTempQName = new QName();
    private StringBuffer fBuffer = new StringBuffer();
    private NamespaceContext fNamespaceContext = null;

    public DTDGrammarUtil(SymbolTable symbolTable) {
        this.fSymbolTable = symbolTable;
    }

    public DTDGrammarUtil(DTDGrammar dTDGrammar, SymbolTable symbolTable) {
        this.fDTDGrammar = dTDGrammar;
        this.fSymbolTable = symbolTable;
    }

    public DTDGrammarUtil(DTDGrammar dTDGrammar, SymbolTable symbolTable, NamespaceContext namespaceContext) {
        this.fDTDGrammar = dTDGrammar;
        this.fSymbolTable = symbolTable;
        this.fNamespaceContext = namespaceContext;
    }

    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        this.fDTDGrammar = null;
        this.fInCDATASection = false;
        this.fInElementContent = false;
        this.fCurrentElementIndex = -1;
        this.fCurrentContentSpecType = -1;
        try {
            this.fNamespaces = xMLComponentManager.getFeature(NAMESPACES);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fNamespaces = true;
        }
        this.fSymbolTable = (SymbolTable)xMLComponentManager.getProperty(SYMBOL_TABLE);
        this.fElementDepth = -1;
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes) throws XNIException {
        this.handleStartElement(qName, xMLAttributes);
    }

    public void endElement(QName qName) throws XNIException {
        this.handleEndElement(qName);
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
        this.fInCDATASection = true;
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
        this.fInCDATASection = false;
    }

    public void addDTDDefaultAttrs(QName qName, XMLAttributes xMLAttributes) throws XNIException {
        boolean bl;
        int n2;
        String string;
        int n3 = this.fDTDGrammar.getElementDeclIndex(qName);
        if (n3 == -1 || this.fDTDGrammar == null) {
            return;
        }
        int n4 = this.fDTDGrammar.getFirstAttributeDeclIndex(n3);
        while (n4 != -1) {
            int n5;
            boolean bl2;
            this.fDTDGrammar.getAttributeDecl(n4, this.fTempAttDecl);
            String string2 = this.fTempAttDecl.name.prefix;
            String string3 = this.fTempAttDecl.name.localpart;
            string = this.fTempAttDecl.name.rawname;
            String string4 = this.getAttributeTypeName(this.fTempAttDecl);
            n2 = this.fTempAttDecl.simpleType.defaultType;
            String string5 = null;
            if (this.fTempAttDecl.simpleType.defaultValue != null) {
                string5 = this.fTempAttDecl.simpleType.defaultValue;
            }
            boolean bl3 = false;
            bl = n2 == 2;
            boolean bl4 = bl2 = string4 == XMLSymbols.fCDATASymbol;
            if (!bl2 || bl || string5 != null) {
                if (this.fNamespaceContext != null && string.startsWith("xmlns")) {
                    String string6 = "";
                    n5 = string.indexOf(58);
                    string6 = n5 != -1 ? string.substring(0, n5) : string;
                    if (!((NamespaceSupport)this.fNamespaceContext).containsPrefixInCurrentContext(string6 = this.fSymbolTable.addSymbol(string6))) {
                        this.fNamespaceContext.declarePrefix(string6, string5);
                    }
                    bl3 = true;
                } else {
                    int n6 = xMLAttributes.getLength();
                    n5 = 0;
                    while (n5 < n6) {
                        if (xMLAttributes.getQName(n5) == string) {
                            bl3 = true;
                            break;
                        }
                        ++n5;
                    }
                }
            }
            if (!bl3 && string5 != null) {
                if (this.fNamespaces && (n5 = string.indexOf(58)) != -1) {
                    string2 = string.substring(0, n5);
                    string2 = this.fSymbolTable.addSymbol(string2);
                    string3 = string.substring(n5 + 1);
                    string3 = this.fSymbolTable.addSymbol(string3);
                }
                this.fTempQName.setValues(string2, string3, string, this.fTempAttDecl.name.uri);
                int n7 = xMLAttributes.addAttribute(this.fTempQName, string4, string5);
            }
            n4 = this.fDTDGrammar.getNextAttributeDeclIndex(n4);
        }
        int n8 = xMLAttributes.getLength();
        int n9 = 0;
        while (n9 < n8) {
            string = xMLAttributes.getQName(n9);
            boolean bl5 = false;
            n2 = -1;
            int n10 = this.fDTDGrammar.getFirstAttributeDeclIndex(n3);
            while (n10 != -1) {
                this.fDTDGrammar.getAttributeDecl(n10, this.fTempAttDecl);
                if (this.fTempAttDecl.name.rawname == string) {
                    n2 = n10;
                    bl5 = true;
                    break;
                }
                n10 = this.fDTDGrammar.getNextAttributeDeclIndex(n10);
            }
            if (bl5) {
                String string7;
                String string8 = this.getAttributeTypeName(this.fTempAttDecl);
                xMLAttributes.setType(n9, string8);
                bl = false;
                String string9 = string7 = xMLAttributes.getValue(n9);
                if (xMLAttributes.isSpecified(n9) && string8 != XMLSymbols.fCDATASymbol) {
                    bl = this.normalizeAttrValue(xMLAttributes, n9);
                    string9 = xMLAttributes.getValue(n9);
                }
            }
            ++n9;
        }
    }

    private boolean normalizeAttrValue(XMLAttributes xMLAttributes, int n2) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = 0;
        int n4 = 0;
        String string = xMLAttributes.getValue(n2);
        char[] cArray = new char[string.length()];
        this.fBuffer.setLength(0);
        string.getChars(0, string.length(), cArray, 0);
        int n5 = 0;
        while (n5 < cArray.length) {
            if (cArray[n5] == ' ') {
                if (bl3) {
                    bl2 = true;
                    bl3 = false;
                }
                if (bl2 && !bl) {
                    bl2 = false;
                    this.fBuffer.append(cArray[n5]);
                    ++n3;
                } else if (bl || !bl2) {
                    ++n4;
                }
            } else {
                bl3 = true;
                bl2 = false;
                bl = false;
                this.fBuffer.append(cArray[n5]);
                ++n3;
            }
            ++n5;
        }
        if (n3 > 0 && this.fBuffer.charAt(n3 - 1) == ' ') {
            this.fBuffer.setLength(n3 - 1);
        }
        String string2 = this.fBuffer.toString();
        xMLAttributes.setValue(n2, string2);
        return !string.equals(string2);
    }

    private String getAttributeTypeName(XMLAttributeDecl xMLAttributeDecl) {
        switch (xMLAttributeDecl.simpleType.type) {
            case 1: {
                return xMLAttributeDecl.simpleType.list ? XMLSymbols.fENTITIESSymbol : XMLSymbols.fENTITYSymbol;
            }
            case 2: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append('(');
                int n2 = 0;
                while (n2 < xMLAttributeDecl.simpleType.enumeration.length) {
                    if (n2 > 0) {
                        stringBuffer.append("|");
                    }
                    stringBuffer.append(xMLAttributeDecl.simpleType.enumeration[n2]);
                    ++n2;
                }
                stringBuffer.append(')');
                return this.fSymbolTable.addSymbol(stringBuffer.toString());
            }
            case 3: {
                return XMLSymbols.fIDSymbol;
            }
            case 4: {
                return xMLAttributeDecl.simpleType.list ? XMLSymbols.fIDREFSSymbol : XMLSymbols.fIDREFSymbol;
            }
            case 5: {
                return xMLAttributeDecl.simpleType.list ? XMLSymbols.fNMTOKENSSymbol : XMLSymbols.fNMTOKENSymbol;
            }
            case 6: {
                return XMLSymbols.fNOTATIONSymbol;
            }
        }
        return XMLSymbols.fCDATASymbol;
    }

    private void ensureStackCapacity(int n2) {
        if (n2 == this.fElementContentState.length) {
            boolean[] blArray = new boolean[n2 * 2];
            System.arraycopy(this.fElementContentState, 0, blArray, 0, n2);
            this.fElementContentState = blArray;
        }
    }

    protected void handleStartElement(QName qName, XMLAttributes xMLAttributes) throws XNIException {
        if (this.fDTDGrammar == null) {
            this.fCurrentElementIndex = -1;
            this.fCurrentContentSpecType = -1;
            this.fInElementContent = false;
            return;
        }
        this.fCurrentElementIndex = this.fDTDGrammar.getElementDeclIndex(qName);
        this.fCurrentContentSpecType = this.fDTDGrammar.getContentSpecType(this.fCurrentElementIndex);
        this.addDTDDefaultAttrs(qName, xMLAttributes);
        this.fInElementContent = this.fCurrentContentSpecType == 3;
        ++this.fElementDepth;
        this.ensureStackCapacity(this.fElementDepth);
        this.fElementContentState[this.fElementDepth] = this.fInElementContent;
    }

    protected void handleEndElement(QName qName) throws XNIException {
        --this.fElementDepth;
        if (this.fElementDepth < -1) {
            throw new RuntimeException("FWK008 Element stack underflow");
        }
        if (this.fElementDepth < 0) {
            this.fCurrentElementIndex = -1;
            this.fCurrentContentSpecType = -1;
            this.fInElementContent = false;
            return;
        }
        this.fInElementContent = this.fElementContentState[this.fElementDepth];
    }

    public boolean isInElementContent() {
        return this.fInElementContent;
    }

    public boolean isIgnorableWhiteSpace(XMLString xMLString) {
        if (this.isInElementContent()) {
            int n2 = xMLString.offset;
            while (n2 < xMLString.offset + xMLString.length) {
                if (!XMLChar.isSpace(xMLString.ch[n2])) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }
}

