/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.javax.xml.stream;

import com.fr.third.javax.xml.stream.BufferManager;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public class FileBufferManager
extends BufferManager {
    static final int DEFAULT_LENGTH = 8192;
    static final int THRESH_HOLD = 81920;
    static final boolean DEBUG = false;
    CharsetDecoder decoder = null;
    FileChannel fChannel = null;
    CharBuffer charBuffer = null;
    boolean calledGetMore;
    long remaining = -1L;
    long filepos = 0L;
    long filesize = -1L;

    public FileBufferManager(FileInputStream fileInputStream, String string) throws IOException {
        this.init(fileInputStream);
        this.setDecoder("UTF-8");
    }

    void init(FileInputStream fileInputStream) throws IOException {
        this.charBuffer = CharBuffer.allocate(16384);
        this.fChannel = fileInputStream.getChannel();
        this.remaining = this.filesize = this.fChannel.size();
    }

    /*
     * Unable to fully structure code
     */
    public boolean arrangeCapacity(int var1_1) throws IOException {
        if (!this.calledGetMore) {
            this.getMore();
        }
        if (this.getCharBuffer().limit() - this.getCharBuffer().position() < var1_1) ** GOTO lbl8
        return true;
lbl-1000:
        // 1 sources

        {
            this.getMore();
lbl8:
            // 2 sources

            ** while (this.getCharBuffer().limit() - this.getCharBuffer().position() < var1_1 && !this.endOfStream())
        }
lbl9:
        // 1 sources

        return this.getCharBuffer().limit() - this.getCharBuffer().position() >= var1_1;
    }

    public ByteBuffer getMoreBytes() throws IOException {
        int n2 = this.getLength();
        if (this.endOfStream) {
            return ByteBuffer.allocate(0);
        }
        ByteBuffer byteBuffer = null;
        if (this.filesize > 81920L) {
            byteBuffer = this.fChannel.map(FileChannel.MapMode.READ_ONLY, this.filepos, n2);
            this.filepos += (long)byteBuffer.limit();
        } else {
            byteBuffer = ByteBuffer.allocate(this.getLength());
            this.fChannel.read(byteBuffer);
            this.filepos = this.fChannel.position();
            byteBuffer.flip();
        }
        this.remaining = this.filesize - this.filepos;
        if (this.remaining < 1L) {
            this.endOfStream = true;
        }
        return byteBuffer;
    }

    public boolean getMore() throws IOException {
        this.calledGetMore = true;
        if (this.endOfStream) {
            return false;
        }
        ByteBuffer byteBuffer = this.getMoreBytes();
        if (this.charBuffer.position() != 0) {
            this.charBuffer.compact();
        } else {
            this.charBuffer.clear();
        }
        int n2 = this.charBuffer.position();
        CoderResult coderResult = this.decoder.decode(byteBuffer, this.charBuffer, false);
        while (byteBuffer.remaining() > 0) {
            if (coderResult.isOverflow()) {
                this.resizeCharBuffer(this.charBuffer.limit() + byteBuffer.remaining());
            }
            coderResult = this.decoder.decode(byteBuffer, this.charBuffer, true);
        }
        if (coderResult.isUnderflow()) {
            coderResult = this.decoder.decode(byteBuffer, this.charBuffer, true);
            this.decoder.flush(this.charBuffer);
        }
        this.decoder.reset();
        if (this.charBuffer.position() > n2) {
            this.charBuffer.flip();
            return true;
        }
        return false;
    }

    public CharBuffer getCharBuffer() {
        return this.charBuffer;
    }

    CharSequence getCharSequence() {
        return this.charBuffer.subSequence(0, this.charBuffer.remaining());
    }

    CharBuffer resizeCharBuffer(int n2) {
        CharBuffer charBuffer = CharBuffer.allocate(n2);
        this.charBuffer = charBuffer.put((CharBuffer)this.charBuffer.flip());
        return this.charBuffer;
    }

    int getLength() {
        return this.remaining < 16384L ? (int)this.remaining : 16384;
    }

    void setDecoder(String string) throws IOException {
        if (string != null) {
            this.decoder = Charset.forName(string).newDecoder();
        } else {
            ByteBuffer byteBuffer = ByteBuffer.allocate(4);
            this.fChannel.read(byteBuffer);
            byte[] byArray = new byte[4];
            byteBuffer.get(byArray);
            Object[] objectArray = this.getEncodingName(byArray, 4);
            this.decoder = Charset.forName((String)objectArray[0]).newDecoder();
        }
    }

    static void printByteBuffer(ByteBuffer byteBuffer) {
        System.out.println("------------ByteBuffer Details---------");
        System.out.println("bb.position = " + byteBuffer.position());
        System.out.println("bb.remaining() = " + byteBuffer.remaining());
        System.out.println("bb.limit = " + byteBuffer.limit());
        System.out.println("bb.capacity = " + byteBuffer.capacity());
    }

    static void printCharBuffer(CharBuffer charBuffer) {
        System.out.println("----------- CharBuffer Details---------");
        System.out.println("bb.position = " + charBuffer.position());
        System.out.println("bb.remaining() = " + charBuffer.remaining());
        System.out.println("bb.limit = " + charBuffer.limit());
        System.out.println("bb.capacity = " + charBuffer.capacity());
    }

    public static void main(String[] stringArray) {
        try {
            FileBufferManager fileBufferManager = new FileBufferManager(new FileInputStream(stringArray[0]), "UTF-8");
            CharBuffer charBuffer = fileBufferManager.getCharBuffer();
            int n2 = 0;
            while (fileBufferManager.getMore()) {
                System.out.println("Loop " + n2++ + " = " + fileBufferManager.getCharBuffer().toString());
                System.out.println("------------Loop CharBuffer details--------");
                FileBufferManager.printCharBuffer(charBuffer);
            }
            System.out.println("End of file reached = " + fileBufferManager.endOfStream());
            System.out.println("Total no. of loops required = " + n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void close() throws IOException {
        if (this.fChannel != null) {
            this.fChannel.close();
        }
    }

    public void setEncoding(String string) throws IOException {
    }
}

