/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.javax.xml.stream;

import com.fr.third.javax.xml.stream.FileBufferManager;
import com.fr.third.javax.xml.stream.StreamBufferManager;
import com.fr.third.javax.xml.stream.xerces.xni.parser.XMLInputSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.CharBuffer;

public abstract class BufferManager {
    protected boolean endOfStream = false;
    static boolean DEBUG = false;

    public static BufferManager getBufferManager(XMLInputSource xMLInputSource) throws IOException {
        InputStream inputStream = xMLInputSource.getByteStream();
        if (inputStream instanceof FileInputStream) {
            if (DEBUG) {
                System.out.println("Using FileBufferManager");
            }
            return new FileBufferManager((FileInputStream)inputStream, xMLInputSource.getEncoding());
        }
        if (DEBUG) {
            System.out.println("Using StreamBufferManager");
        }
        return new StreamBufferManager(inputStream, xMLInputSource.getEncoding());
    }

    public abstract boolean getMore() throws IOException;

    public abstract CharBuffer getCharBuffer();

    public abstract boolean arrangeCapacity(int var1) throws IOException;

    public boolean endOfStream() {
        return this.endOfStream;
    }

    public abstract void close() throws IOException;

    public abstract void setEncoding(String var1) throws IOException;

    protected Object[] getEncodingName(byte[] byArray, int n2) {
        if (n2 < 2) {
            Object[] objectArray = new Object[2];
            objectArray[0] = "UTF-8";
            return objectArray;
        }
        int n3 = byArray[0] & 0xFF;
        int n4 = byArray[1] & 0xFF;
        if (n3 == 254 && n4 == 255) {
            return new Object[]{"UTF-16BE", new Boolean(true)};
        }
        if (n3 == 255 && n4 == 254) {
            return new Object[]{"UTF-16LE", new Boolean(false)};
        }
        if (n2 < 3) {
            Object[] objectArray = new Object[2];
            objectArray[0] = "UTF-8";
            return objectArray;
        }
        int n5 = byArray[2] & 0xFF;
        if (n3 == 239 && n4 == 187 && n5 == 191) {
            Object[] objectArray = new Object[2];
            objectArray[0] = "UTF-8";
            return objectArray;
        }
        if (n2 < 4) {
            Object[] objectArray = new Object[2];
            objectArray[0] = "UTF-8";
            return objectArray;
        }
        int n6 = byArray[3] & 0xFF;
        if (n3 == 0 && n4 == 0 && n5 == 0 && n6 == 60) {
            return new Object[]{"ISO-10646-UCS-4", new Boolean(true)};
        }
        if (n3 == 60 && n4 == 0 && n5 == 0 && n6 == 0) {
            return new Object[]{"ISO-10646-UCS-4", new Boolean(false)};
        }
        if (n3 == 0 && n4 == 0 && n5 == 60 && n6 == 0) {
            Object[] objectArray = new Object[2];
            objectArray[0] = "ISO-10646-UCS-4";
            return objectArray;
        }
        if (n3 == 0 && n4 == 60 && n5 == 0 && n6 == 0) {
            Object[] objectArray = new Object[2];
            objectArray[0] = "ISO-10646-UCS-4";
            return objectArray;
        }
        if (n3 == 0 && n4 == 60 && n5 == 0 && n6 == 63) {
            return new Object[]{"UTF-16BE", new Boolean(true)};
        }
        if (n3 == 60 && n4 == 0 && n5 == 63 && n6 == 0) {
            return new Object[]{"UTF-16LE", new Boolean(false)};
        }
        if (n3 == 76 && n4 == 111 && n5 == 167 && n6 == 148) {
            Object[] objectArray = new Object[2];
            objectArray[0] = "CP037";
            return objectArray;
        }
        Object[] objectArray = new Object[2];
        objectArray[0] = "UTF-8";
        return objectArray;
    }

    public static void main(String[] stringArray) {
        try {
            File file = new File(stringArray[0]);
            System.out.println("url parameter = " + file.toURI().toString());
            URL uRL = new URL(file.toURI().toString());
            XMLInputSource xMLInputSource = new XMLInputSource(null, null, null, new FileInputStream(file), "UTF-8");
            BufferManager bufferManager = BufferManager.getBufferManager(xMLInputSource);
            CharBuffer charBuffer = bufferManager.getCharBuffer();
            int n2 = 0;
            while (bufferManager.getMore()) {
                System.out.println("Loop " + n2++ + " = " + bufferManager.getCharBuffer());
            }
            System.out.println("End of stream reached = " + bufferManager.endOfStream());
            System.out.println("Total no. of loops required = " + n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

