/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.antlr.collections.impl;

import com.fr.third.antlr.collections.impl.VectorEnumerator;
import java.util.Enumeration;

public class Vector
implements Cloneable {
    protected Object[] data;
    protected int lastElement = -1;

    public Vector() {
        this(10);
    }

    public Vector(int n2) {
        this.data = new Object[n2];
    }

    public synchronized void appendElement(Object object) {
        this.ensureCapacity(this.lastElement + 2);
        this.data[++this.lastElement] = object;
    }

    public int capacity() {
        return this.data.length;
    }

    public Object clone() {
        Vector vector = null;
        try {
            vector = (Vector)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("cannot clone Vector.super");
            return null;
        }
        vector.data = new Object[this.size()];
        System.arraycopy(this.data, 0, vector.data, 0, this.size());
        return vector;
    }

    public synchronized Object elementAt(int n2) {
        if (n2 >= this.data.length) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.data.length);
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(n2 + " < 0 ");
        }
        return this.data[n2];
    }

    public synchronized Enumeration elements() {
        return new VectorEnumerator(this);
    }

    public synchronized void ensureCapacity(int n2) {
        if (n2 + 1 > this.data.length) {
            Object[] objectArray = this.data;
            int n3 = this.data.length * 2;
            if (n2 + 1 > n3) {
                n3 = n2 + 1;
            }
            this.data = new Object[n3];
            System.arraycopy(objectArray, 0, this.data, 0, objectArray.length);
        }
    }

    public synchronized boolean removeElement(Object object) {
        int n2;
        for (n2 = 0; n2 <= this.lastElement && this.data[n2] != object; ++n2) {
        }
        if (n2 <= this.lastElement) {
            this.data[n2] = null;
            int n3 = this.lastElement - n2;
            if (n3 > 0) {
                System.arraycopy(this.data, n2 + 1, this.data, n2, n3);
            }
            --this.lastElement;
            return true;
        }
        return false;
    }

    public synchronized void setElementAt(Object object, int n2) {
        if (n2 >= this.data.length) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.data.length);
        }
        this.data[n2] = object;
        if (n2 > this.lastElement) {
            this.lastElement = n2;
        }
    }

    public int size() {
        return this.lastElement + 1;
    }
}

