/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.antlr;

import com.fr.third.antlr.Token;

class TokenQueue {
    private Token[] buffer;
    private int sizeLessOne;
    private int offset;
    protected int nbrEntries;

    public TokenQueue(int n2) {
        int n3;
        if (n2 < 0) {
            this.init(16);
            return;
        }
        if (n2 >= 0x3FFFFFFF) {
            this.init(Integer.MAX_VALUE);
            return;
        }
        for (n3 = 2; n3 < n2; n3 *= 2) {
        }
        this.init(n3);
    }

    public final void append(Token token) {
        if (this.nbrEntries == this.buffer.length) {
            this.expand();
        }
        this.buffer[this.offset + this.nbrEntries & this.sizeLessOne] = token;
        ++this.nbrEntries;
    }

    public final Token elementAt(int n2) {
        return this.buffer[this.offset + n2 & this.sizeLessOne];
    }

    private final void expand() {
        Token[] tokenArray = new Token[this.buffer.length * 2];
        for (int i2 = 0; i2 < this.buffer.length; ++i2) {
            tokenArray[i2] = this.elementAt(i2);
        }
        this.buffer = tokenArray;
        this.sizeLessOne = this.buffer.length - 1;
        this.offset = 0;
    }

    private final void init(int n2) {
        this.buffer = new Token[n2];
        this.sizeLessOne = n2 - 1;
        this.offset = 0;
        this.nbrEntries = 0;
    }

    public final void reset() {
        this.offset = 0;
        this.nbrEntries = 0;
    }

    public final void removeFirst() {
        this.offset = this.offset + 1 & this.sizeLessOne;
        --this.nbrEntries;
    }
}

