/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.JAI;

import com.fr.third.JAI.ImageEncodeParam;
import com.fr.third.JAI.ImageEncoderImpl;
import com.fr.third.JAI.JPEGEncodeParam;
import com.fr.third.JAI.JPEGImageEncoder;
import com.fr.third.JAI.JaiI18N;
import com.fr.third.JAI.SeekableOutputStream;
import com.fr.third.JAI.TIFFEncodeParam;
import com.fr.third.JAI.TIFFFaxEncoder;
import com.fr.third.JAI.TIFFField;
import com.sun.image.codec.jpeg.JPEGCodec;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.Deflater;

public class TIFFImageEncoder
extends ImageEncoderImpl {
    private static final int TIFF_UNSUPPORTED = -1;
    private static final int TIFF_BILEVEL_WHITE_IS_ZERO = 0;
    private static final int TIFF_BILEVEL_BLACK_IS_ZERO = 1;
    private static final int TIFF_GRAY = 2;
    private static final int TIFF_PALETTE = 3;
    private static final int TIFF_RGB = 4;
    private static final int TIFF_CMYK = 5;
    private static final int TIFF_YCBCR = 6;
    private static final int TIFF_CIELAB = 7;
    private static final int TIFF_GENERIC = 8;
    private static final int COMP_NONE = 1;
    private static final int COMP_GROUP3_1D = 2;
    private static final int COMP_GROUP3_2D = 3;
    private static final int COMP_GROUP4 = 4;
    private static final int COMP_JPEG_TTN2 = 7;
    private static final int COMP_PACKBITS = 32773;
    private static final int COMP_DEFLATE = 32946;
    private static final int TIFF_JPEG_TABLES = 347;
    private static final int TIFF_YCBCR_SUBSAMPLING = 530;
    private static final int TIFF_YCBCR_POSITIONING = 531;
    private static final int TIFF_REF_BLACK_WHITE = 532;
    private static final int EXTRA_SAMPLE_UNSPECIFIED = 0;
    private static final int EXTRA_SAMPLE_ASSOCIATED_ALPHA = 1;
    private static final int EXTRA_SAMPLE_UNASSOCIATED_ALPHA = 2;
    private static final int DEFAULT_ROWS_PER_STRIP = 8;
    private static final int[] sizeOfType = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};

    private static final char[] intsToChars(int[] nArray) {
        int n2 = nArray.length;
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = (char)(nArray[i2] & 0xFFFF);
        }
        return cArray;
    }

    public TIFFImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        super(outputStream, imageEncodeParam);
        if (this.param == null) {
            this.param = new TIFFEncodeParam();
        }
    }

    public void encode(RenderedImage renderedImage) throws IOException {
        this.writeFileHeader();
        TIFFEncodeParam tIFFEncodeParam = (TIFFEncodeParam)this.param;
        Iterator iterator = tIFFEncodeParam.getExtraImages();
        if (iterator != null) {
            boolean bl;
            int n2 = 8;
            RenderedImage renderedImage2 = renderedImage;
            TIFFEncodeParam tIFFEncodeParam2 = tIFFEncodeParam;
            do {
                n2 = this.encode(renderedImage2, tIFFEncodeParam2, n2, !(bl = iterator.hasNext()));
                if (!bl) continue;
                Object e2 = iterator.next();
                if (e2 instanceof RenderedImage) {
                    renderedImage2 = (RenderedImage)e2;
                    tIFFEncodeParam2 = tIFFEncodeParam;
                    continue;
                }
                if (!(e2 instanceof Object[])) continue;
                Object[] objectArray = (Object[])e2;
                renderedImage2 = (RenderedImage)objectArray[0];
                tIFFEncodeParam2 = (TIFFEncodeParam)objectArray[1];
            } while (bl);
        } else {
            this.encode(renderedImage, tIFFEncodeParam, 8, true);
        }
    }

    private int encode(RenderedImage renderedImage, TIFFEncodeParam tIFFEncodeParam, int n2, boolean bl) throws IOException {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        Object object;
        Object object2;
        Object object3;
        int n10;
        int[] nArray;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        Object object4;
        byte[] byArray;
        byte[] byArray2;
        int n17;
        int n18;
        int n19 = tIFFEncodeParam.getCompression();
        boolean bl2 = tIFFEncodeParam.getWriteTiled();
        int n20 = renderedImage.getMinX();
        int n21 = renderedImage.getMinY();
        int n22 = renderedImage.getWidth();
        int n23 = renderedImage.getHeight();
        SampleModel sampleModel = renderedImage.getSampleModel();
        int[] nArray2 = sampleModel.getSampleSize();
        for (n18 = 1; n18 < nArray2.length; ++n18) {
            if (nArray2[n18] == nArray2[0]) continue;
            throw new Error(JaiI18N.getString("TIFFImageEncoder0"));
        }
        n18 = sampleModel.getNumBands();
        if ((nArray2[0] == 1 || nArray2[0] == 4) && n18 != 1) {
            throw new Error(JaiI18N.getString("TIFFImageEncoder1"));
        }
        int n24 = sampleModel.getDataType();
        switch (n24) {
            case 0: {
                if (nArray2[0] == 1 || nArray2[0] != 4 || nArray2[0] == 8) break;
                throw new Error(JaiI18N.getString("TIFFImageEncoder2"));
            }
            case 1: 
            case 2: {
                if (nArray2[0] == 16) break;
                throw new Error(JaiI18N.getString("TIFFImageEncoder3"));
            }
            case 3: 
            case 4: {
                if (nArray2[0] == 32) break;
                throw new Error(JaiI18N.getString("TIFFImageEncoder4"));
            }
            default: {
                throw new Error(JaiI18N.getString("TIFFImageEncoder5"));
            }
        }
        boolean bl3 = n24 == 2 || n24 == 1;
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel != null && colorModel instanceof IndexColorModel && n24 != 0) {
            throw new Error(JaiI18N.getString("TIFFImageEncoder6"));
        }
        IndexColorModel indexColorModel = null;
        int n25 = 0;
        int[] nArray3 = null;
        int n26 = -1;
        int n27 = 0;
        int n28 = 0;
        if (colorModel instanceof IndexColorModel) {
            indexColorModel = (IndexColorModel)colorModel;
            n17 = indexColorModel.getMapSize();
            if (nArray2[0] == 1 && n18 == 1) {
                if (n17 != 2) {
                    throw new IllegalArgumentException(JaiI18N.getString("TIFFImageEncoder7"));
                }
                byArray2 = new byte[n17];
                indexColorModel.getReds(byArray2);
                byArray = new byte[n17];
                indexColorModel.getGreens(byArray);
                object4 = new byte[n17];
                indexColorModel.getBlues((byte[])object4);
                n26 = (byArray2[0] & 0xFF) == 0 && (byArray2[1] & 0xFF) == 255 && (byArray[0] & 0xFF) == 0 && (byArray[1] & 0xFF) == 255 && (object4[0] & 0xFF) == 0 && (object4[1] & 0xFF) == 255 ? 1 : ((byArray2[0] & 0xFF) == 255 && (byArray2[1] & 0xFF) == 0 && (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 0 && (object4[0] & 0xFF) == 255 && (object4[1] & 0xFF) == 0 ? 0 : 3);
            } else if (n18 == 1) {
                n26 = 3;
            }
        } else if (colorModel == null) {
            if (nArray2[0] == 1 && n18 == 1) {
                n26 = 1;
            } else {
                n26 = 8;
                if (n18 > 1) {
                    n27 = n18 - 1;
                }
            }
        } else {
            ColorSpace colorSpace = colorModel.getColorSpace();
            switch (colorSpace.getType()) {
                case 9: {
                    n26 = 5;
                    break;
                }
                case 6: {
                    n26 = 2;
                    break;
                }
                case 1: {
                    n26 = 7;
                    break;
                }
                case 5: {
                    if (n19 == 7 && tIFFEncodeParam.getJPEGCompressRGBToYCbCr()) {
                        n26 = 6;
                        break;
                    }
                    n26 = 4;
                    break;
                }
                case 3: {
                    n26 = 6;
                    break;
                }
                default: {
                    n26 = 8;
                }
            }
            if (n26 == 8) {
                n27 = n18 - 1;
            } else if (n18 > 1) {
                n27 = n18 - colorSpace.getNumComponents();
            }
            if (n27 == 1 && colorModel.hasAlpha()) {
                int n29 = n28 = colorModel.isAlphaPremultiplied() ? 1 : 2;
            }
        }
        if (n26 == -1) {
            throw new Error(JaiI18N.getString("TIFFImageEncoder8"));
        }
        if (n19 == 7) {
            if (n26 == 3) {
                throw new Error(JaiI18N.getString("TIFFImageEncoder11"));
            }
            if (nArray2[0] != 8 || n26 != 2 && n26 != 4 && n26 != 6) {
                throw new Error(JaiI18N.getString("TIFFImageEncoder9"));
            }
        }
        n17 = -1;
        switch (n26) {
            case 0: {
                n17 = 0;
                break;
            }
            case 1: {
                n17 = 1;
                break;
            }
            case 2: 
            case 8: {
                n17 = 1;
                break;
            }
            case 3: {
                n17 = 3;
                indexColorModel = (IndexColorModel)colorModel;
                n25 = indexColorModel.getMapSize();
                byArray2 = new byte[n25];
                indexColorModel.getReds(byArray2);
                byArray = new byte[n25];
                indexColorModel.getGreens(byArray);
                object4 = new byte[n25];
                indexColorModel.getBlues((byte[])object4);
                n16 = 0;
                n15 = n25;
                n14 = 2 * n25;
                nArray3 = new int[n25 * 3];
                for (n13 = 0; n13 < n25; ++n13) {
                    nArray3[n16++] = byArray2[n13] << 8 & 0xFFFF;
                    nArray3[n15++] = byArray[n13] << 8 & 0xFFFF;
                    nArray3[n14++] = object4[n13] << 8 & 0xFFFF;
                }
                n25 *= 3;
                break;
            }
            case 4: {
                n17 = 2;
                break;
            }
            case 5: {
                n17 = 5;
                break;
            }
            case 6: {
                n17 = 6;
                break;
            }
            case 7: {
                n17 = 8;
                break;
            }
            default: {
                throw new Error(JaiI18N.getString("TIFFImageEncoder8"));
            }
        }
        if (bl2) {
            n12 = tIFFEncodeParam.getTileWidth() > 0 ? tIFFEncodeParam.getTileWidth() : renderedImage.getTileWidth();
            n11 = tIFFEncodeParam.getTileHeight() > 0 ? tIFFEncodeParam.getTileHeight() : renderedImage.getTileHeight();
        } else {
            n12 = n22;
            n11 = tIFFEncodeParam.getTileHeight() > 0 ? tIFFEncodeParam.getTileHeight() : 8;
        }
        object4 = null;
        if (n19 == 7) {
            object4 = tIFFEncodeParam.getJPEGEncodeParam();
            n16 = ((JPEGEncodeParam)object4).getHorizontalSubsampling(0);
            n15 = ((JPEGEncodeParam)object4).getVerticalSubsampling(0);
            for (n14 = 1; n14 < n18; ++n14) {
                int n30;
                n13 = ((JPEGEncodeParam)object4).getHorizontalSubsampling(n14);
                if (n13 > n16) {
                    n16 = n13;
                }
                if ((n30 = ((JPEGEncodeParam)object4).getVerticalSubsampling(n14)) <= n15) continue;
                n15 = n30;
            }
            n14 = 8 * n15;
            if ((n11 = (int)((float)n11 / (float)n14 + 0.5f) * n14) < n14) {
                n11 = n14;
            }
            if (bl2 && (n12 = (int)((float)n12 / (float)(n13 = 8 * n16) + 0.5f) * n13) < n13) {
                n12 = n13;
            }
        }
        n16 = bl2 ? (n22 + n12 - 1) / n12 * ((n23 + n11 - 1) / n11) : (int)Math.ceil((double)n23 / (double)n11);
        long[] lArray = new long[n16];
        long l2 = (long)Math.ceil((double)nArray2[0] / 8.0 * (double)n12 * (double)n18);
        long l3 = l2 * (long)n11;
        for (int i2 = 0; i2 < n16; ++i2) {
            lArray[i2] = l3;
        }
        if (!bl2) {
            long l4 = n23 - n11 * (n16 - 1);
            lArray[n16 - 1] = l4 * l2;
        }
        long l5 = l3 * (long)(n16 - 1) + lArray[n16 - 1];
        long[] lArray2 = new long[n16];
        TreeSet<TIFFField> treeSet = new TreeSet<TIFFField>();
        treeSet.add(new TIFFField(256, 4, 1, new long[]{n22}));
        treeSet.add(new TIFFField(257, 4, 1, new long[]{n23}));
        treeSet.add(new TIFFField(258, 3, n18, TIFFImageEncoder.intsToChars(nArray2)));
        treeSet.add(new TIFFField(259, 3, 1, new char[]{(char)n19}));
        treeSet.add(new TIFFField(262, 3, 1, new char[]{(char)n17}));
        if (!bl2) {
            treeSet.add(new TIFFField(273, 4, n16, lArray2));
        }
        treeSet.add(new TIFFField(277, 3, 1, new char[]{(char)n18}));
        if (!bl2) {
            treeSet.add(new TIFFField(278, 4, 1, new long[]{n11}));
            treeSet.add(new TIFFField(279, 4, n16, lArray));
        }
        if (nArray3 != null) {
            treeSet.add(new TIFFField(320, 3, n25, TIFFImageEncoder.intsToChars(nArray3)));
        }
        if (bl2) {
            treeSet.add(new TIFFField(322, 4, 1, new long[]{n12}));
            treeSet.add(new TIFFField(323, 4, 1, new long[]{n11}));
            treeSet.add(new TIFFField(324, 4, n16, lArray2));
            treeSet.add(new TIFFField(325, 4, n16, lArray));
        }
        if (n27 > 0) {
            nArray = new int[n27];
            for (n10 = 0; n10 < n27; ++n10) {
                nArray[n10] = n28;
            }
            treeSet.add(new TIFFField(338, 3, n27, TIFFImageEncoder.intsToChars(nArray)));
        }
        if (n24 != 0) {
            nArray = new int[n18];
            nArray[0] = n24 == 4 ? 3 : (n24 == 1 ? 1 : 2);
            for (n10 = 1; n10 < n18; ++n10) {
                nArray[n10] = nArray[0];
            }
            treeSet.add(new TIFFField(339, 3, n18, TIFFImageEncoder.intsToChars(nArray)));
        }
        boolean bl4 = tIFFEncodeParam.getReverseFillOrder();
        n10 = tIFFEncodeParam.getT4Encode2D() ? 1 : 0;
        boolean bl5 = tIFFEncodeParam.getT4PadEOLs();
        TIFFFaxEncoder tIFFFaxEncoder = null;
        if (!(n26 != 1 && n26 != 0 || n19 != 2 && n19 != 3 && n19 != 4)) {
            tIFFFaxEncoder = new TIFFFaxEncoder(bl4);
            treeSet.add(new TIFFField(266, 3, 1, new char[]{bl4 ? (char)'\u0002' : '\u0001'}));
            if (n19 == 3) {
                long l6 = 0L;
                if (n10 != 0) {
                    l6 |= 1L;
                }
                if (bl5) {
                    l6 |= 4L;
                }
                treeSet.add(new TIFFField(292, 4, 1, new long[]{l6}));
            } else if (n19 == 4) {
                treeSet.add(new TIFFField(293, 4, 1, new long[]{0L}));
            }
        }
        com.sun.image.codec.jpeg.JPEGEncodeParam jPEGEncodeParam = null;
        com.sun.image.codec.jpeg.JPEGImageEncoder jPEGImageEncoder = null;
        int n31 = 0;
        if (n19 == 7) {
            n31 = 0;
            switch (n26) {
                case 2: 
                case 3: {
                    n31 = 1;
                    break;
                }
                case 4: {
                    n31 = 2;
                    break;
                }
                case 6: {
                    n31 = 3;
                }
            }
            object3 = renderedImage.getTile(0, 0);
            jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((Raster)object3, (int)n31);
            JPEGImageEncoder.modifyEncodeParam((JPEGEncodeParam)object4, jPEGEncodeParam, n18);
            if (((JPEGEncodeParam)object4).getWriteImageOnly()) {
                jPEGEncodeParam.setImageInfoValid(false);
                jPEGEncodeParam.setTableInfoValid(true);
                object2 = new ByteArrayOutputStream();
                jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)object2, (com.sun.image.codec.jpeg.JPEGEncodeParam)jPEGEncodeParam);
                jPEGImageEncoder.encode((Raster)object3);
                object = ((ByteArrayOutputStream)object2).toByteArray();
                treeSet.add(new TIFFField(347, 7, ((Object)object).length, object));
                jPEGImageEncoder = null;
            }
        }
        if (n26 == 6) {
            int n32 = 1;
            int n33 = 1;
            if (n19 == 7) {
                n32 = ((JPEGEncodeParam)object4).getHorizontalSubsampling(0);
                n33 = ((JPEGEncodeParam)object4).getVerticalSubsampling(0);
                for (int i3 = 1; i3 < n18; ++i3) {
                    n9 = ((JPEGEncodeParam)object4).getHorizontalSubsampling(i3);
                    if (n9 > n32) {
                        n32 = n9;
                    }
                    if ((n8 = ((JPEGEncodeParam)object4).getVerticalSubsampling(i3)) <= n33) continue;
                    n33 = n8;
                }
            }
            treeSet.add(new TIFFField(530, 3, 2, new char[]{(char)n32, (char)n33}));
            treeSet.add(new TIFFField(531, 3, 1, new char[]{n19 == 7 ? (char)'\u0001' : '\u0002'}));
            object = n19 == 7 ? (Object)new long[][]{{0L, 1L}, {255L, 1L}, {128L, 1L}, {255L, 1L}, {128L, 1L}, {255L, 1L}} : (Object)new long[][]{{15L, 1L}, {235L, 1L}, {128L, 1L}, {240L, 1L}, {128L, 1L}, {240L, 1L}};
            treeSet.add(new TIFFField(532, 5, 6, object));
        }
        if ((object3 = tIFFEncodeParam.getExtraFields()) != null) {
            object2 = new ArrayList<Integer>(treeSet.size());
            object = treeSet.iterator();
            while (object.hasNext()) {
                TIFFField tIFFField = (TIFFField)object.next();
                ((ArrayList)object2).add(new Integer(tIFFField.getTag()));
            }
            n9 = ((TIFFField[])object3).length;
            for (n8 = 0; n8 < n9; ++n8) {
                TIFFField tIFFField = object3[n8];
                Integer n34 = new Integer(tIFFField.getTag());
                if (((ArrayList)object2).contains(n34)) continue;
                treeSet.add(tIFFField);
                ((ArrayList)object2).add(n34);
            }
        }
        int n35 = this.getDirectorySize(treeSet);
        lArray2[0] = n2 + n35;
        object = null;
        byte[] byArray3 = null;
        File file = null;
        int n36 = 0;
        boolean bl6 = false;
        Deflater deflater = null;
        int n37 = -1;
        boolean bl7 = false;
        if (n19 == 1) {
            int n38;
            n7 = 0;
            if (nArray2[0] == 16 && lArray2[0] % 2L != 0L) {
                n7 = 1;
                lArray2[0] = lArray2[0] + 1L;
            } else if (nArray2[0] == 32 && lArray2[0] % 4L != 0L) {
                n7 = (int)(4L - lArray2[0] % 4L);
                lArray2[0] = lArray2[0] + (long)n7;
            }
            for (n38 = 1; n38 < n16; ++n38) {
                lArray2[n38] = lArray2[n38 - 1] + lArray[n38 - 1];
            }
            if (!bl && (n36 = (int)(lArray2[0] + l5)) % 2 != 0) {
                ++n36;
                bl6 = true;
            }
            this.writeDirectory(n2, treeSet, n36);
            if (n7 != 0) {
                for (n38 = 0; n38 < n7; ++n38) {
                    this.output.write(0);
                }
            }
        } else {
            if (this.output instanceof SeekableOutputStream) {
                ((SeekableOutputStream)this.output).seek(lArray2[0]);
            } else {
                object = this.output;
                try {
                    file = File.createTempFile("jai-SOS-", ".tmp");
                    file.deleteOnExit();
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                    this.output = new SeekableOutputStream(randomAccessFile);
                }
                catch (Exception exception) {
                    this.output = new ByteArrayOutputStream((int)l5);
                }
            }
            n7 = 0;
            switch (n19) {
                case 2: {
                    n7 = (int)Math.ceil((double)((n12 + 1) / 2 * 9 + 2) / 8.0);
                    break;
                }
                case 3: 
                case 4: {
                    n7 = (int)Math.ceil((double)((n12 + 1) / 2 * 9 + 2) / 8.0);
                    n7 = n11 * (n7 + 2) + 12;
                    break;
                }
                case 32773: {
                    n7 = (int)(l3 + (l2 + 127L) / 128L * (long)n11);
                    break;
                }
                case 7: {
                    n7 = 0;
                    if (n26 != 6 || colorModel == null || colorModel.getColorSpace().getType() != 5) break;
                    bl7 = true;
                    break;
                }
                case 32946: {
                    n7 = (int)l3;
                    deflater = new Deflater(tIFFEncodeParam.getDeflateLevel());
                    break;
                }
                default: {
                    n7 = 0;
                }
            }
            if (n7 != 0) {
                byArray3 = new byte[n7];
            }
        }
        int[] nArray4 = null;
        float[] fArray = null;
        boolean bl8 = nArray2[0] == 1 && sampleModel instanceof MultiPixelPackedSampleModel && n24 == 0 || nArray2[0] == 8 && sampleModel instanceof ComponentSampleModel;
        byte[] byArray4 = null;
        if (n19 != 7) {
            if (n24 == 0) {
                byArray4 = new byte[n11 * n12 * n18];
            } else if (bl3) {
                byArray4 = new byte[2 * n11 * n12 * n18];
            } else if (n24 == 3 || n24 == 4) {
                byArray4 = new byte[4 * n11 * n12 * n18];
            }
        }
        int n39 = n21 + n23;
        int n40 = n20 + n22;
        int n41 = 0;
        for (n6 = n21; n6 < n39; n6 += n11) {
            n5 = bl2 ? n11 : Math.min(n11, n39 - n6);
            n4 = n5 * n12 * n18;
            block55: for (n3 = n20; n3 < n40; n3 += n12) {
                int n42;
                int n43;
                int n44;
                Raster raster = renderedImage.getData(new Rectangle(n3, n6, n12, n5));
                boolean bl9 = false;
                if (n19 != 7) {
                    if (bl8) {
                        if (nArray2[0] == 8) {
                            ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
                            int[] nArray5 = componentSampleModel.getBankIndices();
                            int[] nArray6 = componentSampleModel.getBandOffsets();
                            n44 = componentSampleModel.getPixelStride();
                            n43 = componentSampleModel.getScanlineStride();
                            if (n44 != n18 || (long)n43 != l2) {
                                bl9 = false;
                            } else {
                                bl9 = true;
                                for (n42 = 0; bl9 && n42 < n18; ++n42) {
                                    if (nArray5[n42] == 0 && nArray6[n42] == n42) continue;
                                    bl9 = false;
                                }
                            }
                        } else {
                            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
                            if (multiPixelPackedSampleModel.getNumBands() == 1 && multiPixelPackedSampleModel.getDataBitOffset() == 0 && multiPixelPackedSampleModel.getPixelBitStride() == 1) {
                                bl9 = true;
                            }
                        }
                    }
                    if (!bl9) {
                        if (n24 == 4) {
                            fArray = raster.getPixels(n3, n6, n12, n5, fArray);
                        } else {
                            nArray4 = raster.getPixels(n3, n6, n12, n5, nArray4);
                        }
                    }
                }
                int n45 = 0;
                int n46 = 0;
                switch (nArray2[0]) {
                    case 1: {
                        int n47;
                        int n48;
                        int n49;
                        if (bl9) {
                            byte[] byArray5 = ((DataBufferByte)raster.getDataBuffer()).getData();
                            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
                            n42 = multiPixelPackedSampleModel.getScanlineStride();
                            n49 = multiPixelPackedSampleModel.getOffset(n3 - raster.getSampleModelTranslateX(), n6 - raster.getSampleModelTranslateY());
                            if (n42 == (int)l2) {
                                System.arraycopy(byArray5, n49, byArray4, 0, (int)l2 * n5);
                            } else {
                                n48 = 0;
                                for (n47 = 0; n47 < n5; ++n47) {
                                    System.arraycopy(byArray5, n49, byArray4, n48, (int)l2);
                                    n49 += n42;
                                    n48 += (int)l2;
                                }
                            }
                        } else {
                            int n50 = 0;
                            for (n44 = 0; n44 < n5; ++n44) {
                                for (n43 = 0; n43 < n12 / 8; ++n43) {
                                    n45 = nArray4[n50++] << 7 | nArray4[n50++] << 6 | nArray4[n50++] << 5 | nArray4[n50++] << 4 | nArray4[n50++] << 3 | nArray4[n50++] << 2 | nArray4[n50++] << 1 | nArray4[n50++];
                                    byArray4[n46++] = (byte)n45;
                                }
                                if (n12 % 8 <= 0) continue;
                                n45 = 0;
                                for (n43 = 0; n43 < n12 % 8; ++n43) {
                                    n45 |= nArray4[n50++] << 7 - n43;
                                }
                                byArray4[n46++] = (byte)n45;
                            }
                        }
                        if (n19 == 1) {
                            this.output.write(byArray4, 0, n5 * ((n12 + 7) / 8));
                            continue block55;
                        }
                        if (n19 == 2) {
                            int n51 = (n12 + 7) / 8;
                            int n52 = 0;
                            n42 = 0;
                            for (n49 = 0; n49 < n5; ++n49) {
                                n48 = tIFFFaxEncoder.encodeRLE(byArray4, n52, 0, n12, byArray3);
                                this.output.write(byArray3, 0, n48);
                                n52 += n51;
                                n42 += n48;
                            }
                            lArray[n41++] = n42;
                            continue block55;
                        }
                        if (n19 == 3) {
                            int n53 = tIFFFaxEncoder.encodeT4(n10 == 0, bl5, byArray4, (n12 + 7) / 8, 0, n12, n5, byArray3);
                            lArray[n41++] = n53;
                            this.output.write(byArray3, 0, n53);
                            continue block55;
                        }
                        if (n19 == 4) {
                            int n54 = tIFFFaxEncoder.encodeT6(byArray4, (n12 + 7) / 8, 0, n12, n5, byArray3);
                            lArray[n41++] = n54;
                            this.output.write(byArray3, 0, n54);
                            continue block55;
                        }
                        if (n19 == 32773) {
                            int n55 = TIFFImageEncoder.compressPackBits(byArray4, n5, (int)l2, byArray3);
                            lArray[n41++] = n55;
                            this.output.write(byArray3, 0, n55);
                            continue block55;
                        }
                        if (n19 != 32946) continue block55;
                        int n56 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n41++] = n56;
                        this.output.write(byArray3, 0, n56);
                        continue block55;
                    }
                    case 4: {
                        int n57 = 0;
                        for (n44 = 0; n44 < n5; ++n44) {
                            for (n43 = 0; n43 < n12 / 2; ++n43) {
                                n45 = nArray4[n57++] << 4 | nArray4[n57++];
                                byArray4[n46++] = (byte)n45;
                            }
                            if (n12 % 2 != 1) continue;
                            n45 = nArray4[n57++] << 4;
                            byArray4[n46++] = (byte)n45;
                        }
                        if (n19 == 1) {
                            this.output.write(byArray4, 0, n5 * ((n12 + 1) / 2));
                            continue block55;
                        }
                        if (n19 == 32773) {
                            n44 = TIFFImageEncoder.compressPackBits(byArray4, n5, (int)l2, byArray3);
                            lArray[n41++] = n44;
                            this.output.write(byArray3, 0, n44);
                            continue block55;
                        }
                        if (n19 != 32946) continue block55;
                        n44 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n41++] = n44;
                        this.output.write(byArray3, 0, n44);
                        continue block55;
                    }
                    case 8: {
                        int n47;
                        int n48;
                        if (n19 != 7) {
                            if (bl9) {
                                byte[] byArray6 = ((DataBufferByte)raster.getDataBuffer()).getData();
                                ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
                                n42 = componentSampleModel.getOffset(n3 - raster.getSampleModelTranslateX(), n6 - raster.getSampleModelTranslateY());
                                int n58 = componentSampleModel.getScanlineStride();
                                if (n58 == (int)l2) {
                                    System.arraycopy(byArray6, n42, byArray4, 0, (int)l2 * n5);
                                } else {
                                    n48 = 0;
                                    for (n47 = 0; n47 < n5; ++n47) {
                                        System.arraycopy(byArray6, n42, byArray4, n48, (int)l2);
                                        n42 += n58;
                                        n48 += (int)l2;
                                    }
                                }
                            } else {
                                for (n44 = 0; n44 < n4; ++n44) {
                                    byArray4[n44] = (byte)nArray4[n44];
                                }
                            }
                        }
                        if (n19 == 1) {
                            this.output.write(byArray4, 0, n4);
                            continue block55;
                        }
                        if (n19 == 32773) {
                            n44 = TIFFImageEncoder.compressPackBits(byArray4, n5, (int)l2, byArray3);
                            lArray[n41++] = n44;
                            this.output.write(byArray3, 0, n44);
                            continue block55;
                        }
                        if (n19 == 7) {
                            long l7 = this.getOffset(this.output);
                            if (jPEGImageEncoder == null || jPEGEncodeParam.getWidth() != raster.getWidth() || jPEGEncodeParam.getHeight() != raster.getHeight()) {
                                jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((Raster)raster, (int)n31);
                                JPEGImageEncoder.modifyEncodeParam((JPEGEncodeParam)object4, jPEGEncodeParam, n18);
                                jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)this.output, (com.sun.image.codec.jpeg.JPEGEncodeParam)jPEGEncodeParam);
                            }
                            if (bl7) {
                                WritableRaster writableRaster = null;
                                if (raster instanceof WritableRaster) {
                                    writableRaster = (WritableRaster)raster;
                                } else {
                                    writableRaster = raster.createCompatibleWritableRaster();
                                    writableRaster.setRect(raster);
                                }
                                if (writableRaster.getMinX() != 0 || writableRaster.getMinY() != 0) {
                                    writableRaster = writableRaster.createWritableTranslatedChild(0, 0);
                                }
                                BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
                                jPEGImageEncoder.encode(bufferedImage);
                            } else {
                                jPEGImageEncoder.encode(raster.createTranslatedChild(0, 0));
                            }
                            long l8 = this.getOffset(this.output);
                            lArray[n41++] = (int)(l8 - l7);
                            continue block55;
                        }
                        if (n19 != 32946) continue block55;
                        n44 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n41++] = n44;
                        this.output.write(byArray3, 0, n44);
                        continue block55;
                    }
                    case 16: {
                        n44 = 0;
                        for (n43 = 0; n43 < n4; ++n43) {
                            n42 = (short)nArray4[n43];
                            byArray4[n44++] = (byte)((n42 & 0xFF00) >> 8);
                            byArray4[n44++] = (byte)(n42 & 0xFF);
                        }
                        if (n19 == 1) {
                            this.output.write(byArray4, 0, n4 * 2);
                            continue block55;
                        }
                        if (n19 == 32773) {
                            n43 = TIFFImageEncoder.compressPackBits(byArray4, n5, (int)l2, byArray3);
                            lArray[n41++] = n43;
                            this.output.write(byArray3, 0, n43);
                            continue block55;
                        }
                        if (n19 != 32946) continue block55;
                        n43 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n41++] = n43;
                        this.output.write(byArray3, 0, n43);
                        continue block55;
                    }
                    case 32: {
                        if (n24 == 3) {
                            n43 = 0;
                            for (n42 = 0; n42 < n4; ++n42) {
                                int n59 = nArray4[n42];
                                byArray4[n43++] = (byte)((n59 & 0xFF000000) >> 24);
                                byArray4[n43++] = (byte)((n59 & 0xFF0000) >> 16);
                                byArray4[n43++] = (byte)((n59 & 0xFF00) >> 8);
                                byArray4[n43++] = (byte)(n59 & 0xFF);
                            }
                        } else {
                            n43 = 0;
                            for (n42 = 0; n42 < n4; ++n42) {
                                int n60 = Float.floatToIntBits(fArray[n42]);
                                byArray4[n43++] = (byte)((n60 & 0xFF000000) >> 24);
                                byArray4[n43++] = (byte)((n60 & 0xFF0000) >> 16);
                                byArray4[n43++] = (byte)((n60 & 0xFF00) >> 8);
                                byArray4[n43++] = (byte)(n60 & 0xFF);
                            }
                        }
                        if (n19 == 1) {
                            this.output.write(byArray4, 0, n4 * 4);
                            continue block55;
                        }
                        if (n19 == 32773) {
                            n43 = TIFFImageEncoder.compressPackBits(byArray4, n5, (int)l2, byArray3);
                            lArray[n41++] = n43;
                            this.output.write(byArray3, 0, n43);
                            continue block55;
                        }
                        if (n19 != 32946) continue block55;
                        n43 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n41++] = n43;
                        this.output.write(byArray3, 0, n43);
                    }
                }
            }
        }
        if (n19 == 1) {
            if (bl6) {
                this.output.write(0);
            }
        } else {
            n6 = 0;
            for (n5 = 1; n5 < n16; ++n5) {
                n4 = (int)lArray[n5 - 1];
                n6 += n4;
                lArray2[n5] = lArray2[n5 - 1] + (long)n4;
            }
            n36 = bl ? 0 : n2 + n35 + (n6 += (int)lArray[n16 - 1]);
            boolean bl10 = bl6 = n36 % 2 != 0;
            if (object == null) {
                if (bl6) {
                    this.output.write(0);
                }
                SeekableOutputStream seekableOutputStream = (SeekableOutputStream)this.output;
                long l9 = seekableOutputStream.getFilePointer();
                seekableOutputStream.seek(n2);
                this.writeDirectory(n2, treeSet, n36);
                seekableOutputStream.seek(l9);
            } else if (file != null) {
                int n61;
                FileInputStream fileInputStream = new FileInputStream(file);
                this.output.close();
                this.output = object;
                this.writeDirectory(n2, treeSet, n36);
                byte[] byArray7 = new byte[8192];
                for (n3 = 0; n3 < n6 && (n61 = fileInputStream.read(byArray7)) != -1; n3 += n61) {
                    this.output.write(byArray7, 0, n61);
                }
                fileInputStream.close();
                file.delete();
                if (bl6) {
                    this.output.write(0);
                }
            } else if (this.output instanceof ByteArrayOutputStream) {
                ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)this.output;
                this.output = object;
                this.writeDirectory(n2, treeSet, n36);
                byteArrayOutputStream.writeTo(this.output);
                if (bl6) {
                    this.output.write(0);
                }
            } else {
                throw new IllegalStateException();
            }
        }
        return n36;
    }

    private int getDirectorySize(SortedSet sortedSet) {
        int n2 = sortedSet.size();
        int n3 = 2 + n2 * 12 + 4;
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            TIFFField tIFFField = (TIFFField)iterator.next();
            int n4 = TIFFImageEncoder.getValueSize(tIFFField);
            if (n4 <= 4) continue;
            n3 += n4;
        }
        return n3;
    }

    private void writeFileHeader() throws IOException {
        this.output.write(77);
        this.output.write(77);
        this.output.write(0);
        this.output.write(42);
        this.writeLong(8L);
    }

    private void writeDirectory(int n2, SortedSet sortedSet, int n3) throws IOException {
        int n4 = sortedSet.size();
        long l2 = n2 + 12 * n4 + 4 + 2;
        ArrayList<TIFFField> arrayList = new ArrayList<TIFFField>();
        this.writeUnsignedShort(n4);
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            TIFFField tIFFField = (TIFFField)iterator.next();
            int n5 = tIFFField.getTag();
            this.writeUnsignedShort(n5);
            int n6 = tIFFField.getType();
            this.writeUnsignedShort(n6);
            int n7 = tIFFField.getCount();
            int n8 = TIFFImageEncoder.getValueSize(tIFFField);
            this.writeLong(n6 == 2 ? (long)n8 : (long)n7);
            if (n8 > 4) {
                this.writeLong(l2);
                l2 += (long)n8;
                arrayList.add(tIFFField);
                continue;
            }
            this.writeValuesAsFourBytes(tIFFField);
        }
        this.writeLong(n3);
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            this.writeValues((TIFFField)arrayList.get(i2));
        }
    }

    private static final int getValueSize(TIFFField tIFFField) {
        int n2 = tIFFField.getType();
        int n3 = tIFFField.getCount();
        int n4 = 0;
        if (n2 == 2) {
            for (int i2 = 0; i2 < n3; ++i2) {
                byte[] byArray = tIFFField.getAsString(i2).getBytes();
                n4 += byArray.length;
                if (byArray[byArray.length - 1] == 0) continue;
                ++n4;
            }
        } else {
            n4 = n3 * sizeOfType[n2];
        }
        return n4;
    }

    private void writeValuesAsFourBytes(TIFFField tIFFField) throws IOException {
        int n2 = tIFFField.getType();
        int n3 = tIFFField.getCount();
        switch (n2) {
            case 1: 
            case 6: 
            case 7: {
                int n4;
                byte[] byArray = tIFFField.getAsBytes();
                for (n4 = 0; n4 < n3; ++n4) {
                    this.output.write(byArray[n4]);
                }
                for (n4 = 0; n4 < 4 - n3; ++n4) {
                    this.output.write(0);
                }
                break;
            }
            case 3: {
                int n5;
                char[] cArray = tIFFField.getAsChars();
                for (n5 = 0; n5 < n3; ++n5) {
                    this.writeUnsignedShort(cArray[n5]);
                }
                for (n5 = 0; n5 < 2 - n3; ++n5) {
                    this.writeUnsignedShort(0);
                }
                break;
            }
            case 8: {
                int n6;
                short[] sArray = tIFFField.getAsShorts();
                for (n6 = 0; n6 < n3; ++n6) {
                    this.writeUnsignedShort(sArray[n6]);
                }
                for (n6 = 0; n6 < 2 - n3; ++n6) {
                    this.writeUnsignedShort(0);
                }
                break;
            }
            case 4: {
                this.writeLong(tIFFField.getAsLong(0));
                break;
            }
            case 9: {
                this.writeLong(tIFFField.getAsInt(0));
                break;
            }
            case 11: {
                this.writeLong(Float.floatToIntBits(tIFFField.getAsFloat(0)));
                break;
            }
            case 2: {
                int n7;
                int n8 = 0;
                for (n7 = 0; n7 < n3; ++n7) {
                    byte[] byArray = tIFFField.getAsString(n7).getBytes();
                    this.output.write(byArray);
                    n8 += byArray.length;
                    if (byArray[byArray.length - 1] == 0) continue;
                    this.output.write(0);
                    ++n8;
                }
                for (n7 = 0; n7 < 4 - n8; ++n7) {
                    this.output.write(0);
                }
                break;
            }
            default: {
                throw new Error(JaiI18N.getString("TIFFImageEncoder10"));
            }
        }
    }

    private void writeValues(TIFFField tIFFField) throws IOException {
        int n2 = tIFFField.getType();
        int n3 = tIFFField.getCount();
        switch (n2) {
            case 1: 
            case 6: 
            case 7: {
                byte[] byArray = tIFFField.getAsBytes();
                for (int i2 = 0; i2 < n3; ++i2) {
                    this.output.write(byArray[i2]);
                }
                break;
            }
            case 3: {
                char[] cArray = tIFFField.getAsChars();
                for (int i3 = 0; i3 < n3; ++i3) {
                    this.writeUnsignedShort(cArray[i3]);
                }
                break;
            }
            case 8: {
                short[] sArray = tIFFField.getAsShorts();
                for (int i4 = 0; i4 < n3; ++i4) {
                    this.writeUnsignedShort(sArray[i4]);
                }
                break;
            }
            case 4: {
                long[] lArray = tIFFField.getAsLongs();
                for (int i5 = 0; i5 < n3; ++i5) {
                    this.writeLong(lArray[i5]);
                }
                break;
            }
            case 9: {
                int[] nArray = tIFFField.getAsInts();
                for (int i6 = 0; i6 < n3; ++i6) {
                    this.writeLong(nArray[i6]);
                }
                break;
            }
            case 11: {
                float[] fArray = tIFFField.getAsFloats();
                for (int i7 = 0; i7 < n3; ++i7) {
                    int n4 = Float.floatToIntBits(fArray[i7]);
                    this.writeLong(n4);
                }
                break;
            }
            case 12: {
                double[] dArray = tIFFField.getAsDoubles();
                for (int i8 = 0; i8 < n3; ++i8) {
                    long l2 = Double.doubleToLongBits(dArray[i8]);
                    this.writeLong((int)(l2 >> 32));
                    this.writeLong((int)(l2 & 0xFFFFFFFFFFFFFFFFL));
                }
                break;
            }
            case 5: {
                long[][] lArray = tIFFField.getAsRationals();
                for (int i9 = 0; i9 < n3; ++i9) {
                    this.writeLong(lArray[i9][0]);
                    this.writeLong(lArray[i9][1]);
                }
                break;
            }
            case 10: {
                int[][] nArray = tIFFField.getAsSRationals();
                for (int i10 = 0; i10 < n3; ++i10) {
                    this.writeLong(nArray[i10][0]);
                    this.writeLong(nArray[i10][1]);
                }
                break;
            }
            case 2: {
                for (int i11 = 0; i11 < n3; ++i11) {
                    byte[] byArray = tIFFField.getAsString(i11).getBytes();
                    this.output.write(byArray);
                    if (byArray[byArray.length - 1] == 0) continue;
                    this.output.write(0);
                }
                break;
            }
            default: {
                throw new Error(JaiI18N.getString("TIFFImageEncoder10"));
            }
        }
    }

    private void writeUnsignedShort(int n2) throws IOException {
        this.output.write((n2 & 0xFF00) >>> 8);
        this.output.write(n2 & 0xFF);
    }

    private void writeLong(long l2) throws IOException {
        this.output.write((int)((l2 & 0xFFFFFFFFFF000000L) >>> 24));
        this.output.write((int)((l2 & 0xFF0000L) >>> 16));
        this.output.write((int)((l2 & 0xFF00L) >>> 8));
        this.output.write((int)l2 & 0xFF);
    }

    private long getOffset(OutputStream outputStream) throws IOException {
        if (outputStream instanceof ByteArrayOutputStream) {
            return ((ByteArrayOutputStream)outputStream).size();
        }
        if (outputStream instanceof SeekableOutputStream) {
            return ((SeekableOutputStream)outputStream).getFilePointer();
        }
        throw new IllegalStateException();
    }

    private static int compressPackBits(byte[] byArray, int n2, int n3, byte[] byArray2) {
        int n4 = 0;
        int n5 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n5 = TIFFImageEncoder.packBits(byArray, n4, n3, byArray2, n5);
            n4 += n3;
        }
        return n5;
    }

    private static int packBits(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        int n5 = n2 + n3 - 1;
        int n6 = n5 - 1;
        while (n2 <= n5) {
            int n7;
            byte by = byArray[n2];
            for (n7 = 1; n7 < 127 && n2 < n5 && byArray[n2] == byArray[n2 + 1]; ++n7, ++n2) {
            }
            if (n7 > 1) {
                ++n2;
                byArray2[n4++] = (byte)(-(n7 - 1));
                byArray2[n4++] = by;
            }
            int n8 = n4;
            for (n7 = 0; n7 < 128 && (n2 < n5 && byArray[n2] != byArray[n2 + 1] || n2 < n6 && byArray[n2] != byArray[n2 + 2]); ++n7) {
                byArray2[++n4] = byArray[n2++];
            }
            if (n7 > 0) {
                byArray2[n8] = (byte)(n7 - 1);
                ++n4;
            }
            if (n2 != n5) continue;
            if (n7 > 0 && n7 < 128) {
                int n9 = n8;
                byArray2[n9] = (byte)(byArray2[n9] + 1);
                byArray2[n4++] = byArray[n2++];
                continue;
            }
            byArray2[n4++] = 0;
            byArray2[n4++] = byArray[n2++];
        }
        return n4;
    }

    private static int deflate(Deflater deflater, byte[] byArray, byte[] byArray2) {
        deflater.setInput(byArray);
        deflater.finish();
        int n2 = deflater.deflate(byArray2);
        deflater.reset();
        return n2;
    }
}

