/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.JAI;

import com.fr.third.JAI.ByteArraySeekableStream;
import com.fr.third.JAI.FPXUtils;
import com.fr.third.JAI.FileSeekableStream;
import com.fr.third.JAI.PropertySet;
import com.fr.third.JAI.SSDirectoryEntry;
import com.fr.third.JAI.SeekableStream;
import com.fr.third.JAI.SegmentedSeekableStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;

public class StructuredStorage {
    SeekableStream file;
    private int sectorShift;
    private int miniSectorShift;
    private long csectFat;
    private long sectDirStart;
    private long miniSectorCutoff;
    private long sectMiniFatStart;
    private long csectMiniFat;
    private long sectDifStart;
    private long csectDif;
    private long[] sectFat;
    private long[] MINIFAT;
    private SSDirectoryEntry[] DIR;
    private SeekableStream miniStream;
    private SeekableStream FATStream;
    long cwdIndex = -1L;

    public StructuredStorage(SeekableStream seekableStream) throws IOException {
        this.file = seekableStream;
        this.getHeader();
        this.getFat();
        this.getMiniFat();
        this.getDirectory();
        this.getMiniStream();
    }

    private void getHeader() throws IOException {
        this.file.seek(30L);
        this.sectorShift = this.file.readUnsignedShortLE();
        this.file.seek(32L);
        this.miniSectorShift = this.file.readUnsignedShortLE();
        this.file.seek(44L);
        this.csectFat = this.file.readUnsignedIntLE();
        this.file.seek(48L);
        this.sectDirStart = this.file.readUnsignedIntLE();
        this.file.seek(56L);
        this.miniSectorCutoff = this.file.readUnsignedIntLE();
        this.file.seek(60L);
        this.sectMiniFatStart = this.file.readUnsignedIntLE();
        this.file.seek(64L);
        this.csectMiniFat = this.file.readUnsignedIntLE();
        this.file.seek(68L);
        this.sectDifStart = this.file.readUnsignedIntLE();
        this.file.seek(72L);
        this.csectDif = this.file.readUnsignedIntLE();
        this.sectFat = new long[109];
        this.file.seek(76L);
        for (int i2 = 0; i2 < 109; ++i2) {
            this.sectFat[i2] = this.file.readUnsignedIntLE();
        }
    }

    private void getFat() throws IOException {
        long l2;
        int n2 = this.getSectorSize();
        int n3 = n2 / 4;
        int n4 = n2 / 4 - 1;
        int n5 = (int)(this.csectFat + this.csectDif * (long)n4);
        long[] lArray = new long[n5];
        int n6 = 0;
        for (int i2 = 0; i2 < 109 && (l2 = this.sectFat[i2]) != 0xFFFFFFFFL; ++i2) {
            lArray[n6++] = this.getOffsetOfSector(this.sectFat[i2]);
        }
        if (this.csectDif > 0L) {
            long l3 = this.sectDifStart;
            byte[] byArray = new byte[n2];
            int n7 = 0;
            while ((long)n7 < this.csectDif) {
                this.readSector(l3, byArray, 0);
                for (int i3 = 0; i3 < n4; ++i3) {
                    int n8 = FPXUtils.getIntLE(byArray, 4 * i3);
                    lArray[n6++] = this.getOffsetOfSector(n8);
                }
                l3 = FPXUtils.getIntLE(byArray, n2 - 4);
                ++n7;
            }
        }
        this.FATStream = new SegmentedSeekableStream(this.file, lArray, n2, n5 * n2, true);
    }

    private void getMiniFat() throws IOException {
        int n2 = this.getSectorSize();
        int n3 = n2 / 4;
        int n4 = 0;
        this.MINIFAT = new long[(int)(this.csectMiniFat * (long)n3)];
        long l2 = this.sectMiniFatStart;
        byte[] byArray = new byte[n2];
        while (l2 != 0xFFFFFFFEL) {
            this.readSector(l2, byArray, 0);
            for (int i2 = 0; i2 < n3; ++i2) {
                this.MINIFAT[n4++] = FPXUtils.getIntLE(byArray, 4 * i2);
            }
            l2 = this.getFATSector(l2);
        }
    }

    private void getDirectory() throws IOException {
        int n2 = this.getSectorSize();
        long l2 = this.sectDirStart;
        int n3 = 0;
        while (l2 != 0xFFFFFFFEL) {
            l2 = this.getFATSector(l2);
            ++n3;
        }
        int n4 = 4 * n3;
        this.DIR = new SSDirectoryEntry[n4];
        l2 = this.sectDirStart;
        byte[] byArray = new byte[n2];
        int n5 = 0;
        while (l2 != 0xFFFFFFFEL) {
            this.readSector(l2, byArray, 0);
            int n6 = 0;
            for (int i2 = 0; i2 < 4; ++i2) {
                short s2 = FPXUtils.getShortLE(byArray, n6 + 64);
                String string = FPXUtils.getString(byArray, n6 + 0, s2);
                long l3 = FPXUtils.getUnsignedIntLE(byArray, n6 + 68);
                long l4 = FPXUtils.getUnsignedIntLE(byArray, n6 + 72);
                long l5 = FPXUtils.getUnsignedIntLE(byArray, n6 + 76);
                long l6 = FPXUtils.getUnsignedIntLE(byArray, n6 + 116);
                long l7 = FPXUtils.getUnsignedIntLE(byArray, n6 + 120);
                this.DIR[n5] = new SSDirectoryEntry(n5, string, l7, l6, l3, l4, l5);
                ++n5;
                n6 += 128;
            }
            l2 = this.getFATSector(l2);
        }
    }

    private void getMiniStream() throws IOException {
        int n2 = this.getLength(0L);
        int n3 = this.getSectorSize();
        int n4 = (n2 + n3 - 1) / n3;
        long[] lArray = new long[n4];
        long l2 = this.getStartSector(0L);
        for (int i2 = 0; i2 < n4 - 1; ++i2) {
            lArray[i2] = this.getOffsetOfSector(l2);
            l2 = this.getFATSector(l2);
        }
        lArray[n4 - 1] = this.getOffsetOfSector(l2);
        this.miniStream = new SegmentedSeekableStream(this.file, lArray, n3, n2, true);
    }

    private int getSectorSize() {
        return 1 << this.sectorShift;
    }

    private long getOffsetOfSector(long l2) {
        return l2 * (long)this.getSectorSize() + 512L;
    }

    private int getMiniSectorSize() {
        return 1 << this.miniSectorShift;
    }

    private long getOffsetOfMiniSector(long l2) {
        return l2 * (long)this.getMiniSectorSize();
    }

    private void readMiniSector(long l2, byte[] byArray, int n2, int n3) throws IOException {
        this.miniStream.seek(this.getOffsetOfMiniSector(l2));
        this.miniStream.read(byArray, n2, n3);
    }

    private void readMiniSector(long l2, byte[] byArray, int n2) throws IOException {
        this.readMiniSector(l2, byArray, n2, this.getMiniSectorSize());
    }

    private void readSector(long l2, byte[] byArray, int n2, int n3) throws IOException {
        this.file.seek(this.getOffsetOfSector(l2));
        this.file.read(byArray, n2, n3);
    }

    private void readSector(long l2, byte[] byArray, int n2) throws IOException {
        this.readSector(l2, byArray, n2, this.getSectorSize());
    }

    private SSDirectoryEntry getDirectoryEntry(long l2) {
        return this.DIR[(int)l2];
    }

    private long getStartSector(long l2) {
        return this.DIR[(int)l2].getStartSector();
    }

    private int getLength(long l2) {
        return (int)this.DIR[(int)l2].getSize();
    }

    private long getFATSector(long l2) throws IOException {
        this.FATStream.seek(4L * l2);
        return this.FATStream.readUnsignedIntLE();
    }

    private long getMiniFATSector(long l2) {
        return this.MINIFAT[(int)l2];
    }

    private int getCurrentIndex() {
        return -1;
    }

    private int getIndex(String string, int n2) {
        return -1;
    }

    private long searchDirectory(String string, long l2) {
        if (l2 == 0xFFFFFFFFL) {
            return -1L;
        }
        SSDirectoryEntry sSDirectoryEntry = this.getDirectoryEntry(l2);
        if (string.equals(sSDirectoryEntry.getName())) {
            return l2;
        }
        long l3 = this.searchDirectory(string, sSDirectoryEntry.getSIDLeftSibling());
        if (l3 != -1L) {
            return l3;
        }
        long l4 = this.searchDirectory(string, sSDirectoryEntry.getSIDRightSibling());
        if (l4 != -1L) {
            return l4;
        }
        return -1L;
    }

    public void changeDirectoryToRoot() {
        this.cwdIndex = this.getDirectoryEntry(0L).getSIDChild();
    }

    public boolean changeDirectory(String string) {
        long l2 = this.searchDirectory(string, this.cwdIndex);
        if (l2 != -1L) {
            this.cwdIndex = this.getDirectoryEntry(l2).getSIDChild();
            return true;
        }
        return false;
    }

    private long getStreamIndex(String string) {
        long l2 = this.cwdIndex;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!bl) {
                l2 = this.getDirectoryEntry(l2).getSIDChild();
            } else {
                bl = false;
            }
            l2 = this.searchDirectory(string2, l2);
        }
        return l2;
    }

    public byte[] getStreamAsBytes(String string) throws IOException {
        long l2 = this.getStreamIndex(string);
        if (l2 == -1L) {
            return null;
        }
        int n2 = this.getLength(l2);
        byte[] byArray = new byte[n2];
        if ((long)n2 > this.miniSectorCutoff) {
            int n3 = this.getSectorSize();
            int n4 = (n2 + n3 - 1) / n3;
            long l3 = this.getStartSector(l2);
            int n5 = 0;
            for (int i2 = 0; i2 < n4 - 1; ++i2) {
                this.readSector(l3, byArray, n5, n3);
                n5 += n3;
                l3 = this.getFATSector(l3);
            }
            this.readSector(l3, byArray, n5, n2 - n5);
        } else {
            int n6 = this.getMiniSectorSize();
            int n7 = (n2 + n6 - 1) / n6;
            long l4 = this.getStartSector(l2);
            int n8 = 0;
            for (int i3 = 0; i3 < n7 - 1; ++i3) {
                long l5 = this.getOffsetOfMiniSector(l4);
                this.readMiniSector(l4, byArray, n8, n6);
                n8 += n6;
                l4 = this.getMiniFATSector(l4);
            }
            this.readMiniSector(l4, byArray, n8, n2 - n8);
        }
        return byArray;
    }

    public SeekableStream getStream(String string) throws IOException {
        long l2 = this.getStreamIndex(string);
        if (l2 == -1L) {
            return null;
        }
        int n2 = this.getLength(l2);
        if ((long)n2 > this.miniSectorCutoff) {
            int n3 = this.getSectorSize();
            int n4 = (n2 + n3 - 1) / n3;
            long[] lArray = new long[n4];
            long l3 = this.getStartSector(l2);
            for (int i2 = 0; i2 < n4 - 1; ++i2) {
                lArray[i2] = this.getOffsetOfSector(l3);
                l3 = this.getFATSector(l3);
            }
            lArray[n4 - 1] = this.getOffsetOfSector(l3);
            return new SegmentedSeekableStream(this.file, lArray, n3, n2, true);
        }
        int n5 = this.getMiniSectorSize();
        int n6 = (n2 + n5 - 1) / n5;
        long[] lArray = new long[n6];
        long l4 = this.getStartSector(l2);
        for (int i3 = 0; i3 < n6 - 1; ++i3) {
            lArray[i3] = this.getOffsetOfMiniSector(l4);
            l4 = this.getMiniFATSector(l4);
        }
        lArray[n6 - 1] = this.getOffsetOfMiniSector(l4);
        return new SegmentedSeekableStream(this.miniStream, lArray, n5, n2, true);
    }

    public static void main(String[] stringArray) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(stringArray[0], "r");
            FileSeekableStream fileSeekableStream = new FileSeekableStream(randomAccessFile);
            StructuredStorage structuredStorage = new StructuredStorage(fileSeekableStream);
            structuredStorage.changeDirectoryToRoot();
            byte[] byArray = structuredStorage.getStreamAsBytes("\u0005SummaryInformation");
            PropertySet propertySet = new PropertySet(new ByteArraySeekableStream(byArray));
            byte[] byArray2 = propertySet.getBlob(17);
            System.out.print("BM");
            int n2 = byArray2.length - 8 + 14 + 40;
            System.out.print((char)(n2 & 0xFF));
            System.out.print((char)(n2 >> 8 & 0xFF));
            System.out.print((char)(n2 >> 16 & 0xFF));
            System.out.print((char)(n2 >> 24 & 0xFF));
            System.out.print('\u0000');
            System.out.print('\u0000');
            System.out.print('\u0000');
            System.out.print('\u0000');
            System.out.print('6');
            System.out.print('\u0000');
            System.out.print('\u0000');
            System.out.print('\u0000');
            for (int i2 = 8; i2 < byArray2.length; ++i2) {
                System.out.print((char)(byArray2[i2] & 0xFF));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

