/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.JAI;

import com.fr.third.JAI.ImageEncodeParam;
import com.fr.third.JAI.ImageEncoderImpl;
import com.fr.third.JAI.JaiI18N;
import com.fr.third.JAI.PNMEncodeParam;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public class PNMImageEncoder
extends ImageEncoderImpl {
    private static final int PBM_ASCII = 49;
    private static final int PGM_ASCII = 50;
    private static final int PPM_ASCII = 51;
    private static final int PBM_RAW = 52;
    private static final int PGM_RAW = 53;
    private static final int PPM_RAW = 54;
    private static final int SPACE = 32;
    private static final String COMMENT = "# written by com.sun.media.jai.codecimpl.PNMImageEncoder";
    private byte[] lineSeparator;
    private int variant;
    private int maxValue;

    public PNMImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        super(outputStream, imageEncodeParam);
        if (this.param == null) {
            this.param = new PNMEncodeParam();
        }
    }

    public void encode(RenderedImage renderedImage) throws IOException {
        int n2;
        Object[] objectArray;
        boolean bl;
        boolean bl2;
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        int n3;
        SampleModel sampleModel;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        block61: {
            ComponentSampleModel componentSampleModel;
            ColorModel colorModel;
            block60: {
                int n9;
                n8 = renderedImage.getMinX();
                n7 = renderedImage.getMinY();
                n6 = renderedImage.getWidth();
                n5 = renderedImage.getHeight();
                n4 = renderedImage.getTileHeight();
                sampleModel = renderedImage.getSampleModel();
                colorModel = renderedImage.getColorModel();
                String string = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
                this.lineSeparator = string.getBytes();
                int n10 = sampleModel.getTransferType();
                if (n10 == 4 || n10 == 5) {
                    throw new RuntimeException(JaiI18N.getString("PNMImageEncoder0"));
                }
                int[] nArray = sampleModel.getSampleSize();
                n3 = sampleModel.getNumBands();
                byArray3 = null;
                byArray2 = null;
                byArray = null;
                bl2 = false;
                if (n3 == 1) {
                    if (colorModel instanceof IndexColorModel) {
                        IndexColorModel indexColorModel = (IndexColorModel)colorModel;
                        n9 = indexColorModel.getMapSize();
                        if (n9 < 1 << nArray[0]) {
                            throw new RuntimeException(JaiI18N.getString("PNMImageEncoder1"));
                        }
                        if (nArray[0] == 1) {
                            this.variant = 52;
                            bl2 = indexColorModel.getRed(1) + indexColorModel.getGreen(1) + indexColorModel.getBlue(1) > indexColorModel.getRed(0) + indexColorModel.getGreen(0) + indexColorModel.getBlue(0);
                        } else {
                            this.variant = 54;
                            byArray3 = new byte[n9];
                            byArray2 = new byte[n9];
                            byArray = new byte[n9];
                            indexColorModel.getReds(byArray3);
                            indexColorModel.getGreens(byArray2);
                            indexColorModel.getBlues(byArray);
                        }
                    } else {
                        this.variant = nArray[0] == 1 ? 52 : (nArray[0] <= 8 ? 53 : 50);
                    }
                } else if (n3 == 3) {
                    this.variant = nArray[0] <= 8 && nArray[1] <= 8 && nArray[2] <= 8 ? 54 : 51;
                } else {
                    throw new RuntimeException(JaiI18N.getString("PNMImageEncoder2"));
                }
                if (((PNMEncodeParam)this.param).getRaw()) {
                    if (!this.isRaw(this.variant)) {
                        boolean bl3 = true;
                        for (n9 = 0; n9 < nArray.length; ++n9) {
                            if (nArray[n9] <= 8) continue;
                            bl3 = false;
                            break;
                        }
                        if (bl3) {
                            this.variant += 3;
                        }
                    }
                } else if (this.isRaw(this.variant)) {
                    this.variant -= 3;
                }
                this.maxValue = (1 << nArray[0]) - 1;
                this.output.write(80);
                this.output.write(this.variant);
                this.output.write(this.lineSeparator);
                this.output.write(COMMENT.getBytes());
                this.output.write(this.lineSeparator);
                this.writeInteger(this.output, n6);
                this.output.write(32);
                this.writeInteger(this.output, n5);
                if (this.variant != 52 && this.variant != 49) {
                    this.output.write(this.lineSeparator);
                    this.writeInteger(this.output, this.maxValue);
                }
                if (this.variant == 52 || this.variant == 53 || this.variant == 54) {
                    this.output.write(10);
                }
                bl = false;
                if (this.variant != 52 || sampleModel.getTransferType() != 0 || !(sampleModel instanceof MultiPixelPackedSampleModel)) break block60;
                MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                if (multiPixelPackedSampleModel.getDataBitOffset() != 0 || multiPixelPackedSampleModel.getPixelBitStride() != 1) break block61;
                bl = true;
                break block61;
            }
            if ((this.variant == 53 || this.variant == 54) && sampleModel instanceof ComponentSampleModel && !(colorModel instanceof IndexColorModel) && (componentSampleModel = (ComponentSampleModel)sampleModel).getPixelStride() == n3) {
                bl = true;
                if (this.variant == 54) {
                    objectArray = componentSampleModel.getBandOffsets();
                    for (n2 = 0; n2 < n3; ++n2) {
                        if (objectArray[n2] == n2) continue;
                        bl = false;
                        break;
                    }
                }
            }
        }
        if (bl) {
            int n11 = this.variant == 52 ? (n6 + 7) / 8 : n6 * sampleModel.getNumBands();
            int n12 = renderedImage.getNumYTiles();
            Rectangle rectangle = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getTileHeight());
            byte[] byArray4 = null;
            if (bl2) {
                byArray4 = new byte[n11];
            }
            for (int i2 = 0; i2 < n12; ++i2) {
                int n13;
                if (i2 == n12 - 1) {
                    rectangle.height = renderedImage.getHeight() - rectangle.y;
                }
                Raster raster = renderedImage.getData(rectangle);
                byte[] byArray5 = ((DataBufferByte)raster.getDataBuffer()).getData();
                int n14 = n13 = this.variant == 52 ? ((MultiPixelPackedSampleModel)sampleModel).getScanlineStride() : ((ComponentSampleModel)sampleModel).getScanlineStride();
                if (n13 == n11 && !bl2) {
                    this.output.write(byArray5, 0, byArray5.length);
                } else {
                    int n15 = 0;
                    for (int i3 = 0; i3 < n4; ++i3) {
                        if (bl2) {
                            for (int i4 = 0; i4 < n11; ++i4) {
                                byArray4[i4] = (byte)(~(byArray5[n15 + i4] & 0xFF));
                            }
                            this.output.write(byArray4, 0, n11);
                        } else {
                            this.output.write(byArray5, n15, n11);
                        }
                        n15 += n13;
                    }
                }
                rectangle.y += n4;
            }
            this.output.flush();
            return;
        }
        int[] nArray = new int[8 * n6 * n3];
        objectArray = byArray3 == null ? new byte[8 * n6 * n3] : new byte[8 * n6 * 3];
        n2 = 0;
        int n16 = n7 + n5;
        block12: for (int i5 = n7; i5 < n16; i5 += 8) {
            int n17;
            int n18 = Math.min(8, n16 - i5);
            int n19 = n18 * n6 * n3;
            Raster raster = renderedImage.getData(new Rectangle(n8, i5, n6, n18));
            raster.getPixels(n8, i5, n6, n18, nArray);
            if (bl2) {
                n17 = 0;
                while (n17 < n19) {
                    int n20 = n17++;
                    nArray[n20] = nArray[n20] ^ 1;
                }
            }
            switch (this.variant) {
                case 49: 
                case 50: {
                    for (n17 = 0; n17 < n19; ++n17) {
                        if (n2++ % 16 == 0) {
                            this.output.write(this.lineSeparator);
                        } else {
                            this.output.write(32);
                        }
                        this.writeInteger(this.output, nArray[n17]);
                    }
                    this.output.write(this.lineSeparator);
                    continue block12;
                }
                case 51: {
                    if (byArray3 == null) {
                        for (n17 = 0; n17 < n19; ++n17) {
                            if (n2++ % 16 == 0) {
                                this.output.write(this.lineSeparator);
                            } else {
                                this.output.write(32);
                            }
                            this.writeInteger(this.output, nArray[n17]);
                        }
                    } else {
                        for (n17 = 0; n17 < n19; ++n17) {
                            if (n2++ % 16 == 0) {
                                this.output.write(this.lineSeparator);
                            } else {
                                this.output.write(32);
                            }
                            this.writeInteger(this.output, byArray3[nArray[n17]] & 0xFF);
                            this.output.write(32);
                            this.writeInteger(this.output, byArray2[nArray[n17]] & 0xFF);
                            this.output.write(32);
                            this.writeInteger(this.output, byArray[nArray[n17]] & 0xFF);
                        }
                    }
                    this.output.write(this.lineSeparator);
                    continue block12;
                }
                case 52: {
                    int n21;
                    int n22;
                    n17 = 0;
                    int n23 = 0;
                    for (n22 = 0; n22 < n19 / 8; ++n22) {
                        n21 = nArray[n23++] << 7 | nArray[n23++] << 6 | nArray[n23++] << 5 | nArray[n23++] << 4 | nArray[n23++] << 3 | nArray[n23++] << 2 | nArray[n23++] << 1 | nArray[n23++];
                        objectArray[n17++] = (byte)n21;
                    }
                    if (n19 % 8 > 0) {
                        n22 = 0;
                        for (n21 = 0; n21 < n19 % 8; ++n21) {
                            n22 |= nArray[n19 + n21] << 7 - n21;
                        }
                        objectArray[n17++] = (byte)n22;
                    }
                    this.output.write((byte[])objectArray, 0, (n19 + 7) / 8);
                    continue block12;
                }
                case 53: {
                    int n22;
                    for (n22 = 0; n22 < n19; ++n22) {
                        objectArray[n22] = (byte)nArray[n22];
                    }
                    this.output.write((byte[])objectArray, 0, n19);
                    continue block12;
                }
                case 54: {
                    int n21;
                    int n22;
                    if (byArray3 == null) {
                        for (n22 = 0; n22 < n19; ++n22) {
                            objectArray[n22] = (byte)(nArray[n22] & 0xFF);
                        }
                    } else {
                        n21 = 0;
                        for (n22 = 0; n22 < n19; ++n22) {
                            objectArray[n21++] = byArray3[nArray[n22]];
                            objectArray[n21++] = byArray2[nArray[n22]];
                            objectArray[n21++] = byArray[nArray[n22]];
                        }
                    }
                    this.output.write((byte[])objectArray, 0, objectArray.length);
                }
            }
        }
        this.output.flush();
    }

    private void writeInteger(OutputStream outputStream, int n2) throws IOException {
        outputStream.write(Integer.toString(n2).getBytes());
    }

    private void writeByte(OutputStream outputStream, byte by) throws IOException {
        outputStream.write(Byte.toString(by).getBytes());
    }

    private boolean isRaw(int n2) {
        return n2 >= 52;
    }
}

