/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.JAI;

import com.fr.third.JAI.ImageCodec;
import com.fr.third.JAI.JaiI18N;
import com.fr.third.JAI.PNGChunk;
import com.fr.third.JAI.PNGDecodeParam;
import com.fr.third.JAI.PNGEncodeParam;
import com.fr.third.JAI.SimpleRenderedImage;
import java.awt.Color;
import java.awt.Point;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

class PNGImage
extends SimpleRenderedImage {
    public static final int PNG_COLOR_GRAY = 0;
    public static final int PNG_COLOR_RGB = 2;
    public static final int PNG_COLOR_PALETTE = 3;
    public static final int PNG_COLOR_GRAY_ALPHA = 4;
    public static final int PNG_COLOR_RGB_ALPHA = 6;
    private static final String[] colorTypeNames = new String[]{"Grayscale", "Error", "Truecolor", "Index", "Grayscale with alpha", "Error", "Truecolor with alpha"};
    public static final int PNG_FILTER_NONE = 0;
    public static final int PNG_FILTER_SUB = 1;
    public static final int PNG_FILTER_UP = 2;
    public static final int PNG_FILTER_AVERAGE = 3;
    public static final int PNG_FILTER_PAETH = 4;
    private static final int RED_OFFSET = 2;
    private static final int GREEN_OFFSET = 1;
    private static final int BLUE_OFFSET = 0;
    private int[][] bandOffsets = new int[][]{null, {0}, {0, 1}, {0, 1, 2}, {0, 1, 2, 3}};
    private int bitDepth;
    private int colorType;
    private int compressionMethod;
    private int filterMethod;
    private int interlaceMethod;
    private int paletteEntries;
    private byte[] redPalette;
    private byte[] greenPalette;
    private byte[] bluePalette;
    private byte[] alphaPalette;
    private int bkgdRed;
    private int bkgdGreen;
    private int bkgdBlue;
    private int grayTransparentAlpha;
    private int redTransparentAlpha;
    private int greenTransparentAlpha;
    private int blueTransparentAlpha;
    private int maxOpacity;
    private int[] significantBits = null;
    private boolean hasBackground = false;
    private boolean suppressAlpha = false;
    private boolean expandPalette = false;
    private boolean output8BitGray = false;
    private boolean outputHasAlphaPalette = false;
    private boolean performGammaCorrection = false;
    private boolean expandGrayAlpha = false;
    private boolean generateEncodeParam = false;
    private PNGDecodeParam decodeParam = null;
    private PNGEncodeParam encodeParam = null;
    private boolean emitProperties = true;
    private float fileGamma = 0.45455f;
    private float userExponent = 1.0f;
    private float displayExponent = 2.2f;
    private float[] chromaticity = null;
    private int sRGBRenderingIntent = -1;
    private int postProcess = 0;
    private static final int POST_NONE = 0;
    private static final int POST_GAMMA = 1;
    private static final int POST_GRAY_LUT = 2;
    private static final int POST_GRAY_LUT_ADD_TRANS = 3;
    private static final int POST_PALETTE_TO_RGB = 4;
    private static final int POST_PALETTE_TO_RGBA = 5;
    private static final int POST_ADD_GRAY_TRANS = 6;
    private static final int POST_ADD_RGB_TRANS = 7;
    private static final int POST_REMOVE_GRAY_TRANS = 8;
    private static final int POST_REMOVE_RGB_TRANS = 9;
    private static final int POST_EXP_MASK = 16;
    private static final int POST_GRAY_ALPHA_EXP = 16;
    private static final int POST_GAMMA_EXP = 17;
    private static final int POST_GRAY_LUT_ADD_TRANS_EXP = 19;
    private static final int POST_ADD_GRAY_TRANS_EXP = 22;
    private Vector streamVec = new Vector();
    private DataInputStream dataStream;
    private int bytesPerPixel;
    private int inputBands;
    private int outputBands;
    private int chunkIndex = 0;
    private Vector textKeys = new Vector();
    private Vector textStrings = new Vector();
    private Vector ztextKeys = new Vector();
    private Vector ztextStrings = new Vector();
    private WritableRaster theTile;
    private int[] gammaLut = null;
    private final byte[][] expandBits = new byte[][]{null, {0, -1}, {0, 85, -86, -1}, null, {0, 17, 34, 51, 68, 85, 102, 119, -120, -103, -86, -69, -52, -35, -18, -1}};
    private int[] grayLut = null;

    private void initGammaLut(int n2) {
        double d2 = (double)this.userExponent / (double)(this.fileGamma * this.displayExponent);
        int n3 = 1 << n2;
        int n4 = n2 == 16 ? 65535 : 255;
        this.gammaLut = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            double d3 = (double)i2 / (double)(n3 - 1);
            double d4 = Math.pow(d3, d2);
            int n5 = (int)(d4 * (double)n4 + 0.5);
            if (n5 > n4) {
                n5 = n4;
            }
            this.gammaLut[i2] = n5;
        }
    }

    private void initGrayLut(int n2) {
        int n3 = 1 << n2;
        this.grayLut = new int[n3];
        if (this.performGammaCorrection) {
            for (int i2 = 0; i2 < n3; ++i2) {
                this.grayLut[i2] = this.gammaLut[i2];
            }
        } else {
            for (int i3 = 0; i3 < n3; ++i3) {
                this.grayLut[i3] = this.expandBits[n2][i3];
            }
        }
    }

    public PNGImage(InputStream inputStream, PNGDecodeParam pNGDecodeParam) throws IOException {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        if (pNGDecodeParam == null) {
            pNGDecodeParam = new PNGDecodeParam();
        }
        this.decodeParam = pNGDecodeParam;
        this.suppressAlpha = pNGDecodeParam.getSuppressAlpha();
        this.expandPalette = pNGDecodeParam.getExpandPalette();
        this.output8BitGray = pNGDecodeParam.getOutput8BitGray();
        this.expandGrayAlpha = pNGDecodeParam.getExpandGrayAlpha();
        if (pNGDecodeParam.getPerformGammaCorrection()) {
            this.userExponent = pNGDecodeParam.getUserExponent();
            this.displayExponent = pNGDecodeParam.getDisplayExponent();
            this.performGammaCorrection = true;
            this.output8BitGray = true;
        }
        this.generateEncodeParam = pNGDecodeParam.getGenerateEncodeParam();
        if (this.emitProperties) {
            this.properties.put("file_type", "PNG v. 1.0");
        }
        try {
            long l2 = dataInputStream.readLong();
            if (l2 != -8552249625308161526L) {
                String string = JaiI18N.getString("PNGImageDecoder0");
                throw new RuntimeException(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = JaiI18N.getString("PNGImageDecoder1");
            throw new RuntimeException(string);
        }
        try {
            while (true) {
                PNGChunk pNGChunk;
                String string;
                if ((string = PNGImage.getChunkType(dataInputStream)).equals("IHDR")) {
                    pNGChunk = PNGImage.readChunk(dataInputStream);
                    this.parse_IHDR_chunk(pNGChunk);
                    continue;
                }
                if (string.equals("PLTE")) {
                    pNGChunk = PNGImage.readChunk(dataInputStream);
                    this.parse_PLTE_chunk(pNGChunk);
                    continue;
                }
                if (string.equals("IDAT")) {
                    pNGChunk = PNGImage.readChunk(dataInputStream);
                    this.streamVec.add(new ByteArrayInputStream(pNGChunk.getData()));
                    continue;
                }
                if (string.equals("IEND")) {
                    PNGChunk pNGChunk2 = PNGImage.readChunk(dataInputStream);
                    this.parse_IEND_chunk(pNGChunk2);
                    break;
                }
                if (string.equals("bKGD")) {
                    pNGChunk = PNGImage.readChunk(dataInputStream);
                    this.parse_bKGD_chunk(pNGChunk);
                    continue;
                }
                if (string.equals("cHRM")) {
                    pNGChunk = PNGImage.readChunk(dataInputStream);
                    this.parse_cHRM_chunk(pNGChunk);
                    continue;
                }
                if (string.equals("gAMA")) {
                    pNGChunk = PNGImage.readChunk(dataInputStream);
                    this.parse_gAMA_chunk(pNGChunk);
                    continue;
                }
                if (string.equals("hIST")) {
                    pNGChunk = PNGImage.readChunk(dataInputStream);
                    this.parse_hIST_chunk(pNGChunk);
                    continue;
                }
                if (string.equals("iCCP")) {
                    pNGChunk = PNGImage.readChunk(dataInputStream);
                    this.parse_iCCP_chunk(pNGChunk);
                    continue;
                }
                if (string.equals("pHYs")) {
                    pNGChunk = PNGImage.readChunk(dataInputStream);
                    this.parse_pHYs_chunk(pNGChunk);
                    continue;
                }
                if (string.equals("sBIT")) {
                    pNGChunk = PNGImage.readChunk(dataInputStream);
                    this.parse_sBIT_chunk(pNGChunk);
                    continue;
                }
                if (string.equals("sRGB")) {
                    pNGChunk = PNGImage.readChunk(dataInputStream);
                    this.parse_sRGB_chunk(pNGChunk);
                    continue;
                }
                if (string.equals("tEXt")) {
                    pNGChunk = PNGImage.readChunk(dataInputStream);
                    this.parse_tEXt_chunk(pNGChunk);
                    continue;
                }
                if (string.equals("tIME")) {
                    pNGChunk = PNGImage.readChunk(dataInputStream);
                    this.parse_tIME_chunk(pNGChunk);
                    continue;
                }
                if (string.equals("tRNS")) {
                    pNGChunk = PNGImage.readChunk(dataInputStream);
                    this.parse_tRNS_chunk(pNGChunk);
                    continue;
                }
                if (string.equals("zTXt")) {
                    pNGChunk = PNGImage.readChunk(dataInputStream);
                    this.parse_zTXt_chunk(pNGChunk);
                    continue;
                }
                pNGChunk = PNGImage.readChunk(dataInputStream);
                String string2 = pNGChunk.getTypeString();
                byte[] byArray = pNGChunk.getData();
                if (this.encodeParam != null) {
                    this.encodeParam.addPrivateChunk(string2, byArray);
                }
                if (!this.emitProperties) continue;
                String string3 = "chunk_" + this.chunkIndex++ + ":" + string2;
                this.properties.put(string3.toLowerCase(), byArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = JaiI18N.getString("PNGImageDecoder2");
            throw new RuntimeException(string);
        }
        if (this.significantBits == null) {
            this.significantBits = new int[this.inputBands];
            for (int i2 = 0; i2 < this.inputBands; ++i2) {
                this.significantBits[i2] = this.bitDepth;
            }
            if (this.emitProperties) {
                this.properties.put("significant_bits", this.significantBits);
            }
        }
    }

    private static String getChunkType(DataInputStream dataInputStream) {
        try {
            dataInputStream.mark(8);
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            dataInputStream.reset();
            String string = new String();
            string = string + (char)(n3 >> 24);
            string = string + (char)(n3 >> 16 & 0xFF);
            string = string + (char)(n3 >> 8 & 0xFF);
            string = string + (char)(n3 & 0xFF);
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static PNGChunk readChunk(DataInputStream dataInputStream) {
        try {
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            byte[] byArray = new byte[n2];
            dataInputStream.readFully(byArray);
            int n4 = dataInputStream.readInt();
            return new PNGChunk(n2, n3, byArray, n4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void parse_IHDR_chunk(PNGChunk pNGChunk) {
        this.tileWidth = this.width = pNGChunk.getInt4(0);
        this.tileHeight = this.height = pNGChunk.getInt4(4);
        this.bitDepth = pNGChunk.getInt1(8);
        if (this.bitDepth != 1 && this.bitDepth != 2 && this.bitDepth != 4 && this.bitDepth != 8 && this.bitDepth != 16) {
            String string = JaiI18N.getString("PNGImageDecoder3");
            throw new RuntimeException(string);
        }
        this.maxOpacity = (1 << this.bitDepth) - 1;
        this.colorType = pNGChunk.getInt1(9);
        if (this.colorType != 0 && this.colorType != 2 && this.colorType != 3 && this.colorType != 4 && this.colorType != 6) {
            System.out.println(JaiI18N.getString("PNGImageDecoder4"));
        }
        if (this.colorType == 2 && this.bitDepth < 8) {
            String string = JaiI18N.getString("PNGImageDecoder5");
            throw new RuntimeException(string);
        }
        if (this.colorType == 3 && this.bitDepth == 16) {
            String string = JaiI18N.getString("PNGImageDecoder6");
            throw new RuntimeException(string);
        }
        if (this.colorType == 4 && this.bitDepth < 8) {
            String string = JaiI18N.getString("PNGImageDecoder7");
            throw new RuntimeException(string);
        }
        if (this.colorType == 6 && this.bitDepth < 8) {
            String string = JaiI18N.getString("PNGImageDecoder8");
            throw new RuntimeException(string);
        }
        if (this.emitProperties) {
            this.properties.put("color_type", colorTypeNames[this.colorType]);
        }
        if (this.generateEncodeParam) {
            this.encodeParam = this.colorType == 3 ? new PNGEncodeParam.Palette() : (this.colorType == 0 || this.colorType == 4 ? new PNGEncodeParam.Gray() : new PNGEncodeParam.RGB());
            this.decodeParam.setEncodeParam(this.encodeParam);
        }
        if (this.encodeParam != null) {
            this.encodeParam.setBitDepth(this.bitDepth);
        }
        if (this.emitProperties) {
            this.properties.put("bit_depth", new Integer(this.bitDepth));
        }
        if (this.performGammaCorrection) {
            float f2 = 0.45454544f * (this.displayExponent / this.userExponent);
            if (this.encodeParam != null) {
                this.encodeParam.setGamma(f2);
            }
            if (this.emitProperties) {
                this.properties.put("gamma", new Float(f2));
            }
        }
        this.compressionMethod = pNGChunk.getInt1(10);
        if (this.compressionMethod != 0) {
            String string = JaiI18N.getString("PNGImageDecoder9");
            throw new RuntimeException(string);
        }
        this.filterMethod = pNGChunk.getInt1(11);
        if (this.filterMethod != 0) {
            String string = JaiI18N.getString("PNGImageDecoder10");
            throw new RuntimeException(string);
        }
        this.interlaceMethod = pNGChunk.getInt1(12);
        if (this.interlaceMethod == 0) {
            if (this.encodeParam != null) {
                this.encodeParam.setInterlacing(false);
            }
            if (this.emitProperties) {
                this.properties.put("interlace_method", "None");
            }
        } else if (this.interlaceMethod == 1) {
            if (this.encodeParam != null) {
                this.encodeParam.setInterlacing(true);
            }
            if (this.emitProperties) {
                this.properties.put("interlace_method", "Adam7");
            }
        } else {
            String string = JaiI18N.getString("PNGImageDecoder11");
            throw new RuntimeException(string);
        }
        this.bytesPerPixel = this.bitDepth == 16 ? 2 : 1;
        switch (this.colorType) {
            case 0: {
                this.inputBands = 1;
                this.outputBands = 1;
                if (this.output8BitGray && this.bitDepth < 8) {
                    this.postProcess = 2;
                    break;
                }
                if (this.performGammaCorrection) {
                    this.postProcess = 1;
                    break;
                }
                this.postProcess = 0;
                break;
            }
            case 2: {
                this.inputBands = 3;
                this.bytesPerPixel *= 3;
                this.outputBands = 3;
                if (this.performGammaCorrection) {
                    this.postProcess = 1;
                    break;
                }
                this.postProcess = 0;
                break;
            }
            case 3: {
                this.inputBands = 1;
                this.bytesPerPixel = 1;
                int n2 = this.outputBands = this.expandPalette ? 3 : 1;
                if (this.expandPalette) {
                    this.postProcess = 4;
                    break;
                }
                this.postProcess = 0;
                break;
            }
            case 4: {
                this.inputBands = 2;
                this.bytesPerPixel *= 2;
                if (this.suppressAlpha) {
                    this.outputBands = 1;
                    this.postProcess = 8;
                    break;
                }
                this.postProcess = this.performGammaCorrection ? 1 : 0;
                if (this.expandGrayAlpha) {
                    this.postProcess |= 0x10;
                    this.outputBands = 4;
                    break;
                }
                this.outputBands = 2;
                break;
            }
            case 6: {
                this.inputBands = 4;
                this.bytesPerPixel *= 4;
                int n3 = this.outputBands = !this.suppressAlpha ? 4 : 3;
                this.postProcess = this.suppressAlpha ? 9 : (this.performGammaCorrection ? 1 : 0);
            }
        }
    }

    private void parse_IEND_chunk(PNGChunk pNGChunk) throws Exception {
        Object object;
        String[] stringArray;
        int n2;
        int n3 = this.textKeys.size();
        String[] stringArray2 = new String[2 * n3];
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray = (String[])this.textKeys.elementAt(n2);
            String string = (String)this.textStrings.elementAt(n2);
            stringArray2[2 * n2] = stringArray;
            stringArray2[2 * n2 + 1] = string;
            if (!this.emitProperties) continue;
            object = "text_" + n2 + ":" + (String)stringArray;
            this.properties.put(((String)object).toLowerCase(), string);
        }
        if (this.encodeParam != null) {
            this.encodeParam.setText(stringArray2);
        }
        n2 = this.ztextKeys.size();
        stringArray = new String[2 * n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            object = (String)this.ztextKeys.elementAt(i2);
            String string = (String)this.ztextStrings.elementAt(i2);
            stringArray[2 * i2] = object;
            stringArray[2 * i2 + 1] = string;
            if (!this.emitProperties) continue;
            String string2 = "ztext_" + i2 + ":" + (String)object;
            this.properties.put(string2.toLowerCase(), string);
        }
        if (this.encodeParam != null) {
            this.encodeParam.setCompressedText(stringArray);
        }
        SequenceInputStream sequenceInputStream = new SequenceInputStream(this.streamVec.elements());
        object = new InflaterInputStream(sequenceInputStream, new Inflater());
        this.dataStream = new DataInputStream((InputStream)object);
        int n4 = this.bitDepth;
        if (this.colorType == 0 && this.bitDepth < 8 && this.output8BitGray) {
            n4 = 8;
        }
        if (this.colorType == 3 && this.expandPalette) {
            n4 = 8;
        }
        int n5 = (this.outputBands * this.width * n4 + 7) / 8;
        int n6 = n4 == 16 ? n5 / 2 : n5;
        this.theTile = this.createRaster(this.width, this.height, this.outputBands, n6, n4);
        if (this.performGammaCorrection && this.gammaLut == null) {
            this.initGammaLut(this.bitDepth);
        }
        if (this.postProcess == 2 || this.postProcess == 3 || this.postProcess == 19) {
            this.initGrayLut(this.bitDepth);
        }
        this.decodeImage(this.interlaceMethod == 1);
        this.sampleModel = this.theTile.getSampleModel();
        if (this.colorType == 3 && !this.expandPalette) {
            this.colorModel = this.outputHasAlphaPalette ? new IndexColorModel(this.bitDepth, this.paletteEntries, this.redPalette, this.greenPalette, this.bluePalette, this.alphaPalette) : new IndexColorModel(this.bitDepth, this.paletteEntries, this.redPalette, this.greenPalette, this.bluePalette);
        } else if (this.colorType == 0 && this.bitDepth < 8 && !this.output8BitGray) {
            byte[] byArray = this.expandBits[this.bitDepth];
            this.colorModel = new IndexColorModel(this.bitDepth, byArray.length, byArray, byArray, byArray);
        } else {
            this.colorModel = ImageCodec.createComponentColorModel(this.sampleModel);
        }
    }

    private void parse_PLTE_chunk(PNGChunk pNGChunk) {
        this.paletteEntries = pNGChunk.getLength() / 3;
        this.redPalette = new byte[this.paletteEntries];
        this.greenPalette = new byte[this.paletteEntries];
        this.bluePalette = new byte[this.paletteEntries];
        int n2 = 0;
        if (this.performGammaCorrection) {
            if (this.gammaLut == null) {
                this.initGammaLut(this.bitDepth == 16 ? 16 : 8);
            }
            for (int i2 = 0; i2 < this.paletteEntries; ++i2) {
                byte by = pNGChunk.getByte(n2++);
                byte by2 = pNGChunk.getByte(n2++);
                byte by3 = pNGChunk.getByte(n2++);
                this.redPalette[i2] = (byte)this.gammaLut[by & 0xFF];
                this.greenPalette[i2] = (byte)this.gammaLut[by2 & 0xFF];
                this.bluePalette[i2] = (byte)this.gammaLut[by3 & 0xFF];
            }
        } else {
            for (int i3 = 0; i3 < this.paletteEntries; ++i3) {
                this.redPalette[i3] = pNGChunk.getByte(n2++);
                this.greenPalette[i3] = pNGChunk.getByte(n2++);
                this.bluePalette[i3] = pNGChunk.getByte(n2++);
            }
        }
    }

    private void parse_bKGD_chunk(PNGChunk pNGChunk) {
        int n2;
        int n3;
        this.hasBackground = true;
        switch (this.colorType) {
            case 3: {
                n3 = pNGChunk.getByte(0) & 0xFF;
                this.bkgdRed = this.redPalette[n3] & 0xFF;
                this.bkgdGreen = this.greenPalette[n3] & 0xFF;
                this.bkgdBlue = this.bluePalette[n3] & 0xFF;
                if (this.encodeParam == null) break;
                ((PNGEncodeParam.Palette)this.encodeParam).setBackgroundPaletteIndex(n3);
                break;
            }
            case 0: 
            case 4: {
                this.bkgdGreen = this.bkgdBlue = (n2 = pNGChunk.getInt2(0));
                this.bkgdRed = this.bkgdBlue;
                if (this.encodeParam == null) break;
                ((PNGEncodeParam.Gray)this.encodeParam).setBackgroundGray(n2);
                break;
            }
            case 2: 
            case 6: {
                this.bkgdRed = pNGChunk.getInt2(0);
                this.bkgdGreen = pNGChunk.getInt2(2);
                this.bkgdBlue = pNGChunk.getInt2(4);
                int[] nArray = new int[]{this.bkgdRed, this.bkgdGreen, this.bkgdBlue};
                if (this.encodeParam == null) break;
                ((PNGEncodeParam.RGB)this.encodeParam).setBackgroundRGB(nArray);
            }
        }
        n3 = 0;
        n2 = 0;
        int n4 = 0;
        if (this.bitDepth < 8) {
            n3 = this.expandBits[this.bitDepth][this.bkgdRed];
            n2 = this.expandBits[this.bitDepth][this.bkgdGreen];
            n4 = this.expandBits[this.bitDepth][this.bkgdBlue];
        } else if (this.bitDepth == 8) {
            n3 = this.bkgdRed;
            n2 = this.bkgdGreen;
            n4 = this.bkgdBlue;
        } else if (this.bitDepth == 16) {
            n3 = this.bkgdRed >> 8;
            n2 = this.bkgdGreen >> 8;
            n4 = this.bkgdBlue >> 8;
        }
        if (this.emitProperties) {
            this.properties.put("background_color", new Color(n3, n2, n4));
        }
    }

    private void parse_cHRM_chunk(PNGChunk pNGChunk) {
        if (this.sRGBRenderingIntent != -1) {
            return;
        }
        this.chromaticity = new float[8];
        this.chromaticity[0] = (float)pNGChunk.getInt4(0) / 100000.0f;
        this.chromaticity[1] = (float)pNGChunk.getInt4(4) / 100000.0f;
        this.chromaticity[2] = (float)pNGChunk.getInt4(8) / 100000.0f;
        this.chromaticity[3] = (float)pNGChunk.getInt4(12) / 100000.0f;
        this.chromaticity[4] = (float)pNGChunk.getInt4(16) / 100000.0f;
        this.chromaticity[5] = (float)pNGChunk.getInt4(20) / 100000.0f;
        this.chromaticity[6] = (float)pNGChunk.getInt4(24) / 100000.0f;
        this.chromaticity[7] = (float)pNGChunk.getInt4(28) / 100000.0f;
        if (this.encodeParam != null) {
            this.encodeParam.setChromaticity(this.chromaticity);
        }
        if (this.emitProperties) {
            this.properties.put("white_point_x", new Float(this.chromaticity[0]));
            this.properties.put("white_point_y", new Float(this.chromaticity[1]));
            this.properties.put("red_x", new Float(this.chromaticity[2]));
            this.properties.put("red_y", new Float(this.chromaticity[3]));
            this.properties.put("green_x", new Float(this.chromaticity[4]));
            this.properties.put("green_y", new Float(this.chromaticity[5]));
            this.properties.put("blue_x", new Float(this.chromaticity[6]));
            this.properties.put("blue_y", new Float(this.chromaticity[7]));
        }
    }

    private void parse_gAMA_chunk(PNGChunk pNGChunk) {
        float f2;
        if (this.sRGBRenderingIntent != -1) {
            return;
        }
        this.fileGamma = (float)pNGChunk.getInt4(0) / 100000.0f;
        float f3 = f2 = this.performGammaCorrection ? this.displayExponent / this.userExponent : 1.0f;
        if (this.encodeParam != null) {
            this.encodeParam.setGamma(this.fileGamma * f2);
        }
        if (this.emitProperties) {
            this.properties.put("gamma", new Float(this.fileGamma * f2));
        }
    }

    private void parse_hIST_chunk(PNGChunk pNGChunk) {
        if (this.redPalette == null) {
            String string = JaiI18N.getString("PNGImageDecoder18");
            throw new RuntimeException(string);
        }
        int n2 = this.redPalette.length;
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = pNGChunk.getInt2(2 * i2);
        }
        if (this.encodeParam != null) {
            this.encodeParam.setPaletteHistogram(nArray);
        }
    }

    private void parse_iCCP_chunk(PNGChunk pNGChunk) {
        byte by;
        String string = new String();
        int n2 = 0;
        while ((by = pNGChunk.getByte(n2++)) != 0) {
            string = string + (char)by;
        }
    }

    private void parse_pHYs_chunk(PNGChunk pNGChunk) {
        int n2 = pNGChunk.getInt4(0);
        int n3 = pNGChunk.getInt4(4);
        int n4 = pNGChunk.getInt1(8);
        if (this.encodeParam != null) {
            this.encodeParam.setPhysicalDimension(n2, n3, n4);
        }
        if (this.emitProperties) {
            this.properties.put("x_pixels_per_unit", new Integer(n2));
            this.properties.put("y_pixels_per_unit", new Integer(n3));
            this.properties.put("pixel_aspect_ratio", new Float((float)n2 / (float)n3));
            if (n4 == 1) {
                this.properties.put("pixel_units", "Meters");
            } else if (n4 != 0) {
                String string = JaiI18N.getString("PNGImageDecoder12");
                throw new RuntimeException(string);
            }
        }
    }

    private void parse_sBIT_chunk(PNGChunk pNGChunk) {
        this.significantBits = this.colorType == 3 ? new int[3] : new int[this.inputBands];
        for (int i2 = 0; i2 < this.significantBits.length; ++i2) {
            int n2;
            int n3 = pNGChunk.getByte(i2);
            int n4 = n2 = this.colorType == 3 ? 8 : this.bitDepth;
            if (n3 <= 0 || n3 > n2) {
                String string = JaiI18N.getString("PNGImageDecoder13");
                throw new RuntimeException(string);
            }
            this.significantBits[i2] = n3;
        }
        if (this.encodeParam != null) {
            this.encodeParam.setSignificantBits(this.significantBits);
        }
        if (this.emitProperties) {
            this.properties.put("significant_bits", this.significantBits);
        }
    }

    private void parse_sRGB_chunk(PNGChunk pNGChunk) {
        this.sRGBRenderingIntent = pNGChunk.getByte(0);
        this.fileGamma = 0.45455f;
        this.chromaticity = new float[8];
        this.chromaticity[0] = 3.127f;
        this.chromaticity[1] = 3.29f;
        this.chromaticity[2] = 6.4f;
        this.chromaticity[3] = 3.3f;
        this.chromaticity[4] = 3.0f;
        this.chromaticity[5] = 6.0f;
        this.chromaticity[6] = 1.5f;
        this.chromaticity[7] = 0.6f;
        if (this.performGammaCorrection) {
            float f2 = this.fileGamma * (this.displayExponent / this.userExponent);
            if (this.encodeParam != null) {
                this.encodeParam.setGamma(f2);
                this.encodeParam.setChromaticity(this.chromaticity);
            }
            if (this.emitProperties) {
                this.properties.put("gamma", new Float(f2));
                this.properties.put("white_point_x", new Float(this.chromaticity[0]));
                this.properties.put("white_point_y", new Float(this.chromaticity[1]));
                this.properties.put("red_x", new Float(this.chromaticity[2]));
                this.properties.put("red_y", new Float(this.chromaticity[3]));
                this.properties.put("green_x", new Float(this.chromaticity[4]));
                this.properties.put("green_y", new Float(this.chromaticity[5]));
                this.properties.put("blue_x", new Float(this.chromaticity[6]));
                this.properties.put("blue_y", new Float(this.chromaticity[7]));
            }
        }
    }

    private void parse_tEXt_chunk(PNGChunk pNGChunk) {
        byte by;
        String string = new String();
        String string2 = new String();
        int n2 = 0;
        while ((by = pNGChunk.getByte(n2++)) != 0) {
            string = string + (char)by;
        }
        for (int i2 = n2; i2 < pNGChunk.getLength(); ++i2) {
            string2 = string2 + (char)pNGChunk.getByte(i2);
        }
        this.textKeys.add(string);
        this.textStrings.add(string2);
    }

    private void parse_tIME_chunk(PNGChunk pNGChunk) {
        int n2 = pNGChunk.getInt2(0);
        int n3 = pNGChunk.getInt1(2) - 1;
        int n4 = pNGChunk.getInt1(3);
        int n5 = pNGChunk.getInt1(4);
        int n6 = pNGChunk.getInt1(5);
        int n7 = pNGChunk.getInt1(6);
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.set(n2, n3, n4, n5, n6, n7);
        Date date = gregorianCalendar.getTime();
        if (this.encodeParam != null) {
            this.encodeParam.setModificationTime(date);
        }
        if (this.emitProperties) {
            this.properties.put("timestamp", date);
        }
    }

    private void parse_tRNS_chunk(PNGChunk pNGChunk) {
        if (this.colorType == 3) {
            int n2;
            int n3 = pNGChunk.getLength();
            if (n3 > this.paletteEntries) {
                String string = JaiI18N.getString("PNGImageDecoder14");
                throw new RuntimeException(string);
            }
            this.alphaPalette = new byte[this.paletteEntries];
            for (n2 = 0; n2 < n3; ++n2) {
                this.alphaPalette[n2] = pNGChunk.getByte(n2);
            }
            for (n2 = n3; n2 < this.paletteEntries; ++n2) {
                this.alphaPalette[n2] = -1;
            }
            if (!this.suppressAlpha) {
                if (this.expandPalette) {
                    this.postProcess = 5;
                    this.outputBands = 4;
                } else {
                    this.outputHasAlphaPalette = true;
                }
            }
        } else if (this.colorType == 0) {
            this.grayTransparentAlpha = pNGChunk.getInt2(0);
            if (!this.suppressAlpha) {
                if (this.bitDepth < 8) {
                    this.output8BitGray = true;
                    this.maxOpacity = 255;
                    this.postProcess = 3;
                } else {
                    this.postProcess = 6;
                }
                if (this.expandGrayAlpha) {
                    this.outputBands = 4;
                    this.postProcess |= 0x10;
                } else {
                    this.outputBands = 2;
                }
                if (this.encodeParam != null) {
                    ((PNGEncodeParam.Gray)this.encodeParam).setTransparentGray(this.grayTransparentAlpha);
                }
            }
        } else if (this.colorType == 2) {
            this.redTransparentAlpha = pNGChunk.getInt2(0);
            this.greenTransparentAlpha = pNGChunk.getInt2(2);
            this.blueTransparentAlpha = pNGChunk.getInt2(4);
            if (!this.suppressAlpha) {
                this.outputBands = 4;
                this.postProcess = 7;
                if (this.encodeParam != null) {
                    int[] nArray = new int[]{this.redTransparentAlpha, this.greenTransparentAlpha, this.blueTransparentAlpha};
                    ((PNGEncodeParam.RGB)this.encodeParam).setTransparentRGB(nArray);
                }
            }
        } else if (this.colorType == 4 || this.colorType == 6) {
            String string = JaiI18N.getString("PNGImageDecoder15");
            throw new RuntimeException(string);
        }
    }

    private void parse_zTXt_chunk(PNGChunk pNGChunk) {
        byte by;
        String string = new String();
        String string2 = new String();
        int n2 = 0;
        while ((by = pNGChunk.getByte(n2++)) != 0) {
            string = string + (char)by;
        }
        byte by2 = pNGChunk.getByte(n2++);
        try {
            int n3;
            int n4 = pNGChunk.getLength() - n2;
            byte[] byArray = pNGChunk.getData();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n2, n4);
            InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
            while ((n3 = ((InputStream)inflaterInputStream).read()) != -1) {
                string2 = string2 + (char)n3;
            }
            this.ztextKeys.add(string);
            this.ztextStrings.add(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private WritableRaster createRaster(int n2, int n3, int n4, int n5, int n6) {
        WritableRaster writableRaster = null;
        Point point = new Point(0, 0);
        if (n6 < 8 && n4 == 1) {
            DataBufferByte dataBufferByte = new DataBufferByte(n3 * n5);
            writableRaster = Raster.createPackedRaster(dataBufferByte, n2, n3, n6, point);
        } else if (n6 <= 8) {
            DataBufferByte dataBufferByte = new DataBufferByte(n3 * n5);
            writableRaster = Raster.createInterleavedRaster(dataBufferByte, n2, n3, n5, n4, this.bandOffsets[n4], point);
        } else {
            DataBufferUShort dataBufferUShort = new DataBufferUShort(n3 * n5);
            writableRaster = Raster.createInterleavedRaster(dataBufferUShort, n2, n3, n5, n4, this.bandOffsets[n4], point);
        }
        return writableRaster;
    }

    private static void decodeSubFilter(byte[] byArray, int n2, int n3) {
        for (int i2 = n3; i2 < n2; ++i2) {
            int n4 = byArray[i2] & 0xFF;
            byArray[i2] = (byte)(n4 += byArray[i2 - n3] & 0xFF);
        }
    }

    private static void decodeUpFilter(byte[] byArray, byte[] byArray2, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = byArray[i2] & 0xFF;
            int n4 = byArray2[i2] & 0xFF;
            byArray[i2] = (byte)(n3 + n4);
        }
    }

    private static void decodeAverageFilter(byte[] byArray, byte[] byArray2, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        for (n6 = 0; n6 < n3; ++n6) {
            n5 = byArray[n6] & 0xFF;
            n4 = byArray2[n6] & 0xFF;
            byArray[n6] = (byte)(n5 + n4 / 2);
        }
        for (n6 = n3; n6 < n2; ++n6) {
            n5 = byArray[n6] & 0xFF;
            int n7 = byArray[n6 - n3] & 0xFF;
            n4 = byArray2[n6] & 0xFF;
            byArray[n6] = (byte)(n5 + (n7 + n4) / 2);
        }
    }

    private static int paethPredictor(int n2, int n3, int n4) {
        int n5 = n2 + n3 - n4;
        int n6 = Math.abs(n5 - n2);
        int n7 = Math.abs(n5 - n3);
        int n8 = Math.abs(n5 - n4);
        if (n6 <= n7 && n6 <= n8) {
            return n2;
        }
        if (n7 <= n8) {
            return n3;
        }
        return n4;
    }

    private static void decodePaethFilter(byte[] byArray, byte[] byArray2, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        for (n6 = 0; n6 < n3; ++n6) {
            n5 = byArray[n6] & 0xFF;
            n4 = byArray2[n6] & 0xFF;
            byArray[n6] = (byte)(n5 + n4);
        }
        for (n6 = n3; n6 < n2; ++n6) {
            n5 = byArray[n6] & 0xFF;
            int n7 = byArray[n6 - n3] & 0xFF;
            n4 = byArray2[n6] & 0xFF;
            int n8 = byArray2[n6 - n3] & 0xFF;
            byArray[n6] = (byte)(n5 + PNGImage.paethPredictor(n7, n4, n8));
        }
    }

    private void processPixels(int n2, Raster raster, WritableRaster writableRaster, int n3, int n4, int n5, int n6) {
        int[] nArray = raster.getPixel(0, 0, (int[])null);
        int[] nArray2 = writableRaster.getPixel(0, 0, (int[])null);
        int n7 = n3;
        switch (n2) {
            case 0: {
                for (int i2 = 0; i2 < n6; ++i2) {
                    raster.getPixel(i2, 0, nArray);
                    writableRaster.setPixel(n7, n5, nArray);
                    n7 += n4;
                }
                break;
            }
            case 1: {
                for (int i3 = 0; i3 < n6; ++i3) {
                    raster.getPixel(i3, 0, nArray);
                    for (int i4 = 0; i4 < this.inputBands; ++i4) {
                        int n8 = nArray[i4];
                        nArray[i4] = this.gammaLut[n8];
                    }
                    writableRaster.setPixel(n7, n5, nArray);
                    n7 += n4;
                }
                break;
            }
            case 2: {
                for (int i5 = 0; i5 < n6; ++i5) {
                    raster.getPixel(i5, 0, nArray);
                    nArray2[0] = this.grayLut[nArray[0]];
                    writableRaster.setPixel(n7, n5, nArray2);
                    n7 += n4;
                }
                break;
            }
            case 3: {
                for (int i6 = 0; i6 < n6; ++i6) {
                    raster.getPixel(i6, 0, nArray);
                    int n9 = nArray[0];
                    nArray2[0] = this.grayLut[n9];
                    nArray2[1] = n9 == this.grayTransparentAlpha ? 0 : this.maxOpacity;
                    writableRaster.setPixel(n7, n5, nArray2);
                    n7 += n4;
                }
                break;
            }
            case 4: {
                for (int i7 = 0; i7 < n6; ++i7) {
                    raster.getPixel(i7, 0, nArray);
                    int n10 = nArray[0];
                    nArray2[0] = this.redPalette[n10];
                    nArray2[1] = this.greenPalette[n10];
                    nArray2[2] = this.bluePalette[n10];
                    writableRaster.setPixel(n7, n5, nArray2);
                    n7 += n4;
                }
                break;
            }
            case 5: {
                for (int i8 = 0; i8 < n6; ++i8) {
                    raster.getPixel(i8, 0, nArray);
                    int n11 = nArray[0];
                    nArray2[0] = this.redPalette[n11];
                    nArray2[1] = this.greenPalette[n11];
                    nArray2[2] = this.bluePalette[n11];
                    nArray2[3] = this.alphaPalette[n11];
                    writableRaster.setPixel(n7, n5, nArray2);
                    n7 += n4;
                }
                break;
            }
            case 6: {
                for (int i9 = 0; i9 < n6; ++i9) {
                    raster.getPixel(i9, 0, nArray);
                    int n12 = nArray[0];
                    if (this.performGammaCorrection) {
                        n12 = this.gammaLut[n12];
                    }
                    nArray2[0] = n12;
                    nArray2[1] = n12 == this.grayTransparentAlpha ? 0 : this.maxOpacity;
                    writableRaster.setPixel(n7, n5, nArray2);
                    n7 += n4;
                }
                break;
            }
            case 7: {
                for (int i10 = 0; i10 < n6; ++i10) {
                    raster.getPixel(i10, 0, nArray);
                    int n13 = nArray[0];
                    int n14 = nArray[1];
                    int n15 = nArray[2];
                    if (this.performGammaCorrection) {
                        nArray2[0] = this.gammaLut[n13];
                        nArray2[1] = this.gammaLut[n14];
                        nArray2[2] = this.gammaLut[n15];
                    } else {
                        nArray2[0] = n13;
                        nArray2[1] = n14;
                        nArray2[2] = n15;
                    }
                    nArray2[3] = n13 == this.redTransparentAlpha && n14 == this.greenTransparentAlpha && n15 == this.blueTransparentAlpha ? 0 : this.maxOpacity;
                    writableRaster.setPixel(n7, n5, nArray2);
                    n7 += n4;
                }
                break;
            }
            case 8: {
                for (int i11 = 0; i11 < n6; ++i11) {
                    raster.getPixel(i11, 0, nArray);
                    int n16 = nArray[0];
                    nArray2[0] = this.performGammaCorrection ? this.gammaLut[n16] : n16;
                    writableRaster.setPixel(n7, n5, nArray2);
                    n7 += n4;
                }
                break;
            }
            case 9: {
                for (int i12 = 0; i12 < n6; ++i12) {
                    raster.getPixel(i12, 0, nArray);
                    int n17 = nArray[0];
                    int n18 = nArray[1];
                    int n19 = nArray[2];
                    if (this.performGammaCorrection) {
                        nArray2[0] = this.gammaLut[n17];
                        nArray2[1] = this.gammaLut[n18];
                        nArray2[2] = this.gammaLut[n19];
                    } else {
                        nArray2[0] = n17;
                        nArray2[1] = n18;
                        nArray2[2] = n19;
                    }
                    writableRaster.setPixel(n7, n5, nArray2);
                    n7 += n4;
                }
                break;
            }
            case 17: {
                for (int i13 = 0; i13 < n6; ++i13) {
                    int n20;
                    raster.getPixel(i13, 0, nArray);
                    int n21 = nArray[0];
                    int n22 = nArray[1];
                    nArray2[0] = n20 = this.gammaLut[n21];
                    nArray2[1] = n20;
                    nArray2[2] = n20;
                    nArray2[3] = n22;
                    writableRaster.setPixel(n7, n5, nArray2);
                    n7 += n4;
                }
                break;
            }
            case 16: {
                for (int i14 = 0; i14 < n6; ++i14) {
                    raster.getPixel(i14, 0, nArray);
                    int n23 = nArray[0];
                    int n24 = nArray[1];
                    nArray2[0] = n23;
                    nArray2[1] = n23;
                    nArray2[2] = n23;
                    nArray2[3] = n24;
                    writableRaster.setPixel(n7, n5, nArray2);
                    n7 += n4;
                }
                break;
            }
            case 22: {
                for (int i15 = 0; i15 < n6; ++i15) {
                    raster.getPixel(i15, 0, nArray);
                    int n25 = nArray[0];
                    if (this.performGammaCorrection) {
                        n25 = this.gammaLut[n25];
                    }
                    nArray2[0] = n25;
                    nArray2[1] = n25;
                    nArray2[2] = n25;
                    nArray2[3] = n25 == this.grayTransparentAlpha ? 0 : this.maxOpacity;
                    writableRaster.setPixel(n7, n5, nArray2);
                    n7 += n4;
                }
                break;
            }
            case 19: {
                for (int i16 = 0; i16 < n6; ++i16) {
                    int n26;
                    raster.getPixel(i16, 0, nArray);
                    int n27 = nArray[0];
                    nArray2[0] = n26 = this.grayLut[n27];
                    nArray2[1] = n26;
                    nArray2[2] = n26;
                    nArray2[3] = n27 == this.grayTransparentAlpha ? 0 : this.maxOpacity;
                    writableRaster.setPixel(n7, n5, nArray2);
                    n7 += n4;
                }
                break;
            }
        }
    }

    private void decodePass(WritableRaster writableRaster, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n6 == 0 || n7 == 0) {
            return;
        }
        int n8 = (this.inputBands * n6 * this.bitDepth + 7) / 8;
        int n9 = this.bitDepth == 16 ? n8 / 2 : n8;
        Object object = new byte[n8];
        byte[] byArray = new byte[n8];
        WritableRaster writableRaster2 = this.createRaster(n6, 1, this.inputBands, n9, this.bitDepth);
        DataBuffer dataBuffer = writableRaster2.getDataBuffer();
        int n10 = dataBuffer.getDataType();
        byte[] byArray2 = null;
        short[] sArray = null;
        if (n10 == 0) {
            byArray2 = ((DataBufferByte)dataBuffer).getData();
        } else {
            sArray = ((DataBufferUShort)dataBuffer).getData();
        }
        int n11 = 0;
        int n12 = n3;
        while (n11 < n7) {
            Object object2;
            int n13 = 0;
            try {
                n13 = this.dataStream.read();
                this.dataStream.readFully((byte[])object, 0, n8);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            switch (n13) {
                case 0: {
                    break;
                }
                case 1: {
                    PNGImage.decodeSubFilter(object, n8, this.bytesPerPixel);
                    break;
                }
                case 2: {
                    PNGImage.decodeUpFilter(object, byArray, n8);
                    break;
                }
                case 3: {
                    PNGImage.decodeAverageFilter(object, byArray, n8, this.bytesPerPixel);
                    break;
                }
                case 4: {
                    PNGImage.decodePaethFilter(object, byArray, n8, this.bytesPerPixel);
                    break;
                }
                default: {
                    object2 = JaiI18N.getString("PNGImageDecoder16");
                    throw new RuntimeException((String)object2);
                }
            }
            if (this.bitDepth < 16) {
                System.arraycopy(object, 0, byArray2, 0, n8);
            } else {
                int n14 = 0;
                for (int i2 = 0; i2 < n9; ++i2) {
                    sArray[i2] = (short)(object[n14] << 8 | object[n14 + 1] & 0xFF);
                    n14 += 2;
                }
            }
            this.processPixels(this.postProcess, writableRaster2, writableRaster, n2, n4, n12, n6);
            object2 = byArray;
            byArray = object;
            object = object2;
            ++n11;
            n12 += n5;
        }
    }

    private void decodeImage(boolean bl) {
        if (!bl) {
            this.decodePass(this.theTile, 0, 0, 1, 1, this.width, this.height);
        } else {
            this.decodePass(this.theTile, 0, 0, 8, 8, (this.width + 7) / 8, (this.height + 7) / 8);
            this.decodePass(this.theTile, 4, 0, 8, 8, (this.width + 3) / 8, (this.height + 7) / 8);
            this.decodePass(this.theTile, 0, 4, 4, 8, (this.width + 3) / 4, (this.height + 3) / 8);
            this.decodePass(this.theTile, 2, 0, 4, 4, (this.width + 1) / 4, (this.height + 3) / 4);
            this.decodePass(this.theTile, 0, 2, 2, 4, (this.width + 1) / 2, (this.height + 1) / 4);
            this.decodePass(this.theTile, 1, 0, 2, 2, this.width / 2, (this.height + 1) / 2);
            this.decodePass(this.theTile, 0, 1, 1, 2, this.width, this.height / 2);
        }
    }

    public Raster getTile(int n2, int n3) {
        if (n2 != 0 || n3 != 0) {
            String string = JaiI18N.getString("PNGImageDecoder17");
            throw new IllegalArgumentException(string);
        }
        return this.theTile;
    }
}

