/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.JAI;

import com.fr.third.JAI.ImageEncodeParam;
import com.fr.third.JAI.JaiI18N;
import com.fr.third.JAI.PNGSuggestedPaletteEntry;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Date;
import java.util.Vector;

public abstract class PNGEncodeParam
implements ImageEncodeParam {
    public static final int INTENT_PERCEPTUAL = 0;
    public static final int INTENT_RELATIVE = 1;
    public static final int INTENT_SATURATION = 2;
    public static final int INTENT_ABSOLUTE = 3;
    public static final int PNG_FILTER_NONE = 0;
    public static final int PNG_FILTER_SUB = 1;
    public static final int PNG_FILTER_UP = 2;
    public static final int PNG_FILTER_AVERAGE = 3;
    public static final int PNG_FILTER_PAETH = 4;
    protected int bitDepth;
    protected boolean bitDepthSet = false;
    private boolean useInterlacing = false;
    private float[] chromaticity = null;
    private boolean chromaticitySet = false;
    private float gamma;
    private boolean gammaSet = false;
    private int[] paletteHistogram = null;
    private boolean paletteHistogramSet = false;
    private byte[] ICCProfileData = null;
    private boolean ICCProfileDataSet = false;
    private int[] physicalDimension = null;
    private boolean physicalDimensionSet = false;
    private PNGSuggestedPaletteEntry[] suggestedPalette = null;
    private boolean suggestedPaletteSet = false;
    private int[] significantBits = null;
    private boolean significantBitsSet = false;
    private int SRGBIntent;
    private boolean SRGBIntentSet = false;
    private String[] text = null;
    private boolean textSet = false;
    private Date modificationTime;
    private boolean modificationTimeSet = false;
    boolean transparencySet = false;
    private String[] zText = null;
    private boolean zTextSet = false;
    Vector chunkType = new Vector();
    Vector chunkData = new Vector();

    public static PNGEncodeParam getDefaultEncodeParam(RenderedImage renderedImage) {
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            return new Palette();
        }
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n2 = sampleModel.getNumBands();
        if (n2 == 1 || n2 == 2) {
            return new Gray();
        }
        return new RGB();
    }

    public abstract void setBitDepth(int var1);

    public int getBitDepth() {
        if (!this.bitDepthSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam11"));
        }
        return this.bitDepth;
    }

    public void unsetBitDepth() {
        this.bitDepthSet = false;
    }

    public void setInterlacing(boolean bl) {
        this.useInterlacing = bl;
    }

    public boolean getInterlacing() {
        return this.useInterlacing;
    }

    public void unsetBackground() {
        throw new RuntimeException(JaiI18N.getString("PNGEncodeParam23"));
    }

    public boolean isBackgroundSet() {
        throw new RuntimeException(JaiI18N.getString("PNGEncodeParam24"));
    }

    public void setChromaticity(float[] fArray) {
        if (fArray.length != 8) {
            throw new IllegalArgumentException();
        }
        this.chromaticity = (float[])fArray.clone();
        this.chromaticitySet = true;
    }

    public void setChromaticity(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float[] fArray = new float[]{f2, f3, f4, f5, f6, f7, f8, f9};
        this.setChromaticity(fArray);
    }

    public float[] getChromaticity() {
        if (!this.chromaticitySet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam12"));
        }
        return (float[])this.chromaticity.clone();
    }

    public void unsetChromaticity() {
        this.chromaticity = null;
        this.chromaticitySet = false;
    }

    public boolean isChromaticitySet() {
        return this.chromaticitySet;
    }

    public void setGamma(float f2) {
        this.gamma = f2;
        this.gammaSet = true;
    }

    public float getGamma() {
        if (!this.gammaSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam13"));
        }
        return this.gamma;
    }

    public void unsetGamma() {
        this.gammaSet = false;
    }

    public boolean isGammaSet() {
        return this.gammaSet;
    }

    public void setPaletteHistogram(int[] nArray) {
        this.paletteHistogram = (int[])nArray.clone();
        this.paletteHistogramSet = true;
    }

    public int[] getPaletteHistogram() {
        if (!this.paletteHistogramSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam14"));
        }
        return this.paletteHistogram;
    }

    public void unsetPaletteHistogram() {
        this.paletteHistogram = null;
        this.paletteHistogramSet = false;
    }

    public boolean isPaletteHistogramSet() {
        return this.paletteHistogramSet;
    }

    public void setICCProfileData(byte[] byArray) {
        this.ICCProfileData = (byte[])byArray.clone();
        this.ICCProfileDataSet = true;
    }

    public byte[] getICCProfileData() {
        if (!this.ICCProfileDataSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam15"));
        }
        return (byte[])this.ICCProfileData.clone();
    }

    public void unsetICCProfileData() {
        this.ICCProfileData = null;
        this.ICCProfileDataSet = false;
    }

    public boolean isICCProfileDataSet() {
        return this.ICCProfileDataSet;
    }

    public void setPhysicalDimension(int[] nArray) {
        this.physicalDimension = (int[])nArray.clone();
        this.physicalDimensionSet = true;
    }

    public void setPhysicalDimension(int n2, int n3, int n4) {
        int[] nArray = new int[]{n2, n3, n4};
        this.setPhysicalDimension(nArray);
    }

    public int[] getPhysicalDimension() {
        if (!this.physicalDimensionSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam16"));
        }
        return (int[])this.physicalDimension.clone();
    }

    public void unsetPhysicalDimension() {
        this.physicalDimension = null;
        this.physicalDimensionSet = false;
    }

    public boolean isPhysicalDimensionSet() {
        return this.physicalDimensionSet;
    }

    public void setSuggestedPalette(PNGSuggestedPaletteEntry[] pNGSuggestedPaletteEntryArray) {
        this.suggestedPalette = (PNGSuggestedPaletteEntry[])pNGSuggestedPaletteEntryArray.clone();
        this.suggestedPaletteSet = true;
    }

    public PNGSuggestedPaletteEntry[] getSuggestedPalette() {
        if (!this.suggestedPaletteSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam17"));
        }
        return (PNGSuggestedPaletteEntry[])this.suggestedPalette.clone();
    }

    public void unsetSuggestedPalette() {
        this.suggestedPalette = null;
        this.suggestedPaletteSet = false;
    }

    public boolean isSuggestedPaletteSet() {
        return this.suggestedPaletteSet;
    }

    public void setSignificantBits(int[] nArray) {
        this.significantBits = (int[])nArray.clone();
        this.significantBitsSet = true;
    }

    public int[] getSignificantBits() {
        if (!this.significantBitsSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam18"));
        }
        return (int[])this.significantBits.clone();
    }

    public void unsetSignificantBits() {
        this.significantBits = null;
        this.significantBitsSet = false;
    }

    public boolean isSignificantBitsSet() {
        return this.significantBitsSet;
    }

    public void setSRGBIntent(int n2) {
        this.SRGBIntent = n2;
        this.SRGBIntentSet = true;
    }

    public int getSRGBIntent() {
        if (!this.SRGBIntentSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam19"));
        }
        return this.SRGBIntent;
    }

    public void unsetSRGBIntent() {
        this.SRGBIntentSet = false;
    }

    public boolean isSRGBIntentSet() {
        return this.SRGBIntentSet;
    }

    public void setText(String[] stringArray) {
        this.text = stringArray;
        this.textSet = true;
    }

    public String[] getText() {
        if (!this.textSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam20"));
        }
        return this.text;
    }

    public void unsetText() {
        this.text = null;
        this.textSet = false;
    }

    public boolean isTextSet() {
        return this.textSet;
    }

    public void setModificationTime(Date date) {
        this.modificationTime = date;
        this.modificationTimeSet = true;
    }

    public Date getModificationTime() {
        if (!this.modificationTimeSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam21"));
        }
        return this.modificationTime;
    }

    public void unsetModificationTime() {
        this.modificationTime = null;
        this.modificationTimeSet = false;
    }

    public boolean isModificationTimeSet() {
        return this.modificationTimeSet;
    }

    public void unsetTransparency() {
        this.transparencySet = false;
    }

    public boolean isTransparencySet() {
        return this.transparencySet;
    }

    public void setCompressedText(String[] stringArray) {
        this.zText = stringArray;
        this.zTextSet = true;
    }

    public String[] getCompressedText() {
        if (!this.zTextSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam22"));
        }
        return this.zText;
    }

    public void unsetCompressedText() {
        this.zText = null;
        this.zTextSet = false;
    }

    public boolean isCompressedTextSet() {
        return this.zTextSet;
    }

    public synchronized void addPrivateChunk(String string, byte[] byArray) {
        this.chunkType.add(string);
        this.chunkData.add((byte[])byArray.clone());
    }

    public synchronized int getNumPrivateChunks() {
        return this.chunkType.size();
    }

    public synchronized String getPrivateChunkType(int n2) {
        return (String)this.chunkType.elementAt(n2);
    }

    public synchronized byte[] getPrivateChunkData(int n2) {
        return (byte[])this.chunkData.elementAt(n2);
    }

    public synchronized void removeUnsafeToCopyPrivateChunks() {
        Vector<String> vector = new Vector<String>();
        Vector<byte[]> vector2 = new Vector<byte[]>();
        int n2 = this.getNumPrivateChunks();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = this.getPrivateChunkType(i2);
            char c2 = string.charAt(3);
            if (c2 < 'a' || c2 > 'z') continue;
            vector.add(string);
            vector2.add(this.getPrivateChunkData(i2));
        }
        this.chunkType = vector;
        this.chunkData = vector2;
    }

    public synchronized void removeAllPrivateChunks() {
        this.chunkType = new Vector();
        this.chunkData = new Vector();
    }

    private static final int abs(int n2) {
        return n2 < 0 ? -n2 : n2;
    }

    public static final int paethPredictor(int n2, int n3, int n4) {
        int n5 = n2 + n3 - n4;
        int n6 = PNGEncodeParam.abs(n5 - n2);
        int n7 = PNGEncodeParam.abs(n5 - n3);
        int n8 = PNGEncodeParam.abs(n5 - n4);
        if (n6 <= n7 && n6 <= n8) {
            return n2;
        }
        if (n7 <= n8) {
            return n3;
        }
        return n4;
    }

    public int filterRow(byte[] byArray, byte[] byArray2, byte[][] byArray3, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int[] nArray = new int[5];
        for (n10 = 0; n10 < 5; ++n10) {
            nArray[n10] = Integer.MAX_VALUE;
        }
        n10 = 0;
        for (n9 = n3; n9 < n2 + n3; ++n9) {
            n8 = byArray[n9] & 0xFF;
            n10 += n8;
        }
        nArray[0] = n10;
        byte[] byArray4 = byArray3[1];
        n9 = 0;
        for (n8 = n3; n8 < n2 + n3; ++n8) {
            n7 = byArray[n8] & 0xFF;
            n6 = byArray[n8 - n3] & 0xFF;
            n5 = n7 - n6;
            byArray4[n8] = (byte)n5;
            n9 += PNGEncodeParam.abs(n5);
        }
        nArray[1] = n9;
        byArray4 = byArray3[2];
        n9 = 0;
        for (n8 = n3; n8 < n2 + n3; ++n8) {
            n7 = byArray[n8] & 0xFF;
            n6 = byArray2[n8] & 0xFF;
            n5 = n7 - n6;
            byArray4[n8] = (byte)n5;
            n9 += PNGEncodeParam.abs(n5);
        }
        nArray[2] = n9;
        byArray4 = byArray3[3];
        n9 = 0;
        for (n8 = n3; n8 < n2 + n3; ++n8) {
            n7 = byArray[n8] & 0xFF;
            n6 = byArray[n8 - n3] & 0xFF;
            n5 = byArray2[n8] & 0xFF;
            n4 = n7 - (n6 + n5) / 2;
            byArray4[n8] = (byte)n4;
            n9 += PNGEncodeParam.abs(n4);
        }
        nArray[3] = n9;
        byArray4 = byArray3[4];
        n9 = 0;
        for (n8 = n3; n8 < n2 + n3; ++n8) {
            n7 = byArray[n8] & 0xFF;
            n6 = byArray[n8 - n3] & 0xFF;
            n5 = byArray2[n8] & 0xFF;
            n4 = byArray2[n8 - n3] & 0xFF;
            int n11 = PNGEncodeParam.paethPredictor(n6, n5, n4);
            int n12 = n7 - n11;
            byArray4[n8] = (byte)n12;
            n9 += PNGEncodeParam.abs(n12);
        }
        nArray[4] = n9;
        int n13 = 0;
        n9 = nArray[0];
        for (n8 = 1; n8 < 5; ++n8) {
            if (nArray[n8] >= n9) continue;
            n9 = nArray[n8];
            n13 = n8;
        }
        if (n13 == 0) {
            System.arraycopy(byArray, n3, byArray3[0], n3, n2);
        }
        return n13;
    }

    public static class RGB
    extends PNGEncodeParam {
        private boolean backgroundSet = false;
        private int[] backgroundRGB;
        private int[] transparency;

        public void unsetBackground() {
            this.backgroundSet = false;
        }

        public boolean isBackgroundSet() {
            return this.backgroundSet;
        }

        public void setBitDepth(int n2) {
            if (n2 != 8 && n2 != 16) {
                throw new RuntimeException();
            }
            this.bitDepth = n2;
            this.bitDepthSet = true;
        }

        public void setBackgroundRGB(int[] nArray) {
            if (nArray.length != 3) {
                throw new RuntimeException();
            }
            this.backgroundRGB = nArray;
            this.backgroundSet = true;
        }

        public int[] getBackgroundRGB() {
            if (!this.backgroundSet) {
                throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam9"));
            }
            return this.backgroundRGB;
        }

        public void setTransparentRGB(int[] nArray) {
            this.transparency = (int[])nArray.clone();
            this.transparencySet = true;
        }

        public int[] getTransparentRGB() {
            if (!this.transparencySet) {
                throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam10"));
            }
            return (int[])this.transparency.clone();
        }
    }

    public static class Gray
    extends PNGEncodeParam {
        private boolean backgroundSet = false;
        private int backgroundPaletteGray;
        private int[] transparency;
        private int bitShift;
        private boolean bitShiftSet = false;

        public void unsetBackground() {
            this.backgroundSet = false;
        }

        public boolean isBackgroundSet() {
            return this.backgroundSet;
        }

        public void setBitDepth(int n2) {
            if (n2 != 1 && n2 != 2 && n2 != 4 && n2 != 8 && n2 != 16) {
                throw new IllegalArgumentException();
            }
            this.bitDepth = n2;
            this.bitDepthSet = true;
        }

        public void setBackgroundGray(int n2) {
            this.backgroundPaletteGray = n2;
            this.backgroundSet = true;
        }

        public int getBackgroundGray() {
            if (!this.backgroundSet) {
                throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam6"));
            }
            return this.backgroundPaletteGray;
        }

        public void setTransparentGray(int n2) {
            this.transparency = new int[1];
            this.transparency[0] = n2;
            this.transparencySet = true;
        }

        public int getTransparentGray() {
            if (!this.transparencySet) {
                throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam7"));
            }
            int n2 = this.transparency[0];
            return n2;
        }

        public void setBitShift(int n2) {
            if (n2 < 0) {
                throw new RuntimeException();
            }
            this.bitShift = n2;
            this.bitShiftSet = true;
        }

        public int getBitShift() {
            if (!this.bitShiftSet) {
                throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam8"));
            }
            return this.bitShift;
        }

        public void unsetBitShift() {
            this.bitShiftSet = false;
        }

        public boolean isBitShiftSet() {
            return this.bitShiftSet;
        }

        public boolean isBitDepthSet() {
            return this.bitDepthSet;
        }
    }

    public static class Palette
    extends PNGEncodeParam {
        private boolean backgroundSet = false;
        private int[] palette = null;
        private boolean paletteSet = false;
        private int backgroundPaletteIndex;
        private int[] transparency;

        public void unsetBackground() {
            this.backgroundSet = false;
        }

        public boolean isBackgroundSet() {
            return this.backgroundSet;
        }

        public void setBitDepth(int n2) {
            if (n2 != 1 && n2 != 2 && n2 != 4 && n2 != 8) {
                throw new IllegalArgumentException(JaiI18N.getString("PNGEncodeParam2"));
            }
            this.bitDepth = n2;
            this.bitDepthSet = true;
        }

        public void setPalette(int[] nArray) {
            if (nArray.length < 3 || nArray.length > 768) {
                throw new IllegalArgumentException(JaiI18N.getString("PNGEncodeParam0"));
            }
            if (nArray.length % 3 != 0) {
                throw new IllegalArgumentException(JaiI18N.getString("PNGEncodeParam1"));
            }
            this.palette = (int[])nArray.clone();
            this.paletteSet = true;
        }

        public int[] getPalette() {
            if (!this.paletteSet) {
                throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam3"));
            }
            return (int[])this.palette.clone();
        }

        public void unsetPalette() {
            this.palette = null;
            this.paletteSet = false;
        }

        public boolean isPaletteSet() {
            return this.paletteSet;
        }

        public void setBackgroundPaletteIndex(int n2) {
            this.backgroundPaletteIndex = n2;
            this.backgroundSet = true;
        }

        public int getBackgroundPaletteIndex() {
            if (!this.backgroundSet) {
                throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam4"));
            }
            return this.backgroundPaletteIndex;
        }

        public void setPaletteTransparency(byte[] byArray) {
            this.transparency = new int[byArray.length];
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                this.transparency[i2] = byArray[i2] & 0xFF;
            }
            this.transparencySet = true;
        }

        public byte[] getPaletteTransparency() {
            if (!this.transparencySet) {
                throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam5"));
            }
            byte[] byArray = new byte[this.transparency.length];
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                byArray[i2] = (byte)this.transparency[i2];
            }
            return byArray;
        }
    }
}

