/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.JAI;

import com.fr.third.JAI.JaiI18N;
import com.fr.third.JAI.SeekableStream;
import com.fr.third.JAI.SimpleRenderedImage;
import java.awt.Point;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Arrays;

class GIFImage
extends SimpleRenderedImage {
    private static final int[] INTERLACE_INCREMENT = new int[]{8, 8, 4, 2, -1};
    private static final int[] INTERLACE_OFFSET = new int[]{0, 4, 2, 1, -1};
    private SeekableStream input;
    private boolean interlaceFlag;
    private byte[] block;
    private int blockLength;
    private int bitPos;
    private int nextByte;
    private int initCodeSize;
    private int clearCode;
    private int eofCode;
    private int next32Bits;
    private boolean lastBlockFound;
    private int interlacePass;
    private WritableRaster theTile;

    private void skipBlocks() throws IOException {
        int n2;
        while ((n2 = this.input.readUnsignedByte()) != 0) {
            this.input.skipBytes(n2);
        }
    }

    GIFImage(SeekableStream seekableStream, byte[] byArray) throws IOException {
        int n2;
        int n3;
        int n4;
        boolean bl;
        byte[] byArray2;
        block13: {
            this.interlaceFlag = false;
            this.block = new byte[255];
            this.blockLength = 0;
            this.bitPos = 0;
            this.nextByte = 0;
            this.next32Bits = 0;
            this.lastBlockFound = false;
            this.interlacePass = 0;
            this.theTile = null;
            this.input = seekableStream;
            byArray2 = null;
            bl = false;
            n4 = 0;
            try {
                long l2 = seekableStream.getFilePointer();
                while (true) {
                    int n5;
                    if ((n3 = seekableStream.readUnsignedByte()) == 44) {
                        seekableStream.skipBytes(4);
                        this.width = seekableStream.readUnsignedShortLE();
                        this.height = seekableStream.readUnsignedShortLE();
                        n2 = seekableStream.readUnsignedByte();
                        n5 = (n2 & 0x80) != 0 ? 1 : 0;
                        this.interlaceFlag = (n2 & 0x40) != 0;
                        int n6 = 1 << (n2 & 7) + 1;
                        if (n5 != 0) {
                            byArray2 = new byte[3 * n6];
                            seekableStream.readFully(byArray2);
                        } else {
                            byArray2 = null;
                        }
                        break block13;
                    }
                    if (n3 != 33) break;
                    n2 = seekableStream.readUnsignedByte();
                    if (n2 == 249) {
                        seekableStream.read();
                        n5 = seekableStream.readUnsignedByte();
                        bl = (n5 & 1) != 0;
                        seekableStream.skipBytes(2);
                        n4 = seekableStream.readUnsignedByte();
                        seekableStream.read();
                        continue;
                    }
                    if (n2 == 1) {
                        seekableStream.skipBytes(13);
                        this.skipBlocks();
                        continue;
                    }
                    if (n2 == 254) {
                        this.skipBlocks();
                        continue;
                    }
                    if (n2 == 255) {
                        seekableStream.skipBytes(12);
                        this.skipBlocks();
                        continue;
                    }
                    n5 = 0;
                    do {
                        n5 = seekableStream.readUnsignedByte();
                        seekableStream.skipBytes(n5);
                    } while (n5 > 0);
                }
                throw new IOException(JaiI18N.getString("GIFImage0") + " " + n3 + "!");
            }
            catch (IOException iOException) {
                throw new IOException(JaiI18N.getString("GIFImage1"));
            }
        }
        this.tileGridYOffset = 0;
        this.tileGridXOffset = 0;
        this.minY = 0;
        this.minX = 0;
        this.tileWidth = this.width;
        this.tileHeight = this.height;
        byte[] byArray3 = byArray2 != null ? byArray2 : byArray;
        int n7 = byArray3.length / 3;
        n3 = n7 == 2 ? 1 : (n7 == 4 ? 2 : (n7 == 8 || n7 == 16 ? 4 : 8));
        n2 = 1 << n3;
        byte[] byArray4 = new byte[n2];
        byte[] byArray5 = new byte[n2];
        byte[] byArray6 = new byte[n2];
        int n8 = 0;
        for (int i2 = 0; i2 < n7; ++i2) {
            byArray4[i2] = byArray3[n8++];
            byArray5[i2] = byArray3[n8++];
            byArray6[i2] = byArray3[n8++];
        }
        byte[] byArray7 = null;
        if (bl) {
            byArray7 = new byte[n2];
            Arrays.fill(byArray7, (byte)-1);
            int n9 = Math.min(n4, n2 - 1);
            byArray7[n9] = 0;
        }
        int[] nArray = new int[]{n3};
        this.colorModel = byArray7 == null ? new IndexColorModel(n3, byArray4.length, byArray4, byArray5, byArray6) : new IndexColorModel(n3, byArray4.length, byArray4, byArray5, byArray6, byArray7);
        this.sampleModel = new PixelInterleavedSampleModel(0, this.width, this.height, 1, this.width, new int[]{0});
    }

    private void initNext32Bits() {
        this.next32Bits = this.block[0] & 0xFF;
        this.next32Bits |= (this.block[1] & 0xFF) << 8;
        this.next32Bits |= (this.block[2] & 0xFF) << 16;
        this.next32Bits |= this.block[3] << 24;
        this.nextByte = 4;
    }

    private int getCode(int n2, int n3) throws IOException {
        if (this.bitPos + n2 > 32) {
            return this.eofCode;
        }
        int n4 = this.next32Bits >> this.bitPos & n3;
        this.bitPos += n2;
        while (this.bitPos >= 8 && !this.lastBlockFound) {
            this.next32Bits >>>= 8;
            this.bitPos -= 8;
            if (this.nextByte >= this.blockLength) {
                int n5;
                this.blockLength = this.input.readUnsignedByte();
                if (this.blockLength == 0) {
                    this.lastBlockFound = true;
                    return n4;
                }
                int n6 = 0;
                for (int i2 = this.blockLength; i2 > 0; i2 -= n5) {
                    n5 = this.input.read(this.block, n6, i2);
                    n6 += n5;
                }
                this.nextByte = 0;
            }
            this.next32Bits |= this.block[this.nextByte++] << 24;
        }
        return n4;
    }

    private void initializeStringTable(int[] nArray, byte[] byArray, byte[] byArray2, int[] nArray2) {
        int n2;
        int n3 = 1 << this.initCodeSize;
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = -1;
            byArray[n2] = (byte)n2;
            byArray2[n2] = (byte)n2;
            nArray2[n2] = 1;
        }
        for (n2 = n3; n2 < 4096; ++n2) {
            nArray[n2] = -1;
            nArray2[n2] = 1;
        }
    }

    private Point outputPixels(byte[] byArray, int n2, Point point, byte[] byArray2) {
        if (this.interlacePass < 0 || this.interlacePass > 3) {
            return point;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (point.x >= this.minX) {
                byArray2[point.x - this.minX] = byArray[i2];
            }
            ++point.x;
            if (point.x != this.width) continue;
            this.theTile.setDataElements(this.minX, point.y, this.width, 1, byArray2);
            point.x = 0;
            if (this.interlaceFlag) {
                point.y += INTERLACE_INCREMENT[this.interlacePass];
                if (point.y < this.height) continue;
                ++this.interlacePass;
                if (this.interlacePass > 3) {
                    return point;
                }
                point.y = INTERLACE_OFFSET[this.interlacePass];
                continue;
            }
            ++point.y;
        }
        return point;
    }

    public synchronized Raster getTile(int n2, int n3) {
        if (n2 != 0 || n3 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("GIFImage2"));
        }
        if (this.theTile != null) {
            return this.theTile;
        }
        this.theTile = WritableRaster.createWritableRaster(this.sampleModel, this.sampleModel.createDataBuffer(), null);
        Point point = new Point(0, 0);
        byte[] byArray = new byte[this.width];
        try {
            int n4;
            this.initCodeSize = this.input.readUnsignedByte();
            int n5 = this.blockLength = this.input.readUnsignedByte();
            int n6 = 0;
            while (n5 > 0) {
                n4 = this.input.read(this.block, n6, n5);
                n5 -= n4;
                n6 += n4;
            }
            this.bitPos = 0;
            this.nextByte = 0;
            this.lastBlockFound = false;
            this.initNext32Bits();
            this.clearCode = 1 << this.initCodeSize;
            this.eofCode = this.clearCode + 1;
            int n7 = 0;
            int[] nArray = new int[4096];
            byte[] byArray2 = new byte[4096];
            byte[] byArray3 = new byte[4096];
            int[] nArray2 = new int[4096];
            byte[] byArray4 = new byte[4096];
            this.initializeStringTable(nArray, byArray2, byArray3, nArray2);
            int n8 = (1 << this.initCodeSize) + 2;
            int n9 = this.initCodeSize + 1;
            int n10 = (1 << n9) - 1;
            while (true) {
                int n11;
                int n12;
                int n13;
                if ((n4 = this.getCode(n9, n10)) == this.clearCode) {
                    this.initializeStringTable(nArray, byArray2, byArray3, nArray2);
                    n8 = (1 << this.initCodeSize) + 2;
                    n9 = this.initCodeSize + 1;
                    n10 = (1 << n9) - 1;
                    n4 = this.getCode(n9, n10);
                    if (n4 == this.eofCode) {
                        return this.theTile;
                    }
                } else {
                    if (n4 == this.eofCode) {
                        return this.theTile;
                    }
                    n13 = n4 < n8 ? n4 : n7;
                    n12 = n8++;
                    nArray[n12] = n11 = n7;
                    byArray2[n12] = byArray3[n13];
                    byArray3[n12] = byArray3[n11];
                    nArray2[n12] = nArray2[n11] + 1;
                    if (n8 == 1 << n9 && n8 < 4096) {
                        n10 = (1 << ++n9) - 1;
                    }
                }
                n13 = n4;
                n12 = nArray2[n13];
                for (n11 = n12 - 1; n11 >= 0; --n11) {
                    byArray4[n11] = byArray2[n13];
                    n13 = nArray[n13];
                }
                this.outputPixels(byArray4, n12, point, byArray);
                n7 = n4;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(JaiI18N.getString("GIFImage3"));
        }
    }
}

