/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.JAI;

import com.fr.third.JAI.SeekableStream;
import java.io.IOException;

public class ByteArraySeekableStream
extends SeekableStream {
    private byte[] src;
    private int offset;
    private int length;
    private int pointer;

    public ByteArraySeekableStream(byte[] byArray, int n2, int n3) throws IOException {
        this.src = byArray;
        this.offset = n2;
        this.length = n3;
    }

    public ByteArraySeekableStream(byte[] byArray) throws IOException {
        this(byArray, 0, byArray.length);
    }

    public boolean canSeekBackwards() {
        return true;
    }

    public long getFilePointer() {
        return this.pointer;
    }

    public void seek(long l2) {
        this.pointer = (int)l2;
    }

    public int read() {
        if (this.pointer < this.length + this.offset) {
            return this.src[this.pointer++ + this.offset] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        int n4 = this.pointer;
        this.pointer = Math.min(this.pointer + n3, this.length + this.offset);
        if (this.pointer == n4) {
            return -1;
        }
        System.arraycopy(this.src, n4, byArray, n2, this.pointer - n4);
        return this.pointer - n4;
    }

    public int skipBytes(int n2) {
        int n3 = this.pointer;
        this.pointer = Math.min(this.pointer + n2, this.length + this.offset);
        return this.pointer - n3;
    }

    public void close() {
    }

    public long length() {
        return this.length;
    }
}

