/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.serialize;

import com.fr.stable.StableUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class SerializationUtils {
    private SerializationUtils() {
    }

    public static Object clone(Serializable serializable) {
        return SerializationUtils.deserialize(SerializationUtils.serialize(serializable));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void serialize(Serializable serializable, OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("The OutputStream must not be null");
        }
        ObjectOutputStream objectOutputStream = null;
        try {
            try {
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(serializable);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                if (objectOutputStream == null) throw throwable;
                objectOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (objectOutputStream == null) return;
        objectOutputStream.close();
        return;
    }

    public static byte[] serialize(Serializable serializable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        SerializationUtils.serialize(serializable, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object deserialize(InputStream inputStream) {
        Object object;
        if (inputStream == null) {
            throw new IllegalArgumentException("The InputStream must not be null");
        }
        ObjectInputStream objectInputStream = null;
        try {
            try {
                objectInputStream = new ObjectInputStream(inputStream);
                object = objectInputStream.readObject();
                Object var4_5 = null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                if (objectInputStream == null) throw throwable;
                objectInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return object;
        }
        if (objectInputStream == null) return object;
        objectInputStream.close();
        return object;
    }

    public static Object deserialize(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("The byte[] must not be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return SerializationUtils.deserialize(byteArrayInputStream);
    }

    public static Object deserializable(File file) throws IOException, ClassNotFoundException {
        return SerializationUtils.deserialize(new FileInputStream(file));
    }

    public static void serializable(Serializable serializable, File file) throws IOException {
        if (StableUtils.makesureFileExist(file)) {
            SerializationUtils.serialize(serializable, new FileOutputStream(file));
        }
    }
}

