/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.image4j.codec.ico;

import com.fr.stable.image4j.io.LittleEndianInputStream;
import com.fr.stable.image4j.io.LittleEndianOutputStream;
import java.io.IOException;

public class IconEntry {
    public int bWidth;
    public int bHeight;
    public int bColorCount;
    public byte bReserved;
    public short sPlanes;
    public short sBitCount;
    public int iSizeInBytes;
    public int iFileOffset;

    public IconEntry(LittleEndianInputStream littleEndianInputStream) throws IOException {
        this.bWidth = littleEndianInputStream.readUnsignedByte();
        this.bHeight = littleEndianInputStream.readUnsignedByte();
        this.bColorCount = littleEndianInputStream.readUnsignedByte();
        this.bReserved = littleEndianInputStream.readByte();
        this.sPlanes = littleEndianInputStream.readShortLE();
        this.sBitCount = littleEndianInputStream.readShortLE();
        this.iSizeInBytes = littleEndianInputStream.readIntLE();
        this.iFileOffset = littleEndianInputStream.readIntLE();
    }

    public IconEntry() {
        this.bWidth = 0;
        this.bHeight = 0;
        this.bColorCount = 0;
        this.sPlanes = 1;
        this.bReserved = 0;
        this.sBitCount = 0;
        this.iSizeInBytes = 0;
        this.iFileOffset = 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("width=");
        stringBuffer.append(this.bWidth);
        stringBuffer.append(",height=");
        stringBuffer.append(this.bHeight);
        stringBuffer.append(",bitCount=");
        stringBuffer.append(this.sBitCount);
        stringBuffer.append(",colorCount=" + this.bColorCount);
        return stringBuffer.toString();
    }

    public void write(LittleEndianOutputStream littleEndianOutputStream) throws IOException {
        littleEndianOutputStream.writeByte(this.bWidth);
        littleEndianOutputStream.writeByte(this.bHeight);
        littleEndianOutputStream.writeByte(this.bColorCount);
        littleEndianOutputStream.writeByte(this.bReserved);
        littleEndianOutputStream.writeShortLE(this.sPlanes);
        littleEndianOutputStream.writeShortLE(this.sBitCount);
        littleEndianOutputStream.writeIntLE(this.iSizeInBytes);
        littleEndianOutputStream.writeIntLE(this.iFileOffset);
    }
}

