/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.image4j.codec.bmp;

import com.fr.stable.image4j.codec.bmp.InfoHeader;
import com.fr.stable.image4j.io.LittleEndianOutputStream;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BMPEncoder {
    private BMPEncoder() {
    }

    public static void write(BufferedImage bufferedImage, File file) throws IOException {
        BMPEncoder.write(bufferedImage, new FileOutputStream(file));
    }

    public static void write(BufferedImage bufferedImage, OutputStream outputStream) throws IOException {
        InfoHeader infoHeader = BMPEncoder.createInfoHeader(bufferedImage);
        int n2 = 0;
        IndexColorModel indexColorModel = null;
        if (infoHeader.sBitCount <= 8) {
            indexColorModel = (IndexColorModel)bufferedImage.getColorModel();
            n2 = indexColorModel.getMapSize();
        }
        int n3 = 14 + infoHeader.iSize;
        int n4 = 4 * n2;
        int n5 = n3 + n4;
        int n6 = 0;
        switch (infoHeader.sBitCount) {
            case 1: {
                n6 = BMPEncoder.getBytesPerLine1(infoHeader.iWidth);
                break;
            }
            case 4: {
                n6 = BMPEncoder.getBytesPerLine4(infoHeader.iWidth);
                break;
            }
            case 8: {
                n6 = BMPEncoder.getBytesPerLine8(infoHeader.iWidth);
                break;
            }
            case 24: {
                n6 = BMPEncoder.getBytesPerLine24(infoHeader.iWidth);
                break;
            }
            case 32: {
                n6 = infoHeader.iWidth * 4;
            }
        }
        int n7 = n5 + n6 * infoHeader.iHeight;
        LittleEndianOutputStream littleEndianOutputStream = new LittleEndianOutputStream(outputStream);
        BMPEncoder.writeFileHeader(n7, n5, littleEndianOutputStream);
        infoHeader.write(littleEndianOutputStream);
        if (infoHeader.sBitCount <= 8) {
            BMPEncoder.writeColorMap(indexColorModel, littleEndianOutputStream);
        }
        switch (infoHeader.sBitCount) {
            case 1: {
                BMPEncoder.write1(bufferedImage.getRaster(), littleEndianOutputStream);
                break;
            }
            case 4: {
                BMPEncoder.write4(bufferedImage.getRaster(), littleEndianOutputStream);
                break;
            }
            case 8: {
                BMPEncoder.write8(bufferedImage.getRaster(), littleEndianOutputStream);
                break;
            }
            case 24: {
                BMPEncoder.write24(bufferedImage.getRaster(), littleEndianOutputStream);
                break;
            }
            case 32: {
                BMPEncoder.write32(bufferedImage.getRaster(), bufferedImage.getAlphaRaster(), littleEndianOutputStream);
            }
        }
    }

    public static InfoHeader createInfoHeader(BufferedImage bufferedImage) {
        InfoHeader infoHeader = new InfoHeader();
        infoHeader.iColorsImportant = 0;
        infoHeader.iColorsUsed = 0;
        infoHeader.iCompression = 0;
        infoHeader.iHeight = bufferedImage.getHeight();
        infoHeader.iWidth = bufferedImage.getWidth();
        infoHeader.sBitCount = (short)bufferedImage.getColorModel().getPixelSize();
        infoHeader.iNumColors = 1 << (infoHeader.sBitCount == 32 ? 24 : (int)infoHeader.sBitCount);
        infoHeader.iImageSize = 0;
        return infoHeader;
    }

    public static void writeFileHeader(int n2, int n3, LittleEndianOutputStream littleEndianOutputStream) throws IOException {
        byte[] byArray = "BM".getBytes("UTF-8");
        littleEndianOutputStream.write(byArray);
        littleEndianOutputStream.writeIntLE(n2);
        littleEndianOutputStream.writeIntLE(0);
        littleEndianOutputStream.writeIntLE(n3);
    }

    public static void writeColorMap(IndexColorModel indexColorModel, LittleEndianOutputStream littleEndianOutputStream) throws IOException {
        int n2 = indexColorModel.getMapSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = indexColorModel.getRGB(i2);
            int n4 = n3 >> 16 & 0xFF;
            int n5 = n3 >> 8 & 0xFF;
            int n6 = n3 & 0xFF;
            littleEndianOutputStream.writeByte(n6);
            littleEndianOutputStream.writeByte(n5);
            littleEndianOutputStream.writeByte(n4);
            littleEndianOutputStream.writeByte(0);
        }
    }

    public static int getBytesPerLine1(int n2) {
        int n3 = n2 / 8;
        if (n3 % 4 != 0) {
            n3 = (n3 / 4 + 1) * 4;
        }
        return n3;
    }

    public static int getBytesPerLine4(int n2) {
        int n3 = n2 / 2;
        if (n3 % 4 != 0) {
            n3 = (n3 / 4 + 1) * 4;
        }
        return n3;
    }

    public static int getBytesPerLine8(int n2) {
        int n3 = n2;
        if (n3 % 4 != 0) {
            n3 = (n3 / 4 + 1) * 4;
        }
        return n3;
    }

    public static int getBytesPerLine24(int n2) {
        int n3 = n2 * 3;
        if (n3 % 4 != 0) {
            n3 = (n3 / 4 + 1) * 4;
        }
        return n3;
    }

    public static int getBitmapSize(int n2, int n3, int n4) {
        int n5 = 0;
        switch (n4) {
            case 1: {
                n5 = BMPEncoder.getBytesPerLine1(n2);
                break;
            }
            case 4: {
                n5 = BMPEncoder.getBytesPerLine4(n2);
                break;
            }
            case 8: {
                n5 = BMPEncoder.getBytesPerLine8(n2);
                break;
            }
            case 24: {
                n5 = BMPEncoder.getBytesPerLine24(n2);
                break;
            }
            case 32: {
                n5 = n2 * 4;
            }
        }
        int n6 = n5 * n3;
        return n6;
    }

    public static void write1(Raster raster, LittleEndianOutputStream littleEndianOutputStream) throws IOException {
        int n2 = BMPEncoder.getBytesPerLine1(raster.getWidth());
        byte[] byArray = new byte[n2];
        for (int i2 = raster.getHeight() - 1; i2 >= 0; --i2) {
            int n3;
            for (n3 = 0; n3 < n2; ++n3) {
                byArray[n3] = 0;
            }
            for (n3 = 0; n3 < raster.getWidth(); ++n3) {
                int n4 = n3 / 8;
                int n5 = n3 % 8;
                int n6 = raster.getSample(n3, i2, 0);
                byArray[n4] = BMPEncoder.setBit(byArray[n4], n5, n6);
            }
            littleEndianOutputStream.write(byArray);
        }
    }

    public static void write4(Raster raster, LittleEndianOutputStream littleEndianOutputStream) throws IOException {
        int n2 = raster.getWidth();
        int n3 = raster.getHeight();
        int n4 = BMPEncoder.getBytesPerLine4(n2);
        byte[] byArray = new byte[n4];
        for (int i2 = n3 - 1; i2 >= 0; --i2) {
            int n5;
            for (n5 = 0; n5 < n4; ++n5) {
                byArray[n5] = 0;
            }
            for (n5 = 0; n5 < n2; ++n5) {
                int n6 = n5 / 2;
                int n7 = n5 % 2;
                int n8 = raster.getSample(n5, i2, 0);
                byArray[n6] = BMPEncoder.setNibble(byArray[n6], n7, n8);
            }
            littleEndianOutputStream.write(byArray);
        }
    }

    public static void write8(Raster raster, LittleEndianOutputStream littleEndianOutputStream) throws IOException {
        int n2 = raster.getWidth();
        int n3 = raster.getHeight();
        int n4 = BMPEncoder.getBytesPerLine8(n2);
        for (int i2 = n3 - 1; i2 >= 0; --i2) {
            int n5;
            for (n5 = 0; n5 < n2; ++n5) {
                int n6 = raster.getSample(n5, i2, 0);
                littleEndianOutputStream.writeByte(n6);
            }
            for (n5 = n2; n5 < n4; ++n5) {
                littleEndianOutputStream.writeByte(0);
            }
        }
    }

    public static void write24(Raster raster, LittleEndianOutputStream littleEndianOutputStream) throws IOException {
        int n2 = raster.getWidth();
        int n3 = raster.getHeight();
        int n4 = BMPEncoder.getBytesPerLine24(n2);
        for (int i2 = n3 - 1; i2 >= 0; --i2) {
            int n5;
            for (n5 = 0; n5 < n2; ++n5) {
                int n6 = raster.getSample(n5, i2, 0);
                int n7 = raster.getSample(n5, i2, 1);
                int n8 = raster.getSample(n5, i2, 2);
                littleEndianOutputStream.writeByte(n8);
                littleEndianOutputStream.writeByte(n7);
                littleEndianOutputStream.writeByte(n6);
            }
            for (n5 = n2 * 3; n5 < n4; ++n5) {
                littleEndianOutputStream.writeByte(0);
            }
        }
    }

    public static void write32(Raster raster, Raster raster2, LittleEndianOutputStream littleEndianOutputStream) throws IOException {
        int n2 = raster.getWidth();
        int n3 = raster.getHeight();
        for (int i2 = n3 - 1; i2 >= 0; --i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                int n4 = raster.getSample(i3, i2, 0);
                int n5 = raster.getSample(i3, i2, 1);
                int n6 = raster.getSample(i3, i2, 2);
                int n7 = raster2.getSample(i3, i2, 0);
                littleEndianOutputStream.writeByte(n6);
                littleEndianOutputStream.writeByte(n5);
                littleEndianOutputStream.writeByte(n4);
                littleEndianOutputStream.writeByte(n7);
            }
        }
    }

    private static byte setBit(byte by, int n2, int n3) {
        by = n3 == 0 ? (byte)(by & ~(1 << 7 - n2)) : (byte)(by | 1 << 7 - n2);
        return by;
    }

    private static byte setNibble(byte by, int n2, int n3) {
        by = (byte)(by | n3 << (1 - n2) * 4);
        return by;
    }

    public static int getColorMapSize(short s2) {
        int n2 = 0;
        if (s2 <= 8) {
            n2 = (1 << s2) * 4;
        }
        return n2;
    }
}

