/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.utils;

import com.fr.stable.collections.utils.RandomXS128;
import java.util.Random;

public final class MathUtils {
    public static final float nanoToSec = 1.0E-9f;
    public static final float FLOAT_ROUNDING_ERROR = 1.0E-6f;
    public static final float PI = (float)Math.PI;
    public static final float PI2 = (float)Math.PI * 2;
    public static final float E = (float)Math.E;
    private static final int SIN_BITS = 14;
    private static final int SIN_MASK = 16383;
    private static final int SIN_COUNT = 16384;
    private static final float radFull = (float)Math.PI * 2;
    private static final float degFull = 360.0f;
    private static final float radToIndex = 2607.5945f;
    private static final float degToIndex = 45.511112f;
    public static final float radiansToDegrees = 57.295776f;
    public static final float radDeg = 57.295776f;
    public static final float degreesToRadians = (float)Math.PI / 180;
    public static final float degRad = (float)Math.PI / 180;
    public static Random random = new RandomXS128();
    private static final int BIG_ENOUGH_INT = 16384;
    private static final double BIG_ENOUGH_FLOOR = 16384.0;
    private static final double CEIL = 0.9999999;
    private static final double BIG_ENOUGH_CEIL = 16384.999999999996;
    private static final double BIG_ENOUGH_ROUND = 16384.5;

    public static float sin(float f2) {
        return Sin.table[(int)(f2 * 2607.5945f) & 0x3FFF];
    }

    public static float cos(float f2) {
        return Sin.table[(int)((f2 + 1.5707964f) * 2607.5945f) & 0x3FFF];
    }

    public static float sinDeg(float f2) {
        return Sin.table[(int)(f2 * 45.511112f) & 0x3FFF];
    }

    public static float cosDeg(float f2) {
        return Sin.table[(int)((f2 + 90.0f) * 45.511112f) & 0x3FFF];
    }

    public static float atan2(float f2, float f3) {
        if (f3 == 0.0f) {
            if (f2 > 0.0f) {
                return 1.5707964f;
            }
            if (f2 == 0.0f) {
                return 0.0f;
            }
            return -1.5707964f;
        }
        float f4 = f2 / f3;
        if (Math.abs(f4) < 1.0f) {
            float f5 = f4 / (1.0f + 0.28f * f4 * f4);
            if (f3 < 0.0f) {
                return f5 + (f2 < 0.0f ? (float)(-Math.PI) : (float)Math.PI);
            }
            return f5;
        }
        float f6 = 1.5707964f - f4 / (f4 * f4 + 0.28f);
        return f2 < 0.0f ? f6 - (float)Math.PI : f6;
    }

    public static int random(int n2) {
        return random.nextInt(n2 + 1);
    }

    public static int random(int n2, int n3) {
        return n2 + random.nextInt(n3 - n2 + 1);
    }

    public static long random(long l2) {
        return (long)(random.nextDouble() * (double)l2);
    }

    public static long random(long l2, long l3) {
        return l2 + (long)(random.nextDouble() * (double)(l3 - l2));
    }

    public static boolean randomBoolean() {
        return random.nextBoolean();
    }

    public static boolean randomBoolean(float f2) {
        return MathUtils.random() < f2;
    }

    public static float random() {
        return random.nextFloat();
    }

    public static float random(float f2) {
        return random.nextFloat() * f2;
    }

    public static float random(float f2, float f3) {
        return f2 + random.nextFloat() * (f3 - f2);
    }

    public static int randomSign() {
        return 1 | random.nextInt() >> 31;
    }

    public static float randomTriangular() {
        return random.nextFloat() - random.nextFloat();
    }

    public static float randomTriangular(float f2) {
        return (random.nextFloat() - random.nextFloat()) * f2;
    }

    public static float randomTriangular(float f2, float f3) {
        return MathUtils.randomTriangular(f2, f3, (f2 + f3) * 0.5f);
    }

    public static float randomTriangular(float f2, float f3, float f4) {
        float f5;
        float f6 = random.nextFloat();
        if (f6 <= (f4 - f2) / (f5 = f3 - f2)) {
            return f2 + (float)Math.sqrt(f6 * f5 * (f4 - f2));
        }
        return f3 - (float)Math.sqrt((1.0f - f6) * f5 * (f3 - f4));
    }

    public static int nextPowerOfTwo(int n2) {
        if (n2 == 0) {
            return 1;
        }
        --n2;
        n2 |= n2 >> 1;
        n2 |= n2 >> 2;
        n2 |= n2 >> 4;
        n2 |= n2 >> 8;
        n2 |= n2 >> 16;
        return n2 + 1;
    }

    public static boolean isPowerOfTwo(int n2) {
        return n2 != 0 && (n2 & n2 - 1) == 0;
    }

    public static short clamp(short s2, short s3, short s4) {
        if (s2 < s3) {
            return s3;
        }
        if (s2 > s4) {
            return s4;
        }
        return s2;
    }

    public static int clamp(int n2, int n3, int n4) {
        if (n2 < n3) {
            return n3;
        }
        if (n2 > n4) {
            return n4;
        }
        return n2;
    }

    public static long clamp(long l2, long l3, long l4) {
        if (l2 < l3) {
            return l3;
        }
        if (l2 > l4) {
            return l4;
        }
        return l2;
    }

    public static float clamp(float f2, float f3, float f4) {
        if (f2 < f3) {
            return f3;
        }
        if (f2 > f4) {
            return f4;
        }
        return f2;
    }

    public static double clamp(double d2, double d3, double d4) {
        if (d2 < d3) {
            return d3;
        }
        if (d2 > d4) {
            return d4;
        }
        return d2;
    }

    public static float lerp(float f2, float f3, float f4) {
        return f2 + (f3 - f2) * f4;
    }

    public static float lerpAngle(float f2, float f3, float f4) {
        float f5 = (f3 - f2 + (float)Math.PI * 2 + (float)Math.PI) % ((float)Math.PI * 2) - (float)Math.PI;
        return (f2 + f5 * f4 + (float)Math.PI * 2) % ((float)Math.PI * 2);
    }

    public static float lerpAngleDeg(float f2, float f3, float f4) {
        float f5 = (f3 - f2 + 360.0f + 180.0f) % 360.0f - 180.0f;
        return (f2 + f5 * f4 + 360.0f) % 360.0f;
    }

    public static int floor(float f2) {
        return (int)((double)f2 + 16384.0) - 16384;
    }

    public static int floorPositive(float f2) {
        return (int)f2;
    }

    public static int ceil(float f2) {
        return (int)((double)f2 + 16384.999999999996) - 16384;
    }

    public static int ceilPositive(float f2) {
        return (int)((double)f2 + 0.9999999);
    }

    public static int round(float f2) {
        return (int)((double)f2 + 16384.5) - 16384;
    }

    public static int roundPositive(float f2) {
        return (int)(f2 + 0.5f);
    }

    public static boolean isZero(float f2) {
        return Math.abs(f2) <= 1.0E-6f;
    }

    public static boolean isZero(float f2, float f3) {
        return Math.abs(f2) <= f3;
    }

    public static boolean isEqual(float f2, float f3) {
        return Math.abs(f2 - f3) <= 1.0E-6f;
    }

    public static boolean isEqual(float f2, float f3, float f4) {
        return Math.abs(f2 - f3) <= f4;
    }

    public static float log(float f2, float f3) {
        return (float)(Math.log(f3) / Math.log(f2));
    }

    public static float log2(float f2) {
        return MathUtils.log(2.0f, f2);
    }

    private static class Sin {
        static final float[] table;

        private Sin() {
        }

        static {
            int n2;
            table = new float[16384];
            for (n2 = 0; n2 < 16384; ++n2) {
                Sin.table[n2] = (float)Math.sin(((float)n2 + 0.5f) / 16384.0f * ((float)Math.PI * 2));
            }
            for (n2 = 0; n2 < 360; n2 += 90) {
                Sin.table[(int)((float)n2 * 45.511112f) & 0x3FFF] = (float)Math.sin((float)n2 * ((float)Math.PI / 180));
            }
        }
    }
}

