/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.map;

import com.fr.stable.collections.array.Array;
import com.fr.stable.collections.array.FloatArray;
import com.fr.stable.collections.utils.GdxRuntimeException;
import com.fr.stable.collections.utils.MathUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectFloatMap<K>
implements Iterable<Entry<K>> {
    private static final int PRIME1 = -1105259343;
    private static final int PRIME2 = -1262997959;
    private static final int PRIME3 = -825114047;
    public int size;
    K[] keyTable;
    float[] valueTable;
    int capacity;
    int stashSize;
    private float loadFactor;
    private int hashShift;
    private int mask;
    private int threshold;
    private int stashCapacity;
    private int pushIterations;
    private Entries entries1;
    private Entries entries2;
    private Values values1;
    private Values values2;
    private Keys keys1;
    private Keys keys2;

    public ObjectFloatMap() {
        this(51, 0.8f);
    }

    public ObjectFloatMap(int n2) {
        this(n2, 0.8f);
    }

    public ObjectFloatMap(int n2, float f2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: " + n2);
        }
        if ((n2 = MathUtils.nextPowerOfTwo((int)Math.ceil((float)n2 / f2))) > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: " + n2);
        }
        this.capacity = n2;
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: " + f2);
        }
        this.loadFactor = f2;
        this.threshold = (int)((float)this.capacity * f2);
        this.mask = this.capacity - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(this.capacity);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
        this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
        this.keyTable = new Object[this.capacity + this.stashCapacity];
        this.valueTable = new float[this.keyTable.length];
    }

    public ObjectFloatMap(ObjectFloatMap<? extends K> objectFloatMap) {
        this((int)Math.floor((float)objectFloatMap.capacity * objectFloatMap.loadFactor), objectFloatMap.loadFactor);
        this.stashSize = objectFloatMap.stashSize;
        System.arraycopy(objectFloatMap.keyTable, 0, this.keyTable, 0, objectFloatMap.keyTable.length);
        System.arraycopy(objectFloatMap.valueTable, 0, this.valueTable, 0, objectFloatMap.valueTable.length);
        this.size = objectFloatMap.size;
    }

    public void put(K k2, float f2) {
        int n2;
        if (k2 == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        K[] KArray = this.keyTable;
        int n3 = k2.hashCode();
        int n4 = n3 & this.mask;
        K k3 = KArray[n4];
        if (k2.equals(k3)) {
            this.valueTable[n4] = f2;
            return;
        }
        int n5 = this.hash2(n3);
        K k4 = KArray[n5];
        if (k2.equals(k4)) {
            this.valueTable[n5] = f2;
            return;
        }
        int n6 = this.hash3(n3);
        K k5 = KArray[n6];
        if (k2.equals(k5)) {
            this.valueTable[n6] = f2;
            return;
        }
        int n7 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n7; ++n2) {
            if (!k2.equals(KArray[n2])) continue;
            this.valueTable[n2] = f2;
            return;
        }
        if (k3 == null) {
            KArray[n4] = k2;
            this.valueTable[n4] = f2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        if (k4 == null) {
            KArray[n5] = k2;
            this.valueTable[n5] = f2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        if (k5 == null) {
            KArray[n6] = k2;
            this.valueTable[n6] = f2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(k2, f2, n4, k3, n5, k4, n6, k5);
    }

    public void putAll(ObjectFloatMap<K> objectFloatMap) {
        for (Entry entry : objectFloatMap.entries()) {
            this.put(entry.key, entry.value);
        }
    }

    private void putResize(K k2, float f2) {
        int n2 = k2.hashCode();
        int n3 = n2 & this.mask;
        K k3 = this.keyTable[n3];
        if (k3 == null) {
            this.keyTable[n3] = k2;
            this.valueTable[n3] = f2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n4 = this.hash2(n2);
        K k4 = this.keyTable[n4];
        if (k4 == null) {
            this.keyTable[n4] = k2;
            this.valueTable[n4] = f2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n5 = this.hash3(n2);
        K k5 = this.keyTable[n5];
        if (k5 == null) {
            this.keyTable[n5] = k2;
            this.valueTable[n5] = f2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(k2, f2, n3, k3, n4, k4, n5, k5);
    }

    private void push(K k2, float f2, int n2, K k3, int n3, K k4, int n4, K k5) {
        float f3;
        K k6;
        K[] KArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n5 = this.mask;
        int n6 = 0;
        int n7 = this.pushIterations;
        while (true) {
            switch (MathUtils.random(2)) {
                case 0: {
                    k6 = k3;
                    f3 = fArray[n2];
                    KArray[n2] = k2;
                    fArray[n2] = f2;
                    break;
                }
                case 1: {
                    k6 = k4;
                    f3 = fArray[n3];
                    KArray[n3] = k2;
                    fArray[n3] = f2;
                    break;
                }
                default: {
                    k6 = k5;
                    f3 = fArray[n4];
                    KArray[n4] = k2;
                    fArray[n4] = f2;
                }
            }
            int n8 = k6.hashCode();
            n2 = n8 & n5;
            k3 = KArray[n2];
            if (k3 == null) {
                KArray[n2] = k6;
                fArray[n2] = f3;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n3 = this.hash2(n8);
            k4 = KArray[n3];
            if (k4 == null) {
                KArray[n3] = k6;
                fArray[n3] = f3;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n4 = this.hash3(n8);
            k5 = KArray[n4];
            if (k5 == null) {
                KArray[n4] = k6;
                fArray[n4] = f3;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (++n6 == n7) break;
            k2 = k6;
            f2 = f3;
        }
        this.putStash(k6, f3);
    }

    private void putStash(K k2, float f2) {
        if (this.stashSize == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.put(k2, f2);
            return;
        }
        int n2 = this.capacity + this.stashSize;
        this.keyTable[n2] = k2;
        this.valueTable[n2] = f2;
        ++this.stashSize;
        ++this.size;
    }

    public float get(K k2, float f2) {
        int n2 = k2.hashCode();
        int n3 = n2 & this.mask;
        if (!(k2.equals(this.keyTable[n3]) || k2.equals(this.keyTable[n3 = this.hash2(n2)]) || k2.equals(this.keyTable[n3 = this.hash3(n2)]))) {
            return this.getStash(k2, f2);
        }
        return this.valueTable[n3];
    }

    private float getStash(K k2, float f2) {
        int n2;
        K[] KArray = this.keyTable;
        int n3 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n3; ++n2) {
            if (!k2.equals(KArray[n2])) continue;
            return this.valueTable[n2];
        }
        return f2;
    }

    public float getAndIncrement(K k2, float f2, float f3) {
        int n2 = k2.hashCode();
        int n3 = n2 & this.mask;
        if (!(k2.equals(this.keyTable[n3]) || k2.equals(this.keyTable[n3 = this.hash2(n2)]) || k2.equals(this.keyTable[n3 = this.hash3(n2)]))) {
            return this.getAndIncrementStash(k2, f2, f3);
        }
        float f4 = this.valueTable[n3];
        this.valueTable[n3] = f4 + f3;
        return f4;
    }

    private float getAndIncrementStash(K k2, float f2, float f3) {
        int n2;
        K[] KArray = this.keyTable;
        int n3 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n3; ++n2) {
            if (!k2.equals(KArray[n2])) continue;
            float f4 = this.valueTable[n2];
            this.valueTable[n2] = f4 + f3;
            return f4;
        }
        this.put(k2, f2 + f3);
        return f2;
    }

    public float remove(K k2, float f2) {
        int n2 = k2.hashCode();
        int n3 = n2 & this.mask;
        if (k2.equals(this.keyTable[n3])) {
            this.keyTable[n3] = null;
            float f3 = this.valueTable[n3];
            --this.size;
            return f3;
        }
        n3 = this.hash2(n2);
        if (k2.equals(this.keyTable[n3])) {
            this.keyTable[n3] = null;
            float f4 = this.valueTable[n3];
            --this.size;
            return f4;
        }
        n3 = this.hash3(n2);
        if (k2.equals(this.keyTable[n3])) {
            this.keyTable[n3] = null;
            float f5 = this.valueTable[n3];
            --this.size;
            return f5;
        }
        return this.removeStash(k2, f2);
    }

    float removeStash(K k2, float f2) {
        int n2;
        K[] KArray = this.keyTable;
        int n3 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n3; ++n2) {
            if (!k2.equals(KArray[n2])) continue;
            float f3 = this.valueTable[n2];
            this.removeStashIndex(n2);
            --this.size;
            return f3;
        }
        return f2;
    }

    void removeStashIndex(int n2) {
        --this.stashSize;
        int n3 = this.capacity + this.stashSize;
        if (n2 < n3) {
            this.keyTable[n2] = this.keyTable[n3];
            this.valueTable[n2] = this.valueTable[n3];
        }
    }

    public void shrink(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + n2);
        }
        if (this.size > n2) {
            n2 = this.size;
        }
        if (this.capacity <= n2) {
            return;
        }
        n2 = MathUtils.nextPowerOfTwo(n2);
        this.resize(n2);
    }

    public void clear(int n2) {
        if (this.capacity <= n2) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(n2);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        K[] KArray = this.keyTable;
        int n2 = this.capacity + this.stashSize;
        while (n2-- > 0) {
            KArray[n2] = null;
        }
        this.size = 0;
        this.stashSize = 0;
    }

    public boolean containsValue(float f2) {
        K[] KArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n2 = this.capacity + this.stashSize;
        while (n2-- > 0) {
            if (KArray[n2] == null || fArray[n2] != f2) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(K k2) {
        int n2 = k2.hashCode();
        int n3 = n2 & this.mask;
        if (!(k2.equals(this.keyTable[n3]) || k2.equals(this.keyTable[n3 = this.hash2(n2)]) || k2.equals(this.keyTable[n3 = this.hash3(n2)]))) {
            return this.containsKeyStash(k2);
        }
        return true;
    }

    private boolean containsKeyStash(K k2) {
        int n2;
        K[] KArray = this.keyTable;
        int n3 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n3; ++n2) {
            if (!k2.equals(KArray[n2])) continue;
            return true;
        }
        return false;
    }

    public K findKey(float f2) {
        K[] KArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n2 = this.capacity + this.stashSize;
        while (n2-- > 0) {
            if (KArray[n2] == null || fArray[n2] != f2) continue;
            return KArray[n2];
        }
        return null;
    }

    public void ensureCapacity(int n2) {
        int n3 = this.size + n2;
        if (n3 >= this.threshold) {
            this.resize(MathUtils.nextPowerOfTwo((int)Math.ceil((float)n3 / this.loadFactor)));
        }
    }

    private void resize(int n2) {
        int n3 = this.capacity + this.stashSize;
        this.capacity = n2;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.mask = n2 - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(n2);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(n2)) * 2);
        this.pushIterations = Math.max(Math.min(n2, 8), (int)Math.sqrt(n2) / 8);
        K[] KArray = this.keyTable;
        float[] fArray = this.valueTable;
        this.keyTable = new Object[n2 + this.stashCapacity];
        this.valueTable = new float[n2 + this.stashCapacity];
        int n4 = this.size;
        this.size = 0;
        this.stashSize = 0;
        if (n4 > 0) {
            for (int i2 = 0; i2 < n3; ++i2) {
                K k2 = KArray[i2];
                if (k2 == null) continue;
                this.putResize(k2, fArray[i2]);
            }
        }
    }

    private int hash2(int n2) {
        return ((n2 *= -1262997959) ^ n2 >>> this.hashShift) & this.mask;
    }

    private int hash3(int n2) {
        return ((n2 *= -825114047) ^ n2 >>> this.hashShift) & this.mask;
    }

    public int hashCode() {
        int n2 = 0;
        K[] KArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n3 = this.capacity + this.stashSize;
        for (int i2 = 0; i2 < n3; ++i2) {
            K k2 = KArray[i2];
            if (k2 == null) continue;
            n2 += k2.hashCode() * 31;
            float f2 = fArray[i2];
            n2 += Float.floatToIntBits(f2);
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ObjectFloatMap)) {
            return false;
        }
        ObjectFloatMap objectFloatMap = (ObjectFloatMap)object;
        if (objectFloatMap.size != this.size) {
            return false;
        }
        K[] KArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n2 = this.capacity + this.stashSize;
        for (int i2 = 0; i2 < n2; ++i2) {
            K k2 = KArray[i2];
            if (k2 == null) continue;
            float f2 = objectFloatMap.get(k2, 0.0f);
            if (f2 == 0.0f && !objectFloatMap.containsKey(k2)) {
                return false;
            }
            float f3 = fArray[i2];
            if (f2 == f3) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        K k2;
        if (this.size == 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('{');
        K[] KArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n2 = KArray.length;
        while (n2-- > 0) {
            k2 = KArray[n2];
            if (k2 == null) continue;
            stringBuilder.append(k2);
            stringBuilder.append('=');
            stringBuilder.append(fArray[n2]);
            break;
        }
        while (n2-- > 0) {
            k2 = KArray[n2];
            if (k2 == null) continue;
            stringBuilder.append(", ");
            stringBuilder.append(k2);
            stringBuilder.append('=');
            stringBuilder.append(fArray[n2]);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public Entries<K> iterator() {
        return this.entries();
    }

    public Entries<K> entries() {
        if (this.entries1 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.reset();
            this.entries1.valid = true;
            this.entries2.valid = false;
            return this.entries1;
        }
        this.entries2.reset();
        this.entries2.valid = true;
        this.entries1.valid = false;
        return this.entries2;
    }

    public Values values() {
        if (this.values1 == null) {
            this.values1 = new Values((ObjectFloatMap<?>)this);
            this.values2 = new Values((ObjectFloatMap<?>)this);
        }
        if (!this.values1.valid) {
            this.values1.reset();
            this.values1.valid = true;
            this.values2.valid = false;
            return this.values1;
        }
        this.values2.reset();
        this.values2.valid = true;
        this.values1.valid = false;
        return this.values2;
    }

    public Keys<K> keys() {
        if (this.keys1 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.reset();
            this.keys1.valid = true;
            this.keys2.valid = false;
            return this.keys1;
        }
        this.keys2.reset();
        this.keys2.valid = true;
        this.keys1.valid = false;
        return this.keys2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Keys<K>
    extends MapIterator<K>
    implements Iterable<K>,
    Iterator<K> {
        public Keys(ObjectFloatMap<K> objectFloatMap) {
            super(objectFloatMap);
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public K next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            Object k2 = this.map.keyTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return k2;
        }

        @Override
        public Keys<K> iterator() {
            return this;
        }

        public Array<K> toArray() {
            Array<K> array = new Array<K>(true, this.map.size);
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }

        public Array<K> toArray(Array<K> array) {
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }

        @Override
        public void remove() {
            super.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Values
    extends MapIterator<Object> {
        public Values(ObjectFloatMap<?> objectFloatMap) {
            super(objectFloatMap);
        }

        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        public float next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            float f2 = this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return f2;
        }

        public FloatArray toArray() {
            FloatArray floatArray = new FloatArray(true, this.map.size);
            while (this.hasNext) {
                floatArray.add(this.next());
            }
            return floatArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entries<K>
    extends MapIterator<K>
    implements Iterable<Entry<K>>,
    Iterator<Entry<K>> {
        private Entry<K> entry = new Entry();

        public Entries(ObjectFloatMap<K> objectFloatMap) {
            super(objectFloatMap);
        }

        @Override
        public Entry<K> next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            K[] KArray = this.map.keyTable;
            this.entry.key = KArray[this.nextIndex];
            this.entry.value = this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public Entries<K> iterator() {
            return this;
        }

        @Override
        public void remove() {
            super.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapIterator<K> {
        public boolean hasNext;
        final ObjectFloatMap<K> map;
        int nextIndex;
        int currentIndex;
        boolean valid = true;

        public MapIterator(ObjectFloatMap<K> objectFloatMap) {
            this.map = objectFloatMap;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = -1;
            this.findNextIndex();
        }

        void findNextIndex() {
            this.hasNext = false;
            K[] KArray = this.map.keyTable;
            int n2 = this.map.capacity + this.map.stashSize;
            while (++this.nextIndex < n2) {
                if (KArray[this.nextIndex] == null) continue;
                this.hasNext = true;
                break;
            }
        }

        public void remove() {
            if (this.currentIndex < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            if (this.currentIndex >= this.map.capacity) {
                this.map.removeStashIndex(this.currentIndex);
                this.nextIndex = this.currentIndex - 1;
                this.findNextIndex();
            } else {
                this.map.keyTable[this.currentIndex] = null;
            }
            this.currentIndex = -1;
            --this.map.size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<K> {
        public K key;
        public float value;

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

