/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.map;

import com.fr.stable.collections.array.IntArray;
import com.fr.stable.collections.utils.GdxRuntimeException;
import com.fr.stable.collections.utils.MathUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntIntMap
implements Iterable<Entry> {
    private static final int PRIME1 = -1105259343;
    private static final int PRIME2 = -1262997959;
    private static final int PRIME3 = -825114047;
    private static final int EMPTY = 0;
    public int size;
    int[] keyTable;
    int[] valueTable;
    int capacity;
    int stashSize;
    int zeroValue;
    boolean hasZeroValue;
    private float loadFactor;
    private int hashShift;
    private int mask;
    private int threshold;
    private int stashCapacity;
    private int pushIterations;
    private Entries entries1;
    private Entries entries2;
    private Values values1;
    private Values values2;
    private Keys keys1;
    private Keys keys2;

    public IntIntMap() {
        this(51, 0.8f);
    }

    public IntIntMap(int n2) {
        this(n2, 0.8f);
    }

    public IntIntMap(int n2, float f2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: " + n2);
        }
        if ((n2 = MathUtils.nextPowerOfTwo((int)Math.ceil((float)n2 / f2))) > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: " + n2);
        }
        this.capacity = n2;
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: " + f2);
        }
        this.loadFactor = f2;
        this.threshold = (int)((float)this.capacity * f2);
        this.mask = this.capacity - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(this.capacity);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
        this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
        this.keyTable = new int[this.capacity + this.stashCapacity];
        this.valueTable = new int[this.keyTable.length];
    }

    public IntIntMap(IntIntMap intIntMap) {
        this((int)Math.floor((float)intIntMap.capacity * intIntMap.loadFactor), intIntMap.loadFactor);
        this.stashSize = intIntMap.stashSize;
        System.arraycopy(intIntMap.keyTable, 0, this.keyTable, 0, intIntMap.keyTable.length);
        System.arraycopy(intIntMap.valueTable, 0, this.valueTable, 0, intIntMap.valueTable.length);
        this.size = intIntMap.size;
        this.zeroValue = intIntMap.zeroValue;
        this.hasZeroValue = intIntMap.hasZeroValue;
    }

    public void put(int n2, int n3) {
        int n4;
        if (n2 == 0) {
            this.zeroValue = n3;
            if (!this.hasZeroValue) {
                this.hasZeroValue = true;
                ++this.size;
            }
            return;
        }
        int[] nArray = this.keyTable;
        int n5 = n2 & this.mask;
        int n6 = nArray[n5];
        if (n2 == n6) {
            this.valueTable[n5] = n3;
            return;
        }
        int n7 = this.hash2(n2);
        int n8 = nArray[n7];
        if (n2 == n8) {
            this.valueTable[n7] = n3;
            return;
        }
        int n9 = this.hash3(n2);
        int n10 = nArray[n9];
        if (n2 == n10) {
            this.valueTable[n9] = n3;
            return;
        }
        int n11 = n4 + this.stashSize;
        for (n4 = this.capacity; n4 < n11; ++n4) {
            if (n2 != nArray[n4]) continue;
            this.valueTable[n4] = n3;
            return;
        }
        if (n6 == 0) {
            nArray[n5] = n2;
            this.valueTable[n5] = n3;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        if (n8 == 0) {
            nArray[n7] = n2;
            this.valueTable[n7] = n3;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        if (n10 == 0) {
            nArray[n9] = n2;
            this.valueTable[n9] = n3;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(n2, n3, n5, n6, n7, n8, n9, n10);
    }

    public void putAll(IntIntMap intIntMap) {
        for (Entry entry : intIntMap.entries()) {
            this.put(entry.key, entry.value);
        }
    }

    private void putResize(int n2, int n3) {
        if (n2 == 0) {
            this.zeroValue = n3;
            this.hasZeroValue = true;
            return;
        }
        int n4 = n2 & this.mask;
        int n5 = this.keyTable[n4];
        if (n5 == 0) {
            this.keyTable[n4] = n2;
            this.valueTable[n4] = n3;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n6 = this.hash2(n2);
        int n7 = this.keyTable[n6];
        if (n7 == 0) {
            this.keyTable[n6] = n2;
            this.valueTable[n6] = n3;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n8 = this.hash3(n2);
        int n9 = this.keyTable[n8];
        if (n9 == 0) {
            this.keyTable[n8] = n2;
            this.valueTable[n8] = n3;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(n2, n3, n4, n5, n6, n7, n8, n9);
    }

    private void push(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10;
        int n11;
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        int n12 = this.mask;
        int n13 = 0;
        int n14 = this.pushIterations;
        while (true) {
            switch (MathUtils.random(2)) {
                case 0: {
                    n11 = n5;
                    n10 = nArray2[n4];
                    nArray[n4] = n2;
                    nArray2[n4] = n3;
                    break;
                }
                case 1: {
                    n11 = n7;
                    n10 = nArray2[n6];
                    nArray[n6] = n2;
                    nArray2[n6] = n3;
                    break;
                }
                default: {
                    n11 = n9;
                    n10 = nArray2[n8];
                    nArray[n8] = n2;
                    nArray2[n8] = n3;
                }
            }
            n4 = n11 & n12;
            n5 = nArray[n4];
            if (n5 == 0) {
                nArray[n4] = n11;
                nArray2[n4] = n10;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n6 = this.hash2(n11);
            n7 = nArray[n6];
            if (n7 == 0) {
                nArray[n6] = n11;
                nArray2[n6] = n10;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n8 = this.hash3(n11);
            n9 = nArray[n8];
            if (n9 == 0) {
                nArray[n8] = n11;
                nArray2[n8] = n10;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (++n13 == n14) break;
            n2 = n11;
            n3 = n10;
        }
        this.putStash(n11, n10);
    }

    private void putStash(int n2, int n3) {
        if (this.stashSize == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.put(n2, n3);
            return;
        }
        int n4 = this.capacity + this.stashSize;
        this.keyTable[n4] = n2;
        this.valueTable[n4] = n3;
        ++this.stashSize;
        ++this.size;
    }

    public int get(int n2, int n3) {
        if (n2 == 0) {
            if (!this.hasZeroValue) {
                return n3;
            }
            return this.zeroValue;
        }
        int n4 = n2 & this.mask;
        if (this.keyTable[n4] != n2 && this.keyTable[n4 = this.hash2(n2)] != n2 && this.keyTable[n4 = this.hash3(n2)] != n2) {
            return this.getStash(n2, n3);
        }
        return this.valueTable[n4];
    }

    private int getStash(int n2, int n3) {
        int n4;
        int[] nArray = this.keyTable;
        int n5 = n4 + this.stashSize;
        for (n4 = this.capacity; n4 < n5; ++n4) {
            if (n2 != nArray[n4]) continue;
            return this.valueTable[n4];
        }
        return n3;
    }

    public int getAndIncrement(int n2, int n3, int n4) {
        if (n2 == 0) {
            if (this.hasZeroValue) {
                int n5 = this.zeroValue;
                this.zeroValue += n4;
                return n5;
            }
            this.hasZeroValue = true;
            this.zeroValue = n3 + n4;
            ++this.size;
            return n3;
        }
        int n6 = n2 & this.mask;
        if (n2 != this.keyTable[n6] && n2 != this.keyTable[n6 = this.hash2(n2)] && n2 != this.keyTable[n6 = this.hash3(n2)]) {
            return this.getAndIncrementStash(n2, n3, n4);
        }
        int n7 = this.valueTable[n6];
        this.valueTable[n6] = n7 + n4;
        return n7;
    }

    private int getAndIncrementStash(int n2, int n3, int n4) {
        int n5;
        int[] nArray = this.keyTable;
        int n6 = n5 + this.stashSize;
        for (n5 = this.capacity; n5 < n6; ++n5) {
            if (n2 != nArray[n5]) continue;
            int n7 = this.valueTable[n5];
            this.valueTable[n5] = n7 + n4;
            return n7;
        }
        this.put(n2, n3 + n4);
        return n3;
    }

    public int remove(int n2, int n3) {
        if (n2 == 0) {
            if (!this.hasZeroValue) {
                return n3;
            }
            this.hasZeroValue = false;
            --this.size;
            return this.zeroValue;
        }
        int n4 = n2 & this.mask;
        if (n2 == this.keyTable[n4]) {
            this.keyTable[n4] = 0;
            int n5 = this.valueTable[n4];
            --this.size;
            return n5;
        }
        n4 = this.hash2(n2);
        if (n2 == this.keyTable[n4]) {
            this.keyTable[n4] = 0;
            int n6 = this.valueTable[n4];
            --this.size;
            return n6;
        }
        n4 = this.hash3(n2);
        if (n2 == this.keyTable[n4]) {
            this.keyTable[n4] = 0;
            int n7 = this.valueTable[n4];
            --this.size;
            return n7;
        }
        return this.removeStash(n2, n3);
    }

    int removeStash(int n2, int n3) {
        int n4;
        int[] nArray = this.keyTable;
        int n5 = n4 + this.stashSize;
        for (n4 = this.capacity; n4 < n5; ++n4) {
            if (n2 != nArray[n4]) continue;
            int n6 = this.valueTable[n4];
            this.removeStashIndex(n4);
            --this.size;
            return n6;
        }
        return n3;
    }

    void removeStashIndex(int n2) {
        --this.stashSize;
        int n3 = this.capacity + this.stashSize;
        if (n2 < n3) {
            this.keyTable[n2] = this.keyTable[n3];
            this.valueTable[n2] = this.valueTable[n3];
        }
    }

    public void shrink(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + n2);
        }
        if (this.size > n2) {
            n2 = this.size;
        }
        if (this.capacity <= n2) {
            return;
        }
        n2 = MathUtils.nextPowerOfTwo(n2);
        this.resize(n2);
    }

    public void clear(int n2) {
        if (this.capacity <= n2) {
            this.clear();
            return;
        }
        this.hasZeroValue = false;
        this.size = 0;
        this.resize(n2);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        int[] nArray = this.keyTable;
        int n2 = this.capacity + this.stashSize;
        while (n2-- > 0) {
            nArray[n2] = 0;
        }
        this.size = 0;
        this.stashSize = 0;
        this.hasZeroValue = false;
    }

    public boolean containsValue(int n2) {
        if (this.hasZeroValue && this.zeroValue == n2) {
            return true;
        }
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        int n3 = this.capacity + this.stashSize;
        while (n3-- > 0) {
            if (nArray[n3] == 0 || nArray2[n3] != n2) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(int n2) {
        if (n2 == 0) {
            return this.hasZeroValue;
        }
        int n3 = n2 & this.mask;
        if (this.keyTable[n3] != n2 && this.keyTable[n3 = this.hash2(n2)] != n2 && this.keyTable[n3 = this.hash3(n2)] != n2) {
            return this.containsKeyStash(n2);
        }
        return true;
    }

    private boolean containsKeyStash(int n2) {
        int n3;
        int[] nArray = this.keyTable;
        int n4 = n3 + this.stashSize;
        for (n3 = this.capacity; n3 < n4; ++n3) {
            if (n2 != nArray[n3]) continue;
            return true;
        }
        return false;
    }

    public int findKey(int n2, int n3) {
        if (this.hasZeroValue && this.zeroValue == n2) {
            return 0;
        }
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        int n4 = this.capacity + this.stashSize;
        while (n4-- > 0) {
            if (nArray[n4] == 0 || nArray2[n4] != n2) continue;
            return nArray[n4];
        }
        return n3;
    }

    public void ensureCapacity(int n2) {
        int n3 = this.size + n2;
        if (n3 >= this.threshold) {
            this.resize(MathUtils.nextPowerOfTwo((int)Math.ceil((float)n3 / this.loadFactor)));
        }
    }

    private void resize(int n2) {
        int n3 = this.capacity + this.stashSize;
        this.capacity = n2;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.mask = n2 - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(n2);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(n2)) * 2);
        this.pushIterations = Math.max(Math.min(n2, 8), (int)Math.sqrt(n2) / 8);
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        this.keyTable = new int[n2 + this.stashCapacity];
        this.valueTable = new int[n2 + this.stashCapacity];
        int n4 = this.size;
        this.size = this.hasZeroValue ? 1 : 0;
        this.stashSize = 0;
        if (n4 > 0) {
            for (int i2 = 0; i2 < n3; ++i2) {
                int n5 = nArray[i2];
                if (n5 == 0) continue;
                this.putResize(n5, nArray2[i2]);
            }
        }
    }

    private int hash2(int n2) {
        return ((n2 *= -1262997959) ^ n2 >>> this.hashShift) & this.mask;
    }

    private int hash3(int n2) {
        return ((n2 *= -825114047) ^ n2 >>> this.hashShift) & this.mask;
    }

    public int hashCode() {
        int n2 = 0;
        if (this.hasZeroValue) {
            n2 += Float.floatToIntBits(this.zeroValue);
        }
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        int n3 = this.capacity + this.stashSize;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = nArray[i2];
            if (n4 == 0) continue;
            n2 += n4 * 31;
            int n5 = nArray2[i2];
            n2 += n5;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntIntMap)) {
            return false;
        }
        IntIntMap intIntMap = (IntIntMap)object;
        if (intIntMap.size != this.size) {
            return false;
        }
        if (intIntMap.hasZeroValue != this.hasZeroValue) {
            return false;
        }
        if (this.hasZeroValue && intIntMap.zeroValue != this.zeroValue) {
            return false;
        }
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        int n2 = this.capacity + this.stashSize;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = nArray[i2];
            if (n3 == 0) continue;
            int n4 = intIntMap.get(n3, 0);
            if (n4 == 0 && !intIntMap.containsKey(n3)) {
                return false;
            }
            int n5 = nArray2[i2];
            if (n4 == n5) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int n2;
        if (this.size == 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('{');
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        int n3 = nArray.length;
        if (this.hasZeroValue) {
            stringBuilder.append("0=");
            stringBuilder.append(this.zeroValue);
        } else {
            while (n3-- > 0) {
                n2 = nArray[n3];
                if (n2 == 0) continue;
                stringBuilder.append(n2);
                stringBuilder.append('=');
                stringBuilder.append(nArray2[n3]);
                break;
            }
        }
        while (n3-- > 0) {
            n2 = nArray[n3];
            if (n2 == 0) continue;
            stringBuilder.append(", ");
            stringBuilder.append(n2);
            stringBuilder.append('=');
            stringBuilder.append(nArray2[n3]);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.entries();
    }

    public Entries entries() {
        if (this.entries1 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.reset();
            this.entries1.valid = true;
            this.entries2.valid = false;
            return this.entries1;
        }
        this.entries2.reset();
        this.entries2.valid = true;
        this.entries1.valid = false;
        return this.entries2;
    }

    public Values values() {
        if (this.values1 == null) {
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        if (!this.values1.valid) {
            this.values1.reset();
            this.values1.valid = true;
            this.values2.valid = false;
            return this.values1;
        }
        this.values2.reset();
        this.values2.valid = true;
        this.values1.valid = false;
        return this.values2;
    }

    public Keys keys() {
        if (this.keys1 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.reset();
            this.keys1.valid = true;
            this.keys2.valid = false;
            return this.keys1;
        }
        this.keys2.reset();
        this.keys2.valid = true;
        this.keys1.valid = false;
        return this.keys2;
    }

    public static class Keys
    extends MapIterator {
        public Keys(IntIntMap intIntMap) {
            super(intIntMap);
        }

        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        public int next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            int n2 = this.nextIndex == -1 ? 0 : this.map.keyTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return n2;
        }

        public IntArray toArray() {
            IntArray intArray = new IntArray(true, this.map.size);
            while (this.hasNext) {
                intArray.add(this.next());
            }
            return intArray;
        }
    }

    public static class Values
    extends MapIterator {
        public Values(IntIntMap intIntMap) {
            super(intIntMap);
        }

        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        public int next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            int n2 = this.nextIndex == -1 ? this.map.zeroValue : this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return n2;
        }

        public IntArray toArray() {
            IntArray intArray = new IntArray(true, this.map.size);
            while (this.hasNext) {
                intArray.add(this.next());
            }
            return intArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entries
    extends MapIterator
    implements Iterable<Entry>,
    Iterator<Entry> {
        private Entry entry = new Entry();

        public Entries(IntIntMap intIntMap) {
            super(intIntMap);
        }

        @Override
        public Entry next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            int[] nArray = this.map.keyTable;
            if (this.nextIndex == -1) {
                this.entry.key = 0;
                this.entry.value = this.map.zeroValue;
            } else {
                this.entry.key = nArray[this.nextIndex];
                this.entry.value = this.map.valueTable[this.nextIndex];
            }
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public Iterator<Entry> iterator() {
            return this;
        }

        @Override
        public void remove() {
            super.remove();
        }
    }

    private static class MapIterator {
        static final int INDEX_ILLEGAL = -2;
        static final int INDEX_ZERO = -1;
        public boolean hasNext;
        final IntIntMap map;
        int nextIndex;
        int currentIndex;
        boolean valid = true;

        public MapIterator(IntIntMap intIntMap) {
            this.map = intIntMap;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.map.hasZeroValue) {
                this.hasNext = true;
            } else {
                this.findNextIndex();
            }
        }

        void findNextIndex() {
            this.hasNext = false;
            int[] nArray = this.map.keyTable;
            int n2 = this.map.capacity + this.map.stashSize;
            while (++this.nextIndex < n2) {
                if (nArray[this.nextIndex] == 0) continue;
                this.hasNext = true;
                break;
            }
        }

        public void remove() {
            if (this.currentIndex == -1 && this.map.hasZeroValue) {
                this.map.hasZeroValue = false;
            } else {
                if (this.currentIndex < 0) {
                    throw new IllegalStateException("next must be called before remove.");
                }
                if (this.currentIndex >= this.map.capacity) {
                    this.map.removeStashIndex(this.currentIndex);
                    this.nextIndex = this.currentIndex - 1;
                    this.findNextIndex();
                } else {
                    this.map.keyTable[this.currentIndex] = 0;
                }
            }
            this.currentIndex = -2;
            --this.map.size;
        }
    }

    public static class Entry {
        public int key;
        public int value;

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

