/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.map;

import com.fr.stable.collections.array.FloatArray;
import com.fr.stable.collections.array.IntArray;
import com.fr.stable.collections.utils.GdxRuntimeException;
import com.fr.stable.collections.utils.MathUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntFloatMap
implements Iterable<Entry> {
    private static final int PRIME1 = -1105259343;
    private static final int PRIME2 = -1262997959;
    private static final int PRIME3 = -825114047;
    private static final int EMPTY = 0;
    public int size;
    int[] keyTable;
    float[] valueTable;
    int capacity;
    int stashSize;
    float zeroValue;
    boolean hasZeroValue;
    private float loadFactor;
    private int hashShift;
    private int mask;
    private int threshold;
    private int stashCapacity;
    private int pushIterations;
    private Entries entries1;
    private Entries entries2;
    private Values values1;
    private Values values2;
    private Keys keys1;
    private Keys keys2;

    public IntFloatMap() {
        this(51, 0.8f);
    }

    public IntFloatMap(int n2) {
        this(n2, 0.8f);
    }

    public IntFloatMap(int n2, float f2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: " + n2);
        }
        if ((n2 = MathUtils.nextPowerOfTwo((int)Math.ceil((float)n2 / f2))) > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: " + n2);
        }
        this.capacity = n2;
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: " + f2);
        }
        this.loadFactor = f2;
        this.threshold = (int)((float)this.capacity * f2);
        this.mask = this.capacity - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(this.capacity);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
        this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
        this.keyTable = new int[this.capacity + this.stashCapacity];
        this.valueTable = new float[this.keyTable.length];
    }

    public IntFloatMap(IntFloatMap intFloatMap) {
        this((int)Math.floor((float)intFloatMap.capacity * intFloatMap.loadFactor), intFloatMap.loadFactor);
        this.stashSize = intFloatMap.stashSize;
        System.arraycopy(intFloatMap.keyTable, 0, this.keyTable, 0, intFloatMap.keyTable.length);
        System.arraycopy(intFloatMap.valueTable, 0, this.valueTable, 0, intFloatMap.valueTable.length);
        this.size = intFloatMap.size;
        this.zeroValue = intFloatMap.zeroValue;
        this.hasZeroValue = intFloatMap.hasZeroValue;
    }

    public void put(int n2, float f2) {
        int n3;
        if (n2 == 0) {
            this.zeroValue = f2;
            if (!this.hasZeroValue) {
                this.hasZeroValue = true;
                ++this.size;
            }
            return;
        }
        int[] nArray = this.keyTable;
        int n4 = n2 & this.mask;
        int n5 = nArray[n4];
        if (n2 == n5) {
            this.valueTable[n4] = f2;
            return;
        }
        int n6 = this.hash2(n2);
        int n7 = nArray[n6];
        if (n2 == n7) {
            this.valueTable[n6] = f2;
            return;
        }
        int n8 = this.hash3(n2);
        int n9 = nArray[n8];
        if (n2 == n9) {
            this.valueTable[n8] = f2;
            return;
        }
        int n10 = n3 + this.stashSize;
        for (n3 = this.capacity; n3 < n10; ++n3) {
            if (n2 != nArray[n3]) continue;
            this.valueTable[n3] = f2;
            return;
        }
        if (n5 == 0) {
            nArray[n4] = n2;
            this.valueTable[n4] = f2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        if (n7 == 0) {
            nArray[n6] = n2;
            this.valueTable[n6] = f2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        if (n9 == 0) {
            nArray[n8] = n2;
            this.valueTable[n8] = f2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(n2, f2, n4, n5, n6, n7, n8, n9);
    }

    public void putAll(IntFloatMap intFloatMap) {
        for (Entry entry : intFloatMap.entries()) {
            this.put(entry.key, entry.value);
        }
    }

    private void putResize(int n2, float f2) {
        if (n2 == 0) {
            this.zeroValue = f2;
            this.hasZeroValue = true;
            return;
        }
        int n3 = n2 & this.mask;
        int n4 = this.keyTable[n3];
        if (n4 == 0) {
            this.keyTable[n3] = n2;
            this.valueTable[n3] = f2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n5 = this.hash2(n2);
        int n6 = this.keyTable[n5];
        if (n6 == 0) {
            this.keyTable[n5] = n2;
            this.valueTable[n5] = f2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n7 = this.hash3(n2);
        int n8 = this.keyTable[n7];
        if (n8 == 0) {
            this.keyTable[n7] = n2;
            this.valueTable[n7] = f2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(n2, f2, n3, n4, n5, n6, n7, n8);
    }

    private void push(int n2, float f2, int n3, int n4, int n5, int n6, int n7, int n8) {
        float f3;
        int n9;
        int[] nArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n10 = this.mask;
        int n11 = 0;
        int n12 = this.pushIterations;
        while (true) {
            switch (MathUtils.random(2)) {
                case 0: {
                    n9 = n4;
                    f3 = fArray[n3];
                    nArray[n3] = n2;
                    fArray[n3] = f2;
                    break;
                }
                case 1: {
                    n9 = n6;
                    f3 = fArray[n5];
                    nArray[n5] = n2;
                    fArray[n5] = f2;
                    break;
                }
                default: {
                    n9 = n8;
                    f3 = fArray[n7];
                    nArray[n7] = n2;
                    fArray[n7] = f2;
                }
            }
            n3 = n9 & n10;
            n4 = nArray[n3];
            if (n4 == 0) {
                nArray[n3] = n9;
                fArray[n3] = f3;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n5 = this.hash2(n9);
            n6 = nArray[n5];
            if (n6 == 0) {
                nArray[n5] = n9;
                fArray[n5] = f3;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n7 = this.hash3(n9);
            n8 = nArray[n7];
            if (n8 == 0) {
                nArray[n7] = n9;
                fArray[n7] = f3;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (++n11 == n12) break;
            n2 = n9;
            f2 = f3;
        }
        this.putStash(n9, f3);
    }

    private void putStash(int n2, float f2) {
        if (this.stashSize == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.put(n2, f2);
            return;
        }
        int n3 = this.capacity + this.stashSize;
        this.keyTable[n3] = n2;
        this.valueTable[n3] = f2;
        ++this.stashSize;
        ++this.size;
    }

    public float get(int n2, float f2) {
        if (n2 == 0) {
            if (!this.hasZeroValue) {
                return f2;
            }
            return this.zeroValue;
        }
        int n3 = n2 & this.mask;
        if (this.keyTable[n3] != n2 && this.keyTable[n3 = this.hash2(n2)] != n2 && this.keyTable[n3 = this.hash3(n2)] != n2) {
            return this.getStash(n2, f2);
        }
        return this.valueTable[n3];
    }

    private float getStash(int n2, float f2) {
        int n3;
        int[] nArray = this.keyTable;
        int n4 = n3 + this.stashSize;
        for (n3 = this.capacity; n3 < n4; ++n3) {
            if (n2 != nArray[n3]) continue;
            return this.valueTable[n3];
        }
        return f2;
    }

    public float getAndIncrement(int n2, float f2, float f3) {
        if (n2 == 0) {
            if (this.hasZeroValue) {
                float f4 = this.zeroValue;
                this.zeroValue += f3;
                return f4;
            }
            this.hasZeroValue = true;
            this.zeroValue = f2 + f3;
            ++this.size;
            return f2;
        }
        int n3 = n2 & this.mask;
        if (n2 != this.keyTable[n3] && n2 != this.keyTable[n3 = this.hash2(n2)] && n2 != this.keyTable[n3 = this.hash3(n2)]) {
            return this.getAndIncrementStash(n2, f2, f3);
        }
        float f5 = this.valueTable[n3];
        this.valueTable[n3] = f5 + f3;
        return f5;
    }

    private float getAndIncrementStash(int n2, float f2, float f3) {
        int n3;
        int[] nArray = this.keyTable;
        int n4 = n3 + this.stashSize;
        for (n3 = this.capacity; n3 < n4; ++n3) {
            if (n2 != nArray[n3]) continue;
            float f4 = this.valueTable[n3];
            this.valueTable[n3] = f4 + f3;
            return f4;
        }
        this.put(n2, f2 + f3);
        return f2;
    }

    public float remove(int n2, float f2) {
        if (n2 == 0) {
            if (!this.hasZeroValue) {
                return f2;
            }
            this.hasZeroValue = false;
            --this.size;
            return this.zeroValue;
        }
        int n3 = n2 & this.mask;
        if (n2 == this.keyTable[n3]) {
            this.keyTable[n3] = 0;
            float f3 = this.valueTable[n3];
            --this.size;
            return f3;
        }
        n3 = this.hash2(n2);
        if (n2 == this.keyTable[n3]) {
            this.keyTable[n3] = 0;
            float f4 = this.valueTable[n3];
            --this.size;
            return f4;
        }
        n3 = this.hash3(n2);
        if (n2 == this.keyTable[n3]) {
            this.keyTable[n3] = 0;
            float f5 = this.valueTable[n3];
            --this.size;
            return f5;
        }
        return this.removeStash(n2, f2);
    }

    float removeStash(int n2, float f2) {
        int n3;
        int[] nArray = this.keyTable;
        int n4 = n3 + this.stashSize;
        for (n3 = this.capacity; n3 < n4; ++n3) {
            if (n2 != nArray[n3]) continue;
            float f3 = this.valueTable[n3];
            this.removeStashIndex(n3);
            --this.size;
            return f3;
        }
        return f2;
    }

    void removeStashIndex(int n2) {
        --this.stashSize;
        int n3 = this.capacity + this.stashSize;
        if (n2 < n3) {
            this.keyTable[n2] = this.keyTable[n3];
            this.valueTable[n2] = this.valueTable[n3];
        }
    }

    public void shrink(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + n2);
        }
        if (this.size > n2) {
            n2 = this.size;
        }
        if (this.capacity <= n2) {
            return;
        }
        n2 = MathUtils.nextPowerOfTwo(n2);
        this.resize(n2);
    }

    public void clear(int n2) {
        if (this.capacity <= n2) {
            this.clear();
            return;
        }
        this.hasZeroValue = false;
        this.size = 0;
        this.resize(n2);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        int[] nArray = this.keyTable;
        int n2 = this.capacity + this.stashSize;
        while (n2-- > 0) {
            nArray[n2] = 0;
        }
        this.hasZeroValue = false;
        this.size = 0;
        this.stashSize = 0;
    }

    public boolean containsValue(float f2) {
        if (this.hasZeroValue && this.zeroValue == f2) {
            return true;
        }
        int[] nArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n2 = this.capacity + this.stashSize;
        while (n2-- > 0) {
            if (nArray[n2] == 0 || fArray[n2] != f2) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(float f2, float f3) {
        if (this.hasZeroValue && Math.abs(this.zeroValue - f2) <= f3) {
            return true;
        }
        float[] fArray = this.valueTable;
        int n2 = this.capacity + this.stashSize;
        while (n2-- > 0) {
            if (!(Math.abs(fArray[n2] - f2) <= f3)) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(int n2) {
        if (n2 == 0) {
            return this.hasZeroValue;
        }
        int n3 = n2 & this.mask;
        if (this.keyTable[n3] != n2 && this.keyTable[n3 = this.hash2(n2)] != n2 && this.keyTable[n3 = this.hash3(n2)] != n2) {
            return this.containsKeyStash(n2);
        }
        return true;
    }

    private boolean containsKeyStash(int n2) {
        int n3;
        int[] nArray = this.keyTable;
        int n4 = n3 + this.stashSize;
        for (n3 = this.capacity; n3 < n4; ++n3) {
            if (n2 != nArray[n3]) continue;
            return true;
        }
        return false;
    }

    public int findKey(float f2, int n2) {
        if (this.hasZeroValue && this.zeroValue == f2) {
            return 0;
        }
        int[] nArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n3 = this.capacity + this.stashSize;
        while (n3-- > 0) {
            if (nArray[n3] == 0 || fArray[n3] != f2) continue;
            return nArray[n3];
        }
        return n2;
    }

    public void ensureCapacity(int n2) {
        int n3 = this.size + n2;
        if (n3 >= this.threshold) {
            this.resize(MathUtils.nextPowerOfTwo((int)Math.ceil((float)n3 / this.loadFactor)));
        }
    }

    private void resize(int n2) {
        int n3 = this.capacity + this.stashSize;
        this.capacity = n2;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.mask = n2 - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(n2);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(n2)) * 2);
        this.pushIterations = Math.max(Math.min(n2, 8), (int)Math.sqrt(n2) / 8);
        int[] nArray = this.keyTable;
        float[] fArray = this.valueTable;
        this.keyTable = new int[n2 + this.stashCapacity];
        this.valueTable = new float[n2 + this.stashCapacity];
        int n4 = this.size;
        this.size = this.hasZeroValue ? 1 : 0;
        this.stashSize = 0;
        if (n4 > 0) {
            for (int i2 = 0; i2 < n3; ++i2) {
                int n5 = nArray[i2];
                if (n5 == 0) continue;
                this.putResize(n5, fArray[i2]);
            }
        }
    }

    private int hash2(int n2) {
        return ((n2 *= -1262997959) ^ n2 >>> this.hashShift) & this.mask;
    }

    private int hash3(int n2) {
        return ((n2 *= -825114047) ^ n2 >>> this.hashShift) & this.mask;
    }

    public int hashCode() {
        int n2 = 0;
        if (this.hasZeroValue) {
            n2 += Float.floatToIntBits(this.zeroValue);
        }
        int[] nArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n3 = this.capacity + this.stashSize;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = nArray[i2];
            if (n4 == 0) continue;
            n2 += n4 * 31;
            float f2 = fArray[i2];
            n2 += Float.floatToIntBits(f2);
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntFloatMap)) {
            return false;
        }
        IntFloatMap intFloatMap = (IntFloatMap)object;
        if (intFloatMap.size != this.size) {
            return false;
        }
        if (intFloatMap.hasZeroValue != this.hasZeroValue) {
            return false;
        }
        if (this.hasZeroValue && intFloatMap.zeroValue != this.zeroValue) {
            return false;
        }
        int[] nArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n2 = this.capacity + this.stashSize;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = nArray[i2];
            if (n3 == 0) continue;
            float f2 = intFloatMap.get(n3, 0.0f);
            if (f2 == 0.0f && !intFloatMap.containsKey(n3)) {
                return false;
            }
            float f3 = fArray[i2];
            if (f2 == f3) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int n2;
        if (this.size == 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('{');
        int[] nArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n3 = nArray.length;
        if (this.hasZeroValue) {
            stringBuilder.append("0=");
            stringBuilder.append(this.zeroValue);
        } else {
            while (n3-- > 0) {
                n2 = nArray[n3];
                if (n2 == 0) continue;
                stringBuilder.append(n2);
                stringBuilder.append('=');
                stringBuilder.append(fArray[n3]);
                break;
            }
        }
        while (n3-- > 0) {
            n2 = nArray[n3];
            if (n2 == 0) continue;
            stringBuilder.append(", ");
            stringBuilder.append(n2);
            stringBuilder.append('=');
            stringBuilder.append(fArray[n3]);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.entries();
    }

    public Entries entries() {
        if (this.entries1 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.reset();
            this.entries1.valid = true;
            this.entries2.valid = false;
            return this.entries1;
        }
        this.entries2.reset();
        this.entries2.valid = true;
        this.entries1.valid = false;
        return this.entries2;
    }

    public Values values() {
        if (this.values1 == null) {
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        if (!this.values1.valid) {
            this.values1.reset();
            this.values1.valid = true;
            this.values2.valid = false;
            return this.values1;
        }
        this.values2.reset();
        this.values2.valid = true;
        this.values1.valid = false;
        return this.values2;
    }

    public Keys keys() {
        if (this.keys1 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.reset();
            this.keys1.valid = true;
            this.keys2.valid = false;
            return this.keys1;
        }
        this.keys2.reset();
        this.keys2.valid = true;
        this.keys1.valid = false;
        return this.keys2;
    }

    public static class Keys
    extends MapIterator {
        public Keys(IntFloatMap intFloatMap) {
            super(intFloatMap);
        }

        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        public int next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            int n2 = this.nextIndex == -1 ? 0 : this.map.keyTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return n2;
        }

        public IntArray toArray() {
            IntArray intArray = new IntArray(true, this.map.size);
            while (this.hasNext) {
                intArray.add(this.next());
            }
            return intArray;
        }
    }

    public static class Values
    extends MapIterator {
        public Values(IntFloatMap intFloatMap) {
            super(intFloatMap);
        }

        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        public float next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            float f2 = this.nextIndex == -1 ? this.map.zeroValue : this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return f2;
        }

        public FloatArray toArray() {
            FloatArray floatArray = new FloatArray(true, this.map.size);
            while (this.hasNext) {
                floatArray.add(this.next());
            }
            return floatArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entries
    extends MapIterator
    implements Iterable<Entry>,
    Iterator<Entry> {
        private Entry entry = new Entry();

        public Entries(IntFloatMap intFloatMap) {
            super(intFloatMap);
        }

        @Override
        public Entry next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            int[] nArray = this.map.keyTable;
            if (this.nextIndex == -1) {
                this.entry.key = 0;
                this.entry.value = this.map.zeroValue;
            } else {
                this.entry.key = nArray[this.nextIndex];
                this.entry.value = this.map.valueTable[this.nextIndex];
            }
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public Iterator<Entry> iterator() {
            return this;
        }

        @Override
        public void remove() {
            super.remove();
        }
    }

    private static class MapIterator {
        static final int INDEX_ILLEGAL = -2;
        static final int INDEX_ZERO = -1;
        public boolean hasNext;
        final IntFloatMap map;
        int nextIndex;
        int currentIndex;
        boolean valid = true;

        public MapIterator(IntFloatMap intFloatMap) {
            this.map = intFloatMap;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.map.hasZeroValue) {
                this.hasNext = true;
            } else {
                this.findNextIndex();
            }
        }

        void findNextIndex() {
            this.hasNext = false;
            int[] nArray = this.map.keyTable;
            int n2 = this.map.capacity + this.map.stashSize;
            while (++this.nextIndex < n2) {
                if (nArray[this.nextIndex] == 0) continue;
                this.hasNext = true;
                break;
            }
        }

        public void remove() {
            if (this.currentIndex == -1 && this.map.hasZeroValue) {
                this.map.hasZeroValue = false;
            } else {
                if (this.currentIndex < 0) {
                    throw new IllegalStateException("next must be called before remove.");
                }
                if (this.currentIndex >= this.map.capacity) {
                    this.map.removeStashIndex(this.currentIndex);
                    this.nextIndex = this.currentIndex - 1;
                    this.findNextIndex();
                } else {
                    this.map.keyTable[this.currentIndex] = 0;
                }
            }
            this.currentIndex = -2;
            --this.map.size;
        }
    }

    public static class Entry {
        public int key;
        public float value;

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

