/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable;

import com.fr.stable.ListSet;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final int TYPE_KEY_SET = 0;
    private static final int TYPE_ENTRY_SET = 1;
    private static final int TYPE_VALUES = 2;
    private HashMap<K, V> m_map = null;
    private ListSet<K> m_list = null;
    private transient Set m_keySet = null;
    private transient Set m_entrySet = null;
    private transient Collection m_values = null;

    public ListMap() {
        this.m_map = new HashMap();
        this.m_list = new ListSet();
    }

    public ListMap(int n2) {
        this.m_map = new HashMap(n2);
        this.m_list = new ListSet(n2);
    }

    public ListMap(int n2, float f2) {
        this.m_map = new HashMap(n2, f2);
        this.m_list = new ListSet(n2);
    }

    public ListMap(Map map) {
        if (map == null) {
            this.m_map = new HashMap();
            this.m_list = new ListSet();
        } else {
            this.m_map = new HashMap(map);
            this.m_list = new ListSet(map.keySet());
        }
    }

    @Override
    public V put(K k2, V v2) {
        return this.put(-1, k2, v2);
    }

    @Override
    public V remove(Object object) {
        this.m_list.remove(object);
        return this.m_map.remove(object);
    }

    @Override
    public Set keySet() {
        if (this.m_keySet == null) {
            this.m_keySet = new KeySet();
        }
        return this.m_keySet;
    }

    @Override
    public void clear() {
        this.m_list.clear();
        this.m_map.clear();
    }

    @Override
    public Collection values() {
        if (this.m_values == null) {
            this.m_values = new Values();
        }
        return this.m_values;
    }

    @Override
    public int hashCode() {
        return this.m_map.hashCode();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.m_map.containsKey(object);
    }

    @Override
    public int size() {
        return this.m_map.size();
    }

    @Override
    public Set entrySet() {
        if (this.m_entrySet == null) {
            this.m_entrySet = new EntrySet();
        }
        return this.m_entrySet;
    }

    @Override
    public boolean containsValue(Object object) {
        return this.m_map.containsValue(object);
    }

    @Override
    public void putAll(Map map) {
        if (map != null) {
            this.m_map.putAll(map);
            this.m_list.addAll(map.keySet());
        }
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof ListMap) {
            ListMap listMap = (ListMap)object;
            bl = this.m_map.equals(listMap.m_map);
        }
        return bl;
    }

    @Override
    public boolean isEmpty() {
        return this.m_map.isEmpty();
    }

    @Override
    public V get(Object object) {
        return this.m_map.get(object);
    }

    public V put(int n2, K k2, V v2) {
        Object object;
        if (n2 != -1) {
            object = this.m_list.get(n2);
            this.m_map.remove(object);
            this.m_list.remove(n2);
        }
        object = this.m_map.put(k2, v2);
        if (n2 == -1) {
            this.m_list.add(k2);
        } else {
            this.m_list.add(n2, k2);
        }
        return (V)object;
    }

    public Object getByIndex(int n2) {
        return this.get(this.m_list.get(n2));
    }

    public K getKeyByIndex(int n2) {
        return this.m_list.get(n2);
    }

    public Object remove(int n2) {
        return this.remove(this.m_list.get(n2));
    }

    public int indexOf(Object object) {
        return this.m_list.indexOf(object);
    }

    public Object clone() throws CloneNotSupportedException {
        ListMap listMap = (ListMap)super.clone();
        if (this.m_map != null) {
            listMap.m_map = (HashMap)this.m_map.clone();
        }
        if (this.m_list != null) {
            listMap.m_list = (ListSet)this.m_list.clone();
        }
        listMap.m_keySet = null;
        listMap.m_entrySet = null;
        listMap.m_values = null;
        return listMap;
    }

    private Iterator getIterator(int n2) {
        return new ListMapIterator(n2);
    }

    private Map.Entry getEntry(Object object, Object object2) {
        return new ListMapEntry(object, object2);
    }

    private abstract class EmbSet
    extends AbstractSet {
        private EmbSet() {
        }

        public int size() {
            return ListMap.this.size();
        }

        public void clear() {
            ListMap.this.clear();
        }
    }

    private class ListMapEntry
    implements Map.Entry {
        Object m_key = null;
        Object m_value = null;

        private ListMapEntry(Object object, Object object2) {
            this.m_key = object;
            this.m_value = object2;
        }

        public Object getKey() {
            return this.m_key;
        }

        public int hashCode() {
            return (this.m_key == null ? 0 : this.m_key.hashCode()) + (this.m_value == null ? 0 : this.m_value.hashCode());
        }

        public Object getValue() {
            return this.m_value;
        }

        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof ListMapEntry) {
                ListMapEntry listMapEntry = (ListMapEntry)object;
                bl = (this.getKey() == null ? listMapEntry.getKey() == null : this.getKey().equals(listMapEntry.getKey())) && (this.getValue() == null ? listMapEntry.getValue() == null : this.getValue().equals(listMapEntry.getValue()));
            }
            return bl;
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        public int size() {
            return ListMap.this.size();
        }

        public boolean contains(Object object) {
            return ListMap.this.containsValue(object);
        }

        public void clear() {
            ListMap.this.clear();
        }

        public Iterator iterator() {
            return ListMap.this.getIterator(2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends EmbSet {
        private EntrySet() {
        }

        @Override
        public boolean contains(Object object) {
            Map.Entry entry;
            Object k2;
            boolean bl = false;
            if (object != null && object instanceof Map.Entry && ListMap.this.containsKey(k2 = (entry = (Map.Entry)object).getKey())) {
                Object v2 = ListMap.this.get(k2);
                Object v3 = entry.getValue();
                bl = v2 == null ? v3 == null : v2.equals(v3);
            }
            return bl;
        }

        @Override
        public boolean remove(Object object) {
            boolean bl = false;
            if (object != null && object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Object k2 = entry.getKey();
                int n2 = this.size();
                ListMap.this.remove(k2);
                bl = n2 != this.size();
            }
            return bl;
        }

        @Override
        public Iterator iterator() {
            return ListMap.this.getIterator(1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends EmbSet {
        private KeySet() {
        }

        @Override
        public boolean contains(Object object) {
            return ListMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            int n2 = this.size();
            ListMap.this.remove(object);
            return this.size() != n2;
        }

        @Override
        public Iterator iterator() {
            return ListMap.this.getIterator(0);
        }
    }

    private class ListMapIterator
    implements Iterator {
        private Iterator m_iterator = null;
        private int m_type;
        private Object m_lastReturned = null;

        private ListMapIterator(int n2) {
            this.m_type = n2;
            this.m_iterator = ListMap.this.m_list.iterator();
        }

        public boolean hasNext() {
            return this.m_iterator.hasNext();
        }

        public Object next() {
            this.m_lastReturned = this.m_iterator.next();
            Object object = null;
            switch (this.m_type) {
                case 0: {
                    object = this.m_lastReturned;
                    break;
                }
                case 1: {
                    Object v2 = ListMap.this.get(this.m_lastReturned);
                    object = ListMap.this.getEntry(this.m_lastReturned, v2);
                    break;
                }
                case 2: {
                    object = ListMap.this.get(this.m_lastReturned);
                }
            }
            return object;
        }

        public void remove() {
            this.m_iterator.remove();
            ListMap.this.remove(this.m_lastReturned);
        }
    }
}

