/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable;

import com.fr.stable.ColumnRowRelated;
import com.fr.stable.StableUtils;
import com.fr.stable.script.CalculatorKey;
import java.io.Serializable;

public class ColumnRow
implements Serializable,
Cloneable,
ColumnRowRelated {
    public static CalculatorKey CURRENT_CR_KEY = CalculatorKey.createKey("CURRENT_CR");
    private static final int CACHE_COLUMN = 50;
    private static final int CACHE_ROW = 10000;
    public final int column;
    public final int row;
    public static final ColumnRow ERROR = new ColumnRow(-1, -1);

    public static ColumnRow valueOf(int n2, int n3) {
        if (ColumnRow.isInCache(n2, n3)) {
            return ColumnRowCache.CACHE[n2][n3];
        }
        return new ColumnRow(n2, n3);
    }

    private static boolean isInCache(int n2, int n3) {
        return n2 >= 0 && n2 < 50 && n3 >= 0 && n3 < 10000;
    }

    public static ColumnRow valueOf(String string) {
        ColumnRow columnRow = ERROR;
        try {
            char[] cArray = string.trim().toCharArray();
            int n2 = cArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = cArray[i2];
                if (!StableUtils.isNum(c2)) continue;
                if (i2 > 0) {
                    String string2 = new String(cArray, 0, i2);
                    String string3 = new String(cArray, i2, n2 - i2);
                    columnRow = ColumnRow.valueOf(StableUtils.convertABCToInt(string2) - 1, Integer.parseInt(string3) - 1);
                }
                break;
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return columnRow;
    }

    public static boolean validate(ColumnRow columnRow) {
        return columnRow != null && columnRow.getColumn() >= 0 && columnRow.getRow() >= 0;
    }

    protected ColumnRow(int n2, int n3) {
        this.column = n2;
        this.row = n3;
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public ColumnRow[] getRelatedColumnRows() {
        return new ColumnRow[]{this};
    }

    public String toString() {
        return StableUtils.convertIntToABC(this.column + 1) + (this.row + 1);
    }

    public String stateDescription() {
        return this.toString() + "_value_state";
    }

    public int hashCode() {
        int n2 = 17;
        n2 = 37 * n2 + this.column;
        n2 = 37 * n2 + this.row;
        return n2;
    }

    public boolean equals(Object object) {
        return object instanceof ColumnRow && ((ColumnRow)object).row == this.row && ((ColumnRow)object).column == this.column;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private static class ColumnRowCache {
        static final ColumnRow[][] CACHE = new ColumnRow[50][10000];

        private ColumnRowCache() {
        }

        static {
            for (int i2 = 0; i2 < CACHE.length; ++i2) {
                int n2 = CACHE[i2].length;
                for (int i3 = 0; i3 < n2; ++i3) {
                    ColumnRowCache.CACHE[i2][i3] = new ColumnRow(i2, i3);
                }
            }
        }
    }
}

