/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.write;

import com.fr.base.FRContext;
import com.fr.data.TableDataSource;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.report.core.namespace.SimpleCellValueNameSpace;
import com.fr.report.report.Report;
import com.fr.report.write.MismatchException;
import com.fr.report.write.SubmitVisitor;
import com.fr.script.Calculator;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.Map;

public abstract class AbstractSubmitVisitor
implements SubmitVisitor {
    private String name;
    private String condition;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String string) {
        this.condition = string;
    }

    public void execute(Report report, TableDataSource tableDataSource, Map map) throws Exception {
        if (!StringUtils.isBlank(this.condition)) {
            Calculator calculator = Calculator.createCalculator();
            calculator.pushNameSpace(SimpleCellValueNameSpace.getInstance());
            calculator.setAttribute(Report.KEY, (Object)report);
            calculator.setAttribute(TableDataSource.KEY, (Object)tableDataSource);
            Object object = calculator.evalValue(this.condition);
            if (!ComparatorUtils.equals(Boolean.TRUE, object)) {
                FRContext.getLogger().info("The condition " + this.condition + " is non-compliance");
                throw new MismatchException();
            }
        }
    }

    public Object __mod_column_row(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        return mOD_COLUMN_ROW;
    }

    public boolean isBuiltin() {
        return false;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Condition".equals(string)) {
                this.setCondition(xMLableReader.getElementValue());
            } else if ("Name".equals(string)) {
                this.setName(xMLableReader.getElementValue());
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (StringUtils.isNotBlank(this.condition)) {
            xMLPrintWriter.startTAG("Condition").textNode(this.condition).end();
        }
        if (StringUtils.isNotBlank(this.name)) {
            xMLPrintWriter.startTAG("Name").textNode(this.name).end();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

