/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web.style;

import com.fr.base.FRContext;
import com.fr.cluster.rpc.RPC;
import com.fr.file.BaseClusterHelper;
import com.fr.file.XMLFileManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralContext;
import com.fr.report.web.style.CustomStyleManagerProvider;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLTools;
import com.fr.stable.xml.XMLableReader;
import java.io.InputStream;

public class CustomStyleXMLFileManager
extends XMLFileManager
implements CustomStyleManagerProvider {
    private static final String XML_TAG = "CustomStyleSelectionManager";
    private static final String TOAST_TAG = "ToastStyle";
    private static final String DEFAULT_STYLE = "Default";
    private static CustomStyleManagerProvider manager = null;
    private String toastSelection;

    public static synchronized CustomStyleXMLFileManager getInstance() {
        return (CustomStyleXMLFileManager)CustomStyleXMLFileManager.getProviderInstance();
    }

    private static synchronized void envChanged() {
        manager = null;
    }

    public static synchronized CustomStyleManagerProvider getProviderInstance() {
        if (manager == null) {
            if (CustomStyleXMLFileManager.isClusterMember()) {
                return manager;
            }
            manager.readXMLFile();
        }
        return manager;
    }

    private static synchronized boolean isClusterMember() {
        switch (BaseClusterHelper.getClusterState()) {
            case LEADER: {
                manager = new CustomStyleXMLFileManager();
                RPC.registerSkeleton(manager);
                return false;
            }
            case MEMBER: {
                String string = BaseClusterHelper.getMainServiceIP();
                manager = (CustomStyleManagerProvider)RPC.getProxy(CustomStyleXMLFileManager.class, string);
                return true;
            }
        }
        manager = new CustomStyleXMLFileManager();
        return false;
    }

    public static synchronized void readInputStream(InputStream inputStream) throws Exception {
        CustomStyleXMLFileManager customStyleXMLFileManager = new CustomStyleXMLFileManager();
        XMLTools.readInputStreamXML(customStyleXMLFileManager, inputStream);
        manager = customStyleXMLFileManager;
        FRContext.getCurrentEnv().writeResource(manager);
    }

    public String fileName() {
        return "customstyle.xml";
    }

    public String getToastSelection() {
        return this.toastSelection;
    }

    public void setToastSelection(String string) {
        this.toastSelection = string;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && ComparatorUtils.equals(string = xMLableReader.getTagName(), TOAST_TAG)) {
            this.toastSelection = xMLableReader.getAttrAsString("toast", DEFAULT_STYLE);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        if (StringUtils.isNotEmpty(this.toastSelection)) {
            xMLPrintWriter.startTAG(TOAST_TAG).attr("toast", this.toastSelection).end();
        }
        xMLPrintWriter.end();
    }

    public boolean writeResource() throws Exception {
        return FRContext.getCurrentEnv().writeResource(CustomStyleXMLFileManager.getProviderInstance());
    }

    public static void reinit() {
        CustomStyleXMLFileManager.envChanged();
        CustomStyleXMLFileManager.getProviderInstance();
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                CustomStyleXMLFileManager.envChanged();
            }
        });
    }
}

