/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.web;

import com.fr.form.event.Listener;
import com.fr.general.ComparatorUtils;
import com.fr.js.JavaScriptImpl;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.report.web.WebContent;
import com.fr.stable.ArrayUtils;
import com.fr.stable.ColumnRow;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.xml.SynchronizedFrozenColumnRow;
import java.awt.Color;

public class WebWrite
extends WebContent {
    public static final String EVENT_BEFORE_VERIFY_WRITE = "beforeverifywrite";
    public static final String EVENT_AFTER_VERIFY_WRITE = "afterverifywrite";
    public static final String EVENT_AFTER_VERIFY = "afterverify";
    public static final String EVENT_BEFORE_WRITE = "beforewrite";
    public static final String EVENT_AFTER_WRITE = "afterwrite";
    public static final String EVENT_WRITE_SUCCESS = "writesuccess";
    public static final String EVENT_WRITE_FAILURE = "writefailure";
    public static final String EVENT_BEFORE_APPEND = "beforeappend";
    public static final String EVENT_AFTER_APPEND = "afterappend";
    public static final String EVENT_BEFORE_DELETE = "beforedelete";
    public static final String EVENT_AFTER_DELETE = "afterdelete";
    public static final String EVENT_UNLOAD_CHECK = "unloadcheck";
    private Color selectedColor = new Color(102, 231, 255);
    private int sheetPosition = 3;
    private boolean reportPosition = true;
    private boolean unloadCheck = true;
    private boolean showWidgets = false;
    private boolean isAutoStash = false;

    public WebWrite() {
        WebContent.DEFAULT_ARGS.put(EVENT_AFTER_VERIFY, new String[]{"fr_verifyinfo"});
        WebContent.DEFAULT_ARGS.put(EVENT_AFTER_WRITE, new String[]{"fr_submitinfo"});
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void setEmptyColor() {
        this.selectedColor = null;
    }

    public void setSelectedColor(Color color) {
        this.selectedColor = color;
    }

    public String getColor() {
        return "rgb(" + this.selectedColor.getRed() + "," + this.selectedColor.getGreen() + "," + this.selectedColor.getBlue() + ")";
    }

    public boolean isUnloadCheck() {
        return this.unloadCheck;
    }

    public void setUnloadCheck(boolean bl) {
        this.unloadCheck = bl;
    }

    public boolean isShowWidgets() {
        return this.showWidgets;
    }

    public void setShowWidgets(boolean bl) {
        this.showWidgets = bl;
    }

    public boolean isAutoStash() {
        return this.isAutoStash;
    }

    public void setAutoStash(boolean bl) {
        this.isAutoStash = bl;
    }

    public String[] supportedEvents() {
        return ArrayUtils.addAll(super.supportedEvents(), new String[]{EVENT_AFTER_VERIFY, EVENT_BEFORE_VERIFY_WRITE, EVENT_AFTER_VERIFY_WRITE, EVENT_BEFORE_WRITE, EVENT_AFTER_WRITE, EVENT_WRITE_SUCCESS, EVENT_WRITE_FAILURE, EVENT_BEFORE_APPEND, EVENT_AFTER_APPEND, EVENT_BEFORE_DELETE, EVENT_AFTER_DELETE, "beforeimportexcel", "afterimportexcel"});
    }

    public boolean equals(Object object) {
        if (!(object instanceof WebWrite)) {
            return false;
        }
        return ComparatorUtils.equals(((WebWrite)object).selectedColor, this.selectedColor);
    }

    public JSONArray createJSONListener(Repository repository) throws JSONException {
        for (int i2 = 0; i2 < this.getListenerSize(); ++i2) {
            Listener listener = this.getListener(i2);
            String[] stringArray = WebContent.getDefaultArg(listener.getEventName());
            if (stringArray == null || !(listener.getAction() instanceof JavaScriptImpl)) continue;
            JavaScriptImpl javaScriptImpl = (JavaScriptImpl)listener.getAction();
            javaScriptImpl.setDefaultPara(stringArray[0]);
        }
        return super.createJSONListener(repository);
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            if (xMLableReader.getTagName().equals("FrozenColumnRow")) {
                ColumnRow columnRow;
                String string = xMLableReader.getAttrAsString("columnrow", null);
                if (string != null && ColumnRow.validate(columnRow = ColumnRow.valueOf(string))) {
                    SynchronizedFrozenColumnRow.putSynchronizedFrozenColumnRow(columnRow);
                }
            } else if (xMLableReader.getTagName().equals("SelectedColor")) {
                String string = xMLableReader.getAttrAsString("color", null);
                if (string != null) {
                    this.setSelectedColor(new Color(Integer.parseInt(string), true));
                } else {
                    this.setEmptyColor();
                }
            } else if (xMLableReader.getTagName().equals("WebWrite")) {
                if (xMLableReader.getAttrAsInt("SheetPosition", 3) == 1 || xMLableReader.getAttrAsString("isSheet", "false").equalsIgnoreCase("true")) {
                    this.setSheetPosition(1);
                } else if (xMLableReader.getAttrAsInt("SheetPosition", 3) == 3 || xMLableReader.getAttrAsString("isSheet", "false").equalsIgnoreCase("false")) {
                    this.setSheetPosition(3);
                }
            } else if (xMLableReader.getTagName().equals("RptLocation")) {
                if (xMLableReader.getAttrAsString("isShowAtLeft", "true").equalsIgnoreCase("false")) {
                    this.setViewAtLeft(false);
                }
            } else if (xMLableReader.getTagName().equals("UnloadCheck")) {
                if (xMLableReader.getAttrAsString("check", "true").equalsIgnoreCase("false")) {
                    this.setUnloadCheck(false);
                }
            } else if (xMLableReader.getTagName().equals("ShowWidgets")) {
                boolean bl = xMLableReader.getAttrAsBoolean("show", false);
                if (xMLableReader.getXMLVersion().isAfterWebWriteError()) {
                    this.setShowWidgets(bl);
                } else {
                    this.setShowWidgets(!bl);
                }
            } else if (xMLableReader.getTagName().equals("OtherAttr")) {
                this.setAutoStash(xMLableReader.getAttrAsBoolean("isAutoStash", false));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("SelectedColor");
        if (this.selectedColor != null) {
            xMLPrintWriter.attr("color", this.selectedColor.getRGB());
        }
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("WebWrite");
        xMLPrintWriter.attr("SheetPosition", this.sheetPosition);
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("RptLocation");
        xMLPrintWriter.attr("isShowAtLeft", this.reportPosition);
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("UnloadCheck");
        if (!this.unloadCheck) {
            xMLPrintWriter.attr("check", false);
        }
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("ShowWidgets");
        if (this.showWidgets) {
            xMLPrintWriter.attr("show", true);
        }
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("OtherAttr");
        xMLPrintWriter.attr("isAutoStash", this.isAutoStash);
        xMLPrintWriter.end();
    }

    public int getSheetPosition() {
        return this.sheetPosition;
    }

    public void setSheetPosition(int n2) {
        this.sheetPosition = n2;
    }

    public boolean isViewAtLeft() {
        return this.reportPosition;
    }

    public void setViewAtLeft(boolean bl) {
        this.reportPosition = bl;
    }
}

