/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.stable;

import com.fr.general.ComparatorUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.io.Serializable;

public class ColumnRowMappingArray
implements Serializable {
    private int[] rowMappingArray = null;
    private int[] columnMappingArray = null;

    public int[] getRowMappingArray() {
        return this.rowMappingArray;
    }

    public void setRowMappingArray(int[] nArray) {
        this.rowMappingArray = nArray;
    }

    public int[] getColumnMappingArray() {
        return this.columnMappingArray;
    }

    public void setColumnMappingArray(int[] nArray) {
        this.columnMappingArray = nArray;
    }

    public void readColumnRowMappingXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (ComparatorUtils.equals(string, "OIRowIntList")) {
                this.readRowMapping(xMLableReader);
            } else if (ComparatorUtils.equals(string, "OIColumnIntList")) {
                this.readColumnMapping(xMLableReader);
            }
        }
    }

    private void readRowMapping(XMLableReader xMLableReader) {
        String string = xMLableReader.getElementValue();
        if (string != null) {
            String[] stringArray = StableUtils.splitString(string, ',');
            this.rowMappingArray = new int[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2] == null || stringArray[i2].length() <= 0) continue;
                this.rowMappingArray[i2] = Integer.parseInt(stringArray[i2]);
            }
        }
    }

    private void readColumnMapping(XMLableReader xMLableReader) {
        String string = xMLableReader.getElementValue();
        if (string != null) {
            String[] stringArray = StableUtils.splitString(string, ',');
            this.columnMappingArray = new int[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2] == null || stringArray[i2].length() <= 0) continue;
                this.columnMappingArray[i2] = Integer.parseInt(stringArray[i2]);
            }
        }
    }

    public void writeColumnRowMappings(XMLPrintWriter xMLPrintWriter) {
        if (this.rowMappingArray != null) {
            this.writeRowMapping(xMLPrintWriter);
        }
        if (this.columnMappingArray != null) {
            this.writeColumnMapping(xMLPrintWriter);
        }
    }

    private void writeColumnMapping(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("OIColumnIntList");
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.columnMappingArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.columnMappingArray[i2]);
        }
        xMLPrintWriter.textNode(stringBuffer.toString());
        xMLPrintWriter.end();
    }

    private void writeRowMapping(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("OIRowIntList");
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.rowMappingArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.rowMappingArray[i2]);
        }
        xMLPrintWriter.textNode(stringBuffer.toString());
        xMLPrintWriter.end();
    }
}

