/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core;

import com.fr.report.cell.Cell;
import com.fr.report.cellcase.CellCase;
import com.fr.report.cellcase.DefaultCellCase;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SupportAddCellCaseContainer
extends DefaultCellCase {
    private static final long serialVersionUID = 7361398637897197787L;
    private CellCase packee;

    public static SupportAddCellCaseContainer pack(CellCase cellCase) {
        return new SupportAddCellCaseContainer(cellCase);
    }

    private SupportAddCellCaseContainer(CellCase cellCase) {
        this.packee = cellCase;
    }

    public void add(Cell cell, boolean bl) {
        if (cell == null) {
            return;
        }
        int n2 = cell.getRow();
        int n3 = cell.getRowSpan();
        int n4 = cell.getColumn();
        int n5 = cell.getColumnSpan();
        if (n2 < 0 || n3 <= 0 || n4 < 0 || n5 <= 0) {
            return;
        }
        if (this.packee.intersect(n4, n2, n5, n3).hasNext()) {
            throw new UnsupportedOperationException();
        }
        super.add(cell, bl);
    }

    public Iterator cellIterator() {
        return new ContainerCellIterator(this.packee.cellIterator(), super.cellIterator());
    }

    public Cell get(int n2, int n3) {
        if (n2 < 0 || n3 < 0 || n2 > this.getColumnCount() || n3 > this.getRowCount()) {
            throw new IndexOutOfBoundsException();
        }
        Cell cell = null;
        try {
            cell = this.packee.get(n2, n3);
            if (cell == null) {
                cell = super.get(n2, n3);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return cell;
    }

    public Iterator getColumn(int n2) {
        return new ContainerCellIterator(this.packee.getColumn(n2), super.getColumn(n2));
    }

    public int getColumnCount() {
        return Math.max(this.packee.getColumnCount(), super.getColumnCount());
    }

    public Iterator getRow(int n2) {
        return new ContainerCellIterator(this.packee.getRow(n2), super.getRow(n2));
    }

    public int getRowCount() {
        return Math.max(this.packee.getRowCount(), super.getRowCount());
    }

    public Iterator intersect(int n2, int n3, int n4, int n5) {
        return new ContainerCellIterator(this.packee.intersect(n2, n3, n4, n5), super.intersect(n2, n3, n4, n5));
    }

    public void recalculate() {
        this.packee.recalculate();
        super.recalculate();
    }

    public void releaseCache() {
        this.packee.releaseCache();
        super.releaseCache();
    }

    public Object clone() throws CloneNotSupportedException {
        SupportAddCellCaseContainer supportAddCellCaseContainer = (SupportAddCellCaseContainer)super.clone();
        supportAddCellCaseContainer.packee = (CellCase)this.packee.clone();
        return supportAddCellCaseContainer;
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void insertColumn(int n2) {
        throw new UnsupportedOperationException();
    }

    public void insertRow(int n2) {
        throw new UnsupportedOperationException();
    }

    public Cell removeCell(int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    public int removeColumn(int n2) {
        throw new UnsupportedOperationException();
    }

    public int removeRow(int n2) {
        throw new UnsupportedOperationException();
    }

    public void toCache(int n2, int n3, boolean bl) {
        throw new UnsupportedOperationException();
    }

    private class ContainerCellIterator
    implements Iterator {
        private Iterator packeei;
        private Iterator superi;
        private Cell packee_next = null;
        private Cell super_next = null;

        ContainerCellIterator(Iterator iterator, Iterator iterator2) {
            this.packeei = iterator;
            this.superi = iterator2;
            this.findPackeeNext();
            this.findSuperNext();
        }

        public boolean hasNext() {
            return this.packee_next != null || this.super_next != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("At last element");
            }
            Cell cell = this.packee_next == null ? this.super_next : (this.super_next == null ? this.packee_next : (this.packee_next.getRow() == this.super_next.getRow() ? (this.packee_next.getColumn() <= this.super_next.getColumn() ? this.packee_next : this.super_next) : (this.packee_next.getRow() < this.super_next.getRow() ? this.packee_next : this.super_next)));
            if (cell == this.packee_next) {
                this.findPackeeNext();
            } else {
                this.findSuperNext();
            }
            return cell;
        }

        private void findPackeeNext() {
            this.packee_next = this.packeei.hasNext() ? (Cell)this.packeei.next() : null;
        }

        private void findSuperNext() {
            this.super_next = this.superi.hasNext() ? (Cell)this.superi.next() : null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

