/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.painter.barcode.line.ean13;

import com.fr.base.FRContext;
import com.fr.general.Inter;
import com.fr.report.cell.painter.barcode.BarcodeException;
import com.fr.report.cell.painter.barcode.BarcodeImpl;
import com.fr.report.cell.painter.barcode.Module;
import com.fr.report.cell.painter.barcode.line.ean13.ModuleFactory;
import com.fr.report.cell.painter.barcode.output.AbstractOutput;
import java.awt.Dimension;
import java.text.StringCharacterIterator;
import java.util.ArrayList;

public class UPCABarcode
extends BarcodeImpl {
    public static final String[] TYPES = new String[]{"UPC-A", "UPCA"};
    protected boolean requiresChecksum = false;
    protected final String label;
    protected int width = 0;
    protected static final int CHECKSUM_WEIGHT_EVEN = 1;
    protected static final int CHECKSUM_WEIGHT_ODD = 3;
    public static final int BARCODE_LENGTH = 11;

    public UPCABarcode(String string) throws BarcodeException {
        this(string, false);
    }

    public UPCABarcode(String string, boolean bl) throws BarcodeException {
        super(UPCABarcode.validateChars(string));
        if (string.length() != this.getBarcodeLength()) {
            if (string.length() > 12) {
                string = string.substring(0, 12);
                FRContext.getLogger().info(Inter.getLocText("Ean13_more_than_12"));
            } else {
                FRContext.getLogger().error(Inter.getLocText("Ean13_less_than_12"));
            }
        }
        this.requiresChecksum = true;
        if (bl) {
            string = this.populateRandonWeightCheckDigit(string);
        }
        this.label = string;
    }

    protected int getBarcodeLength() {
        return 11;
    }

    protected Dimension draw(AbstractOutput abstractOutput, int n2, int n3, double d2, double d3) {
        int n4;
        int n5;
        int n6 = n2;
        abstractOutput.beginDraw(d2, d3);
        double d4 = 0.0;
        double d5 = d3;
        double d6 = 10.0 * d2;
        if (this.drawingText) {
            d5 = d3 - 11.0 * d2;
            d4 = d5 + 6.0 * d2;
        } else {
            d5 = d3 - 6.0 * d2;
            d4 = d3;
        }
        String string = this.getLabel();
        int n7 = (int)this.barHeight + n3;
        Module[] moduleArray = this.encodeData();
        String string2 = String.valueOf(string.charAt(0));
        String string3 = String.valueOf(string.charAt(string.length() - 1));
        String string4 = string.substring(1, this.getLeftWidth());
        String string5 = string.substring(this.getLeftWidth(), 11);
        if (this.requiresChecksum) {
            string3 = this.calculateChecksum().getSymbol();
        }
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = n2;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        Module module = this.getPreAmble();
        Module module2 = this.getPostAmble();
        n12 = 0;
        n8 = n2;
        n12 = n6 - n8;
        n16 = n6;
        int n17 = this.getGuardCharSize();
        int n18 = this.getLeftWidth();
        if (module != null) {
            n6 = (int)((double)n6 + this.drawModule(module, abstractOutput, n6, n3, d2, d4));
        }
        for (n5 = 0; n5 < n17; ++n5) {
            n6 = (int)((double)n6 + this.drawModule(moduleArray[0], abstractOutput, n6, n3, d2, d4));
        }
        n9 = n6;
        n16 = n6 - n16;
        for (n5 = n17; n5 < n18; ++n5) {
            n6 = (int)((double)n6 + this.drawModule(moduleArray[n5], abstractOutput, n6, n3, d2, d5));
        }
        n13 = n6 - n9;
        n16 = n6;
        n10 = n6 = (int)((double)n6 + this.drawModule(this.getCentreGuard(), abstractOutput, n6, n3, d2, d4));
        n16 = n6 - n16;
        n5 = moduleArray.length - n17;
        for (n4 = n18; n4 < n5; ++n4) {
            n6 = (int)((double)n6 + this.drawModule(moduleArray[n4], abstractOutput, n6, n3, d2, d5));
        }
        n14 = n6 - n10;
        n16 = n6;
        for (n4 = n5; n4 < moduleArray.length; ++n4) {
            n6 = (int)((double)n6 + this.drawModule(moduleArray[n4], abstractOutput, n6, n3, d2, d4));
        }
        if (module2 != null) {
            n6 = (int)((double)n6 + this.drawModule(module2, abstractOutput, n6, n3, d2, d4));
        }
        n16 = n6 - n16;
        n11 = n6;
        n15 = n6 - n11;
        if (this.drawingText) {
            abstractOutput.drawText(string2, n2, n3, d2);
            abstractOutput.drawText(string4, n2, n3, d2);
            abstractOutput.drawText(string5, n2, n3, d2);
            abstractOutput.drawText(string3, n2, n3, d2);
        }
        Dimension dimension = new Dimension(n6 - n2, n7 - n3);
        abstractOutput.endDraw();
        return dimension;
    }

    public String getLabel() {
        return this.label;
    }

    protected double getBarcodeWidth(int n2) {
        this.encodeData();
        return this.barWidth * (double)this.width;
    }

    protected Module[] encodeData() {
        ArrayList<Module> arrayList = new ArrayList<Module>();
        Module module = null;
        int n2 = this.data.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = this.data.charAt(i2);
            module = ModuleFactory.getModule(String.valueOf(c2), i2);
            this.width += module.widthInBars();
            arrayList.add(module);
        }
        if (this.requiresChecksum) {
            module = ModuleFactory.getModule(this.calculateChecksum().getSymbol(), arrayList.size() - 1);
            this.width += module.widthInBars();
            arrayList.add(module);
        }
        return arrayList.toArray(new Module[0]);
    }

    protected Module calculateChecksum() {
        if (this.requiresChecksum) {
            return ModuleFactory.getModuleForIndex(UPCABarcode.getModCheckDigit(this.data));
        }
        return null;
    }

    protected int getGuardCharSize() {
        return 1;
    }

    protected int getLeftWidth() {
        return 6;
    }

    protected Module getLeftMargin() {
        return ModuleFactory.LEFT_MARGIN;
    }

    protected Module getRightMargin() {
        return ModuleFactory.RIGHT_MARGIN;
    }

    protected Module getPreAmble() {
        return ModuleFactory.LEFT_GUARD;
    }

    protected Module getCentreGuard() {
        return ModuleFactory.CENTRE_GUARD;
    }

    protected Module getPostAmble() {
        return ModuleFactory.RIGHT_GUARD;
    }

    public static int getModCheckDigit(String string) {
        int n2;
        int n3 = 0;
        int n4 = string.length();
        for (n2 = 0; n2 < n4; ++n2) {
            try {
                int n5 = Integer.parseInt(String.valueOf(string.charAt(n2)));
                n3 += UPCABarcode.calculateChecksum(n5, n2 % 2 == 1);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        n2 = 10 - n3 % 10;
        if (n2 == 10) {
            n2 = 0;
        }
        return n2;
    }

    protected static int calculateChecksum(int n2, boolean bl) {
        if (bl) {
            return n2 * 1;
        }
        return n2 * 3;
    }

    private static String validateChars(String string) throws BarcodeException {
        if (string == null) {
            throw new IllegalArgumentException("data param must contain a value, not null");
        }
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c2 = stringCharacterIterator.first();
        while (c2 != '\uffff') {
            if (!ModuleFactory.hasModule(String.valueOf(c2))) {
                throw new BarcodeException("Illegal character");
            }
            c2 = stringCharacterIterator.next();
        }
        return string;
    }

    private String populateRandonWeightCheckDigit(String string) {
        int[][] nArrayArray = new int[][]{{0, 2, 4, 6, 8, 9, 1, 3, 5, 7}, {0, 3, 6, 9, 2, 5, 8, 1, 4, 7}, {0, 5, 9, 4, 8, 3, 7, 2, 6, 1}};
        int n2 = 0;
        int n3 = 0;
        char[] cArray = string.toCharArray();
        int n4 = Character.digit(cArray[7], 10);
        n2 += nArrayArray[0][n4];
        n4 = Character.digit(cArray[8], 10);
        n2 += nArrayArray[0][n4];
        n4 = Character.digit(cArray[9], 10);
        n2 += nArrayArray[1][n4];
        n4 = Character.digit(cArray[10], 10);
        n3 = (n2 += nArrayArray[2][n4]) % 10 == 0 ? 0 : 10 - n2 % 10;
        cArray[6] = String.valueOf(n3).charAt(0);
        return String.valueOf(cArray);
    }
}

