/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.painter.barcode;

import com.fr.report.cell.painter.barcode.BarcodeException;
import com.fr.report.cell.painter.barcode.Module;
import com.fr.report.cell.painter.barcode.env.EnvironmentFactory;
import com.fr.report.cell.painter.barcode.output.AbstractOutput;
import com.fr.report.cell.painter.barcode.output.GraphicsOutput;
import com.fr.stable.CoreGraphHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.text.StringCharacterIterator;
import javax.swing.JComponent;

public abstract class BarcodeImpl
extends JComponent {
    private static final String[] UNITS = new String[]{"in", "px", "cm", "mm"};
    private static final double DEFAULT_BAR_HEIGHT = 50.0;
    protected String data;
    protected boolean drawingText;
    protected boolean drawingQuietSection = true;
    protected double barWidth = 1.0;
    protected double barHeight;
    protected Font font;
    private Color foreground;
    private Color background;
    protected Dimension size;
    protected int x;
    protected int y;
    private int resolution = -1;
    private int RCodeVersion = 7;
    private int RCodeErrorCorrect = 1;
    private int RcodeDrawPix = 1;

    protected BarcodeImpl(String string) throws BarcodeException {
        if (string == null || string.length() == 0) {
            throw new BarcodeException("Data to encode cannot be empty");
        }
        this.data = string;
        double d2 = this.calculateMinimumBarHeight(this.getResolution());
        this.barHeight = d2 > 0.0 ? d2 : 50.0;
        this.font = EnvironmentFactory.getEnvironment().getDefaultFont();
        this.drawingText = true;
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.setSVGScalar(0.0078125, "in");
        this.invalidateSize();
    }

    public String getData() {
        return this.data;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.invalidateSize();
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public void setDrawingText(boolean bl) {
        this.drawingText = bl;
        this.invalidateSize();
    }

    public boolean isDrawingText() {
        return this.drawingText;
    }

    public void setDrawingQuietSection(boolean bl) {
        this.drawingQuietSection = bl;
        this.invalidateSize();
    }

    public boolean isDrawingQuietSection() {
        return this.drawingQuietSection;
    }

    public void setBarWidth(double d2) {
        this.barWidth = d2 >= 1.0 ? d2 : 1.0;
        this.invalidateSize();
    }

    public void setBarHeight(double d2) {
        if (d2 > this.calculateMinimumBarHeight(this.getResolution())) {
            this.barHeight = d2;
            this.invalidateSize();
        }
    }

    public void setResolution(int n2) {
        if (n2 > 0) {
            this.resolution = n2;
            double d2 = this.calculateMinimumBarHeight(this.getResolution());
            if (d2 > this.barHeight) {
                this.barHeight = d2;
            }
            this.invalidateSize();
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return (int)this.getActualSize().getWidth();
    }

    public int getHeight() {
        return (int)this.getActualSize().getHeight();
    }

    public Rectangle getBounds() {
        return this.getBounds(new Rectangle());
    }

    public Rectangle getBounds(Rectangle rectangle) {
        rectangle.setBounds(this.getX(), this.getY(), (int)this.getActualSize().getWidth() + this.getX(), (int)this.getActualSize().getHeight() + this.getY());
        return rectangle;
    }

    public Dimension getPreferredSize() {
        return this.getActualSize();
    }

    public Dimension getMinimumSize() {
        return this.getActualSize();
    }

    public Dimension getMaximumSize() {
        return this.getActualSize();
    }

    public Dimension getSize() {
        return this.getActualSize();
    }

    public void draw(Graphics2D graphics2D, int n2, int n3) {
        this.x = n2;
        this.y = n3;
        this.size = this.internalDraw(graphics2D, n2, n3, true);
    }

    protected abstract Dimension draw(AbstractOutput var1, int var2, int var3, double var4, double var6);

    protected abstract double getBarcodeWidth(int var1);

    protected abstract Module[] encodeData();

    protected abstract Module calculateChecksum();

    protected abstract Module getPreAmble();

    protected abstract Module getPostAmble();

    protected String getLabel() {
        return this.data;
    }

    protected double calculateMinimumBarHeight(int n2) {
        return 0.0;
    }

    protected int getResolution() {
        if (this.resolution > 0) {
            return this.resolution;
        }
        return EnvironmentFactory.getEnvironment().getResolution();
    }

    private Dimension internalDraw(Graphics2D graphics2D, int n2, int n3, boolean bl) {
        Module[] moduleArray;
        Color color = graphics2D.getColor();
        double d2 = n2;
        GraphicsOutput graphicsOutput = new GraphicsOutput(graphics2D, this.font, this.barWidth, this.barHeight, bl, this.getForeground(), this.getBackground());
        if (bl) {
            moduleArray = this.getActualSize();
            ((AbstractOutput)graphicsOutput).beginDraw(moduleArray.width, moduleArray.height);
        }
        d2 += this.drawModule(this.getPreAmble(), graphicsOutput, d2, n3);
        moduleArray = this.encodeData();
        for (int i2 = 0; i2 < moduleArray.length; ++i2) {
            Module module = moduleArray[i2];
            d2 += this.drawModule(module, graphicsOutput, d2, n3);
        }
        d2 += this.drawModule(this.calculateChecksum(), graphicsOutput, d2, n3);
        d2 += this.drawModule(this.getPostAmble(), graphicsOutput, d2, n3);
        double d3 = this.barHeight + (double)n3;
        if (this.drawingText) {
            d3 += this.drawTextLabel(graphicsOutput, n2, (int)d3, d2);
        }
        if (bl) {
            ((AbstractOutput)graphicsOutput).endDraw();
        }
        graphics2D.setColor(color);
        return new Dimension((int)(d2 - (double)n2), (int)d3 - n3);
    }

    private void invalidateSize() {
        this.size = null;
    }

    private Dimension getActualSize() {
        if (this.size == null) {
            this.size = this.calculateSize();
        }
        return this.size;
    }

    protected Dimension calculateSize() {
        return this.internalDraw((Graphics2D)CoreGraphHelper.createBufferedImage(1000, 1000, 10).getGraphics(), 0, 0, false);
    }

    protected double drawModule(Module module, AbstractOutput abstractOutput, int n2, int n3, double d2, double d3) {
        return this.drawModule(module, abstractOutput, n2, n3);
    }

    protected double drawModule(Module module, AbstractOutput abstractOutput, double d2, double d3) {
        if (module == null) {
            return 0.0;
        }
        return module.draw(abstractOutput, d2, d3);
    }

    protected String beautify(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c2 = stringCharacterIterator.first();
        while (c2 != '\uffff') {
            if (Character.isDefined(c2) && !Character.isISOControl(c2)) {
                stringBuffer.append(c2);
            }
            c2 = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }

    public void setSVGScalar(double d2, String string) {
        String string2 = "";
        boolean bl = false;
        for (int i2 = 0; !bl && i2 < UNITS.length; ++i2) {
            if (string.equals(UNITS[i2])) {
                bl = true;
            }
            if (i2 != 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + UNITS[i2];
        }
        if (!bl) {
            throw new IllegalArgumentException("SVG Units must be one of " + string2);
        }
    }

    private double drawTextLabel(AbstractOutput abstractOutput, double d2, double d3, double d4) {
        String string = this.beautify(this.getLabel());
        return abstractOutput.drawText(string, d2, d3, d4);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void setRCodeVersion(int n2) {
        this.RCodeVersion = n2;
        this.invalidateSize();
    }

    public void setRCodeErrorCorrect(int n2) {
        this.RCodeErrorCorrect = n2;
        this.invalidateSize();
    }

    public void setRcodeDrawPix(int n2) {
        this.RcodeDrawPix = n2;
        this.invalidateSize();
    }

    public int getRCodeVersion() {
        return this.RCodeVersion;
    }

    public int getRCodeErrorCorrect() {
        return this.RCodeErrorCorrect;
    }

    public int getRcodeDrawPix() {
        return this.RcodeDrawPix;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Insets insets = this.getInsets();
        try {
            this.draw((Graphics2D)graphics, insets.left, insets.top);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

