/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.painter;

import com.fr.base.Style;
import com.fr.base.core.serializable.Point2DSerializable;
import com.fr.cache.list.IntList;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.report.cell.painter.BiasZone;
import com.fr.report.cell.painter.TagPainter;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

public class BiasTextPainter
extends TagPainter {
    private String text = null;
    private List angleList = new ArrayList();
    private transient List lineEndList = new ArrayList();
    private List textList = new ArrayList();
    private List isLargeDiagonal = new ArrayList();
    private boolean isCenter = false;
    private boolean isBackSlash = false;

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        if (n2 > 0) {
            if (this.lineEndList == null) {
                this.lineEndList = new ArrayList();
            }
            this.lineEndList.clear();
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = objectInputStream.readObject();
                if (object == null) continue;
                this.lineEndList.add(((Point2DSerializable)object).getPoint2D());
            }
        }
    }

    public JSONObject toJSONObject(NodeVisitor nodeVisitor, Repository repository, int n2, int n3, Style style) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("type", "bias");
        JSONArray jSONArray = new JSONArray();
        for (int i2 = 0; i2 < this.textList.size(); ++i2) {
            jSONArray.put(this.textList.get(i2));
        }
        jSONObject.put("texts", jSONArray);
        if (this.isBackSlash) {
            jSONObject.put("backslash", true);
        }
        return jSONObject;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.lineEndList.size());
        for (int i2 = 0; i2 < this.lineEndList.size(); ++i2) {
            Point2D point2D = (Point2D)this.lineEndList.get(i2);
            objectOutputStream.writeObject(new Point2DSerializable(point2D));
        }
    }

    public BiasTextPainter(String string) {
        this.setText(string);
    }

    private void generateTextListAndAngleList() {
        int n2;
        int n3;
        this.angleList.clear();
        this.lineEndList.clear();
        this.textList.clear();
        this.isLargeDiagonal.clear();
        int n4 = this.getText().length();
        IntList intList = new IntList();
        intList.add(0);
        for (n3 = 0; n3 < n4; ++n3) {
            if (this.getText().charAt(n3) != '|') continue;
            n2 = intList.get(intList.size() - 1);
            if (n3 != n2) {
                intList.add(n3 + 1);
                String string = this.getText().substring(n2, n3);
                this.getTextList().add(string);
                continue;
            }
            intList.add(n3 + 1);
            this.getTextList().add(" ");
        }
        n3 = intList.get(intList.size() - 1);
        if (n3 == n4) {
            this.getTextList().add(" ");
        } else {
            this.getTextList().add(this.getText().substring(intList.get(intList.size() - 1), n4));
        }
        for (n2 = 1; n2 < intList.size(); ++n2) {
            if (this.isBackSlash) {
                this.getAngleList().add(new Double(90 / intList.size() * (intList.size() - n2)));
                continue;
            }
            this.getAngleList().add(new Double(90 / intList.size() * n2));
        }
    }

    public void setAngle(int n2, double d2, double d3, double d4) {
        double d5;
        double d6;
        this.getAngleList().set(n2, new Double(d2));
        double d7 = d4 / d3;
        if (d7 > Math.tan(d2 / 180.0 * Math.PI)) {
            this.getLargeDiagonal().set(n2, Boolean.FALSE);
            if (this.isBackSlash) {
                d6 = d3;
                d5 = -d3 * Math.tan(d2 / 180.0 * Math.PI);
            } else {
                d6 = d3;
                d5 = d3 * Math.tan(d2 / 180.0 * Math.PI);
            }
        } else {
            this.getLargeDiagonal().set(n2, Boolean.TRUE);
            if (this.isBackSlash) {
                d5 = -d4;
                d6 = d4 / Math.tan(d2 / 180.0 * Math.PI);
            } else {
                d5 = d4;
                d6 = d4 / Math.tan(d2 / 180.0 * Math.PI);
            }
        }
        this.getLineEndList().set(n2, new Point2D.Double(d6, d5));
    }

    public void generateLineEndList(double d2, double d3) {
        ArrayList<Point2D.Double> arrayList = this.getLineEndList();
        if (arrayList == null) {
            arrayList = new ArrayList<Point2D.Double>();
            this.setLineEndList(arrayList);
        }
        arrayList.clear();
        double d4 = d3 / d2;
        for (int i2 = 0; i2 < this.getAngleList().size(); ++i2) {
            double d5;
            double d6;
            double d7 = (Double)this.getAngleList().get(i2) / 180.0 * Math.PI;
            if (d4 > Math.tan(d7)) {
                this.getLargeDiagonal().add(Boolean.FALSE);
                if (this.isBackSlash) {
                    d6 = d2;
                    d5 = -d2 * Math.tan(d7);
                } else {
                    d6 = d2;
                    d5 = d2 * Math.tan(d7);
                }
            } else {
                this.getLargeDiagonal().add(Boolean.TRUE);
                if (this.isBackSlash) {
                    d5 = -d3;
                    d6 = d3 / Math.tan(d7);
                } else {
                    d5 = d3;
                    d6 = d3 / Math.tan(d7);
                }
            }
            arrayList.add(new Point2D.Double(d6, d5));
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
        this.generateTextListAndAngleList();
    }

    public List getAngleList() {
        return this.angleList;
    }

    public void setAngleList(List list) {
        this.angleList = list;
    }

    public List getLineEndList() {
        return this.lineEndList;
    }

    public void setLineEndList(List list) {
        this.lineEndList = list;
    }

    public List getTextList() {
        return this.textList;
    }

    public void setTextList(List list) {
        this.textList = list;
    }

    public List getLargeDiagonal() {
        return this.isLargeDiagonal;
    }

    public void setLargeDiagonal(List list) {
        this.isLargeDiagonal = list;
    }

    public void setIsBackSlash(boolean bl) {
        this.isBackSlash = bl;
    }

    public boolean isBackSlash() {
        return this.isBackSlash;
    }

    public void paint(Graphics graphics, int n2, int n3, int n4, Style style) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.paintBiasString(graphics2D, new Rectangle2D.Double(0.0, 0.0, n2, n3), new Rectangle2D.Double(0.0, 0.0, n2, n3), this.text, style, n4);
    }

    private void paintBiasString(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, String string, Style style, int n2) {
        if (string == null || string.indexOf("|") == -1) {
            return;
        }
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        if (this.isBackSlash) {
            graphics2D2.translate(rectangle2D.getX(), rectangle2D.getY() + rectangle2D.getHeight());
        } else {
            graphics2D2.translate(rectangle2D.getX(), rectangle2D.getY());
        }
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D2.setStroke(graphics2D2.getStroke());
        if (string.length() > 0) {
            int n3;
            Color color;
            FRFont fRFont;
            if (style == null) {
                style = Style.DEFAULT_STYLE;
            }
            if (!ComparatorUtils.equals(fRFont = style.getFRFont(), graphics2D2.getFont())) {
                graphics2D2.setFont(fRFont);
            }
            if (!ComparatorUtils.equals(color = fRFont.getForeground(), graphics2D2.getPaint())) {
                graphics2D2.setPaint(color);
            }
            this.generateLineEndList(rectangle2D.getWidth(), rectangle2D.getHeight());
            int n4 = this.textList.size();
            BiasZone[] biasZoneArray = new BiasZone[n4];
            if (n4 == 2) {
                n3 = 0;
                this.setAngle(0, Math.atan2(rectangle2D.getHeight(), rectangle2D.getWidth()) * 180.0 / Math.PI, rectangle2D.getWidth(), rectangle2D.getHeight());
                if (this.isBackSlash) {
                    biasZoneArray[0] = new BiasZone(rectangle2D, 90.0, (Double)this.getAngleList().get(0), (String)this.getTextList().get(0), style, 1, n3 != 0, this.isBackSlash);
                    biasZoneArray[1] = new BiasZone(rectangle2D, (Double)this.getAngleList().get(0), 0.0, (String)this.getTextList().get(1), style, 2, n3 != 0, this.isBackSlash);
                } else {
                    biasZoneArray[0] = new BiasZone(rectangle2D, 0.0, (Double)this.getAngleList().get(0), (String)this.getTextList().get(0), style, 1, n3 != 0, this.isBackSlash);
                    biasZoneArray[1] = new BiasZone(rectangle2D, (Double)this.getAngleList().get(0), 90.0, (String)this.getTextList().get(1), style, 2, n3 != 0, this.isBackSlash);
                }
            } else if (n4 == 3) {
                boolean bl;
                double d2;
                if (this.isBackSlash) {
                    double d3 = 180.0 * Math.atan(2.0 * rectangle2D.getHeight() / 3.0 / rectangle2D.getWidth()) / Math.PI;
                    d2 = 180.0 * (1.5707963267948966 - Math.atan(2.0 * rectangle2D.getWidth() / 3.0 / rectangle2D.getHeight())) / Math.PI;
                    this.setAngle(0, d2, rectangle2D.getWidth(), rectangle2D.getHeight());
                    this.setAngle(1, d3, rectangle2D.getWidth(), rectangle2D.getHeight());
                    bl = false;
                    biasZoneArray[0] = new BiasZone(rectangle2D, 90.0, (Double)this.getAngleList().get(0), (String)this.getTextList().get(0), style, 1, bl, this.isBackSlash);
                    biasZoneArray[1] = new BiasZone(rectangle2D, (Double)this.getAngleList().get(0), (Double)this.getAngleList().get(1), (String)this.getTextList().get(1), style, 3, this.isCenter, this.isBackSlash);
                    biasZoneArray[2] = new BiasZone(rectangle2D, (Double)this.getAngleList().get(1), 0.0, (String)this.getTextList().get(2), style, 2, bl, this.isBackSlash);
                } else {
                    double d4 = 180.0 * Math.atan(2.0 * rectangle2D.getHeight() / 3.0 / rectangle2D.getWidth()) / Math.PI;
                    d2 = 180.0 * (1.5707963267948966 - Math.atan(2.0 * rectangle2D.getWidth() / 3.0 / rectangle2D.getHeight())) / Math.PI;
                    this.setAngle(0, d4, rectangle2D.getWidth(), rectangle2D.getHeight());
                    this.setAngle(1, d2, rectangle2D.getWidth(), rectangle2D.getHeight());
                    bl = false;
                    biasZoneArray[0] = new BiasZone(rectangle2D, 0.0, (Double)this.getAngleList().get(0), (String)this.getTextList().get(0), style, 1, bl, this.isBackSlash);
                    biasZoneArray[1] = new BiasZone(rectangle2D, (Double)this.getAngleList().get(0), (Double)this.getAngleList().get(1), (String)this.getTextList().get(1), style, 3, this.isCenter, this.isBackSlash);
                    biasZoneArray[2] = new BiasZone(rectangle2D, (Double)this.getAngleList().get(1), 90.0, (String)this.getTextList().get(2), style, 2, bl, this.isBackSlash);
                }
            } else if (this.isBackSlash) {
                biasZoneArray[0] = new BiasZone(rectangle2D, 90.0, (Double)this.getAngleList().get(0), (String)this.getTextList().get(0), style, 3, this.isCenter, this.isBackSlash);
                biasZoneArray[n4 - 1] = new BiasZone(rectangle2D, (Double)this.getAngleList().get(this.getAngleList().size() - 1), 0.0, (String)this.getTextList().get(this.getTextList().size() - 1), style, 3, this.isCenter, this.isBackSlash);
                for (int i2 = 1; i2 < n4 - 1; ++i2) {
                    biasZoneArray[i2] = new BiasZone(rectangle2D, (Double)this.getAngleList().get(i2 - 1), (Double)this.getAngleList().get(i2), (String)this.getTextList().get(i2), style, 3, this.isCenter, this.isBackSlash);
                }
            } else {
                biasZoneArray[0] = new BiasZone(rectangle2D, 0.0, (Double)this.getAngleList().get(0), (String)this.getTextList().get(0), style, 3, this.isCenter, this.isBackSlash);
                biasZoneArray[n4 - 1] = new BiasZone(rectangle2D, (Double)this.getAngleList().get(this.getAngleList().size() - 1), 90.0, (String)this.getTextList().get(this.getTextList().size() - 1), style, 3, this.isCenter, this.isBackSlash);
                for (int i3 = 1; i3 < n4 - 1; ++i3) {
                    biasZoneArray[i3] = new BiasZone(rectangle2D, (Double)this.getAngleList().get(i3 - 1), (Double)this.getAngleList().get(i3), (String)this.getTextList().get(i3), style, 3, this.isCenter, this.isBackSlash);
                }
            }
            for (n3 = 0; n3 < n4; ++n3) {
                biasZoneArray[n3].paintZone(graphics2D2, n2);
            }
            for (n3 = 0; n3 < this.getLineEndList().size(); ++n3) {
                Point2D point2D = (Point2D)this.getLineEndList().get(n3);
                graphics2D2.draw(new Line2D.Double(0.0, 0.0, point2D.getX(), point2D.getY()));
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof BiasTextPainter)) {
            return false;
        }
        return ComparatorUtils.equals(this.getText(), ((BiasTextPainter)object).getText()) && ComparatorUtils.equals(this.isBackSlash(), ((BiasTextPainter)object).isBackSlash);
    }

    public String toString() {
        return "";
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("IsBackSlash")) {
            this.setIsBackSlash(xMLableReader.getAttrAsBoolean("value", false));
        }
        if (xMLableReader.isCharacters()) {
            this.setText(xMLableReader.getContent());
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("IsBackSlash").attr("value", this.isBackSlash).end().textNode(this.text);
    }
}

