/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.painter;

import com.fr.base.Base64;
import com.fr.base.FRContext;
import com.fr.base.Style;
import com.fr.base.background.ColorBackground;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.report.cell.cellattr.BarcodeAttr;
import com.fr.report.cell.cellattr.core.CellUtils;
import com.fr.report.cell.painter.TagPainter;
import com.fr.report.cell.painter.barcode.BarcodeException;
import com.fr.report.cell.painter.barcode.BarcodeImpl;
import com.fr.report.cell.painter.barcode.core.BarCodeUtils;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.pinyin.ChineseHelper;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.io.Serializable;

public class BarcodePainter
extends TagPainter {
    private String text = null;
    private BarcodeAttr barcodeAttr;

    public BarcodePainter() {
    }

    public BarcodePainter(BarcodeAttr barcodeAttr, String string) {
        this.barcodeAttr = barcodeAttr;
        this.setText(string);
    }

    public BarcodeAttr getBarcodeAttr() {
        return this.barcodeAttr;
    }

    public void setBarcodeAttr(BarcodeAttr barcodeAttr) {
        this.barcodeAttr = barcodeAttr;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = ChineseHelper.containChinese(string) && this.barcodeAttr.getType() != 16 ? null : string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics, int n2, int n3, int n4, Style style) {
        if (this.text == null) {
            return;
        }
        Font font = graphics.getFont();
        try {
            Serializable serializable;
            BarcodeImpl barcodeImpl = BarCodeUtils.getBarcodeImpl(this);
            if (style.getFRFont() != null) {
                serializable = style.getFRFont();
                serializable = serializable.deriveFont(serializable.getSize2D() * (float)n4 / 72.0f);
                barcodeImpl.setFont((Font)serializable);
                graphics.setFont((Font)serializable);
                barcodeImpl.setForeground(style.getFRFont().getForeground());
            } else {
                serializable = FRFont.getInstance();
                serializable = serializable.deriveFont(serializable.getSize2D() * (float)n4 / 72.0f);
                graphics.setFont((Font)serializable);
            }
            serializable = style.getBackground();
            if (serializable != null && serializable instanceof ColorBackground) {
                barcodeImpl.setBackground(((ColorBackground)serializable).getColor());
            }
            double d2 = (n2 - barcodeImpl.getWidth()) / 2;
            double d3 = (n3 - barcodeImpl.getHeight()) / 2;
            barcodeImpl.draw((Graphics2D)graphics, (int)d2, (int)d3);
        }
        catch (BarcodeException barcodeException) {
            FRContext.getLogger().error(barcodeException.getMessage(), barcodeException);
        }
        finally {
            graphics.setFont(font);
        }
    }

    public String toString() {
        return "";
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("XMLable");
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("BarCodeText").attr("barcodeText", this.text).end();
        if (this.barcodeAttr != null) {
            this.barcodeAttr.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("BarCodeText".equalsIgnoreCase(string)) {
                String string2 = xMLableReader.getAttrAsString("barcodeText", null);
                if (string2 != null) {
                    this.text = string2;
                }
            } else if ("BarcodeAttr".equalsIgnoreCase(string)) {
                BarcodeAttr barcodeAttr = new BarcodeAttr();
                barcodeAttr.readXML(xMLableReader);
                this.barcodeAttr = barcodeAttr;
            }
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof BarcodePainter && ComparatorUtils.equals(((BarcodePainter)object).getBarcodeAttr(), this.barcodeAttr) && ComparatorUtils.equals(((BarcodePainter)object).getText(), this.text);
    }

    public JSONObject toJSONObject(NodeVisitor nodeVisitor, Repository repository, int n2, int n3) throws JSONException {
        Image image = CellUtils.value2Image((Object)this, repository.getResolution(), null, n2, n3);
        return new JSONObject().put("type", "image").put("value", Base64.encode(image, "png")).put("imageLayout", 4);
    }
}

