/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.cellattr.highlight;

import com.fr.base.FRContext;
import com.fr.general.Inter;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.cellattr.highlight.AbstractHighlightAction;
import com.fr.report.elementcase.ElementCase;
import com.fr.report.report.Report;
import com.fr.script.Calculator;
import com.fr.stable.unit.FU;
import com.fr.stable.unit.OLDPIX;
import com.fr.stable.unit.UNIT;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class ColWidthHighlightAction
extends AbstractHighlightAction {
    private UNIT columnWidth = UNIT.ZERO;

    public ColWidthHighlightAction() {
    }

    public ColWidthHighlightAction(UNIT uNIT) {
        this.columnWidth = uNIT;
    }

    public UNIT getColumnWidth() {
        return this.columnWidth;
    }

    public void setColumnWidth(UNIT uNIT) {
        this.columnWidth = uNIT;
    }

    public void action(CellElement cellElement, Calculator calculator) {
        int n2;
        if (cellElement == null || calculator == null || calculator.getAttribute(Report.KEY) == null) {
            return;
        }
        ElementCase elementCase = (ElementCase)calculator.getAttribute(ElementCase.KEY);
        if (elementCase == null) {
            FRContext.getLogger().error(Inter.getLocText("NS_LayerReport_RowCol"));
            return;
        }
        int n3 = n2 + cellElement.getColumnSpan();
        for (n2 = cellElement.getColumn(); n2 < n3; ++n2) {
            elementCase.setColumnWidth(n2, this.columnWidth);
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode() && "ColumnWidth".equals(xMLableReader.getTagName())) {
            if (xMLableReader.getXMLVersion().isAfterREPORT_REFECT_FOR65_4_XML_VERSION()) {
                this.setColumnWidth(FU.getInstance(xMLableReader.getAttrAsLong("i", 0L)));
            } else {
                this.setColumnWidth(new OLDPIX((float)xMLableReader.getAttrAsInt("i", 0)));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.columnWidth.more_than_zero()) {
            xMLPrintWriter.startTAG("ColumnWidth").attr("i", this.columnWidth.toFU()).end();
        }
    }

    public boolean equals(Object object) {
        return object instanceof ColWidthHighlightAction && super.equals(object) && this.columnWidth == ((ColWidthHighlightAction)object).columnWidth;
    }
}

