/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.cellattr.highlight;

import com.fr.base.CellBorderStyle;
import com.fr.base.Style;
import com.fr.general.ComparatorUtils;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.cellattr.highlight.AbstractHighlightAction;
import com.fr.script.Calculator;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;

public class BorderHighlightAction
extends AbstractHighlightAction {
    private Color topColor = Color.BLACK;
    private int topLine = 0;
    private Color leftColor = Color.BLACK;
    private int leftLine = 0;
    private Color bottomColor = Color.BLACK;
    private int bottomLine = 0;
    private Color rightColor = Color.BLACK;
    private int rightLine = 0;

    public BorderHighlightAction() {
    }

    public BorderHighlightAction(CellBorderStyle cellBorderStyle) {
        if (cellBorderStyle == null) {
            return;
        }
        this.topLine = cellBorderStyle.getTopStyle();
        this.topColor = cellBorderStyle.getTopColor();
        this.bottomLine = cellBorderStyle.getBottomStyle();
        this.bottomColor = cellBorderStyle.getBottomColor();
        this.leftLine = cellBorderStyle.getLeftStyle();
        this.leftColor = cellBorderStyle.getLeftColor();
        this.rightLine = cellBorderStyle.getRightStyle();
        this.rightColor = cellBorderStyle.getRightColor();
    }

    public CellBorderStyle getCellBorder() {
        CellBorderStyle cellBorderStyle = new CellBorderStyle();
        cellBorderStyle.setTopStyle(this.getLine(this.topLine));
        cellBorderStyle.setBottomStyle(this.getLine(this.bottomLine));
        cellBorderStyle.setLeftStyle(this.getLine(this.leftLine));
        cellBorderStyle.setRightStyle(this.getLine(this.rightLine));
        cellBorderStyle.setTopColor(this.getColor(this.topColor));
        cellBorderStyle.setBottomColor(this.getColor(this.bottomColor));
        cellBorderStyle.setLeftColor(this.getColor(this.leftColor));
        cellBorderStyle.setRightColor(this.getColor(this.rightColor));
        return cellBorderStyle;
    }

    public void action(CellElement cellElement, Calculator calculator) {
        if (cellElement == null) {
            return;
        }
        Style style = cellElement.getStyle();
        cellElement.setStyle(style.deriveBorder(this.getLine(this.topLine), this.getColor(this.topColor), this.getLine(this.bottomLine), this.getColor(this.bottomColor), this.getLine(this.leftLine), this.getColor(this.leftColor), this.getLine(this.rightLine), this.getColor(this.rightColor)));
    }

    public int getLine(int n2) {
        if (n2 != 0) {
            return n2;
        }
        return 0;
    }

    public Color getColor(Color color) {
        if (color != Color.black) {
            return color;
        }
        return Color.black;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode() && "Border".equals(xMLableReader.getTagName())) {
            this.topLine = xMLableReader.getAttrAsInt("topLine", 0);
            this.topColor = xMLableReader.getAttrAsColor("topColor", Color.black);
            this.bottomLine = xMLableReader.getAttrAsInt("bottomLine", 0);
            this.bottomColor = xMLableReader.getAttrAsColor("bottomColor", Color.black);
            this.leftLine = xMLableReader.getAttrAsInt("leftLine", 0);
            this.leftColor = xMLableReader.getAttrAsColor("leftColor", Color.black);
            this.rightLine = xMLableReader.getAttrAsInt("rightLine", 0);
            this.rightColor = xMLableReader.getAttrAsColor("rightColor", Color.black);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Border").attr("topLine", this.getLine(this.topLine)).attr("topColor", this.getColor(this.topColor).getRGB()).attr("bottomLine", this.getLine(this.bottomLine)).attr("bottomColor", this.getColor(this.bottomColor).getRGB()).attr("leftLine", this.getLine(this.leftLine)).attr("leftColor", this.getColor(this.leftColor).getRGB()).attr("rightLine", this.getLine(this.rightLine)).attr("rightColor", this.getColor(this.rightColor).getRGB()).end();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<Border").append(" topLine=\"").append(this.getLine(this.topLine)).append("\" topColor=\"").append(this.getColor(this.topColor).getRGB()).append("\" bottomLine=\"").append(this.getLine(this.bottomLine)).append("\" bottomColor=\"").append(this.getColor(this.bottomColor).getRGB()).append("\" leftLine=\"").append(this.getLine(this.leftLine)).append("\" leftColor=\"").append(this.getColor(this.leftColor).getRGB()).append("\" rightLine=\"").append(this.getLine(this.rightLine)).append("\" rightColor=\"").append(this.getColor(this.rightColor).getRGB()).append("\">").append("</Border>");
    }

    public boolean equals(Object object) {
        return object instanceof BorderHighlightAction && super.equals(object) && this.topLine == ((BorderHighlightAction)object).topLine && this.bottomLine == ((BorderHighlightAction)object).bottomLine && this.leftLine == ((BorderHighlightAction)object).leftLine && this.rightLine == ((BorderHighlightAction)object).rightLine && ComparatorUtils.equals(this.topColor, ((BorderHighlightAction)object).topColor) && ComparatorUtils.equals(this.bottomColor, ((BorderHighlightAction)object).bottomColor) && ComparatorUtils.equals(this.leftColor, ((BorderHighlightAction)object).leftColor) && ComparatorUtils.equals(this.rightColor, ((BorderHighlightAction)object).rightColor);
    }
}

