/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.cellattr.core.group;

import com.fr.base.BaseScriptUtils;
import com.fr.base.BaseXMLUtils;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.Parameter;
import com.fr.base.ParameterMapNameSpace;
import com.fr.base.Style;
import com.fr.base.TableData;
import com.fr.cache.list.IntList;
import com.fr.data.SingleRowNameSpace;
import com.fr.data.TableDataSource;
import com.fr.data.core.DataCoreUtils;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.data.impl.RowsDataModel;
import com.fr.file.DatasourceManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.Condition;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataColumn;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.report.cell.cellattr.core.group.FunctionGrouper;
import com.fr.report.cell.cellattr.core.group.Group;
import com.fr.report.cell.cellattr.core.group.IndexGrouper;
import com.fr.report.cell.cellattr.core.group.MonoGrouper;
import com.fr.report.cell.cellattr.core.group.RecordGrouper;
import com.fr.report.cell.cellattr.core.group.SelectCount;
import com.fr.report.cell.cellattr.core.group.SummaryGrouper;
import com.fr.report.cell.painter.TagPainter;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.DependenceProvider;
import com.fr.stable.ParameterProvider;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.NameSpace;
import com.fr.stable.xml.StableXMLUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import com.fr.xml.ReportXMLUtils;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSColumn
extends TagPainter
implements DependenceProvider {
    private String dsName;
    private TableDataColumn column;
    private boolean reselect = false;
    private Condition condition;
    private RecordGrouper grouper;
    private Parameter[] parameters;
    private int order = 0;
    private String sortFormula = null;
    private Comparator sortComparator = null;
    private SelectCount selectCount = null;
    private String result = null;

    public String getDSName() {
        return this.dsName;
    }

    public void setDSName(String string) {
        this.dsName = string;
    }

    public Parameter[] getParameters() {
        return this.parameters == null ? new Parameter[]{} : this.parameters;
    }

    public void setParameters(Parameter[] parameterArray) {
        this.parameters = parameterArray;
    }

    public String getColumnName() {
        return TableDataColumn.getColumnName(this.column);
    }

    public void setColumnName(String string) {
        this.column = TableDataColumn.createColumn(string);
    }

    public TableDataColumn getColumn() {
        return this.column;
    }

    public void setColumn(TableDataColumn tableDataColumn) {
        this.column = tableDataColumn;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public RecordGrouper getGrouper() {
        if (this.grouper == null) {
            this.grouper = new FunctionGrouper();
        }
        return this.grouper;
    }

    public void setGrouper(RecordGrouper recordGrouper) {
        this.grouper = recordGrouper;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int n2) {
        this.order = n2;
    }

    public String getSortFormula() {
        return this.sortFormula;
    }

    public void setSortFormula(String string) {
        this.sortFormula = string;
    }

    public boolean isReselect() {
        return this.reselect;
    }

    public void setReselect(boolean bl) {
        this.reselect = bl;
    }

    public SelectCount getSelectCount() {
        return this.selectCount;
    }

    public void setSelectCount(SelectCount selectCount) {
        this.selectCount = selectCount;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String string) {
        this.result = string;
    }

    public Iterator dataIterator(DataModel dataModel, int n2, int[] nArray, Calculator calculator) {
        return new DataIterator(this.getGrouper().groupIterator(dataModel, n2, nArray, calculator), dataModel, calculator);
    }

    public Group[] dealwith_condition_group_sort_select_result(DataModel dataModel, int n2, int[] nArray, Calculator calculator) {
        nArray = this.getCondition() == null ? nArray : this.getCondition().evalTableData(dataModel, nArray, n2, calculator);
        return this.dealwith_result(this.dealwith_select(this.dealwith_sort(this.getGrouper().group(dataModel, n2, nArray, calculator), dataModel, calculator), calculator), dataModel, calculator);
    }

    private Group[] dealwith_sort(Group[] groupArray, DataModel dataModel, Calculator calculator) {
        int n2;
        if (this.order == 0) {
            return groupArray;
        }
        GroupComparable[] groupComparableArray = new GroupComparable[groupArray.length];
        for (n2 = 0; n2 < groupComparableArray.length; ++n2) {
            Group group = groupArray[n2];
            Object object = null;
            if (this.sortFormula == null) {
                object = group.getValue();
            } else {
                calculator.setAttribute(RowsDataModel.KEY, (Object)new RowsDataModel(dataModel, group.getArray()));
                SingleRowNameSpace singleRowNameSpace = new SingleRowNameSpace(dataModel, group.getArray() == null || group.getArray().length > 0 ? group.getArray()[0] : -1, group.getValue());
                calculator.pushNameSpace(singleRowNameSpace);
                if (this.sortFormula.length() > 0 && this.sortFormula.charAt(0) == '=') {
                    this.sortFormula = this.sortFormula.substring(1);
                }
                try {
                    object = calculator.evalValue(this.sortFormula);
                }
                catch (UtilEvalError utilEvalError) {
                    String string = "error happens at DSColumn.sort\nformula expression is " + this.sortFormula + "\nerror message is " + utilEvalError.getMessage();
                    FRContext.getLogger().error(string, utilEvalError);
                }
                calculator.removeNameSpace(singleRowNameSpace);
                calculator.removeAttribute(RowsDataModel.KEY);
            }
            groupComparableArray[n2] = new GroupComparable(group, object);
        }
        Arrays.sort(groupComparableArray, new GroupComparableComparator(this.sortComparator, this.order));
        for (n2 = 0; n2 < groupComparableArray.length; ++n2) {
            groupArray[n2] = groupComparableArray[n2].group;
        }
        return groupArray;
    }

    private Group[] dealwith_select(Group[] groupArray, Calculator calculator) {
        Group[] groupArray2;
        String string;
        if (this.selectCount == null) {
            return groupArray;
        }
        String string2 = this.selectCount.getFormulaCount();
        int n2 = -1;
        if (StringUtils.isNotBlank(string2)) {
            try {
                n2 = Integer.parseInt(calculator.evalValue(string2).toString());
            }
            catch (UtilEvalError utilEvalError) {
                string = "error happens at calculating DSColumn, SelectCount's formula\nformula expression is " + string2 + "\nerror message is " + utilEvalError.getMessage();
                FRContext.getLogger().error(string, utilEvalError);
            }
        }
        switch (this.selectCount.getType()) {
            case 1: {
                n2 = n2 < 0 ? groupArray.length : Math.min(n2, groupArray.length);
                groupArray2 = new Group[n2];
                System.arraycopy(groupArray, 0, groupArray2, 0, n2);
                break;
            }
            case 2: {
                n2 = n2 < 0 ? groupArray.length : Math.min(n2, groupArray.length);
                groupArray2 = new Group[n2];
                System.arraycopy(groupArray, groupArray.length - n2, groupArray2, 0, n2);
                break;
            }
            case 3: {
                n2 = groupArray.length / 2 + groupArray.length % 2;
                groupArray2 = new Group[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    groupArray2[i2] = groupArray[i2 * 2];
                }
                break;
            }
            case 4: {
                n2 = groupArray.length / 2;
                groupArray2 = new Group[n2];
                for (int i3 = 0; i3 < n2; ++i3) {
                    groupArray2[i3] = groupArray[i3 * 2 + 1];
                }
                break;
            }
            default: {
                string = this.selectCount.getSerial();
                groupArray2 = this.dealWithSelectType_Default(string, groupArray, calculator);
            }
        }
        return groupArray2;
    }

    private Group[] dealWithSelectType_Default(String string, Group[] groupArray, Calculator calculator) {
        Group[] groupArray2;
        Object object;
        Object object2;
        boolean bl;
        boolean bl2 = bl = string.length() > 0 && string.charAt(0) == '=';
        if (StringUtils.isNotBlank(string) && bl) {
            try {
                object2 = new HashMap();
                object2.put("__count__", new Integer(groupArray.length));
                object = ParameterMapNameSpace.create((Map)object2);
                calculator.pushNameSpace((NameSpace)object);
                string = calculator.evalValue(string.substring(1)).toString();
                calculator.removeNameSpace((NameSpace)object);
            }
            catch (UtilEvalError utilEvalError) {
                FRContext.getLogger().error(utilEvalError.getMessage(), utilEvalError);
            }
        }
        if ((object2 = IntList.toIntArrayDecimal(string, ',')) != null && ((int[])object2).length > 0) {
            object = new ArrayList();
            int n2 = ((Object)object2).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                reference var10_10 = object2[i2] - true;
                if (var10_10 >= groupArray.length || var10_10 < 0) continue;
                object.add(groupArray[var10_10]);
            }
            groupArray2 = new Group[object.size()];
            object.toArray(groupArray2);
        } else {
            groupArray2 = groupArray;
        }
        return groupArray2;
    }

    private Group[] dealwith_result(Group[] groupArray, DataModel dataModel, Calculator calculator) {
        if (this.shouldCCGroupByResult()) {
            for (int i2 = 0; i2 < groupArray.length; ++i2) {
                this.ccGroupByResult(groupArray[i2], dataModel, calculator);
            }
        }
        return groupArray;
    }

    private boolean shouldCCGroupByResult() {
        if (this.result == null) {
            return false;
        }
        String string = this.result.length() > 0 && this.result.charAt(0) == '=' ? this.result.substring(1) : this.result;
        return !ComparatorUtils.equals("$$$", string) && !StringUtils.isBlank(string);
    }

    private void ccGroupByResult(Group group, DataModel dataModel, Calculator calculator) {
        SingleRowNameSpace singleRowNameSpace = null;
        if (group.getArray() != null && group.getArray().length > 0 && dataModel != null) {
            singleRowNameSpace = new SingleRowNameSpace(dataModel, group.getArray()[0], group.getValue());
            calculator.pushNameSpace(singleRowNameSpace);
        }
        try {
            group.setValue(calculator.evalValue(this.result));
        }
        catch (UtilEvalError utilEvalError) {
            String string = "error happens at calculate formula\nformula expression is " + this.result + "\nerror message is " + utilEvalError.getMessage();
            FRContext.getLogger().error(string, utilEvalError);
        }
        if (singleRowNameSpace != null) {
            calculator.removeNameSpace(singleRowNameSpace);
        }
    }

    @Override
    public void paint(Graphics graphics, int n2, int n3, int n4, Style style) {
        Style.paintCellStyleString((Graphics2D)graphics, n2, n3, this.toString(), style, n4);
    }

    @Override
    public String[] dependence(CalculatorProvider calculatorProvider) {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.dependenceFromTabledata(calculatorProvider, arrayList);
        this.dependenceFromPara(arrayList);
        this.dependenceFromCondition(arrayList, calculatorProvider);
        this.dependenceFromFormula(arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void dependenceFromTabledata(CalculatorProvider calculatorProvider, ArrayList<String> arrayList) {
        ParameterProvider[] parameterProviderArray;
        String string = this.getDSName();
        if (StringUtils.isEmpty(string)) {
            return;
        }
        TableDataSource tableDataSource = (TableDataSource)calculatorProvider.getAttribute(TableDataSource.KEY);
        if (tableDataSource == null) {
            return;
        }
        TableData tableData = tableDataSource.getTableData(string);
        if (tableData == null && (tableData = (parameterProviderArray = DatasourceManager.getProviderInstance()).getTableData(string)) == null) {
            return;
        }
        parameterProviderArray = tableData.getParameters((Calculator)calculatorProvider);
        int n2 = ArrayUtils.getLength(parameterProviderArray);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.addSinglePara(parameterProviderArray[i2], arrayList);
        }
    }

    private void addSinglePara(ParameterProvider parameterProvider, ArrayList<String> arrayList) {
        if (parameterProvider != null && parameterProvider.getName() != null) {
            arrayList.add(parameterProvider.getName());
        }
    }

    private void dependenceFromPara(ArrayList<String> arrayList) {
        int n2 = ArrayUtils.getLength(this.parameters);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.addSinglePara(this.parameters[i2], arrayList);
        }
    }

    private void dependenceFromCondition(ArrayList<String> arrayList, CalculatorProvider calculatorProvider) {
        if (this.condition == null) {
            return;
        }
        String[] stringArray = this.condition.dependence(calculatorProvider);
        arrayList.addAll(Arrays.asList(stringArray));
    }

    private void dependenceFromFormula(ArrayList<String> arrayList) {
        if (StringUtils.isEmpty(this.sortFormula)) {
            return;
        }
        String[] stringArray = new String[]{};
        stringArray = BaseScriptUtils.getDependenceByFormula(this.sortFormula.substring(1));
        arrayList.addAll(Arrays.asList(stringArray));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.dsName).append('.');
        if (this.reselect) {
            stringBuffer.append("(R)");
        }
        if (this.grouper instanceof FunctionGrouper && ((FunctionGrouper)this.grouper).getDivideMode() == 1) {
            stringBuffer.append("S(");
            stringBuffer.append(this.column);
            stringBuffer.append(')');
        } else if (this.grouper instanceof MonoGrouper) {
            stringBuffer.append("S(");
            stringBuffer.append(this.column);
            stringBuffer.append(')');
        } else if (this.grouper instanceof SummaryGrouper) {
            stringBuffer.append(DataCoreUtils.getFunctionDisplayName(((SummaryGrouper)this.grouper).getFunction())).append('(');
            stringBuffer.append(this.column);
            stringBuffer.append(')');
        } else if (this.grouper instanceof IndexGrouper) {
            stringBuffer.append(this.column);
        } else {
            stringBuffer.append('G').append('(');
            stringBuffer.append(this.column);
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DSColumn dSColumn = (DSColumn)super.clone();
        if (this.column != null) {
            dSColumn.column = (TableDataColumn)this.column.clone();
        }
        if (this.condition != null) {
            dSColumn.condition = (Condition)this.condition.clone();
        }
        if (this.grouper != null) {
            dSColumn.grouper = (RecordGrouper)this.grouper.clone();
        }
        if (this.selectCount != null) {
            dSColumn.selectCount = (SelectCount)this.selectCount.clone();
        }
        if (this.parameters != null) {
            dSColumn.parameters = new Parameter[this.parameters.length];
            for (int i2 = 0; i2 < this.parameters.length; ++i2) {
                dSColumn.parameters[i2] = (Parameter)this.parameters[i2].clone();
            }
        }
        return dSColumn;
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Attributes".equals(string)) {
                this.readAttributes(xMLableReader);
            } else if ("Condition".equals(string)) {
                this.condition = DataCoreXmlUtils.readXMLCondition(xMLableReader);
            } else if (string.equals("Complex")) {
                this.setOrder(xMLableReader.getAttrAsInt("order", 0));
                this.setReselect(xMLableReader.getAttrAsBoolean("reselect", false));
            } else if ("Result".equals(string)) {
                this.result = xMLableReader.getElementValue();
            } else if ("SortFormula".equals(string)) {
                this.readSortFormula(xMLableReader);
            } else if ("Comparator".equals(string)) {
                this.sortComparator = DataCoreXmlUtils.readXMLComparator(xMLableReader);
            } else if ("SelectCount".equals(string)) {
                this.selectCount = new SelectCount();
                xMLableReader.readXMLObject(this.selectCount);
            } else if ("RG".equals(string)) {
                this.grouper = ReportXMLUtils.readXMLRecordGrouper(xMLableReader);
            } else if ("Parameters".equals(string)) {
                final ArrayList arrayList = new ArrayList();
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if ("Parameter".equals(xMLableReader.getTagName())) {
                            arrayList.add(BaseXMLUtils.readParameter(xMLableReader));
                        }
                    }
                });
                if (arrayList != null && !arrayList.isEmpty()) {
                    this.parameters = new Parameter[arrayList.size()];
                    arrayList.toArray(this.parameters);
                }
            } else if ("Object".equals(string) || "O".equals(string)) {
                this.result = ((Formula)GeneralXMLTools.readObject(xMLableReader)).getContent();
            } else if ("GC".equals(string)) {
                this.setGrouper(ReportXMLUtils.readXMLRecordGrouper(xMLableReader));
            }
        }
    }

    private void readAttributes(XMLableReader xMLableReader) {
        String string = xMLableReader.getAttrAsString("dbName", null);
        if (string != null) {
            this.setDSName(string);
        }
        if ((string = xMLableReader.getAttrAsString("dsName", null)) != null) {
            String[] stringArray = string.split("\\.");
            if (stringArray.length == 2) {
                this.setDSName(stringArray[1]);
                if (StringUtils.isEmpty(xMLableReader.getAttrAsString("columnName", null))) {
                    this.column = TableDataColumn.createColumn(stringArray[1]);
                    return;
                }
            } else {
                this.setDSName(string);
            }
        }
        this.column = TableDataColumn.readXML(xMLableReader);
    }

    private void readSortFormula(XMLableReader xMLableReader) {
        this.sortFormula = xMLableReader.getElementValue();
        if (this.sortFormula == null) {
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    String string;
                    if (xMLableReader.isChildNode() && ("Object".equals(string = xMLableReader.getTagName()) || "O".equals(string))) {
                        Object object = GeneralXMLTools.readObject(xMLableReader);
                        if (object instanceof Formula) {
                            DSColumn.this.sortFormula = ((Formula)object).getContent();
                        } else {
                            DSColumn.this.sortFormula = object + "";
                        }
                    }
                }
            });
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Attributes").attr("dsName", this.getDSName());
        TableDataColumn.writeXML(xMLPrintWriter, this.column);
        xMLPrintWriter.end();
        DataCoreXmlUtils.writeXMLCondition(xMLPrintWriter, this.condition);
        xMLPrintWriter.startTAG("Complex");
        if (this.getOrder() != 0) {
            xMLPrintWriter.attr("order", this.getOrder());
        }
        if (this.isReselect()) {
            xMLPrintWriter.attr("reselect", "true");
        }
        xMLPrintWriter.end();
        if (this.grouper != null) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.grouper, "RG");
        }
        if (this.sortFormula != null && this.sortFormula.length() > 0) {
            xMLPrintWriter.startTAG("SortFormula").textNode(this.sortFormula).end();
        }
        if (this.sortComparator instanceof XMLable) {
            DataCoreXmlUtils.writeXMLComparator(xMLPrintWriter, this.sortComparator);
        }
        if (this.selectCount != null) {
            this.selectCount.writeXML(xMLPrintWriter);
        }
        if (this.result != null) {
            xMLPrintWriter.startTAG("Result").textNode(this.result).end();
        }
        StableXMLUtils.writeParameters(xMLPrintWriter, this.parameters);
    }

    public boolean isAttrNotEmpty() {
        return this.reselect || this.condition != null && !"()".equals(this.condition.toString()) || this.parameters != null || this.order != 0 || this.sortFormula != null || this.sortComparator != null || this.selectCount != null || this.result != null && !"$$$".equals(this.result);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof DSColumn && ComparatorUtils.equals(this.dsName, ((DSColumn)object).dsName) && ComparatorUtils.equals(this.column, ((DSColumn)object).column) && this.reselect == ((DSColumn)object).reselect && ComparatorUtils.equals(this.condition, ((DSColumn)object).condition) && ComparatorUtils.equals(this.grouper, ((DSColumn)object).grouper) && ComparatorUtils.equals(this.parameters, ((DSColumn)object).parameters) && this.order == ((DSColumn)object).order && ComparatorUtils.equals(this.sortFormula, ((DSColumn)object).sortFormula) && ComparatorUtils.equals(this.sortComparator, ((DSColumn)object).sortComparator) && ComparatorUtils.equals(this.selectCount, ((DSColumn)object).selectCount) && ComparatorUtils.equals(this.result, ((DSColumn)object).result);
    }

    private class DataIterator
    implements Iterator {
        private Iterator groupIterator;
        private Calculator calculator;
        private DataModel resultSet;
        private Group curGroup = null;
        private int next_count = 0;
        private int select_count = -1;
        private IntList selectList;

        DataIterator(Iterator iterator, DataModel dataModel, Calculator calculator) {
            this.groupIterator = iterator;
            this.resultSet = dataModel;
            this.calculator = calculator;
            if (DSColumn.this.selectCount != null) {
                String string;
                boolean bl;
                String string2 = DSColumn.this.selectCount.getFormulaCount();
                if (StringUtils.isNotBlank(string2)) {
                    try {
                        this.select_count = Integer.parseInt(calculator.evalValue(string2).toString());
                    }
                    catch (UtilEvalError utilEvalError) {
                        String string3 = "error happens at calculating DSColumn, SelectCount's formula\nformula expression is " + string2 + "\nerror message is " + utilEvalError.getMessage();
                        FRContext.getLogger().error(string3, utilEvalError);
                    }
                }
                boolean bl2 = bl = (string = DSColumn.this.selectCount.getSerial()).length() > 0 && string.charAt(0) == '=';
                if (StringUtils.isNotBlank(string) && bl) {
                    try {
                        string = calculator.evalValue(string.substring(1)).toString();
                    }
                    catch (UtilEvalError utilEvalError) {
                        FRContext.getLogger().error(utilEvalError.getMessage(), utilEvalError);
                    }
                }
                int[] nArray = IntList.toIntArrayDecimal(string, ',');
                this.selectList = new IntList();
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    this.selectList.add(nArray[i2]);
                }
            }
        }

        public boolean hasNext() {
            block6: while (this.groupIterator.hasNext()) {
                ++this.next_count;
                this.curGroup = (Group)this.groupIterator.next();
                if (DSColumn.this.selectCount != null) {
                    switch (DSColumn.this.selectCount.getType()) {
                        case 1: {
                            if (this.next_count <= this.select_count) break;
                            this.curGroup = null;
                            continue block6;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            if (this.next_count % 2 == 1) break;
                            this.curGroup = null;
                            continue block6;
                        }
                        case 4: {
                            if (this.next_count % 2 == 0) break;
                            this.curGroup = null;
                            continue block6;
                        }
                        default: {
                            if (this.selectList == null || this.selectList.contain(this.next_count)) break;
                            this.curGroup = null;
                            continue block6;
                        }
                    }
                }
                if (DSColumn.this.condition != null && !DSColumn.this.condition.eval(this.curGroup.getValue(), this.calculator)) {
                    this.curGroup = null;
                    continue;
                }
                return true;
            }
            return false;
        }

        public Object next() {
            if (DSColumn.this.shouldCCGroupByResult()) {
                DSColumn.this.ccGroupByResult(this.curGroup, this.resultSet, this.calculator);
            }
            return this.curGroup;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class GroupComparableComparator
    implements Comparator {
        private Comparator comparator = null;
        private int order = 1;

        public GroupComparableComparator(Comparator comparator, int n2) {
            this.comparator = comparator;
            this.order = n2;
        }

        public int compare(Object object, Object object2) {
            if (!(object instanceof GroupComparable) || !(object2 instanceof GroupComparable)) {
                return 0;
            }
            GroupComparable groupComparable = (GroupComparable)object;
            GroupComparable groupComparable2 = (GroupComparable)object2;
            int n2 = this.comparator == null ? ComparatorUtils.compare(groupComparable.comparable, groupComparable2.comparable) : this.comparator.compare(groupComparable.comparable, groupComparable2.comparable);
            if (this.order == 1) {
                return n2;
            }
            return 0 - n2;
        }
    }

    private static final class GroupComparable {
        private Group group;
        private Object comparable;

        public GroupComparable(Group group, Object object) {
            this.group = group;
            this.comparable = object;
        }
    }
}

