/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.cellattr.core;

import com.fr.base.DynamicNumberList;
import com.fr.base.DynamicPixList;
import com.fr.base.FRContext;
import com.fr.base.GraphHelper;
import com.fr.base.Style;
import com.fr.base.Utils;
import com.fr.base.background.ColorBackground;
import com.fr.data.PresentationType;
import com.fr.general.Background;
import com.fr.main.workbook.PageRWorkBook;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.report.ReportHelper;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.cellattr.CellGUIAttr;
import com.fr.report.cell.painter.TagPainter;
import com.fr.report.core.PaintUtils;
import com.fr.report.report.ECReport;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSubReport
extends TagPainter {
    public static final String XML_TAG = "ResultSubReport";
    private ResultWorkBook packee;

    public ResultSubReport() {
        this(new PageRWorkBook());
    }

    public ResultSubReport(ResultWorkBook resultWorkBook) {
        this.packee = resultWorkBook;
    }

    @Override
    public void paint(Graphics graphics, int n2, int n3, int n4, Style style) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        ECReport eCReport = null;
        if (this.packee.getReportCount() > 0) {
            eCReport = (ECReport)this.packee.getReport(0);
        }
        if (eCReport == null) {
            return;
        }
        ArrayList<CellElement> arrayList = new ArrayList<CellElement>();
        ArrayList<Rectangle> arrayList2 = new ArrayList<Rectangle>();
        this.paintCell(eCReport, n4, arrayList, arrayList2, graphics2D);
        this.translateBorder(arrayList, graphics2D);
        this.paintBorder(arrayList, arrayList2, graphics2D);
    }

    private void paintCell(ECReport eCReport, int n2, List<CellElement> list, List<Rectangle> list2, Graphics2D graphics2D) {
        DynamicNumberList dynamicNumberList = this.getColumnWidthDynamicNumberList(eCReport, n2);
        DynamicNumberList dynamicNumberList2 = this.getRowHeightDynamicPixList(eCReport, n2);
        Iterator iterator = eCReport.cellIterator();
        while (iterator.hasNext()) {
            CellElement cellElement = (CellElement)iterator.next();
            Rectangle rectangle = this.initCellPaintRec(cellElement, dynamicNumberList, dynamicNumberList2, n2);
            list.add(cellElement);
            list2.add(rectangle);
            graphics2D.translate(rectangle.x, rectangle.y);
            Object object = this.getShowValue(cellElement, rectangle);
            this.paintBackground(graphics2D, cellElement.getStyle(), rectangle.width, rectangle.height);
            Style.paintContent(graphics2D, object, cellElement.getStyle(), rectangle.width, rectangle.height, n2);
            graphics2D.translate(-rectangle.x, -rectangle.y);
        }
    }

    private DynamicNumberList getColumnWidthDynamicNumberList(ECReport eCReport, int n2) {
        DynamicPixList dynamicPixList = ReportHelper.getColumnWidthList(eCReport).toDynamicPixList();
        int n3 = eCReport.getColumnCount();
        return this.converPixToNumberList(dynamicPixList, n3, n2);
    }

    private DynamicNumberList getRowHeightDynamicPixList(ECReport eCReport, int n2) {
        DynamicPixList dynamicPixList = ReportHelper.getRowHeightList(eCReport).toDynamicPixList();
        int n3 = eCReport.getRowCount();
        return this.converPixToNumberList(dynamicPixList, n3, n2);
    }

    private DynamicNumberList converPixToNumberList(DynamicPixList dynamicPixList, int n2, int n3) {
        DynamicNumberList dynamicNumberList = new DynamicNumberList(0, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            dynamicNumberList.set(i2, dynamicPixList.get(i2, n3));
        }
        return dynamicNumberList;
    }

    private void translateBorder(List<CellElement> list, Graphics2D graphics2D) {
        if (list.isEmpty()) {
            return;
        }
        CellElement cellElement = list.get(0);
        int n2 = GraphHelper.getLineStyleSize(cellElement.getStyle().getBorderLeft());
        graphics2D.translate(n2 / 2, 0);
    }

    private void paintBorder(List<CellElement> list, List<Rectangle> list2, Graphics2D graphics2D) {
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            CellElement cellElement = list.get(i2);
            Rectangle rectangle = list2.get(i2);
            graphics2D.translate(rectangle.x, rectangle.y);
            Style.paintBorder(graphics2D, cellElement.getStyle(), rectangle.width, rectangle.height);
            graphics2D.translate(-rectangle.x, -rectangle.y);
        }
    }

    private Object getShowValue(CellElement cellElement, Rectangle rectangle) {
        Object object = cellElement.getValue();
        CellGUIAttr cellGUIAttr = cellElement.getCellGUIAttr();
        Style style = cellElement.getStyle();
        if (cellGUIAttr != null && cellGUIAttr.isShowAsHTML()) {
            object = PaintUtils.createHTMLContentBufferedImage(Utils.objectToString(object), rectangle, 0, 0, style);
        }
        if (!(object instanceof String) && !(object instanceof Integer)) {
            object = Utils.resolveOtherValue(object, cellElement.getCellGUIAttr() != null ? cellElement.getCellGUIAttr().isShowAsImage() : false, PresentationType.EXPORT);
        }
        return object;
    }

    private Rectangle initCellPaintRec(CellElement cellElement, DynamicNumberList dynamicNumberList, DynamicNumberList dynamicNumberList2, int n2) {
        Rectangle rectangle = new Rectangle(cellElement.getColumn(), cellElement.getRow(), cellElement.getColumnSpan(), cellElement.getRowSpan());
        int n3 = dynamicNumberList.getRangeValue(0, rectangle.x);
        int n4 = dynamicNumberList2.getRangeValue(0, rectangle.y);
        int n5 = dynamicNumberList.getRangeValue(rectangle.x, rectangle.x + rectangle.width);
        int n6 = dynamicNumberList2.getRangeValue(rectangle.y, rectangle.y + rectangle.height);
        return new Rectangle(n3, n4, n5, n6);
    }

    private void paintBackground(Graphics2D graphics2D, Style style, double d2, double d3) {
        if (style == null) {
            return;
        }
        Background background = style.getBackground();
        background = background == null ? ColorBackground.getInstance(Color.WHITE) : background;
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        ((Rectangle2D)double_).setRect(0.0, 0.0, d2, d3);
        background.paint(graphics2D, double_);
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        String string;
        String string2;
        if (xMLableReader.isChildNode() && (string2 = xMLableReader.getTagName()).equals("packee") && (string = xMLableReader.getAttrAsString("class", null)) != null) {
            try {
                ResultWorkBook resultWorkBook = null;
                Object obj = Class.forName(string).newInstance();
                if (obj instanceof ResultWorkBook) {
                    this.packee = resultWorkBook = (ResultWorkBook)obj;
                    xMLableReader.readXMLObject(resultWorkBook);
                }
            }
            catch (Exception exception) {
                FRContext.getLogger().error("Failed to read resultSubReport" + exception.getMessage());
            }
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("packee").attr("class", this.packee.getClass().getName());
        this.packee.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ResultSubReport resultSubReport = (ResultSubReport)super.clone();
        resultSubReport.packee = (ResultWorkBook)this.packee.clone();
        return resultSubReport;
    }
}

