/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.cellattr;

import com.fr.base.Style;
import com.fr.general.ComparatorUtils;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.js.NameJavaScriptGroup;
import com.fr.privilege.finegrain.CellPrivilegeControl;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.DefaultPageCellElement;
import com.fr.report.cell.ResultCellElement;
import com.fr.report.cell.cellattr.BrokenCellInfo;
import com.fr.report.cell.cellattr.CellExpandAttr;
import com.fr.report.cell.cellattr.CellGUIAttr;
import com.fr.report.cell.cellattr.CellPageAttr;
import com.fr.report.report.ResultECReport;
import com.fr.stable.FCloneable;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.xml.ReportXMLUtils;

public class PageExportCellElement
implements ResultCellElement {
    private static final Object NULL = new Object();
    private static final CellPageAttr C_NULL = new CellPageAttr();
    protected CellElement cell;
    private int row = 0;
    private int column = 0;
    private int rowspan = 1;
    private int columnspan = 1;
    private Object value = NULL;
    private CellPageAttr cellPageAttr = C_NULL;
    public static final String CELL_XML_TAG = "C";
    private BrokenCellInfo info = null;

    public BrokenCellInfo getBrokenCellInfo() {
        return this.info;
    }

    public void setBrokenCellInfo(BrokenCellInfo brokenCellInfo) {
        this.info = brokenCellInfo;
    }

    public PageExportCellElement() {
    }

    public PageExportCellElement(CellElement cellElement) {
        this.cell = cellElement;
        if (this.cell == null) {
            throw new NullPointerException("Covered cell can not be null");
        }
        this.column = cellElement.getColumn();
        this.row = cellElement.getRow();
        this.columnspan = cellElement.getColumnSpan();
        this.rowspan = cellElement.getRowSpan();
    }

    public PageExportCellElement(CellElement cellElement, int n2, int n3, int n4, int n5) {
        this.cell = cellElement;
        if (this.cell == null) {
            throw new NullPointerException("Covered cell can not be null");
        }
        this.column = n2;
        this.row = n3;
        this.columnspan = n4;
        this.rowspan = n5;
    }

    protected PageExportCellElement(CellElement cellElement, int n2, int n3, int n4, int n5, Object object) {
        this(cellElement, n2, n3, n4, n5);
        this.value = object;
    }

    public CellElement clone(int n2, int n3, int n4, int n5) throws CloneNotSupportedException {
        PageExportCellElement pageExportCellElement = (PageExportCellElement)this.clone();
        pageExportCellElement.setColumn(n2);
        pageExportCellElement.setRow(n3);
        pageExportCellElement.setColumnSpan(n4);
        pageExportCellElement.setRowSpan(n5);
        return pageExportCellElement;
    }

    public void doExcelImportWithLeftSon(ResultECReport resultECReport, CellElement cellElement, int n2, int n3, int n4) {
    }

    public void doExcelImportWithUpSon(ResultECReport resultECReport, CellElement cellElement, int n2, int n3, int n4) {
    }

    public boolean isReadyToDelete() {
        return false;
    }

    public CellElement deriveCellElement(int n2, int n3) {
        return new PageExportCellElement(this.cell, n2, n3, this.columnspan, this.rowspan, this.value);
    }

    public CellElement deriveCellElement(int n2, int n3, int n4, int n5) {
        return new PageExportCellElement(this.cell, n2, n3, n4, n5, this.value);
    }

    public int getColumn() {
        return this.column;
    }

    public int getColumnSpan() {
        return this.columnspan;
    }

    public int getRow() {
        return this.row;
    }

    public int getRowSpan() {
        return this.rowspan;
    }

    public void setColumn(int n2) {
        this.column = n2;
    }

    public void setColumnSpan(int n2) {
        this.columnspan = n2;
    }

    public void setRow(int n2) {
        this.row = n2;
    }

    public void setRowSpan(int n2) {
        this.rowspan = n2;
    }

    public CellGUIAttr getCellGUIAttr() {
        return this.cell.getCellGUIAttr();
    }

    public CellPageAttr getCellPageAttr() {
        return this.cellPageAttr != C_NULL ? this.cellPageAttr : this.cell.getCellPageAttr();
    }

    public NameJavaScriptGroup getNameHyperlinkGroup() {
        return this.cell.getNameHyperlinkGroup();
    }

    public Style getStyle() {
        return this.cell.getStyle();
    }

    public CellElement getOldCell() {
        return this.cell;
    }

    public Object getValue() {
        return this.value != NULL ? this.value : this.cell.getValue();
    }

    public void setCellGUIAttr(CellGUIAttr cellGUIAttr) {
        throw new UnsupportedOperationException();
    }

    public void setCellPageAttr(CellPageAttr cellPageAttr) {
        this.cellPageAttr = cellPageAttr;
    }

    public void setNameHyperlinkGroup(NameJavaScriptGroup nameJavaScriptGroup) {
        throw new UnsupportedOperationException();
    }

    public void setStyle(Style style) {
        this.cell.setStyle(style);
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public boolean isDoneAuthority(String string) {
        return false;
    }

    public boolean isDoneNewValueAuthority(String string) {
        return false;
    }

    public void changeNewValueAuthorityState(String string, boolean bl, Object object) {
    }

    public void changeAuthorityState(String string, boolean bl) {
    }

    public void cleanAuthority(String string) {
    }

    public Object clone() throws CloneNotSupportedException {
        PageExportCellElement pageExportCellElement = (PageExportCellElement)super.clone();
        if (this.value != NULL && this.value != null && this.getValue() instanceof FCloneable) {
            pageExportCellElement.setValue(((FCloneable)this.getValue()).clone());
        }
        if (this.cellPageAttr != C_NULL && this.cellPageAttr != null) {
            pageExportCellElement.setCellPageAttr((CellPageAttr)this.cellPageAttr.clone());
        }
        return pageExportCellElement;
    }

    public Object getShowValue() {
        if (this.value == NULL) {
            return this.cell.getShowValue();
        }
        return ComparatorUtils.equals(this.cell.getValue(), this.cell.getShowValue()) ? this.value : this.cell.getShowValue();
    }

    public boolean isExist() {
        return this.cell.isExist();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.setColumn(Math.max(xMLableReader.getAttrAsInt("c", 0), 0));
            this.setRow(Math.max(xMLableReader.getAttrAsInt("r", 0), 0));
            this.setColumnSpan(Math.max(xMLableReader.getAttrAsInt("cs", 1), 1));
            this.setRowSpan(Math.max(xMLableReader.getAttrAsInt("rs", 1), 1));
        }
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("O")) {
                this.value = GeneralXMLTools.readObject(xMLableReader, true);
            } else if ("CellPageAttr".equals(string)) {
                CellPageAttr cellPageAttr = new CellPageAttr();
                xMLableReader.readXMLObject(cellPageAttr);
                this.cellPageAttr = cellPageAttr;
            } else if (CELL_XML_TAG.equals(string)) {
                DefaultPageCellElement defaultPageCellElement = new DefaultPageCellElement();
                xMLableReader.readXMLObject(defaultPageCellElement);
                this.cell = defaultPageCellElement;
            } else if ("BCI".equals(string)) {
                BrokenCellInfo brokenCellInfo = new BrokenCellInfo();
                xMLableReader.readXMLObject(brokenCellInfo);
                this.info = brokenCellInfo;
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.value != NULL) {
            if (this.value == null) {
                this.value = "";
            }
            GeneralXMLTools.writeObject(xMLPrintWriter, this.value);
        }
        if (this.cellPageAttr != C_NULL) {
            this.cellPageAttr.writeXML(xMLPrintWriter);
        }
        if (this.info != null) {
            xMLPrintWriter.startTAG("BCI");
            this.info.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.cell != null) {
            DefaultPageCellElement defaultPageCellElement = new DefaultPageCellElement(this.cell);
            ReportXMLUtils.writeCellElement(xMLPrintWriter, defaultPageCellElement);
        }
    }

    public void writeCommonResultAttrXML(XMLPrintWriter xMLPrintWriter) {
    }

    public CellElement getCell() {
        return this.cell;
    }

    public CellPrivilegeControl getCellPrivilegeControl() {
        return null;
    }

    public CellExpandAttr getCellExpandAttr() {
        return new CellExpandAttr();
    }

    public boolean isWriter() {
        return false;
    }

    public boolean isView() {
        return false;
    }
}

