/*
 * Decompiled with CFR 0.152.
 */
package com.fr.record;

import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.MSSQLDialect;
import com.fr.data.core.db.dialect.OracleDialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DialectType {
    DEFAULT(0),
    MYSQL(1),
    ORACLE(2){

        public String getReportNameMapTableData(String string) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("select count(a) as tempnum ,nlogtime from (SELECT distinct ").append("\"").append("tname").append("\"").append(" as a,to_char(").append("\"").append("logtime").append("\"").append(",").append("'YYYY-MM-DD')").append(" as nlogtime ").append("from ").append("\"").append(string).append("\"").append(")  group by nlogtime");
            return stringBuffer.toString();
        }

        public String getReportUsageDetailTableData() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("select ").append("\"").append("tname").append("\"").append(", ").append("MIN(").append("\"").append("logtime").append("\"").append(") as MinTime , case ((to_char(sysdate,'yyyy')-1970)*365 + (to_char(sysdate,'mm')-1)*31 + to_char(sysdate,'dd')-((to_char(MIN(").append("\"").append("logtime").append("\"").append("),'yyyy')-1970)*365 + (to_char(MIN(").append("\"").append("logtime").append("\"").append("),'mm')-1)*31 + to_char(MIN(").append("\"").append("logtime").append("\"").append("),'dd')))/31 ").append("WHEN 0 THEN '").append("FS-Monitor-Model_Using").append("' ELSE '").append("FS-Monitor-Model_Unused").append("' END AS CurrentState, ((to_char(sysdate,'yyyy')-1970)*365 + (to_char(sysdate,'mm')-1)*31 + to_char(sysdate,'dd')-((to_char(MIN(").append("\"").append("logtime").append("\"").append("),'yyyy')-1970)*365 + (to_char(MIN(").append("\"").append("logtime").append("\"").append("),'mm')-1)*31 + to_char(MIN(").append("\"").append("logtime").append("\"").append("),'dd'))) AS UseDays from ").append("\"").append("fr_exerecord").append("\"").append(" GROUP BY ").append("\"").append("tname").append("\"").append(" order by CurrentState asc,UseDays desc,MinTime asc,").append("\"").append("tname").append("\"").append(" asc");
            return stringBuffer.toString();
        }

        public String getUserNameMapTableData() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("select count(a) as usernum ,nlogtime from (SELECT distinct ").append("\"").append("username").append("\"").append(" as a,to_char(").append("\"").append("logtime").append("\"").append(",").append("'YYYY-MM-DD')").append(" as nlogtime FROM ").append("\"").append("fr_fsrecord").append("\"").append(")  group by nlogtime");
            return stringBuffer.toString();
        }

        public String getFunctionProcessDBTableData() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("select distinct ").append("\"").append("func").append("\"").append(" from ").append("\"").append("fr_functionrecord").append("\"");
            return stringBuffer.toString();
        }

        public String getReportOpDetailTableData(String string) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("select ").append("\"").append("tname").append("\"").append(", ").append("\"").append("logtime").append("\"").append(", ").append("\"").append("ip").append("\"").append(", ").append("\"").append("type").append("\"").append(", ").append("\"").append("userrole").append("\"").append(", ").append("\"").append("username").append("\"").append(" ").append("from ").append("\"").append(string).append("\"").append(" where ").append("\"").append("logtime").append("\"").append(" >= ").append("to_date(").append("'").append("${START_TIME}").append("'").append(",").append("'YYYY-MM-DD HH24:MI:ss')").append(" and ").append("\"").append("logtime").append("\"").append(" < ").append("to_date(").append("'").append("${END_TIME}").append("'").append(",").append("'YYYY-MM-DD HH24:MI:ss')");
            return stringBuffer.toString();
        }

        public String getReportOpTimeMapTableData(String string) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("select ").append("\"").append("logtime").append("\"").append(" ").append("from ").append("\"").append(string).append("\"");
            return stringBuffer.toString();
        }
    }
    ,
    SQL_SERVER(3){

        public String getReportNameMapTableData(String string) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("select count(a) as tempnum ,nlogtime from (SELECT distinct ").append("tname").append(" as a,").append("logtime").append(" as nlogtime ").append("from ").append(string).append(") as c group by nlogtime");
            return stringBuffer.toString();
        }

        public String getReportUsageDetailTableData() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("select ").append("tname").append(", ").append("MIN(").append("logtime").append(") as MinTime , case ((year(getdate())-1970)*365 + (month(getdate())-1)*31 + day(getdate())-((year(MIN(").append("logtime").append("))-1970)*365 + (month(MIN(").append("logtime").append("))-1)*31 + day(MIN(").append("logtime").append("))))/31 ").append("WHEN 0 THEN '").append("FS-Monitor-Model_Using").append("' ELSE '").append("FS-zMonitor-Model_Unused").append("' END AS CurrentState, ((year(getdate())-1970)*365 + (month(getdate())-1)*31 + day(getdate())-((year(MIN(").append("logtime").append("))-1970)*365 + (month(MIN(").append("logtime").append("))-1)*31 + day(MIN(").append("logtime").append(")))) AS UseDays from ").append("fr_exerecord").append(" GROUP BY ").append("tname").append(" order by CurrentState asc,UseDays desc,MinTime asc,tname asc");
            return stringBuffer.toString();
        }

        public String getUserNameMapTableData() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("select count(a) as usernum ,nlogtime from (SELECT distinct ").append("username").append(" as a,").append("logtime").append(" as nlogtime FROM ").append("fr_fsrecord").append(") as c group by nlogtime");
            return stringBuffer.toString();
        }
    };

    private int type;

    private DialectType(int n3) {
        this.type = n3;
    }

    public String getReportNameMapTableData(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select count(a) as tempnum ,nlogtime from (SELECT distinct ").append("tname").append(" as a,substr(").append("logtime").append(",0,10) as nlogtime ").append("from ").append(string).append(") as c group by nlogtime");
        return stringBuffer.toString();
    }

    public String getReportUsageDetailTableData() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select ").append("tname").append(", ").append("MIN(").append("logtime").append(") as MinTime , case ((year(now())-1970)*365 + (month(now())-1)*31 + day(now())-((year(MIN(").append("logtime").append("))-1970)*365 + (month(MIN(").append("logtime").append("))-1)*31 + day(MIN(").append("logtime").append("))))/31 ").append("WHEN 0 THEN '").append("FS-Monitor-Model_Using").append("' ELSE '").append("FS-Monitor-Model_Unused").append("' END AS CurrentState, ((year(now())-1970)*365 + (month(now())-1)*31 + day(now())-((year(MIN(").append("logtime").append("))-1970)*365 + (month(MIN(").append("logtime").append("))-1)*31 + day(MIN(").append("logtime").append(")))) AS UseDays from ").append("fr_exerecord").append(" GROUP BY ").append("tname").append(" order by CurrentState asc,UseDays desc,MinTime asc,tname asc");
        return stringBuffer.toString();
    }

    public String getUserNameMapTableData() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select count(a) as usernum ,nlogtime from (SELECT distinct ").append("username").append(" as a,substr(").append("logtime").append(",0,10) as nlogtime FROM ").append("fr_fsrecord").append(") as c group by nlogtime");
        return stringBuffer.toString();
    }

    public String getFunctionProcessDBTableData() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select distinct ").append("func").append(" from ").append("fr_functionrecord");
        return stringBuffer.toString();
    }

    public String getReportOpDetailTableData(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select ").append("tname").append(", ").append("logtime").append(", ").append("ip").append(", ").append("type").append(", ").append("userrole").append(", ").append("username").append(" ").append("from ").append(string).append(" where ").append("logtime").append(" >= '${START_TIME}' and ").append("logtime").append(" < '${END_TIME}' ");
        return stringBuffer.toString();
    }

    public String getReportOpTimeMapTableData(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select ").append("logtime").append(" ").append("from ").append(string);
        return stringBuffer.toString();
    }

    public int getType() {
        return this.type;
    }

    public static DialectType parseDialectType(int n2) {
        for (DialectType dialectType : DialectType.values()) {
            if (dialectType.getType() != n2) continue;
            return dialectType;
        }
        return DEFAULT;
    }

    public static DialectType parseTypeByDialect(Dialect dialect) {
        if (dialect instanceof OracleDialect) {
            return ORACLE;
        }
        if (dialect instanceof MSSQLDialect) {
            return SQL_SERVER;
        }
        return DEFAULT;
    }
}

