/*
 * Decompiled with CFR 0.152.
 */
package com.fr.privilege.authentication;

import com.fr.general.ComparatorUtils;
import com.fr.privilege.Authentication;
import com.fr.privilege.PrivilegeManager;
import com.fr.stable.privilege.AuthorityBridge;

public abstract class AbstractAuthentication
implements Authentication {
    private static final long serialVersionUID = 1L;
    private AuthorityBridge[] authorities;
    private boolean authenticated = false;
    protected boolean isRoot = false;
    private transient String[] role;

    public String[] getRole() {
        if (this.role == null) {
            this.role = PrivilegeManager.getRoleFromAuthentication(this);
        }
        return this.role;
    }

    public void setAuthorities(AuthorityBridge[] authorityBridgeArray) {
        this.authorities = authorityBridgeArray;
        this.role = null;
    }

    public AuthorityBridge[] getAuthorities() {
        if (this.authorities == null) {
            return new AuthorityBridge[0];
        }
        AuthorityBridge[] authorityBridgeArray = new AuthorityBridge[this.authorities.length];
        System.arraycopy(this.authorities, 0, authorityBridgeArray, 0, this.authorities.length);
        return authorityBridgeArray;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(boolean bl) {
        this.authenticated = bl;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setRoot(boolean bl) {
        this.isRoot = bl;
    }

    public boolean equals(Object object) {
        return object instanceof AbstractAuthentication && ComparatorUtils.equals(((AbstractAuthentication)object).authorities, this.authorities) && ComparatorUtils.equals(((AbstractAuthentication)object).getCredentials(), this.getCredentials()) && ComparatorUtils.equals(((AbstractAuthentication)object).getPrincipal(), this.getPrincipal()) && ((AbstractAuthentication)object).authenticated == this.authenticated;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append(": ");
        stringBuffer.append("Principal: ").append(this.getPrincipal()).append("; ");
        stringBuffer.append("Password: [PROTECTED]; ");
        stringBuffer.append("Authenticated: ").append(this.isAuthenticated()).append("; ");
        if (this.getAuthorities() != null) {
            stringBuffer.append("Granted Authorities: ");
            for (int i2 = 0; i2 < this.getAuthorities().length; ++i2) {
                if (i2 > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.getAuthorities()[i2].toString());
            }
        } else {
            stringBuffer.append("Not granted any authorities");
        }
        return stringBuffer.toString();
    }
}

