/*
 * Decompiled with CFR 0.152.
 */
package com.fr.privilege.allocation;

import com.fr.general.ComparatorUtils;
import com.fr.privilege.allocation.FileFrag;
import com.fr.privilege.allocation.FileFragList;
import com.fr.stable.StableUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Allocation
implements XMLable {
    private static final long serialVersionUID = -2914825417693733767L;
    public static final String XML_TAG = "Allocation";
    private FileFragList designList = new FileFragList();
    private FileFragList viewList = new FileFragList();
    private FileFragList formList = new FileFragList();
    private FileFragList writeList = new FileFragList();
    private FileFragList excelSubmitList = new FileFragList();
    private HashSet<String> dsPrivilegeSet = new HashSet();

    public Allocation() {
    }

    public Allocation(HashSet<String> hashSet) {
        this.dsPrivilegeSet = hashSet;
    }

    public void addDSPrivilege(String string) {
        this.dsPrivilegeSet.add(string);
    }

    public void setDSPrivilege(HashSet<String> hashSet) {
        this.dsPrivilegeSet = hashSet;
    }

    public HashSet<String> getDSPrivilege() {
        return this.dsPrivilegeSet;
    }

    public void removeDSPrivilege(String string) {
        this.dsPrivilegeSet.remove(string);
    }

    public void clearDSPrivilege() {
        this.dsPrivilegeSet.clear();
    }

    public void addDesign(FileFrag fileFrag) {
        if (!this.designList.contains(fileFrag)) {
            this.designList.addFileFrag(fileFrag);
        }
    }

    public void addDesign(FileFrag[] fileFragArray) {
        if (fileFragArray != null && fileFragArray.length > 0) {
            for (int i2 = 0; i2 < fileFragArray.length; ++i2) {
                this.addDesign(fileFragArray[i2]);
            }
        }
    }

    public int getDesignCount() {
        return this.designList.size();
    }

    public String designString() {
        return StableUtils.join(this.designList.toArray(), ",");
    }

    public FileFrag getDesign(int n2) {
        return this.designList.getFileFrag(n2);
    }

    public void clearDesign() {
        this.designList.clear();
    }

    public void removeDesign(FileFrag fileFrag) {
        this.designList.remove(fileFrag);
    }

    public void removeDesign(FileFrag[] fileFragArray) {
        if (fileFragArray != null && fileFragArray.length > 0) {
            for (int i2 = 0; i2 < fileFragArray.length; ++i2) {
                this.removeDesign(fileFragArray[i2]);
            }
        }
    }

    public void addView(FileFrag fileFrag) {
        if (!this.viewList.contains(fileFrag)) {
            this.viewList.addFileFrag(fileFrag);
        }
    }

    public void addView(FileFrag[] fileFragArray) {
        if (fileFragArray != null && fileFragArray.length > 0) {
            for (int i2 = 0; i2 < fileFragArray.length; ++i2) {
                this.addView(fileFragArray[i2]);
            }
        }
    }

    public int getViewCount() {
        return this.viewList.size();
    }

    public FileFrag getView(int n2) {
        return this.viewList.getFileFrag(n2);
    }

    public void clearView() {
        this.viewList.clear();
    }

    public void removeView(FileFrag fileFrag) {
        this.viewList.remove(fileFrag);
    }

    public void removeView(FileFrag[] fileFragArray) {
        if (fileFragArray != null && fileFragArray.length > 0) {
            for (int i2 = 0; i2 < fileFragArray.length; ++i2) {
                this.removeView(fileFragArray[i2]);
            }
        }
    }

    public void addForm(FileFrag fileFrag) {
        if (!this.formList.contains(fileFrag)) {
            this.formList.addFileFrag(fileFrag);
        }
    }

    public void addForm(FileFrag[] fileFragArray) {
        if (fileFragArray != null && fileFragArray.length > 0) {
            for (int i2 = 0; i2 < fileFragArray.length; ++i2) {
                this.addForm(fileFragArray[i2]);
            }
        }
    }

    public int getFormCount() {
        return this.formList.size();
    }

    public FileFrag getForm(int n2) {
        return this.formList.getFileFrag(n2);
    }

    public void clearForm() {
        this.formList.clear();
    }

    public void removeForm(FileFrag fileFrag) {
        this.formList.remove(fileFrag);
    }

    public void removeForm(FileFrag[] fileFragArray) {
        if (fileFragArray != null && fileFragArray.length > 0) {
            for (int i2 = 0; i2 < fileFragArray.length; ++i2) {
                this.removeForm(fileFragArray[i2]);
            }
        }
    }

    public void addWrite(FileFrag fileFrag) {
        if (!this.writeList.contains(fileFrag)) {
            this.writeList.addFileFrag(fileFrag);
        }
    }

    public void addWrite(FileFrag[] fileFragArray) {
        if (fileFragArray != null && fileFragArray.length > 0) {
            for (int i2 = 0; i2 < fileFragArray.length; ++i2) {
                this.addWrite(fileFragArray[i2]);
            }
        }
    }

    public int getWriteCount() {
        return this.writeList.size();
    }

    public FileFrag getWrite(int n2) {
        return this.writeList.getFileFrag(n2);
    }

    public void clearWrite() {
        this.writeList.clear();
    }

    public void removeWrite(FileFrag fileFrag) {
        this.writeList.remove(fileFrag);
    }

    public void removeWrite(FileFrag[] fileFragArray) {
        if (fileFragArray != null && fileFragArray.length > 0) {
            for (int i2 = 0; i2 < fileFragArray.length; ++i2) {
                this.removeWrite(fileFragArray[i2]);
            }
        }
    }

    public void addExcelSubmit(FileFrag fileFrag) {
        if (!this.excelSubmitList.contains(fileFrag)) {
            this.excelSubmitList.addFileFrag(fileFrag);
        }
    }

    public void addExcelSubmit(FileFrag[] fileFragArray) {
        if (fileFragArray != null && fileFragArray.length > 0) {
            for (int i2 = 0; i2 < fileFragArray.length; ++i2) {
                this.addExcelSubmit(fileFragArray[i2]);
            }
        }
    }

    public int getExcelSubmitCount() {
        return this.excelSubmitList.size();
    }

    public FileFrag getExcelSubmit(int n2) {
        return this.excelSubmitList.getFileFrag(n2);
    }

    public void clearExcelSubmit() {
        this.excelSubmitList.clear();
    }

    public void removeExcelSubmit(FileFrag fileFrag) {
        this.excelSubmitList.remove(fileFrag);
    }

    public void removeExcelSubmit(FileFrag[] fileFragArray) {
        if (fileFragArray != null && fileFragArray.length > 0) {
            for (int i2 = 0; i2 < fileFragArray.length; ++i2) {
                this.removeExcelSubmit(fileFragArray[i2]);
            }
        }
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.clearDesign();
            this.clearView();
            this.clearForm();
            this.clearWrite();
            this.clearExcelSubmit();
        }
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (ComparatorUtils.equals("Designs", string)) {
                FileFrag[] fileFragArray = this.readFileFrags(xMLableReader);
                this.addDesign(fileFragArray);
            } else if (ComparatorUtils.equals("Views", string)) {
                FileFrag[] fileFragArray = this.readFileFrags(xMLableReader);
                this.addView(fileFragArray);
            } else if (ComparatorUtils.equals("Forms", string)) {
                FileFrag[] fileFragArray = this.readFileFrags(xMLableReader);
                this.addForm(fileFragArray);
            } else if (ComparatorUtils.equals("Writes", string)) {
                FileFrag[] fileFragArray = this.readFileFrags(xMLableReader);
                this.addWrite(fileFragArray);
            } else if (ComparatorUtils.equals("ExcelSubmit", string)) {
                FileFrag[] fileFragArray = this.readFileFrags(xMLableReader);
                this.addExcelSubmit(fileFragArray);
            } else if (ComparatorUtils.equals("DSPrivilege", string)) {
                final HashSet<String> hashSet = new HashSet<String>();
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if ("DSName".equals(xMLableReader.getTagName())) {
                            xMLableReader.readXMLObject(new XMLReadable(){

                                public void readXML(XMLableReader xMLableReader) {
                                    String string;
                                    if (xMLableReader.isAttr() && (string = xMLableReader.getAttrAsString("dsName", null)) != null) {
                                        hashSet.add(string);
                                    }
                                }
                            });
                        }
                    }
                });
                this.setDSPrivilege(hashSet);
            }
        }
    }

    private FileFrag[] readFileFrags(XMLableReader xMLableReader) {
        final FileFragList fileFragList = new FileFragList();
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if ("FileFrag".equals(xMLableReader.getTagName())) {
                    FileFrag fileFrag = new FileFrag();
                    xMLableReader.readXMLObject(fileFrag);
                    fileFragList.addFileFrag(fileFrag);
                }
            }
        });
        return fileFragList.toArray();
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        int n2;
        xMLPrintWriter.startTAG(XML_TAG);
        if (this.designList.size() > 0) {
            xMLPrintWriter.startTAG("Designs");
            for (n2 = 0; n2 < this.designList.size(); ++n2) {
                this.designList.getFileFrag(n2).writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
        if (this.viewList.size() > 0) {
            xMLPrintWriter.startTAG("Views");
            for (n2 = 0; n2 < this.viewList.size(); ++n2) {
                this.viewList.getFileFrag(n2).writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
        if (this.formList.size() > 0) {
            xMLPrintWriter.startTAG("Forms");
            for (n2 = 0; n2 < this.formList.size(); ++n2) {
                this.formList.getFileFrag(n2).writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
        if (this.writeList.size() > 0) {
            xMLPrintWriter.startTAG("Writes");
            for (n2 = 0; n2 < this.writeList.size(); ++n2) {
                this.writeList.getFileFrag(n2).writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
        if (this.excelSubmitList.size() > 0) {
            xMLPrintWriter.startTAG("ExcelSubmit");
            for (n2 = 0; n2 < this.excelSubmitList.size(); ++n2) {
                this.excelSubmitList.getFileFrag(n2).writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
        if (this.dsPrivilegeSet.size() > 0) {
            xMLPrintWriter.startTAG("DSPrivilege");
            for (String string : this.dsPrivilegeSet) {
                xMLPrintWriter.startTAG("DSName");
                xMLPrintWriter.attr("dsName", string);
                xMLPrintWriter.end();
            }
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Allocation allocation = (Allocation)super.clone();
        FileFragList fileFragList = new FileFragList();
        for (int i2 = 0; i2 < this.designList.size(); ++i2) {
            fileFragList.addFileFrag((FileFrag)this.designList.getFileFrag(i2).clone());
        }
        allocation.designList = fileFragList;
        FileFragList fileFragList2 = new FileFragList();
        for (int i3 = 0; i3 < this.viewList.size(); ++i3) {
            fileFragList2.addFileFrag((FileFrag)this.viewList.getFileFrag(i3).clone());
        }
        allocation.viewList = fileFragList2;
        FileFragList fileFragList3 = new FileFragList();
        for (int i4 = 0; i4 < this.formList.size(); ++i4) {
            fileFragList3.addFileFrag((FileFrag)this.formList.getFileFrag(i4).clone());
        }
        allocation.formList = fileFragList3;
        FileFragList fileFragList4 = new FileFragList();
        for (int i5 = 0; i5 < this.writeList.size(); ++i5) {
            fileFragList4.addFileFrag((FileFrag)this.writeList.getFileFrag(i5).clone());
        }
        allocation.writeList = fileFragList4;
        return allocation;
    }
}

