/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.dependence;

import com.fr.base.FRContext;
import com.fr.general.Inter;
import com.fr.json.JSONArray;
import com.fr.plugin.dependence.PluginDependenceUnit;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginDependence
implements XMLable {
    private String currentPluginID;
    private List<PluginDependenceUnit> dependPlugins;

    public PluginDependence(String string) {
        this.currentPluginID = string;
        this.dependPlugins = new ArrayList<PluginDependenceUnit>();
    }

    public String getCurrentPluginID() {
        return this.currentPluginID;
    }

    public List<PluginDependenceUnit> getDependPlugins() {
        return this.dependPlugins;
    }

    public void checkDependExist() {
        for (PluginDependenceUnit pluginDependenceUnit : this.dependPlugins) {
            pluginDependenceUnit.checkDependExist(this.getCurrentPluginID());
        }
    }

    public void startService() {
        for (PluginDependenceUnit pluginDependenceUnit : this.dependPlugins) {
            if (pluginDependenceUnit.startService()) continue;
            FRContext.getLogger().error(Inter.getLocText("FR-Plugin-Dependence_Service_Not_Found") + pluginDependenceUnit.getDependenceID());
        }
    }

    public JSONArray createJSON() {
        return new JSONArray(this.dependPlugins);
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    PluginDependenceUnit pluginDependenceUnit = new PluginDependenceUnit();
                    xMLableReader.readXMLObject(pluginDependenceUnit);
                    PluginDependence.this.dependPlugins.add(pluginDependenceUnit);
                }
            }
        });
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
    }
}

