/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin;

import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.IOUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.stable.fun.Authorize;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;

public class PluginLicense
implements XMLable {
    public static final PluginLicense NULL = new PluginLicense();
    private static final String TRIAL = "trial";
    private static final String DAMAGE = "damage";
    private String licType;
    private String pluginID;
    private String version;
    private String macAddress;
    private String licLock;
    private String machineID;
    private String projectID;
    private String vendor;
    private String pluginLife;
    private String startTime;
    private boolean available = false;
    private int leftTime = -1;
    private boolean trial = false;
    private Authorize authorize;

    public PluginLicense() {
    }

    public PluginLicense(Authorize authorize, String string) {
        this.authorize = authorize;
        this.pluginID = string;
    }

    public String getAuthorizedSignKey() {
        return StringUtils.isNotBlank(this.authorize.callSignKey()) ? this.authorize.callSignKey() : this.readPluginSignKeyFile(this.authorize.callSignKeyPath());
    }

    public String getStartTime() {
        return this.startTime;
    }

    public boolean isTrial() {
        return this.trial;
    }

    public void setTrial(boolean bl) {
        this.trial = bl;
        if (bl) {
            this.licType = TRIAL;
        }
    }

    public int getLeftTime() {
        return this.leftTime;
    }

    public void setLeftTime(int n2) {
        this.leftTime = n2;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean bl) {
        this.available = bl;
    }

    public String getLicType() {
        return this.licType;
    }

    public void setPluginID(String string) {
        this.pluginID = string;
    }

    public String getPluginID() {
        return this.pluginID;
    }

    public String getVersion() {
        return this.version;
    }

    public String getMACAddress() {
        return this.macAddress;
    }

    public String getLicLock() {
        return this.licLock;
    }

    public String getMachineID() {
        return this.machineID;
    }

    public String getProjectID() {
        return this.projectID;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getPluginLife() {
        return this.pluginLife;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("licTypeChecked".equals(string)) {
                this.licType = xMLableReader.getElementValue();
            } else if ("pluginID".equals(string)) {
                this.pluginID = xMLableReader.getElementValue();
            } else if ("version".equals(string)) {
                this.version = xMLableReader.getElementValue();
            } else if ("macAddress".equals(string)) {
                this.macAddress = xMLableReader.getElementValue();
            } else if ("licLock".equals(string)) {
                this.licLock = xMLableReader.getElementValue();
            } else if ("machineID".equals(string)) {
                this.machineID = xMLableReader.getElementValue();
            } else if ("projectID".equals(string)) {
                this.projectID = xMLableReader.getElementValue();
            } else if ("vendor".equals(string)) {
                this.vendor = xMLableReader.getElementValue();
            } else if ("pluginLife".equals(string)) {
                this.pluginLife = xMLableReader.getElementValue();
            } else if ("startTime".equals(string)) {
                this.startTime = xMLableReader.getElementValue();
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = JSONObject.create();
        try {
            jSONObject.put("licTypeChecked", this.licType);
            jSONObject.put("pluginID", this.pluginID);
            jSONObject.put("version", this.version);
            jSONObject.put("macAddress", this.macAddress);
            jSONObject.put("licLock", this.licLock);
            jSONObject.put("machineID", this.machineID);
            jSONObject.put("vendor", this.vendor);
            jSONObject.put("projectID", this.projectID);
            jSONObject.put("pluginLife", this.pluginLife);
            jSONObject.put("startTime", this.startTime);
            jSONObject.put("available", this.available);
            jSONObject.put("leftTime", this.leftTime);
            jSONObject.put(TRIAL, this.trial);
        }
        catch (JSONException jSONException) {
            FRLogger.getLogger().error(jSONException.getMessage(), jSONException);
        }
        return jSONObject;
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        this.licType = jSONObject.optString("licTypeChecked");
        this.pluginID = jSONObject.optString("pluginID");
        this.version = jSONObject.optString("version");
        this.macAddress = jSONObject.optString("macAddress");
        this.vendor = jSONObject.optString("vendor");
        this.licLock = jSONObject.optString("licLock");
        this.machineID = jSONObject.optString("machineID");
        this.projectID = jSONObject.optString("projectID");
        this.pluginLife = jSONObject.optString("pluginLife");
        this.startTime = jSONObject.optString("startTime");
        this.available = jSONObject.optBoolean("available");
        this.leftTime = jSONObject.optInt("leftTime");
        this.trial = jSONObject.optBoolean(TRIAL);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        return object instanceof PluginLicense && ComparatorUtils.equals(((PluginLicense)object).pluginID, this.pluginID) && ComparatorUtils.equals(((PluginLicense)object).version, this.version);
    }

    public int hashCode() {
        int n2 = this.pluginID.hashCode();
        n2 = 31 * n2 + (this.version != null ? this.version.hashCode() : 0);
        return n2;
    }

    public boolean isValid() {
        return StringUtils.isNotBlank(this.pluginID) && StringUtils.isNotBlank(this.pluginLife) && StringUtils.isNotBlank(this.licType);
    }

    public void jarDamage() {
        this.licType = DAMAGE;
    }

    public boolean isJarIntact() {
        return ComparatorUtils.equals(this.pluginID, this.getAuthorizedSignKey());
    }

    public boolean isJarDamage() {
        return ComparatorUtils.equals(this.licType, DAMAGE);
    }

    public void setPluginInfoFromXml(PluginLicense pluginLicense) {
        this.licType = pluginLicense.getLicType();
        this.available = pluginLicense.isAvailable();
        this.leftTime = pluginLicense.getLeftTime();
        this.licLock = pluginLicense.getLicLock();
        this.macAddress = pluginLicense.getMACAddress();
        this.machineID = pluginLicense.getMachineID();
        this.pluginLife = pluginLicense.getPluginLife();
        this.projectID = pluginLicense.getProjectID();
        this.startTime = pluginLicense.getStartTime();
        this.trial = pluginLicense.isTrial();
        this.vendor = pluginLicense.getVendor();
        this.version = pluginLicense.getVersion();
    }

    private String readPluginSignKeyFile(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(string));
            return IOUtils.inputStream2String(fileInputStream, "UTF-8");
        }
        catch (FileNotFoundException fileNotFoundException) {
            return "";
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }
}

