/*
 * Decompiled with CFR 0.152.
 */
package com.fr.performance.recorder;

import com.fr.general.FRLogger;
import com.fr.performance.dao.PerformanceSaverManager;
import com.fr.performance.info.IExportInfo;
import com.fr.performance.info.IReportPerformanceInfo;
import com.fr.performance.info.ISubmitInfo;
import com.fr.performance.info.ReportPerformanceInfo;
import com.fr.performance.recorder.PerformanceInfoRecorder;
import java.util.Map;

class PerformanceInfoRecorderImpl
implements PerformanceInfoRecorder {
    private IReportPerformanceInfo reportPerformanceInfo = this.createReportPerformanceInfo();
    private static final String UNKNOWN_NAME = "unknown";
    private String dsName = "unknown";

    public void setReportPerformanceInfo(IReportPerformanceInfo iReportPerformanceInfo) {
        this.reportPerformanceInfo = iReportPerformanceInfo;
    }

    private ReportPerformanceInfo createReportPerformanceInfo() {
        return ReportPerformanceInfo.newInstance();
    }

    public void setWorkBookName(String string) {
        this.reportPerformanceInfo.setWorkBookName(string);
    }

    public void recordDataModelRowCount(String string, int n2) {
        this.reportPerformanceInfo.putDataModelRowCount(string, n2);
    }

    public void recordDataModelColCount(String string, int n2) {
        this.reportPerformanceInfo.putDataModelColCount(string, n2);
    }

    public void recordSqlExecuteTime(String string, long l2) {
        this.reportPerformanceInfo.putDataSourceExecuteTime(string, l2);
    }

    public void recordTransferTime(String string, long l2) {
        this.reportPerformanceInfo.putDataSourceTransferTime(string, l2);
    }

    public void recordBuildDataTime(String string, long l2) {
        this.reportPerformanceInfo.addBuildDataTime(string, l2);
    }

    public void recordCellCalculateTime(String string, long l2) {
        this.reportPerformanceInfo.putCellCalculateTime(string, l2);
    }

    public void recordCalculateTime(long l2) {
        this.reportPerformanceInfo.setCalculateTime(l2);
    }

    public void addCellFilterTime(String string, long l2) {
        this.reportPerformanceInfo.addCellFilterTime(string, l2);
    }

    public void addCellCustomDisplayTime(String string, long l2) {
        this.reportPerformanceInfo.addCellCustomDisplayTime(string, l2);
    }

    public void addCellPresentTime(String string, long l2) {
        this.reportPerformanceInfo.addCellPresentTime(string, l2);
    }

    public void addCellHighlightTime(String string, long l2) {
        this.reportPerformanceInfo.addCellHighlightTime(string, l2);
    }

    public void addDynamicTime(String string, long l2) {
    }

    public void addCellHyperlinkTime(String string, long l2) {
        this.reportPerformanceInfo.addCellHyperlinkTime(string, l2);
    }

    public void recordReportMemory(String string, long l2) {
        this.reportPerformanceInfo.putReportMemory(string, l2);
    }

    public void recordExportInfo(IExportInfo iExportInfo) {
        this.reportPerformanceInfo.addExportInfo(iExportInfo);
    }

    public void recordSubmitInfo(ISubmitInfo iSubmitInfo) {
        this.reportPerformanceInfo.addSubmitInfo(iSubmitInfo);
    }

    public void completeRecorder() {
        PerformanceSaverManager.saveReportPerformanceInfo(this.reportPerformanceInfo);
    }

    public void recordParameterMap(Map map) {
        String string = FRLogger.createParamString(map);
        this.reportPerformanceInfo.putParameterString(string);
    }

    public void recordSQLFun(String string, long l2) {
        this.reportPerformanceInfo.addSqlFunExecuteTimes(string, l2);
    }

    public void recordToImageFun(String string, long l2, boolean bl) {
        this.reportPerformanceInfo.addImageMemory(string, l2, bl);
    }

    public void recordToImageFun(String string, long l2) {
        this.reportPerformanceInfo.addImageMemory(string, l2);
    }

    public void recordReportFromCache() {
        this.reportPerformanceInfo.setCalculateTime(-2L);
    }

    public void beginDataSourceRecord(String string) {
        this.dsName = string;
    }

    public void endDataSourceRecord(String string) {
        this.dsName = UNKNOWN_NAME;
    }

    public String getRecordingDsName() {
        return this.dsName;
    }

    public void recordBuildDataTime(long l2) {
        this.recordBuildDataTime(this.dsName, l2);
    }

    public void recordSqlExecuteTime(long l2) {
        this.recordSqlExecuteTime(this.dsName, l2);
    }

    public void recordTransferTime(long l2) {
        this.recordTransferTime(this.dsName, l2);
    }

    public void addCellDynamicParameter(String string, long l2) {
        this.reportPerformanceInfo.addCellDynamicParameter(string, l2);
    }

    public IReportPerformanceInfo getReportPerformanceInfo() {
        return this.reportPerformanceInfo;
    }
}

