/*
 * Decompiled with CFR 0.152.
 */
package com.fr.performance.memory;

import com.fr.performance.exception.OverThresholdMemoryException;
import com.fr.performance.memory.MemoryConfig;
import com.fr.performance.memory.MemoryManager;
import com.fr.performance.strategy.Strategy;
import com.fr.performance.strategy.StrategyManager;
import java.lang.management.MemoryPoolMXBean;

public class MemoryMonitor {
    private static boolean isOnMonitor = true;
    private static final long UNCHECKED_MEMORY = 0x100000L;
    private static final int MAX_UNCHECKED_COUNT = 100;
    private static int uncheckedCount;
    private static final double maxPercent = 0.625;

    public static void init() {
        MemoryConfig.init();
    }

    public static void setMonitorEnable(boolean bl) {
        isOnMonitor = bl;
    }

    private static boolean isOnMonitor() {
        return isOnMonitor;
    }

    public static void checkMemoryAfterAllocated(long l2) {
        if (MemoryMonitor.isIgnoreCheck(l2)) {
            return;
        }
        MemoryMonitor.checkMemory();
    }

    public static void checkMemory() throws OverThresholdMemoryException {
        MemoryMonitor.checkMemory(StrategyManager.getOverMemoryStrategy());
    }

    public static void checkMemory(Strategy strategy) {
        if (MemoryMonitor.isOnMonitor() && MemoryMonitor.isOverThreshold()) {
            strategy.action();
        }
    }

    public static void checkMemoryBeforeAllocated(long l2) {
        if (MemoryMonitor.isIgnoreCheck(l2)) {
            return;
        }
        if (MemoryMonitor.isOnMonitor() && MemoryMonitor.isOverThresholdWhenAllocate(l2)) {
            StrategyManager.getOverMemoryStrategy().action();
        }
    }

    private static boolean isIgnoreCheck(long l2) {
        if (l2 < 0x100000L || uncheckedCount < 100) {
            ++uncheckedCount;
            return true;
        }
        uncheckedCount = 0;
        return false;
    }

    static boolean isOverThreshold() {
        MemoryPoolMXBean memoryPoolMXBean = MemoryManager.getTenuredMemoryPool();
        if (MemoryManager.checkValid(memoryPoolMXBean)) {
            return memoryPoolMXBean.isUsageThresholdExceeded();
        }
        return MemoryMonitor.isOverThresholdWhenAllocate(0L);
    }

    static boolean isOverThresholdWhenAllocate(long l2) {
        MemoryPoolMXBean memoryPoolMXBean = MemoryManager.getTenuredMemoryPool();
        if (memoryPoolMXBean == null) {
            return MemoryMonitor.isOverThresholdWhenNoMXBean();
        }
        return MemoryMonitor.isOverThreshold(memoryPoolMXBean, l2);
    }

    private static boolean isOverThreshold(MemoryPoolMXBean memoryPoolMXBean, long l2) {
        long l3;
        long l4 = memoryPoolMXBean.getUsage().getUsed();
        long l5 = l4 + l2;
        return l5 >= MemoryConfig.calculateThreshold(l3 = memoryPoolMXBean.getUsage().getMax());
    }

    private static boolean isOverThresholdWhenNoMXBean() {
        double d2 = 0.625;
        long l2 = (long)((double)Runtime.getRuntime().maxMemory() * d2);
        long l3 = MemoryConfig.calculateThreshold(l2);
        long l4 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        if (l4 > l2) {
            return true;
        }
        return (double)l4 - (1.0 - d2) / 2.0 * (double)l2 > (double)l3;
    }

    private static long estimateUsedMemoryWhenNoMXBean() {
        long l2 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        return l2;
    }

    static {
        MemoryMonitor.init();
    }
}

