/*
 * Decompiled with CFR 0.152.
 */
package com.fr.performance.memory;

import com.fr.base.ExcelUtils;
import com.fr.io.exporter.AppExporter;
import com.fr.io.exporter.Excel2007Exporter;
import com.fr.io.exporter.ExcelExporter;
import com.fr.io.exporter.LargeDataPageExcelExporter;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.performance.EngineMemoryEstimation;
import com.fr.report.report.ResultECReport;
import com.fr.report.report.ResultReport;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;

public class MemoryEstimation
implements EngineMemoryEstimation {
    private static final MemoryEstimation INSTANCE = new MemoryEstimation();

    private MemoryEstimation() {
    }

    public static MemoryEstimation getInstance() {
        return INSTANCE;
    }

    public long estimateMemory(AppExporter appExporter, ResultWorkBook resultWorkBook) {
        if (appExporter instanceof ExcelExporter) {
            if (this.isExcel2007Export()) {
                try {
                    return this.calculateCellCount(resultWorkBook) * 800L;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (appExporter instanceof Excel2007Exporter) {
                return this.calculateCellCount(resultWorkBook) * 800L;
            }
            if (appExporter instanceof LargeDataPageExcelExporter) {
                return 0L;
            }
            return this.calculateCellCount(resultWorkBook) * 180L;
        }
        return 0L;
    }

    private boolean isExcel2007Export() {
        return ExcelUtils.checkThirdJarSupportPOI();
    }

    private long calculateCellCount(ResultWorkBook resultWorkBook) {
        int n2 = resultWorkBook.getReportCount();
        long l2 = 0L;
        for (int i2 = 0; i2 < n2; ++i2) {
            ResultReport resultReport = resultWorkBook.getResultReport(i2);
            if (!(resultReport instanceof ResultECReport)) continue;
            l2 += this.calculateCellCount((ResultECReport)resultReport);
        }
        return l2;
    }

    private long calculateCellCount(ResultECReport resultECReport) {
        int n2 = resultECReport.getRowCount();
        int n3 = resultECReport.getColumnCount();
        return n2 * n3;
    }

    public long estimateImageMemory(BufferedImage bufferedImage) {
        SampleModel sampleModel = bufferedImage.getRaster().getSampleModel();
        int n2 = this.getElementSize(sampleModel) / 8;
        return bufferedImage.getWidth() * bufferedImage.getHeight() * n2;
    }

    private int getElementSize(SampleModel sampleModel) {
        int n2 = DataBuffer.getDataTypeSize(sampleModel.getDataType());
        if (sampleModel instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
            return multiPixelPackedSampleModel.getSampleSize(0) * multiPixelPackedSampleModel.getNumBands();
        }
        if (sampleModel instanceof ComponentSampleModel) {
            return sampleModel.getNumBands() * n2;
        }
        if (sampleModel instanceof SinglePixelPackedSampleModel) {
            return n2;
        }
        return n2 * sampleModel.getNumBands();
    }
}

