/*
 * Decompiled with CFR 0.152.
 */
package com.fr.page;

import com.fr.base.FRContext;
import com.fr.base.Margin;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.page.ClippedECPage;
import com.fr.page.ClippedPage;
import com.fr.page.ClippedPageProvider;
import com.fr.page.PageAttributeGetter;
import com.fr.page.PagePainter;
import com.fr.page.PaperSettingGetter;
import com.fr.page.PaperSettingProvider;
import com.fr.page.ReportHFProvider;
import com.fr.page.ReportPageAttrProvider;
import com.fr.page.ReportPageProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.report.core.ReportHF;
import com.fr.report.core.ReportUtils;
import com.fr.report.report.ResultReport;
import com.fr.report.stable.ReportSettings;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.FCloneable;
import com.fr.stable.html.Tag;
import com.fr.stable.html.TextHtml;
import com.fr.stable.unit.UNIT;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.output.json.JSONOutlet;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ReportPage
implements PageAttributeGetter,
Printable,
Serializable,
FCloneable,
PaperSettingGetter,
ReportPageProvider {
    private static final long serialVersionUID = 4854581643677224811L;
    public static final String XML_TAG = "REPORTPAGE";
    protected ResultReport source_report;
    protected ReportSettingsProvider reportSettings;
    protected int currentPageNumber;
    protected int totalPageNumber;
    protected int bsCurrentPageNumber = -1;
    protected int bsTotalPageNumber = -1;
    protected int x;
    protected int y;
    protected int resolution = 72;
    protected List clippedPageList = new ArrayList(1);
    private static final int NOT_INITIALED = -1;

    public ReportPage() {
    }

    public ReportPage(ResultReport resultReport, int n2, int n3, int n4, ReportSettings reportSettings) {
        this(resultReport, n2, n3, n4);
        this.reportSettings = reportSettings;
    }

    public ReportPage(ResultReport resultReport, int n2, int n3, int n4) {
        this.source_report = resultReport;
        this.totalPageNumber = n2;
        this.x = n3;
        this.y = n4;
    }

    public JSONObject toJSONObject(Repository repository) throws Exception {
        JSONOutlet jSONOutlet = new JSONOutlet((ReportPageProvider)this, repository);
        return jSONOutlet.out();
    }

    public ClippedPageProvider[] getPages() {
        return this.clippedPageList.toArray(new ClippedPage[this.clippedPageList.size()]);
    }

    public void addClippedPage(ClippedPageProvider clippedPageProvider) {
        this.x = clippedPageProvider.getXY()[0];
        this.y = clippedPageProvider.getXY()[1];
        this.clippedPageList.add(clippedPageProvider);
    }

    public int[] getXY() {
        return new int[]{this.x, this.y};
    }

    public ReportPageAttrProvider getReportPageAttr() {
        return this.source_report.getReportPageAttr();
    }

    public PaperSettingProvider getPaperSetting() {
        return this.getReportSettings().getPaperSetting();
    }

    public UNIT getPaperWidth() {
        return ReportUtils.getPaperWidth(this.getReportSettings().getPaperSetting());
    }

    public int getWebPageWidth() {
        return this.getPaperWidth().toPixI(96);
    }

    public UNIT getPaperHeight() {
        return ReportUtils.getPaperHeight(this.getReportSettings().getPaperSetting());
    }

    public int getWebPageHeight() {
        return this.getPaperHeight().toPixI(96);
    }

    private Margin getMargin() {
        ReportSettingsProvider reportSettingsProvider = this.getReportSettings();
        if (reportSettingsProvider.getPaperSetting() != null) {
            return reportSettingsProvider.getPaperSetting().getMargin();
        }
        return new Margin();
    }

    public UNIT getMarginTop() {
        return this.getMargin().getTop();
    }

    public UNIT getMarginLeft() {
        return this.getMargin().getLeft();
    }

    public UNIT getMarginBottom() {
        return this.getMargin().getBottom();
    }

    public UNIT getMarginRight() {
        return this.getMargin().getRight();
    }

    public ReportSettingsProvider getReportSettings() {
        if (this.reportSettings == null) {
            this.reportSettings = ReportUtils.getReportSettings(this.source_report);
        }
        return this.reportSettings;
    }

    public ReportHFProvider getHeader() {
        ReportHFProvider reportHFProvider = null;
        if (this.currentPageNumber == 1) {
            reportHFProvider = this.getHeader(1);
        }
        if (reportHFProvider != null) {
            return reportHFProvider;
        }
        if (this.currentPageNumber == this.getTotalPages()) {
            reportHFProvider = this.getHeader(2);
        }
        if (reportHFProvider != null) {
            return reportHFProvider;
        }
        if (this.currentPageNumber % 2 != 0) {
            reportHFProvider = this.getHeader(3);
        }
        if (reportHFProvider != null) {
            return reportHFProvider;
        }
        if (this.currentPageNumber % 2 == 0) {
            reportHFProvider = this.getHeader(4);
        }
        if (reportHFProvider != null) {
            return reportHFProvider;
        }
        return this.getHeader(0);
    }

    public ReportHFProvider getFooter() {
        ReportHFProvider reportHFProvider = null;
        if (this.currentPageNumber == 1) {
            reportHFProvider = this.getFooter(1);
        }
        if (reportHFProvider != null) {
            return reportHFProvider;
        }
        if (this.currentPageNumber == this.getTotalPages()) {
            reportHFProvider = this.getFooter(2);
        }
        if (reportHFProvider != null) {
            return reportHFProvider;
        }
        if (this.currentPageNumber % 2 != 0) {
            reportHFProvider = this.getFooter(3);
        }
        if (reportHFProvider != null) {
            return reportHFProvider;
        }
        if (this.currentPageNumber % 2 == 0) {
            reportHFProvider = this.getFooter(4);
        }
        if (reportHFProvider != null) {
            return reportHFProvider;
        }
        return this.getFooter(0);
    }

    public ReportHFProvider getFooter(int n2) {
        return this.source_report.getFooter(n2);
    }

    public ReportHFProvider getHeader(int n2) {
        return this.source_report.getHeader(n2);
    }

    public int getContentWidth() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.clippedPageList.size(); ++i2) {
            ClippedPage clippedPage = (ClippedPage)this.clippedPageList.get(i2);
            int n3 = clippedPage.getOffsetX().toPixI(96);
            n2 = Math.max(n2, clippedPage.getContentWidth() + n3);
        }
        return n2;
    }

    public int getContentHeight() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.clippedPageList.size(); ++i2) {
            ClippedPage clippedPage = (ClippedPage)this.clippedPageList.get(i2);
            int n3 = clippedPage.getOffsetY().toPixI(96);
            n2 = Math.max(n2, clippedPage.getContentHeight() + n3);
        }
        return n2;
    }

    public void setCurrentPageNumber(int n2) {
        int n3 = this.clippedPageList.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            ClippedPage clippedPage = (ClippedPage)this.clippedPageList.get(i2);
            clippedPage.setCurrentPageNumber(n2);
            clippedPage.setFirstPageNumber(this.getReportSettings().getFirstPageNumber());
        }
        this.currentPageNumber = n2;
    }

    public int getCurrentPageNumber() {
        return this.currentPageNumber;
    }

    public int getTotalPages() {
        return this.totalPageNumber;
    }

    public int getFirstPage() {
        return this.getReportSettings().getFirstPageNumber();
    }

    public void setTotalPages(int n2) {
        int n3 = this.clippedPageList.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            ClippedPage clippedPage = (ClippedPage)this.clippedPageList.get(i2);
            clippedPage.setTotalPageNumber(n2);
            clippedPage.setFirstPageNumber(this.getReportSettings().getFirstPageNumber());
        }
        this.totalPageNumber = n2;
    }

    public void setBsCurrentPageNumber(int n2) {
        this.bsCurrentPageNumber = n2;
    }

    public int getBsCurrentPageNumber() {
        return this.bsCurrentPageNumber;
    }

    public void setBsTotalPageNumber(int n2) {
        this.bsTotalPageNumber = n2;
    }

    public int getBsTotalPageNumber() {
        return this.bsTotalPageNumber;
    }

    public void writeScriptForWebPage(PrintWriter printWriter) {
        int n2 = this.bsCurrentPageNumber == -1 ? this.currentPageNumber : this.bsCurrentPageNumber;
        int n3 = this.bsTotalPageNumber == -1 ? this.totalPageNumber : this.bsTotalPageNumber;
        new Tag("script").sub(new TextHtml(this.pageNumberBuffer(n2, n3).toString())).writeHtml(printWriter);
    }

    public void writePageIndex(JSONObject jSONObject) throws JSONException {
        int n2 = this.bsCurrentPageNumber == -1 ? this.currentPageNumber : this.bsCurrentPageNumber;
        int n3 = this.bsTotalPageNumber == -1 ? this.totalPageNumber : this.bsTotalPageNumber;
        jSONObject.put("currentPageIndex", n2);
        jSONObject.put("reportTotalPage", n3);
    }

    private StringBuffer pageNumberBuffer(int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FR._p=_g();").append("FR._p.currentPageIndex=").append(n2).append(";").append("FR._p.reportTotalPage=").append(n3).append(";").append("delete FR._p;");
        return stringBuffer;
    }

    public Image toImage() {
        return this.toImage(true, false);
    }

    public Image toImage(boolean bl, boolean bl2) {
        int n2 = this.getPaperWidth().toPixI(96);
        int n3 = this.getPaperHeight().toPixI(96);
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage(n2, n3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        new PagePainter(this, graphics2D, 96, bl, bl2).convert();
        return bufferedImage;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n2) throws PrinterException {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        double d2 = 0.75;
        graphics2D.scale(d2, d2);
        new PagePainter(this, graphics2D, 96, true).convert();
        return 0;
    }

    private double[] readFromText() {
        double[] dArray = new double[]{1.0, 1.0};
        try {
            FileInputStream fileInputStream = new FileInputStream("d:\\1.txt");
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String[] stringArray = bufferedReader.readLine().split(",");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                dArray[i2] = Double.parseDouble(stringArray[i2]);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dArray;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public ReportPageProvider deriveResolution(int n2) {
        if (n2 == this.resolution) {
            return this;
        }
        try {
            ReportPage reportPage = (ReportPage)this.clone();
            reportPage.resolution = n2;
            reportPage.clippedPageList = new ArrayList(reportPage.clippedPageList.size());
            int n3 = this.clippedPageList.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                ClippedPage clippedPage = (ClippedPage)this.clippedPageList.get(i2);
                if (clippedPage != null) {
                    clippedPage = (ClippedPage)clippedPage.clone();
                    clippedPage.resolution = reportPage.resolution;
                    reportPage.clippedPageList.add(clippedPage);
                    continue;
                }
                reportPage.clippedPageList.add(null);
            }
            return reportPage;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRContext.getLogger().error(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
            return null;
        }
    }

    public ClippedPageProvider getDefaultPage() {
        if (this.clippedPageList.isEmpty()) {
            this.addClippedPage(new ClippedECPage.EmptyClippedReportPage());
        }
        return (ClippedECPage)this.clippedPageList.get(0);
    }

    public static class XMLReportPage
    extends ReportPage
    implements XMLReadable {
        private ReportHF header;
        private ReportHF footer;
        public ReportSettings rsettings;

        public ReportHFProvider getFooter() {
            return this.footer;
        }

        public ReportHFProvider getHeader() {
            return this.header;
        }

        public ReportSettingsProvider getReportSettings() {
            return this.rsettings;
        }

        public void readXML(XMLableReader xMLableReader) {
            if (xMLableReader.isAttr()) {
                this.clippedPageList.clear();
            }
            if (xMLableReader.isChildNode()) {
                String string = xMLableReader.getTagName();
                if (string.equals("PageAttr")) {
                    this.currentPageNumber = xMLableReader.getAttrAsInt("currentpagenumber", 0);
                    this.totalPageNumber = xMLableReader.getAttrAsInt("totalpagenumber", 0);
                    this.x = xMLableReader.getAttrAsInt("x", this.x);
                    this.y = xMLableReader.getAttrAsInt("y", this.y);
                    this.bsCurrentPageNumber = xMLableReader.getAttrAsInt("bsCurrentPageNumber", this.bsCurrentPageNumber);
                    this.bsTotalPageNumber = xMLableReader.getAttrAsInt("bsTotalPageNumber", this.bsTotalPageNumber);
                } else if (string.equals("ClippedPage")) {
                    ClippedECPage.XMLClippedReportPage xMLClippedReportPage = new ClippedECPage.XMLClippedReportPage();
                    xMLClippedReportPage.readXML(xMLableReader);
                    this.addClippedPage(xMLClippedReportPage);
                } else if ("ReportSettings".equals(string)) {
                    this.rsettings = new ReportSettings();
                    xMLableReader.readXMLObject(this.rsettings);
                } else if ("Header".equals(string)) {
                    this.header = new ReportHF();
                    this.header.readXML(xMLableReader);
                } else if ("Footer".equals(string)) {
                    this.footer = new ReportHF();
                    this.footer.readXML(xMLableReader);
                }
            }
        }
    }
}

