/*
 * Decompiled with CFR 0.152.
 */
package com.fr.mobile.push;

import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.json.JSONObject;
import com.fr.mobile.push.FMobilePusherSettingManager;
import com.fr.stable.StringUtils;
import com.tencent.xinge.Message;
import com.tencent.xinge.MessageIOS;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FMobileMessagePushUtils {
    private static long thousand = 1000L;
    private static int md5Length = 32;
    private static int toStringLength = 16;

    public static String sendIOSMessageByXinGe(long l2, String string, String[] stringArray, com.fr.base.platform.msg.Message message) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        MessageIOS messageIOS = new MessageIOS();
        messageIOS.setExpireTime(86400);
        String string2 = message.getMessage();
        if (StringUtils.isEmpty(string2)) {
            string2 = Inter.getLocText("FS-Schedule-Output_Push_New_Message");
        }
        messageIOS.setAlert(string2);
        JSONObject jSONObject = message.createJSONObject();
        if (jSONObject != null) {
            messageIOS.setCustom(jSONObject.toMap());
        }
        messageIOS.setBadge(1);
        messageIOS.setSound("beep.wav");
        List<String> list = Arrays.asList(stringArray);
        hashMap.put("access_id", l2);
        hashMap.put("expire_time", messageIOS.getExpireTime());
        hashMap.put("device_type", 0);
        hashMap.put("account_list", new JSONArray(list).toString());
        hashMap.put("message_type", messageIOS.getType());
        hashMap.put("message", messageIOS.toJson());
        hashMap.put("timestamp", System.currentTimeMillis() / thousand);
        hashMap.put("environment", FMobileMessagePushUtils.getPushEnvironment());
        return FMobileMessagePushUtils.sendMessageWithSign(hashMap, string);
    }

    public static String sendAndroidMessageByXinGe(long l2, String string, String[] stringArray, com.fr.base.platform.msg.Message message) throws Exception {
        Message message2 = new Message();
        message2.setType(2);
        message2.setExpireTime(86400);
        JSONObject jSONObject = message.createJSONObject();
        if (StringUtils.isEmpty(jSONObject.optString("title"))) {
            message2.setTitle(jSONObject.optString("title"));
        } else {
            message2.setTitle(Inter.getLocText("FS-Generic-M_Data_Analysis"));
        }
        message2.setContent(jSONObject.optString("message"));
        message2.setCustom(jSONObject.toMap());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("access_id", l2);
        hashMap.put("expire_time", message2.getExpireTime());
        hashMap.put("multi_pkg", message2.getMultiPkg());
        hashMap.put("device_type", 0);
        hashMap.put("account_list", new JSONArray((Object)stringArray).toString());
        hashMap.put("message_type", message2.getType());
        hashMap.put("message", message2.toJson());
        hashMap.put("timestamp", System.currentTimeMillis() / thousand);
        return FMobileMessagePushUtils.sendMessageWithSign(hashMap, string);
    }

    private static int getPushEnvironment() {
        return FMobilePusherSettingManager.getInstance().isDevelop() ? 2 : 1;
    }

    private static String sendMessageWithSign(HashMap hashMap, String string) throws Exception {
        String string22;
        String string3 = FMobileMessagePushUtils.generateSign("POST", "http://openapi.xg.qq.com/v2/push/account_list", hashMap, string);
        hashMap.put("sign", string3);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string22 : hashMap.keySet()) {
            stringBuilder.append(string22).append("=").append(URLEncoder.encode(hashMap.get(string22).toString(), "UTF-8")).append("&");
        }
        string22 = FMobileMessagePushUtils.sendPost("http://openapi.xg.qq.com/v2/push/account_list", stringBuilder.toString());
        FRLogger.getLogger().info("XinGe Push Result : " + string22);
        return string22;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String sendPost(String string, String string2) {
        PrintWriter printWriter = null;
        BufferedReader bufferedReader = null;
        String string3 = "";
        try {
            String string4;
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setRequestProperty("accept", "*/*");
            uRLConnection.setRequestProperty("connection", "Keep-Alive");
            uRLConnection.setDoOutput(true);
            uRLConnection.setDoInput(true);
            printWriter = new PrintWriter(uRLConnection.getOutputStream());
            printWriter.print(string2);
            printWriter.flush();
            bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            while ((string4 = bufferedReader.readLine()) != null) {
                string3 = string3 + string4;
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        finally {
            try {
                if (printWriter != null) {
                    printWriter.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                FRLogger.getLogger().error(iOException.getMessage());
            }
        }
        return string3;
    }

    private static String generateSign(String string, String string2, Map<String, Object> map, String string3) {
        ArrayList<Map.Entry<String, Object>> arrayList = new ArrayList<Map.Entry<String, Object>>(map.entrySet());
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((String)((Map.Entry)object).getKey()).toString().compareTo((String)((Map.Entry)object2).getKey());
            }
        });
        String string4 = "";
        String string5 = "";
        for (Map.Entry<String, Object> entry : arrayList) {
            string4 = string4 + entry.getKey() + "=" + entry.getValue().toString();
        }
        try {
            URL uRL = new URL(string2);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            String string6 = string + uRL.getHost() + uRL.getPath() + string4 + string3;
            byte[] byArray = string6.getBytes("UTF-8");
            byte[] byArray2 = messageDigest.digest(byArray);
            BigInteger bigInteger = new BigInteger(1, byArray2);
            string5 = bigInteger.toString(toStringLength);
            while (string5.length() < md5Length) {
                string5 = "0" + string5;
            }
            return string5;
        }
        catch (Exception exception) {
            return "";
        }
    }
}

