/*
 * Decompiled with CFR 0.152.
 */
package com.fr.main;

import com.fr.base.io.IOFile;
import com.fr.general.ComparatorUtils;
import com.fr.io.attr.ReportExportAttr;
import com.fr.main.FineBook;
import com.fr.plugin.ExtraClassManager;
import com.fr.privilege.PrivilegeManager;
import com.fr.privilege.finegrain.WorkSheetPrivilegeControl;
import com.fr.report.core.PackedReport;
import com.fr.report.fun.ReportFitProcessor;
import com.fr.report.mobile.ElementCaseMobileAttr;
import com.fr.report.report.ECReport;
import com.fr.report.report.Report;
import com.fr.report.worksheet.AnalysisRWorkSheet;
import com.fr.report.worksheet.WorkSheet;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.fun.ReportFitAttrProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.attr.ReportWebAttr;
import com.fr.xml.ReportXMLUtils;
import com.fr.xml.SynchronizedBoxRelation;
import com.fr.xml.SynchronizedStyleList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFineBook
extends IOFile
implements FineBook {
    private List nameReportList = new ArrayList(1);
    protected ReportWebAttr reportWebAttr = null;
    protected ReportExportAttr reportExportAttr = null;
    protected ReportFitAttrProvider fitAttr = null;
    protected ElementCaseMobileAttr mobileAttr = null;

    protected void addReport(Report report) {
        this.addReport(null, report);
    }

    public void addReport(String string, Report report) {
        this.addReport(this.getReportCount(), string, report);
    }

    protected abstract void setWorkBook(Report var1, FineBook var2);

    protected void addReport(int n2, String string, Report report) {
        if (string == null) {
            string = this.__autoReportName();
        }
        this.nameReportList.add(n2, new NameReport(string, report));
        this.setWorkBook(report, this);
    }

    public boolean isElementCaseBook() {
        for (int i2 = 0; i2 < this.getReportCount(); ++i2) {
            if (this.isElementCaseBook(i2)) continue;
            return false;
        }
        return true;
    }

    public boolean isElementCaseBook(int n2) {
        return this.getReportCount() > n2 && this.getReport(n2).isElementCaseReport();
    }

    public ECReport getElementCaseReport(int n2) {
        if (!this.isElementCaseBook(n2)) {
            throw new RuntimeException("No ECReport exist, please check the function 'isElementCaseBook'!");
        }
        return (ECReport)this.getReport(n2);
    }

    private NameReport __getNameReportByIndex(int n2) {
        return (NameReport)this.nameReportList.get(n2);
    }

    public String getReportName(int n2) {
        return this.__getNameReportByIndex(n2).getName();
    }

    public void setReportName(int n2, String string) {
        this.__getNameReportByIndex(n2).name = string;
    }

    public Report getReport(int n2) {
        return this.__getNameReportByIndex(n2).report;
    }

    protected void setReport(int n2, Report report) {
        this.setWorkBook(report, this);
        this.__getNameReportByIndex(n2).report = report;
    }

    protected void setReport(int n2, String string, Report report) {
        this.setWorkBook(report, this);
        this.__getNameReportByIndex(n2).name = string;
        this.__getNameReportByIndex(n2).report = report;
    }

    protected int getReportIndex(Report report) {
        int n2 = this.nameReportList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (((NameReport)this.nameReportList.get(i2)).report != report) continue;
            return i2;
        }
        return -1;
    }

    public void removeReport(String string) {
        int n2 = this.nameReportList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            NameReport nameReport = this.__getNameReportByIndex(i2);
            if (!ComparatorUtils.equals(string, nameReport.name)) continue;
            this.setWorkBook(nameReport.report, null);
            this.nameReportList.remove(i2);
            return;
        }
    }

    public void removeReports() {
        int n2 = this.nameReportList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setWorkBook(this.__getNameReportByIndex(i2).report, null);
        }
        this.nameReportList.clear();
    }

    public void removeReport(int n2) {
        NameReport nameReport = (NameReport)this.nameReportList.remove(n2);
        this.setWorkBook(nameReport.report, null);
    }

    public int getReportCount() {
        return this.nameReportList.size();
    }

    public ReportWebAttr getReportWebAttr() {
        return this.reportWebAttr;
    }

    public ReportFitAttrProvider getFitAttr() {
        return this.fitAttr;
    }

    public ElementCaseMobileAttr getReportMobileAttr() {
        if (this.mobileAttr == null) {
            this.mobileAttr = new ElementCaseMobileAttr();
        }
        return this.mobileAttr;
    }

    public void setReportMobileAttr(ElementCaseMobileAttr elementCaseMobileAttr) {
        this.mobileAttr = elementCaseMobileAttr;
    }

    public void setFitAttr(ReportFitAttrProvider reportFitAttrProvider) {
        this.fitAttr = reportFitAttrProvider;
    }

    public void setReportWebAttr(ReportWebAttr reportWebAttr) {
        this.reportWebAttr = reportWebAttr;
    }

    public void setReportExportAttr(ReportExportAttr reportExportAttr) {
        this.reportExportAttr = reportExportAttr;
    }

    public ReportExportAttr getReportExportAttr() {
        return this.reportExportAttr;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractFineBook abstractFineBook = (AbstractFineBook)super.clone();
        ArrayList<NameReport> arrayList = new ArrayList<NameReport>();
        int n2 = this.nameReportList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            NameReport nameReport = (NameReport)((NameReport)this.nameReportList.get(i2)).clone();
            this.setWorkBook(nameReport.report, abstractFineBook);
            arrayList.add(nameReport);
        }
        abstractFineBook.nameReportList = arrayList;
        if (this.getReportWebAttr() != null) {
            abstractFineBook.setReportWebAttr((ReportWebAttr)this.getReportWebAttr().clone());
        }
        if (this.getReportExportAttr() != null) {
            abstractFineBook.setReportExportAttr((ReportExportAttr)this.getReportExportAttr().clone());
        }
        return abstractFineBook;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        this.writeXML(xMLPrintWriter, OReportWriter.SC);
    }

    protected void writeXML(XMLPrintWriter xMLPrintWriter, ReportWriter reportWriter) {
        ReportFitAttrProvider reportFitAttrProvider;
        ReportExportAttr reportExportAttr;
        super.writeXML(xMLPrintWriter);
        ReportWebAttr reportWebAttr = this.getReportWebAttr();
        if (reportWebAttr != null) {
            reportWebAttr.writeXML(xMLPrintWriter);
        }
        if ((reportExportAttr = this.getReportExportAttr()) != null) {
            reportExportAttr.writeXML(xMLPrintWriter);
        }
        if ((reportFitAttrProvider = this.getFitAttr()) != null) {
            reportFitAttrProvider.writeXML(xMLPrintWriter);
        }
        if (this.mobileAttr != null) {
            xMLPrintWriter.startTAG("ElementCaseMobileAttr");
            this.mobileAttr.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        int n2 = this.getReportCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Report report = this.getReport(i2);
            if (report == null) continue;
            reportWriter.writeReport(xMLPrintWriter, report, this.getReportName(i2));
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Version")) {
                String string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    xMLableReader.getXMLVersion().setVersion(Double.parseDouble(string2));
                }
            } else if (string.equals("XMLVersion")) {
                String string3 = xMLableReader.getElementValue();
                if (string3 != null) {
                    xMLableReader.setXmlVersionByString(string3);
                }
            } else if ("StyleList".equals(string)) {
                SynchronizedStyleList.getSynchronizedStyleList().deXmlizeStyleList(xMLableReader);
            } else if ("Report".equals(string)) {
                this.readReportXML(xMLableReader);
            } else if ("ReportWebAttr".equals(string)) {
                ReportWebAttr reportWebAttr = this.getReportWebAttr();
                if (reportWebAttr == null) {
                    reportWebAttr = new ReportWebAttr();
                    this.setReportWebAttr(reportWebAttr);
                }
                xMLableReader.readXMLObject(reportWebAttr);
            } else if ("ReportExportAttr".equals(string)) {
                ReportExportAttr reportExportAttr = new ReportExportAttr();
                xMLableReader.readXMLObject(reportExportAttr);
                this.setReportExportAttr(reportExportAttr);
            } else if ("ReportFitAttr".equals(string)) {
                this.readReportFitAttr(xMLableReader);
                this.compatiableOldFitAttr(xMLableReader);
            } else if ("ElementCaseMobileAttr".equals(string)) {
                ElementCaseMobileAttr elementCaseMobileAttr = new ElementCaseMobileAttr();
                xMLableReader.readXMLObject(elementCaseMobileAttr);
                this.mobileAttr = elementCaseMobileAttr;
            }
        }
    }

    private void compatiableOldFitAttr(XMLableReader xMLableReader) {
        int n2 = xMLableReader.getAttrAsInt("fitHorizontalInApp", -1);
        int n3 = xMLableReader.getAttrAsInt("fitVerticalInApp", -1);
        if (n2 != -1 || n3 != -1) {
            this.mobileAttr = new ElementCaseMobileAttr(n2, n3);
        }
    }

    private void readReportFitAttr(XMLableReader xMLableReader) {
        ReportFitProcessor reportFitProcessor = (ReportFitProcessor)ExtraClassManager.getInstance().getSingle("ReportFitProcessor");
        if (reportFitProcessor == null) {
            return;
        }
        ReportFitAttrProvider reportFitAttrProvider = reportFitProcessor.newInstanceFitAttr();
        xMLableReader.readXMLObject(reportFitAttrProvider);
        this.setFitAttr(reportFitAttrProvider);
    }

    private void readReportXML(XMLableReader xMLableReader) {
        Report report = null;
        String string = xMLableReader.getAttrAsString("class", null);
        if (string != null) {
            report = ReportXMLUtils.readReportFromClassName(string);
        }
        String string2 = "";
        string = xMLableReader.getAttrAsString("title", null);
        if (string != null) {
            string2 = string;
        }
        if ((string = xMLableReader.getAttrAsString("name", null)) != null) {
            string2 = string;
        }
        if (report instanceof PackedReport) {
            xMLableReader.readXMLObject(report);
            this.addReport(string2, report);
        } else {
            this.addReport(string2, report);
            xMLableReader.readXMLObject(report);
            if (report instanceof AnalysisRWorkSheet) {
                SynchronizedBoxRelation.flushAll((AnalysisRWorkSheet)report);
            }
        }
    }

    public String[] getJSImport() {
        ReportWebAttr reportWebAttr = this.getReportWebAttr();
        if (reportWebAttr == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return reportWebAttr.getJSImport();
    }

    public String[] getCSSImport() {
        ReportWebAttr reportWebAttr = this.getReportWebAttr();
        if (reportWebAttr == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return reportWebAttr.getCSSImport();
    }

    private String __autoReportName() {
        String string = "sheet1";
        int n2 = this.nameReportList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = this.__getNameReportByIndex(i2).name;
            if (!string2.toLowerCase().matches("^sheet[1-9]\\d*$")) continue;
            String string3 = "sheet" + (Integer.parseInt(string2.toLowerCase().substring(5)) + 1);
            if (i2 != this.getReportCount() - 1 && !this.didNotContainsIgnoreCase(string3)) continue;
            string = string3;
            break;
        }
        return string;
    }

    private boolean didNotContainsIgnoreCase(String string) {
        int n2 = this.nameReportList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = this.__getNameReportByIndex(i2).name;
            if (!string2.equalsIgnoreCase(string)) continue;
            return false;
        }
        return true;
    }

    public void mainContent(XMLPrintWriter xMLPrintWriter) {
        this.mainContentWriteXML(xMLPrintWriter);
        SynchronizedStyleList.getSynchronizedStyleList().xmlizeStyleList(xMLPrintWriter);
    }

    protected abstract void mainContentWriteXML(XMLPrintWriter var1);

    public boolean equals(Object object) {
        return super.equals(object) && object instanceof AbstractFineBook && ComparatorUtils.equals(this.reportWebAttr, ((AbstractFineBook)object).reportWebAttr) && ComparatorUtils.equals(this.reportExportAttr, ((AbstractFineBook)object).reportExportAttr) && ComparatorUtils.equals((Object)this.nameReportList, (Object)((AbstractFineBook)object).nameReportList);
    }

    private static class NameReport
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = -4090072956249660275L;
        private String name;
        private Report report;

        private NameReport(String string, Report report) {
            this.name = string;
            this.report = report;
        }

        public String getName() {
            String[] stringArray;
            WorkSheetPrivilegeControl workSheetPrivilegeControl;
            if (this.report instanceof WorkSheet && (workSheetPrivilegeControl = ((WorkSheet)this.report).getWorkSheetPrivilegeControl()).checkInvisible(stringArray = PrivilegeManager.getRoleFromCalculator(Calculator.createCalculator()))) {
                return null;
            }
            return this.name;
        }

        public Object clone() throws CloneNotSupportedException {
            NameReport nameReport = (NameReport)super.clone();
            nameReport.report = (Report)this.report.clone();
            return nameReport;
        }

        public boolean equals(Object object) {
            return object instanceof NameReport && ComparatorUtils.equals(this.name, ((NameReport)object).name) && ComparatorUtils.equals(this.report, ((NameReport)object).report);
        }
    }

    private static class OReportWriter
    implements ReportWriter {
        private static OReportWriter SC = new OReportWriter();

        private OReportWriter() {
        }

        public void writeReport(XMLPrintWriter xMLPrintWriter, Report report, String string) {
            String string2 = report.getClass().getName();
            xMLPrintWriter.startTAG("Report").attr("class", string2).attr("name", string);
            report.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    protected static interface ReportWriter {
        public void writeReport(XMLPrintWriter var1, Report var2, String var3);
    }
}

