/*
 * Decompiled with CFR 0.152.
 */
package com.fr.js;

import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.privilege.NoCheckHyperLinkSessionAttribute;
import com.fr.js.Hyperlink;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ReportletHyperlink
extends Hyperlink {
    private static final String POST_METHOD = "FR.doHyperlinkByPost";
    private static final String GET_METHOD = "FR.doHyperlinkByGet4Reportlet";
    private String reportPath = "";
    private boolean extendParameters = false;
    private boolean showParameterInterface = true;
    private boolean byPost = false;

    public ReportletHyperlink() {
    }

    public ReportletHyperlink(String string) {
        this(string, "");
    }

    public ReportletHyperlink(String string, String string2) {
        this.setReportletPath(string);
        this.setTargetFrame(string2);
    }

    public String getReportletPath() {
        return this.reportPath;
    }

    public void setReportletPath(String string) {
        this.reportPath = string;
    }

    public boolean isExtendParameters() {
        return this.extendParameters;
    }

    public void setExtendParameters(boolean bl) {
        this.extendParameters = bl;
    }

    public boolean isShowParameterInterface() {
        return this.showParameterInterface;
    }

    public void setShowParameterInterface(boolean bl) {
        this.showParameterInterface = bl;
    }

    public boolean isByPost() {
        return this.byPost;
    }

    public void setByPost(boolean bl) {
        this.byPost = bl;
    }

    protected boolean isPost() {
        return this.isByPost();
    }

    public String actionJS(Repository repository) {
        try {
            return this.createReportPath(repository);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
            return "";
        }
    }

    public JSONObject createJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.createJSONObject(repository);
        JSONObject jSONObject2 = this.createPara(repository);
        jSONObject.put("reportlet", this.reportPath);
        jSONObject.put("__pi__", this.showParameterInterface);
        this.insertAccessPolicy(repository, this.reportPath, jSONObject2);
        return jSONObject;
    }

    protected String getHyperlinkType() {
        return "report";
    }

    private String createLetPath(String string, Repository repository) {
        if (string == null) {
            return "";
        }
        String string2 = string.indexOf(".frm") != -1 ? "formlet" : "reportlet";
        return repository.checkoutObject(string, string2);
    }

    private String createReportPath(Repository repository) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.byPost) {
            stringBuilder.append(POST_METHOD);
        } else {
            stringBuilder.append(GET_METHOD);
        }
        stringBuilder.append("(");
        JSONObject jSONObject = JSONObject.create();
        String string = this.getReportletPath();
        JSONObject jSONObject2 = this.createPara(repository);
        jSONObject.put("url", this.createLetPath(string, repository));
        jSONObject.put("para", jSONObject2);
        jSONObject.put("target", this.getTargetFrame());
        jSONObject.put("feature", this.features4NewWindow());
        jSONObject.put("title", this.getTitle());
        stringBuilder.append(jSONObject.toString());
        stringBuilder.append(")");
        this.insertAccessPolicy(repository, string, jSONObject2);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertAccessPolicy(Repository repository, String string, JSONObject jSONObject) {
        String string2;
        HttpSession httpSession;
        HttpServletRequest httpServletRequest = repository.getHttpServletRequest();
        if (httpServletRequest != null && (httpSession = httpServletRequest.getSession(false)) != null && (string2 = (String)httpSession.getAttribute("fr_username")) != null) {
            HttpSession httpSession2 = httpSession;
            synchronized (httpSession2) {
                NoCheckHyperLinkSessionAttribute noCheckHyperLinkSessionAttribute = (NoCheckHyperLinkSessionAttribute)httpSession.getAttribute("fr_nocheck_hyperlinkinfo");
                if (noCheckHyperLinkSessionAttribute == null) {
                    httpSession.setAttribute("fr_nocheck_hyperlinkinfo", new NoCheckHyperLinkSessionAttribute(string2, string, this.getExtendsOP(jSONObject)));
                } else {
                    noCheckHyperLinkSessionAttribute.putHyperLinkInfo(string2, string, this.getExtendsOP(jSONObject));
                }
            }
        }
    }

    private String getExtendsOP(JSONObject jSONObject) {
        if (jSONObject != null) {
            return jSONObject.optString("op", null);
        }
        return null;
    }

    protected JSONObject createPara(Repository repository) throws JSONException {
        JSONObject jSONObject = JSONObject.create();
        jSONObject.put("__pi__", this.showParameterInterface);
        if (this.isExtendParameters()) {
            this.putExtendParameters(repository, jSONObject, false);
        }
        this.para2JSON(jSONObject, false);
        return jSONObject;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("JavaScript").attr("class", this.getClass().getName());
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("ReportletName");
        if (this.isExtendParameters()) {
            xMLPrintWriter.attr("extendParameters", this.isExtendParameters());
        }
        if (this.isShowParameterInterface()) {
            xMLPrintWriter.attr("showPI", this.isShowParameterInterface());
        }
        if (this.byPost) {
            xMLPrintWriter.attr("byPost", true);
        }
        String string = this.getReportletPath().replaceAll("\\\\", "/");
        xMLPrintWriter.textNode(string);
        xMLPrintWriter.end();
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("ReportletName")) {
            this.setExtendParameters(xMLableReader.getAttrAsBoolean("extendParameters", false));
            this.setShowParameterInterface(xMLableReader.getAttrAsBoolean("showPI", false));
            this.setByPost(xMLableReader.getAttrAsBoolean("byPost", false));
            String string = xMLableReader.getElementValue();
            if (StringUtils.isNotBlank(string)) {
                string = string.replaceAll("\\\\", "/");
                this.setReportletPath(string);
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ReportletHyperlink)) {
            return false;
        }
        return super.equals(object) && this.extendParameters == ((ReportletHyperlink)object).extendParameters && ComparatorUtils.equals(this.reportPath, ((ReportletHyperlink)object).reportPath) && this.byPost == ((ReportletHyperlink)object).byPost && ComparatorUtils.equals(this.showParameterInterface, ((ReportletHyperlink)object).showParameterInterface);
    }
}

