/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.exporter;

import com.fr.cache.list.IntList;
import com.fr.io.core.ExporterUtils;
import com.fr.io.core.PageExcelExporterReport;
import com.fr.io.exporter.AppExporter;
import com.fr.io.exporter.ExcelExporter;
import com.fr.io.exporter.LargeDataPageExcelExporter;
import com.fr.io.exporter.PageExcel2007Exporter;
import com.fr.io.exporter.poi.wrapper.POIWorkbookAction;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.page.ClippedPageProvider;
import com.fr.page.PageSetProvider;
import com.fr.page.PaperSettingProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.report.core.A.A.A;
import com.fr.report.core.A.A.C;
import com.fr.report.core.ReportUtils;
import com.fr.report.report.ECReport;
import com.fr.report.report.Report;
import com.fr.report.report.ResultReport;
import com.fr.stable.ExportConstants;
import com.fr.stable.FT;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import java.io.OutputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageExcelExporter
extends ExcelExporter {
    public PageExcelExporter(List list) {
        super(list);
    }

    @Override
    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        this.export(outputStream, resultWorkBook, false);
    }

    @Override
    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook, boolean bl) throws Exception {
        if (resultWorkBook == null) {
            throw new Exception("Report can not be null!");
        }
        for (int i2 = 0; i2 < resultWorkBook.getReportCount(); ++i2) {
            if (!(resultWorkBook.getReport(i2) instanceof A) && !(resultWorkBook.getReport(i2) instanceof C)) continue;
            new LargeDataPageExcelExporter(this.paperSettingList, true).export(outputStream, resultWorkBook, bl);
            return;
        }
        super.export(outputStream, resultWorkBook, bl);
    }

    @Override
    protected AppExporter getExporterFor2007(List<PaperSettingProvider> list) throws ClassNotFoundException {
        return new PageExcel2007Exporter((List)list);
    }

    private int initPageCount(int n2, List<Report> list, ResultWorkBook resultWorkBook, PageSetProvider[] pageSetProviderArray, int[] nArray) {
        int n3;
        for (n3 = 0; n3 < n2; ++n3) {
            Report report = resultWorkBook.getReport(n3);
            list.add(report);
        }
        n3 = 0;
        for (int i2 = 0; i2 < resultWorkBook.getReportCount(); ++i2) {
            if (resultWorkBook.getReport(i2) == null) continue;
            pageSetProviderArray[i2] = ((ResultReport)list.get(i2)).generateReportPageSet(this.paperSettingList == null || this.paperSettingList.isEmpty() ? null : (PaperSettingProvider)this.paperSettingList.get(i2)).traverse4Export();
            nArray[i2] = n3;
            n3 += pageSetProviderArray[i2].size();
        }
        return n3;
    }

    @Override
    protected void exportBook(ResultWorkBook resultWorkBook, POIWorkbookAction pOIWorkbookAction, List list, List<String> list2, List<Report> list3, boolean bl) throws Exception {
        int n2 = resultWorkBook.getReportCount();
        PageSetProvider[] pageSetProviderArray = new PageSetProvider[n2];
        int[] nArray = new int[n2];
        int n3 = this.initPageCount(n2, list3, resultWorkBook, pageSetProviderArray, nArray);
        for (int i2 = 0; i2 < n2; ++i2) {
            ECReport eCReport = (ECReport)list3.get(i2);
            PageSetProvider pageSetProvider = pageSetProviderArray[i2];
            ClippedPageProvider clippedPageProvider = null;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            IntList intList = new IntList();
            intList.add(1);
            IntList intList2 = new IntList();
            intList2.add(1);
            ReportSettingsProvider reportSettingsProvider = ReportUtils.getReportSettings(eCReport);
            int n8 = reportSettingsProvider.getPageOrder();
            PageBlock pageBlock = new PageBlock(n4, n5, n6, n7);
            if (n8 == 0) {
                this.doTopToBottom(pageBlock, pageSetProvider, clippedPageProvider, intList2, intList);
            } else {
                this.doLeftToRight(pageBlock, pageSetProvider, clippedPageProvider, intList2, intList);
            }
            this.innerExport(nArray, n3, i2, pageBlock, intList, intList2, resultWorkBook, pageSetProvider, eCReport, pOIWorkbookAction, list, n8, list2);
            if (bl) continue;
            pageSetProvider.release();
        }
    }

    private void innerExport(int[] nArray, int n2, int n3, PageBlock pageBlock, IntList intList, IntList intList2, ResultWorkBook resultWorkBook, PageSetProvider pageSetProvider, ECReport eCReport, POIWorkbookAction pOIWorkbookAction, List list, int n4, List<String> list2) throws Exception {
        int n5 = pageBlock.maxX;
        int n6 = pageBlock.maxY;
        int n7 = pageBlock.columnCount;
        int n8 = pageBlock.rowCount;
        FT fT = new FT(nArray[n3], n2);
        int[] nArray2 = new int[]{n5, n6};
        for (int i2 = 0; i2 < intList.size(); ++i2) {
            FT fT2 = new FT(intList.get(i2), i2 != intList.size() - 1 ? intList.get(i2 + 1) : n5 + 1);
            for (int i3 = 0; i3 < intList2.size(); ++i3) {
                FT fT3 = new FT(intList2.get(i3), i3 != intList2.size() - 1 ? intList2.get(i3 + 1) : n6 + 1);
                this.innerExportReport(new PageExcelExporterReport(eCReport, pageSetProvider, fT2, fT3, fT, nArray2, n4), resultWorkBook.getReportExportAttr(), resultWorkBook.getReportName(n3) + (i2 == 0 ? "" : "_" + (i2 + 1)) + (i3 == 0 ? "" : "_" + (i3 + 1)), (HSSFWorkbook)pOIWorkbookAction.getWorkbook(), list, list2, n3);
            }
        }
    }

    private void doLeftToRight(PageBlock pageBlock, PageSetProvider pageSetProvider, ClippedPageProvider clippedPageProvider, IntList intList, IntList intList2) {
        int n2;
        int n3 = pageBlock.maxX;
        int n4 = pageBlock.maxY;
        int n5 = pageBlock.columnCount;
        int n6 = pageBlock.rowCount;
        for (n2 = 0; n2 < pageSetProvider.size() && n3 < (clippedPageProvider = ExporterUtils.support(pageSetProvider.getPage(n2))).getXY()[0] + 1; ++n2) {
            n3 = clippedPageProvider.getXY()[0] + 1;
            if ((n5 += clippedPageProvider.getColumnCount()) <= ExportConstants.MAX_COLS) continue;
            intList2.add(n3);
            n5 = clippedPageProvider.getColumnCount();
        }
        n4 = pageSetProvider.size() / n3;
        for (n2 = 0; n2 < pageSetProvider.size(); n2 += n3) {
            clippedPageProvider = ExporterUtils.support(pageSetProvider.getPage(n2));
            if ((n6 += clippedPageProvider.getRowCount()) <= ExportConstants.MAX_ROWS) continue;
            intList.add(clippedPageProvider.getXY()[1] + 1);
            n6 = clippedPageProvider.getRowCount();
        }
        pageBlock.setMaxX(n3);
        pageBlock.setMaxY(n4);
        pageBlock.setColumnCount(n5);
        pageBlock.setRowCount(n6);
    }

    private void doTopToBottom(PageBlock pageBlock, PageSetProvider pageSetProvider, ClippedPageProvider clippedPageProvider, IntList intList, IntList intList2) {
        int n2;
        int n3 = pageBlock.maxX;
        int n4 = pageBlock.maxY;
        int n5 = pageBlock.columnCount;
        int n6 = pageBlock.rowCount;
        for (n2 = 0; n2 < pageSetProvider.size() && n4 < (clippedPageProvider = ExporterUtils.support(pageSetProvider.getPage(n2))).getXY()[1] + 1; ++n2) {
            n4 = clippedPageProvider.getXY()[1] + 1;
            if ((n6 += clippedPageProvider.getRowCount()) <= ExportConstants.MAX_ROWS) continue;
            intList.add(n4);
            n6 = clippedPageProvider.getRowCount();
        }
        n3 = pageSetProvider.size() / n4;
        for (n2 = 0; n2 < pageSetProvider.size(); n2 += n4) {
            clippedPageProvider = ExporterUtils.support(pageSetProvider.getPage(n2));
            if ((n5 += clippedPageProvider.getColumnCount()) <= ExportConstants.MAX_COLS) continue;
            intList2.add(clippedPageProvider.getXY()[0] + 1);
            n5 = clippedPageProvider.getColumnCount();
        }
        pageBlock.setMaxX(n3);
        pageBlock.setMaxY(n4);
        pageBlock.setColumnCount(n5);
        pageBlock.setRowCount(n6);
    }

    private static class PageBlock {
        protected int maxX = 0;
        protected int maxY = 0;
        protected int columnCount = 0;
        protected int rowCount = 0;

        public PageBlock(int n2, int n3, int n4, int n5) {
            this.maxX = n2;
            this.maxY = n3;
            this.columnCount = n4;
            this.rowCount = n5;
        }

        public void setMaxX(int n2) {
            this.maxX = n2;
        }

        public void setMaxY(int n2) {
            this.maxY = n2;
        }

        public void setColumnCount(int n2) {
            this.columnCount = n2;
        }

        public void setRowCount(int n2) {
            this.rowCount = n2;
        }
    }
}

